<?php

class MyProfileController extends Controller {

    public $steps = array('basic', 'preferences', 'education', 'entrance', 'others', 'extra');

    public $instId = '';
    public $isCssAccess = false;
    public $cssStudentNames = array();
    public $cssStudentNamesList = array();
    public $rbacRole = '';

    public $currentStudyLevelArray = array(
        '9p' => '9th',
        '10p' => '10th',
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );

    public function init(){
        if(Yii::app()->user->isGuest) {
            echo "<script>window.location.href = '/app/home';</script>"; exit;
            //$this->redirect(Yii::app()->urlManager->createUrl('home')); Yii::app()->user->user_type_ref_id != 1
        }

        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->checkCssAccess();
        $this->rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        /*if ($this->rbacRole == 'Student'){
            $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
            $signUpSteps = SignupSteps::model()->count('user_ref_id=:user_ref_id', array('user_ref_id' => Yii::app()->user->sub_id));
            if($user->is_visited_school == 'N' && !$signUpSteps)
            {
                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_b2csignup',), 1);
                $redirectUrl = $urlDetails[0]['url'];
                if($redirectUrl) {
                    //$this->redirect($redirectUrl) ;
                }
            }
        }*/
    }

    public function actionIndex() {


        //Yii::app()->clientScript->registerCssFile('//fonts.googleapis.com/css?family=Roboto:300,400,500');
        //Yii::app()->clientScript->registerScriptFile('//maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&libraries=places');

        $user_id = Yii::app()->user->sub_id;
        if ($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin')
        {
            if(Yii::app()->request->getParam('uid'))// && Yii::app()->request->getParam('uid') > 0
            {
                $user_id = Yii::app()->request->getParam('uid');
                $count = TblUserMaster::model()->count(array('condition' => "user_id='".$user_id ."' "));
                if(!$count){
                    if($this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin') {
                        $this->redirect(Yii::app()->urlManager->createUrl('../mainadmin/admin_home.php'));
                    }
                    elseif($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor') {
                        $this->redirect(Yii::app()->urlManager->createUrl('schoolDashboard/index'));
                    }

                }
            }
        }
        //echo '+++'.$this->rbacRole.$user_id;
        $section = $this->get_section($user_id);

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$user_id."'";
        $steps = SignupSteps::model()->findAll($criteria);
        if (count($steps) < 6) {
            $this->layout = "//layouts/new_grid_signup";
        }

        $this->render('index', compact('user_id', 'section'));
    }

    public function get_section($user_id) {
        $signup_steps = SignupSteps::getUserSteps($user_id);
        $section = '';
        if (count($signup_steps)) {
            switch($signup_steps[0]['step_no']) {
                case 1:
                    $section = 'preferences';
                    break;
                case 2:
                    $section = 'education';
                    break;
                case 3:
                    $section = 'entrance';
                    break;
                case 4:
                    $section = 'others';
                    break;
                case 5:
                    $section = 'extra';
                    break;
            }
        } else {
            $section = 'basic';
        }

        return $section;
    }


    public function actionShowSections() {
        $section = Yii::app()->request->getParam('section');
        $prevSection = Yii::app()->request->getParam('prevSection');
        $user_id = Yii::app()->request->getParam('user_id');
        $loadAll = Yii::app()->request->getParam('loadAll');
        $user = TblUserMaster::model()->findByPk($user_id);
        Yii::app()->session['last_section'] = Yii::app()->request->getParam('section');
        $milesRes = UserMilestone::getUserConfirmedMilestoneDetails($user_id);
        $isFinalise = 0;
        foreach($milesRes as $res)
        {
            if($res->milestone_id == 2 && $res->status == 'Confirmed')
            {
                $isFinalise = 1;
            }
        }

        foreach ($this->steps as $view) {
            if (in_array($user->present_class, array(9, 10)) && $view == 'entrance') {

            } else {
                if ($section == $view) {
                    $file = $view;
                    if ($view == 'education' || $view == 'preferences') {
                        if (in_array($user->present_class, array(9, 10))) {
                            if($isFinalise && $view == 'preferences'){
                                $file = $view;
                            }else{
                                $file = $view.'_9';
                            }
                        }
                    }
                    //$this->renderPartial($view.'_edit', compact('user_id', 'section'), false, true);
                    $html = "<div class='sectionView editMode' rel='$view'>";
                    $html .= $this->renderPartial($file.'_edit', compact('user_id', 'section'), true, true);
                    $html .= '</div>';
                    echo $html;

                } else {
                    if($loadAll || $prevSection == $view)
                    {
                        $file = $view;
                        if ($view == 'education' || $view == 'preferences') {
                            if (in_array($user->present_class, array(9, 10))) {
                                if($isFinalise && $view == 'preferences'){
                                    $file = $view;
                                }else{
                                    $file = $view.'_9';
                                }
                            }
                        }
                        $html = "<div class='sectionView viewMode' rel='$view'>";
                        $html .= $this->renderPartial($file.'_view', compact('user_id', 'section'), true);
                        $html .= '</div>';
                        echo $html;
                    }
                }
            }
        }
    }

    public function actionValidate() {
        //echo '<pre>'; print_r($_POST); exit;
        $section = Yii::app()->request->getParam('section');
        $model = new ProfileData($section);

        if (Yii::app()->request->isAjaxRequest) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionGetSubDept() {
        $id = Yii::app()->request->getParam('id');
        $sub_depts = LookupDepartment::getSubDepartmentsList($id);
        $sub_depts_list = CHtml::ListData($sub_depts, 'department_id', 'department_name');
        $sub_depts_list = $this->parseOthers($sub_depts_list);
        $ret = array();
        foreach ($sub_depts_list as $key=>$value) {
            $key = 'key'.$key;
            $ret[$key] = $value;
        }

        echo json_encode($ret);
        Yii::app()->end();

    }

    public function actionDeptAddMore() {
        $i = Yii::app()->request->getParam('i');

        $this->renderPartial('pref_dept_addmore', compact('i'), false, true);
    }

    public function actionProsAddMore() {
        $i = Yii::app()->request->getParam('i');
        $passout_year = Yii::app()->request->getParam('passout_year');

        $this->renderPartial('pros_addmore', compact('i', 'passout_year'), false, true);
    }

    public function actionSavePreferences() {
        $postData = $_POST['ProfileData'];

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$postData['user_id']."'";
        //StudentPreferredCountry::model()->deleteAll($criteria);
        foreach(StudentPreferredCountry::model()->findAll($criteria) as $_StudentPreferredCountry) $_StudentPreferredCountry->delete();

        $i = 0;
        if ($postData['country_not_sure']) {
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->not_sure = 1;
            $obj->{preference_order} = 1;
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save();
        } else {
            foreach ($postData['country_pref'] as $key=> $value) {
                if ($value['countryids'])
                {   $i++;
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $postData['user_id'];
                    $obj->{country_ref_id} = $value['countryids'];
                    $obj->{preference_order} = $i;
                    $obj->{no_scholarship} = ($value['no_scholarship']) ? 1 : (($value['no_scholarship'] == '0') ? '0' : null) ;
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save();
                    $locations = explode(',',$value['pref_location']);
                    if($value['pref_location'] && $value['is_location_entered'] == 'Y')
                    {
                        foreach ($locations as $k => $loc)
                        {
                            $model = new StudentPreferredLocation();
                            $model->{preferred_country_ref_id} = $obj->preferred_country_id;
                            $subString = substr($loc,0,1);
                            $clrLoc = substr($loc,1);
                            if($subString == 'c') {
                                $model->{city_ref_id} = $clrLoc;
                            } elseif($subString == 's') {
                                $model->{state_ref_id} = $clrLoc;
                            } elseif($subString == 'r') {
                                $model->{region_ref_id} = $clrLoc;
                            } elseif($subString == 't') {
                                $model->{cluster_ref_id} = $clrLoc;
                            }
                            $model->added_on = date('Y-m-d H:i:s');
                            $model->save(false);
                        }
                    }
                }
            }
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$postData['user_id']."'";
        //StudentPreferredDepartment::model()->deleteAll($criteria);
        foreach(StudentPreferredDepartment::model()->findAll($criteria) as $_StudentPreferredDepartment) $_StudentPreferredDepartment->delete();

        $i = 0;
        if ($postData['dept_not_sure']) {
            $obj = new StudentPreferredDepartment();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->{preference_order} = 1;
            $obj->not_sure = 1;
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save();
        } else {
            foreach ($postData['dept_pref'] as $key=>$value) {$course_id = '';
                if ($value) { $i++;

                    if ($postData['dept_others'][$i] != "") {
                        $criteria = new CDbCriteria;
                        $criteria->select = 'course_id';
                        $criteria->condition = " course_name = '".$postData['dept_others'][$i]."' AND user_entered = '0' ";
                        $data = Courses::model()->find($criteria);
                        if ($data) {
                            $course_id = $data->course_id;
                        } else {
                            $obj = new Courses();
                            $obj->course_name = $postData['dept_others'][$i];
                            $obj->main_dept_ref_id = $postData['dept_pref'][$i];
                            $obj->sub_dept_ref_id = ($postData['sub_dept_pref'][$i]) ? $postData['sub_dept_pref'][$i] : '';
                            $obj->user_entered = '1';
                            $obj->added_on = date('Y-m-d H:i:s');
                            $obj->save(false);

                            $criteria->select = 'course_id';
                            $criteria->condition = " course_name = '".$postData['dept_others'][$i]."' AND user_entered = '1' ";
                            $data = Courses::model()->find($criteria);
                            $course_id = $data->course_id;
                        }
                    }

                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $postData['user_id'];
                    $obj->{main_dept_ref_id} = $value;
                    $obj->{sub_dept_ref_id} = $postData['sub_dept_pref'][$key];
                    $obj->{preference_order} = $i;
                    if ($course_id != '') {
                        $obj->{course_ref_id} = $course_id;
                    }
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save();
                }
            }
        }

        //StudentPreferredPeriod::model()->deleteAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "'"));
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>2));
        if($det)
        {
            foreach(StudentPreferredPeriod::model()->findAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "'")) as $_StudentPreferredPeriod) $_StudentPreferredPeriod->delete();

            foreach ($postData['prospective_session'] as $key=>$value) {
                $keys = explode('==', $value);
                $details = LookupLikelyPeriod::model()->findByPk($keys[1]);

                $model = new StudentPreferredPeriod();
                $model->user_ref_id = $postData['user_id'];
                $model->year = $keys[0];
                $model->period_ref_id = $keys[1];
                $model->from_month = $details->from_month;
                $model->to_month = $details->to_month;
                $model->added_on = date('Y-m-d H:i:s');
                $model->save(false);
            }
        }

        $criticalFields = array(
            'country' => 1,
            'intended_subjects' => 1,
            'likely_start_period' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);

        $section = $postData['section'];

        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $shortList = new ShortListEngine();
        $shortList->profileUpdated();

        $section = $this->get_section($postData['user_id']);

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionGetSchoolList() {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        $cityId = Yii::app()->getRequest()->getParam('cityId', false);
        if ($term) {
            /*$res = LookupSchool::model()->findAll(array('select'=>'DISTINCT(school_name)','condition' => 'school_name like "%' . $term . '%" AND user_entered <> 1 ', 'limit' => '10', 'order' => 'CASE WHEN school_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(school_name), school_name'));*/
            $res = LookupSchool::getSchoolList($term,$cityId);
            $val = array();
            if ($res) {$i = 1;
                foreach ($res as $r) {
                    $val[] = array(
                        'id' => $r['school_id'],
                        'label' => $r['school_name'],
                        //'label' => $r->attributes['school_name'],
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionGetSubjectList() {
        $user_id = Yii::app()->request->getParam('user_id');
        $class = Yii::app()->request->getParam('class');
        $user = TblUserMaster::model()->findByPk($user_id);
        $prefCourses = $user->getPreferredCourses();

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse['main_dept_ref_id'];
        }


        $board = Yii::app()->request->getParam('board');
        $board_det = LookupBoardEquivalent::model()->findByPk($board);

        $subjects = LookupStudentSubject::getPreferredSubjectsByDepartment($board, $keys);
        if (count($subjects['Preferred Subjects']) > 6) {
            $sub = $subjects['Preferred Subjects'] + $subjects['Other Subjects'];
            $subjects = $sub;
        }
        $gradeArray = array();
        if($board){
            $gradeArray = LookupBoardConversion::getGradesByBoard($board);
        }
        if($board && $board == '12' || $board == '27' || $board == '28'){
            $gradeArray = array(''=>'Points',7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            if($class == 10){
                $gradeArray = array(''=>'Points',8=>8, 7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            }
        }
        $this->renderPartial('subjects_marks_12', compact('subjects', 'class', 'board_det', 'user_id','gradeArray','user'));
    }

    public function actionGetSubjectList_9() {
        $user_id = Yii::app()->request->getParam('user_id');
        $class = Yii::app()->request->getParam('class');
        $user = TblUserMaster::model()->findByPk($user_id);
        $prefCourses = $user->getPreferredCourses();

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse['main_dept_ref_id'];
        }


        $board = Yii::app()->request->getParam('board');
        $board_det = LookupBoardEquivalent::model()->findByPk($board);

        $subjectList = LookupStudentSubject::getSubjectListByBoard($board);
        //$subjectList = LookupStudentSubject::getSubjectListByBoard($board_det->board_ref_id);
        $subjects = CHtml::listData($subjectList,'student_subject_id','subject_name');
        //$subjects['others'] = 'Others';
        $gradeArray = array();
        if($board){
            $gradeArray = LookupBoardConversion::getGradesByBoard($board);
        }
        if($board && $board == '12' || $board == '27' || $board == '28'){
            $gradeArray = array(''=>'Points',7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            if($class == 10 || $class == 9){
                $gradeArray = array(''=>'Points',8=>8, 7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            }
        }

        $this->renderPartial('subjects_marks_12_9', compact('subjects', 'class', 'board_det', 'user_id','gradeArray'));
    }

    public function actionSubjectAddMore() {
        $user_id = Yii::app()->request->getParam('user_id');
        $l = Yii::app()->request->getParam('i');
        $class = Yii::app()->request->getParam('class');
        $user = TblUserMaster::model()->findByPk($user_id);
        $prefCourses = $user->getPreferredCourses();

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse['main_dept_ref_id'];
        }


        $board = Yii::app()->request->getParam('board');
        $board_det = LookupBoardEquivalent::model()->findByPk($board);

        /*$sub = LookupStudentSubject::getPreferredSubjectsByDepartment($board, $keys);
        $subjects = $sub;*/

        $subjects = LookupStudentSubject::getPreferredSubjectsByDepartment($board, $keys);
        if (count($subjects['Preferred Subjects']) > 6) {
            $sub = $subjects['Preferred Subjects'] + $subjects['Other Subjects'];
            $subjects = $sub;
        }
        $gradeArray = array();
        if($board){
            $gradeArray = LookupBoardConversion::getGradesByBoard($board);
        }
        if($board && $board == '12' || $board == '27' || $board == '28'){
            $gradeArray = array(''=>'Points',7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            if($class == 10){
                $gradeArray = array(''=>'Points',8=>8, 7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            }
        }
        /*if (count($sub['Other Subjects'])) {
            $subjects = $sub['Other Subjects'];
        } */

        $this->renderPartial('subjects_marks_more', compact('subjects', 'class', 'board_det', 'l', 'user_id','gradeArray','user'));
    }

    public function actionSubjectAddMore_9() {
        $user_id = Yii::app()->request->getParam('user_id');
        $l = Yii::app()->request->getParam('i');
        $class = Yii::app()->request->getParam('class');
        $user = TblUserMaster::model()->findByPk($user_id);
        $prefCourses = $user->getPreferredCourses();

        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse['main_dept_ref_id'];
        }

        $board = Yii::app()->request->getParam('board');
        $board_det = LookupBoardEquivalent::model()->findByPk($board);

        $subjectList = LookupStudentSubject::getSubjectListByBoard($board);
        $subjects = CHtml::listData($subjectList,'student_subject_id','subject_name');
        //$subjects['others'] = 'Others';
        $gradeArray = array();
        if($board){
            $gradeArray = LookupBoardConversion::getGradesByBoard($board);
        }
        if($board && $board == '12' || $board == '27' || $board == '28'){
            $gradeArray = array(''=>'Points',7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            if($class == 10 || $class == 9){
                $gradeArray = array(''=>'Points',8=>8, 7=>7, 6=>6, 5=>5, 4=>4, 3=>3, 2=>2, 1=>1);
            }
        }

        $this->renderPartial('subjects_marks_more_9', compact('subjects', 'class', 'board_det', 'l', 'user_id','gradeArray'));
    }

    public function actionSaveEducation() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];

        $board_12 = LookupBoardEquivalent::model()->findByPk($postData['board_12']);

        $user = TblUserMaster::model()->findByPk($user_id);
        $user->passout_year = $postData['year_12'];
        $user->present_board_ref_id = $board_12->board_ref_id;
        $user->save(false);

        $obj = new StudentRegistration();
        $obj->calculateLikelyStartPeriod($user_id);

        $education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$user_id));

        if ($education_12) {
            //StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $education_12->student_education_id);
            //StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $education_12->student_education_id);
            //StudentEducation::model()->deleteAll('student_education_id=' . $education_12->student_education_id);

            foreach(StudentEducationDetail::model()->findAll('student_education_ref_id=' . $education_12->student_education_id) as $_StudentEducationDetail) $_StudentEducationDetail->delete();
            foreach(StudentGradeCount::model()->findAll('student_education_ref_id=' . $education_12->student_education_id) as $_StudentGradeCount) $_StudentGradeCount->delete();
            foreach(StudentEducation::model()->findAll('student_education_id=' . $education_12->student_education_id) as $_StudentEducation) $_StudentEducation->delete();

        }
        $education_12 = new StudentEducation();
        $education_12->added_on = date('Y-m-d H:i:s');
        $education_12->user_ref_id = $user_id;
        $education_12->class_level = '12';

        $education_12->board_ref_id = $postData['board_12'];
        if ($board_12->overall_type == 'Marks') {
            $education_12->overall_marks = $postData['overall_marks_12'];
        } elseif ($board_12->overall_type == 'Marks-GPA') {
            $education_12->overall_marks = $postData['overall_marks_gpa_12'];
        } elseif ($board_12->overall_type == 'Points') {
            $education_12->overall_marks = $postData['overall_points_12'];
        }
        $education_12->status = $user->class_status;
        $education_12->year = $postData['year_12'];
        $education_12->school_name = $postData['school_name_12'];
        $education_12->save(false);

        $education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$user_id));

        if ($board_12->overall_type == 'Grades') {
            foreach($postData['overall_grade_12'] as $key=>$val){
                if($val) {
                    StudentGradeCount::setStudentGrades($education_12->student_education_id, $key, $val);
                }
            }
        }

        foreach ($postData['subject_12'] as $key=>$value) {
            if ($postData['subject_marks_12'][$key]) {
                if($value == 'others') {
                    $student_subject_id = LookupSubjectMaster::saveTwelveSubjects($postData,$key);
                }
                $obj = new StudentEducationDetail();
                $obj->student_education_ref_id = $education_12->student_education_id;
                if($value == 'others') {
                    $obj->student_subject_ref_id = $student_subject_id;
                } else {
                    $obj->student_subject_ref_id = $value;
                }
                $obj->added_on = date('Y-m-d H:i:s');
                if (($board_12->overall_type == 'Grades') || ($board_12->overall_type == 'Marks-GPA') || $board_12->board_ref_id == 7 ) {
                    $grade_det = LookupBoardConversion::model()->findByPk($postData['subject_marks_12'][$key]);
                    $obj->board_conversion_ref_id = $postData['subject_marks_12'][$key];
                    $obj->grade = $grade_det->board_marks;

                } else {
                    $obj->marks = $postData['subject_marks_12'][$key];
                }

                $obj->save();
            }
        }

        if(trim($postData['school_name_12']) != ''){
            $schoolExistID = $postData['school_id'];
            if(!$schoolExistID){
                $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name_12']));
            }
            $siDiData = TblSiDi::GetInstIdFromSchoolId($user->school_ref_id);
            // If Change School Delete the record
            if($schoolExistID != $user->school_ref_id){
                $findInstId = TblSiStudents::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  inst_ref_id = '".$siDiData->inst_id."' "));
                if($findInstId){
                    $findInstId->delete();
                }
            }
            if($schoolExistID){
                $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
                if($siDiData->inst_id){
                    $instId = $siDiData->inst_id;
                    //inserting to tbl_si_students if he is related to a School
                    if($schoolExistID != $user->school_ref_id) {
                    $studentSignupModel = new StudentSignup('firstPage');
                    $studentSignupModel->setSiStudents($user_id, $instId);
                    }
                } else {
                    $instId = 'null';
                }
            }
            $userMembershipRefId = ($instId > 0) ? 2 : 1; // 2 for SI and 1 for guest
            $user->membership_ref_id = $userMembershipRefId;
            $user->save(false);

            if ($schoolExistID) {
                $user->school_ref_id = $schoolExistID;
            } else {
                $checkSchool = LookupSchool::getUserSchoolID(trim($postData['school_name_12']));
                if(!$checkSchool){
                    LookupSchool::addStudentSchool(trim($postData['school_name_12']));
                }
                $schoolExistID = LookupSchool::getUserSchoolID(trim($postData['school_name_12']));
                $user->school_ref_id = $schoolExistID;
            }
            $user->save(false);
        }

        $education_10 = StudentEducation::model()->findByAttributes(array('class_level'=>'10', 'user_ref_id'=>$user_id));
        $board_10 = LookupBoardEquivalent::model()->findByPk($postData['board_10']);
        if ($education_10) {
            //StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $education_10->student_education_id);
            foreach(StudentEducationDetail::model()->findAll('student_education_ref_id=' . $education_10->student_education_id) as $_StudentEducationDetail) $_StudentEducationDetail->delete();
            //StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $education_10->student_education_id);
            foreach(StudentGradeCount::model()->findAll('student_education_ref_id=' . $education_10->student_education_id) as $_StudentGradeCount) $_StudentGradeCount->delete();
            //StudentEducation::model()->deleteAll('student_education_id=' . $education_10->student_education_id);
            foreach(StudentEducation::model()->findAll('student_education_id=' . $education_10->student_education_id) as $_StudentEducation) $_StudentEducation->delete();
        }
        $education_10 = new StudentEducation();
        $education_10->added_on = date('Y-m-d H:i:s');
        $education_10->user_ref_id = $user_id;
        $education_10->class_level = '10';

        $education_10->board_ref_id = $postData['board_10'];
        if ($board_10->overall_type == 'Marks') {
            $education_10->overall_marks = $postData['overall_marks_10'];
        } elseif ($board_10->overall_type == 'Marks-GPA') {
            $education_10->overall_marks = $postData['overall_marks_gpa_10'];
        } elseif ($board_10->overall_type == 'Points') {
            $education_10->overall_marks = $postData['overall_points_10'];
        }
        $education_10->status = $user->class_status;
        $education_10->year = $postData['year_10'];
        $education_10->school_name = $postData['school_name_10'];
        $education_10->save(false);

        $education_10 = StudentEducation::model()->findByAttributes(array('class_level'=>'10', 'user_ref_id'=>$user_id));

        if ($board_10->overall_type == 'Grades') {
            foreach($postData['overall_grade_10'] as $key=>$val){
                if($val) {
                    StudentGradeCount::setStudentGrades($education_10->student_education_id, $key, $val);
                }
            }
        }

        foreach ($postData['subject_10'] as $key=>$value) {
            if ($postData['subject_marks_10'][$key]) {
                if($value == 'others') {
                    $student_subject_id = LookupSubjectMaster::saveTenthSubjects($postData,$key);
                }

                $obj = new StudentEducationDetail();
                $obj->student_education_ref_id = $education_10->student_education_id;
                if($value == 'others') {
                    $obj->student_subject_ref_id = $student_subject_id;
                } else {
                    $obj->student_subject_ref_id = $value;
                }
                $obj->added_on = date('Y-m-d H:i:s');
                if (($board_10->overall_type == 'Grades') || ($board_10->overall_type == 'Marks-GPA') || $board_10->board_ref_id == 7) {
                    //$grade_det = LookupGrade::model()->findByPk($postData['subject_marks_10'][$key]);
                    //$obj->grade_ref_id = $grade_det->grade_id;
                    $grade_det = LookupBoardConversion::model()->findByPk($postData['subject_marks_10'][$key]);
                    $obj->board_conversion_ref_id = $postData['subject_marks_10'][$key];
                    $obj->grade = $grade_det->board_marks;

                } else {
                    $obj->marks = $postData['subject_marks_10'][$key];
                }

                $obj->save();
            }
        }

        $criticalFields = array(
            'edu_study_level' => 1,
            'school_name' => 1,
            'completion_year' => 1,
            'board' => 1,
            'overall_marks' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);

        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $section = $this->get_section($user_id);

        $sec_status = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$user_id, 'step_no'=>4));

        if(!$sec_status){
            $studentPreferredDepartmentIds = array();
            $userInfo = TblUserMaster::getUserDetails($user_id);
            $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
            if (count($studentPreferredDepartments) > 0) {
                foreach ($studentPreferredDepartments as $deptPref) {
                    $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
                }
            }
            $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);


            $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails($user_id);
            if(count($preferredCountryListData) > 0) {
                foreach ($preferredCountryListData as $key => $value) {
                    $studentPreferredCountryIds[] = $value->country_ref_id;
                }
            }

            $result1 = UserEntranceExam::getUserexams($user_id);
            $result = EntranceExam::getTestDetailsByCountryDepartmentArr($studentPreferredCountryIds, $studentPreferredDepartmentIds);

            $examlist = CHtml::listData($result,'entrance_id','entrance_short_name');

            $examlist = $result1+$examlist;

            if(count($examlist)<1){
                $det = new SignupSteps();
                $det->added_on = date('Y-m-d H:i:s');
                $det->user_ref_id = $postData['user_id'];
                $det->step_no = 4;
                $det->save();

                $section = $this->get_section($user_id);
            }
        }
		//if(!$det){
        $shortList = new ShortListEngine();
        $shortList->profileUpdated();
		//}

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();

    }

    public function actionGetAddMore() {
        $this->renderPartial('addmore_ec',array('i'=>$_POST['id']));
    }

    public function actionSaveExtra() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        $urlDetails = LookupUrl::getUrlByModel(array('class_level' => '0','label' => 'dashboard'), 1);
        $redirectUrlRefId = $urlDetails[0]['url_id'];
        TblUserMaster::updateUserFields($user_id, array('redirect_url_ref_id' => $redirectUrlRefId));
        Yii::app()->user->redirectUrl =  $urlDetails[0]['url'];


        //TblUserInterest::model()->deleteAll('user_ref_id = '.$user_id);
        foreach(TblUserInterest::model()->findAll('user_ref_id = '.$user_id) as $_TblUserInterest) $_TblUserInterest->delete();
        // For Ninth and Tenth class
        if(in_array($user->present_class, array(9, 10)))
        {
            if($postData['summer_plan_id'])
            {
                $obj = StudentSummerPlan::model()->findByAttributes(array('user_ref_id'=>$user_id));
                if(!$obj){
                    $obj = new StudentSummerPlan();
                }
                $obj->user_ref_id = $user_id;
                $obj->summer_plan_ref_id = $postData['summer_plan_id'];
                $obj->stu_entered_plan1 = null;
                $obj->stu_entered_plan2 = null;
                if(trim($postData['summer_plan_id']) == 6){
                    $obj->stu_entered_plan1 = trim($postData['summer_plan']) ? trim($postData['summer_plan']) : null;
                    $obj->stu_entered_plan2 = trim($postData['summer_plan2']) ? trim($postData['summer_plan2']) : null;
                }
                $obj->save();
            }
        }

        foreach ($postData['extra_type'] as $key=>$value) {
            if ($postData['extra_interest'][$key]) {
                $obj = new TblUserInterest();
                $obj->user_ref_id = $user_id;
                $obj->user_interest_ref_id = $postData['extra_type'][$key];
                $obj->user_interest_type_ref_id = $postData['extra_interest'][$key];
                $obj->user_interest_level_ref_id = $postData['extra_level'][$key];
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save(false);
            }
        }

        $user = TblUserMaster::model()->findByPk($user_id);
        $user->attributes = $postData;
        if($postData['state_ref_id']>0){
            $user->state_ref_id = $postData['state_ref_id'];
        }
        else{
            $user->state_ref_id = NULL;
        }
        $user->other_activities = substr(trim($postData['extraCurriculum_other']), 0, 2000);
        $user->introduce_yourself = substr(trim($postData['introduce_yourself']), 0, 2000);
        if($postData['dob_date'] && $postData['dob_month'] && $postData['dob_year']) {
            $user->dob = implode('-', array($postData['dob_year'], $postData['dob_month'], $postData['dob_date']));
            $criticalFields = array(
                'dob' => 1,
            );
        } else {
            $user->dob = NULL;
            $criticalFields = array(
                'dob' => 0,
            );
        }
        $user->save(false);
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);


        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>6));
        $section = '';
        $return['redirect'] = 'no';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
            $section = $this->get_section($user_id);
            $return['redirect'] = 'yes';
        }
        //$section = $this->steps[$key];


        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionSaveImage() {

        $valid_formats = array(".jpg", ".png", ".gif");
        $path = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $user_id = $_POST['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        $name = $_FILES['userImage']['name'];
        $size = $_FILES['userImage']['size'];

        $ext = strrchr($name, '.');
        $ext = strtolower($ext);
        if (in_array($ext, $valid_formats)) {
            if ($size < (1024 * 1024)) {
                $actual_image_name = 'img_U_' . time() . $ext; //time() . substr(str_replace(" ", "_", $txt), 5) . "." . $ext;
                $tmp = $_FILES['userImage']['tmp_name'];
                if (move_uploaded_file($tmp, $path . $actual_image_name)) {
                    /*
                    if (file_exists($path . $user->user_photo)) {
                        if (unlink($path . $user->user_photo)) {
                            @unlink($path.'thumb_90x90/' . $user->user_photo);
                        }
                    }*/

                    $user->setAttributes(array('user_photo' => $actual_image_name));
                    $user->save(false);
                    $imgPath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/' . $actual_image_name;
                    $imgPathThumb = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/thumb_90x90/' . $actual_image_name;

                    Yii::import('application.extensions.image.Image');
                    $image = new Image($imgPath);
                    list($width, $height) = getimagesize($imgPath);

                    $newWidth = 90;
                    $newHeight = 90;
                    if ($width > 90 || $height > 90) {
                        $image->resize($newWidth, $newHeight);
                    }
                    $image->save($imgPathThumb);
                    $criticalFields = array(
                        'picture' => 1,
                    );
                    TblUserProfCriticalCompletion::updateCriticalFields($user_id, $criticalFields);
                    $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');

                    $return['image'] = $latestUrlForRedirection.'/imagedisplay.php?img='.base64_encode($imgPathThumb);
                } else {
                    $return['msg'] = 'Image upload failed';
                }
            } else {
                $return['msg'] = 'Image file size max 1 MB';
            }
        } else {
            $return['msg'] = 'Invalid file format';
        }

        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionSaveEdutcation9() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        $user->present_class = $postData['class_9'];
        $user->save(false);

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$user_id."'";
        StudentPreferredSubject::model()->deleteAll($criteria);

        $i = 1;
        foreach ($postData['strong_subj'] as $value) {
            if ($value) {
                $obj = new StudentPreferredSubject();
                $obj->user_ref_id = $user_id;
                $obj->student_subject_ref_id = $value;
                $obj->type = 'Like';
                $obj->preference = $i;$i++;
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save(false);
            }
        }
        $i = 1;
        foreach ($postData['weak_subj'] as $value) {
            if ($value) {
                $obj = new StudentPreferredSubject();
                $obj->user_ref_id = $user_id;
                $obj->student_subject_ref_id = $value;
                $obj->type = 'Dislike';
                $obj->preference = $i;$i++;
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save(false);
            }
        }

        if ($postData['class_9'] == 10) {
            $education_9 = StudentEducation::model()->findByAttributes(array('class_level'=>'9', 'user_ref_id'=>$user_id));
            $board_9 = LookupBoardEquivalent::model()->findByPk($postData['board_10']);

            if (!$education_9) {
                $education_9 = new StudentEducation();
                $education_9->added_on = date('Y-m-d H:i:s');
                $education_9->user_ref_id = $user_id;
                $education_9->class_level = '9';
            }
            $education_9->board_ref_id = $postData['board_10'];
            if ($board_9->overall_type == 'Marks') {
                $education_9->overall_marks = $postData['overall_marks_10'];
            } elseif ($board_9->overall_type == 'Marks-GPA') {
                $education_9->overall_marks = $postData['overall_marks_gpa_10'];
            } elseif ($board_9->overall_type == 'Points') {
                $education_9->overall_marks = $postData['overall_points_10'];
            }
            $education_9->status = $user->class_status;
            $education_9->year = $postData['year_10'];
            $education_9->school_name = $postData['school_name_10'];
            $education_9->save(false);

            if(trim($postData['school_name_10']) != '' && $user->membership_ref_id == '1'){
                $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name_10']));
                if ($schoolExistID) {
                    $user->school_ref_id = $schoolExistID;
                } else {
                    LookupSchool::addStudentSchool(trim($postData['school_name_10']));
                    $schoolExistID = LookupSchool::getUserSchoolID(trim($postData['school_name_10']));
                    $user->school_ref_id = $schoolExistID;
                }
                $user->save(false);
            }

            $education_9 = StudentEducation::model()->findByAttributes(array('class_level'=>'9', 'user_ref_id'=>$user_id));

            StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $education_9->student_education_id);
            StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $education_9->student_education_id);

            if ($board_9->overall_type == 'Grades') {
                foreach($postData['overall_grade_10'] as $key=>$val){
                    if($val) {
                        StudentGradeCount::setStudentGrades($education_9->student_education_id, $key, $val);
                    }
                }
            }

            foreach ($postData['subject_9'] as $key=>$value) {
                if ($postData['subject_marks_9'][$key] && $postData['subject_9'][$key]) {
                    if($value == 'others') {
                        $student_subject_id = LookupSubjectMaster::saveTenthSubjects($postData,$key,9);
                    }
                    $obj = new StudentEducationDetail();
                    $obj->student_education_ref_id = $education_9->student_education_id;
                    if($value == 'others') {
                        $obj->student_subject_ref_id = $student_subject_id;
                    } else {
                        $obj->student_subject_ref_id = $value;
                    }
                    $obj->added_on = date('Y-m-d H:i:s');
                    if (($board_9->overall_type == 'Grades') || ($board_9->overall_type == 'Marks-GPA') || $board_9->board_ref_id == 7) {
                        $grade_det = LookupBoardConversion::model()->findByPk($postData['subject_marks_9'][$key]);
                        $obj->board_conversion_ref_id = $postData['subject_marks_9'][$key];
                        $obj->grade = $grade_det->board_marks;
                    } else {
                        $obj->marks = $postData['subject_marks_9'][$key];
                    }

                    $obj->save(false);
                }
            }
        }

        $criticalFields = array(
            'edu_study_level' => 1,
            'school_name' => 1,
            'completion_year' => 1,
            'board' => 1,
            'overall_marks' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);

        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key+1;
            $det->save();
        }
        //$section = $this->steps[$key+1];
        $section = $this->get_section($user_id);

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();

    }

    public function actionSavePreferences_9() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$postData['user_id']."'";
        if($postData['status_shown'] != 'iframe'){
            StudentPreferredCountry::model()->deleteAll($criteria);
            SelfCountryStatus::model()->deleteAll($criteria);
        }
        StudentPreferredCareer::model()->deleteAll($criteria);


        if($postData['status_shown'] != 'iframe'){

            if ($postData['status']) {
                $obj = new SelfCountryStatus();
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->status = $postData['status'];
                $obj->user_ref_id = $user_id;
                $obj->save(false);
            }

            if ($postData['status'] != 'Yes') {
                $i = 0;
                foreach ($postData['country_pref'] as $value) {
                    if ($value) {$i++;
                        $obj = new StudentPreferredCountry();
                        $obj->{user_ref_id} = $postData['user_id'];
                        $obj->{country_ref_id} = $value;
                        $obj->{preference_order} = $i;
                        $obj->added_on = date('Y-m-d H:i:s');
                        $obj->save();
                    }
                }
            } else {
                $obj = new StudentPreferredCountry();
                $obj->{user_ref_id} = $postData['user_id'];
                $obj->{country_ref_id} = $user->country_ref_id;
                $obj->{preference_order} = 1;
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save();
            }
        }


        if (trim($postData['parent_choice1'])) {
            $obj = new StudentPreferredCareer();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->career_ref_id = $postData['parent_choice1'];
            $obj->preference = 0;
            //$obj->preference = ($postData['parent_choice1'] == '209') ? 0 : 1;
            $obj->parent_choice = 'Y';
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save();
            if ($postData['parent_choice1'] == Yii::app()->session['Others'])
            {
                if($postData['parent_career_1']){
                    $cdb = new CDbCriteria();
                    $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                    $cdb->addCondition(' career_name = "'.trim($postData['parent_career_1']).' "', 'AND');
                    $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                    $cdb->addCondition('is_active = 1', 'AND');
                    $career_det = LookupCareer::model()->find($cdb);
                    $obj = new StudentPreferredCareer();
                    $obj->{user_ref_id} = $postData['user_id'];
                    if ($career_det) {
                        $obj->career_ref_id = $career_det->career_id;
                    } else {
                        $obj->career_name = trim($postData['parent_career_1']);
                    }
                    $obj->parent_choice = 'Y';
                    $obj->preference = 1;
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save(false);
                }
                if($postData['parent_career_2']){
                    $cdb = new CDbCriteria();
                    $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                    $cdb->addCondition(' career_name = "'.trim($postData['parent_career_2']).' "', 'AND');
                    $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                    $cdb->addCondition('is_active = 1', 'AND');
                    $career_det = LookupCareer::model()->find($cdb);
                    $obj = new StudentPreferredCareer();
                    $obj->{user_ref_id} = $postData['user_id'];
                    if ($career_det) {
                        $obj->career_ref_id = $career_det->career_id;
                    } else {
                        $obj->career_name = trim($postData['parent_career_2']);
                    }
                    $obj->parent_choice = 'Y';
                    $obj->preference = 2;
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save(false);
                }
            }
        }
        if ($postData['parent_choice2']) {
            $obj = new StudentPreferredCareer();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->career_ref_id = $postData['parent_choice2'];
            $obj->preference = 1;
            $obj->parent_choice = 'Y';
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save(false);
            if ($postData['parent_choice2'] == Yii::app()->session['Others'])
            {
                if($postData['parent_career_3']){
                    $cdb = new CDbCriteria();
                    $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                    $cdb->addCondition(' career_name = "'.trim($postData['parent_career_3']).' "', 'AND');
                    $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                    $cdb->addCondition('is_active = 1', 'AND');
                    $career_det = LookupCareer::model()->find($cdb);
                    $obj = new StudentPreferredCareer();
                    $obj->{user_ref_id} = $postData['user_id'];
                    if ($career_det) {
                        $obj->career_ref_id = $career_det->career_id;
                    } else {
                        $obj->career_name = trim($postData['parent_career_3']);
                    }
                    $obj->parent_choice = 'Y';
                    $obj->preference = 2;
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save(false);
                }
            }
        }

        if ($postData['agree_parent_choice'] == 'N' || $postData['parent_choice1'] == Yii::app()->session['Havent'])
        {
            if (trim($postData['career_1'])) {
                $cdb = new CDbCriteria();
                $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                $cdb->addCondition(' career_name = "'.trim($postData['career_1']).' "', 'AND');
                $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                $cdb->addCondition('is_active = 1', 'AND');
                $career_det = LookupCareer::model()->find($cdb);

                //$career_det = LookupCareer::model()->findByAttributes(array('career_name'=>trim($postData['career_1'])));
                $obj = new StudentPreferredCareer();
                $obj->{user_ref_id} = $postData['user_id'];
                if ($career_det) {
                    $obj->career_ref_id = $career_det->career_id;
                } else {
                    $obj->career_name = trim($postData['career_1']);
                }
                $obj->preference = 1;
                $obj->parent_choice = 'N';
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save(false);
            }
            if (trim($postData['career_2'])) {
                $cdb = new CDbCriteria();
                $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                $cdb->addCondition(' career_name = "'.trim($postData['career_2']).' "', 'AND');
                $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                $cdb->addCondition('is_active = 1', 'AND');
                $career_det = LookupCareer::model()->find($cdb);
                //$career_det = LookupCareer::model()->findByAttributes(array('career_name'=>trim($postData['career_2'])));
                $obj = new StudentPreferredCareer();
                $obj->{user_ref_id} = $postData['user_id'];
                if ($career_det) {
                    $obj->career_ref_id = $career_det->career_id;
                } else {
                    $obj->career_name = trim($postData['career_2']);
                }
                $obj->preference = 2;
                $obj->parent_choice = 'N';
                $obj->added_on = date('Y-m-d H:i:s');
                $obj->save(false);
            }
        }
        if ($postData['know_subjects']) {
            $user->know_your_subjects = $postData['know_subjects'];
            $user->save(false);
        }

        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $section = $this->get_section($user_id);

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionGetCareer() {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            /*$res = LookupCareer::model()->findAll(array('condition' => 'career_name like "%' . $term . '%" AND is_active = 1 ', 'limit' => '10', 'order' => 'CASE WHEN career_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(career_name), career_name'));*/
            $cdb = new CDbCriteria();
            $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
            $cdb->addCondition(' career_name like "%'.$term.'%"', 'AND');
            $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
            $cdb->addCondition('is_active = 1', 'AND');
            //$cdb->order = ' (CASE WHEN career_name LIKE "'.$term.'%" THEN 0 ELSE 1 END, length(career_name), career_name';
            $cdb->order = ' career_name';
            $cdb->limit = 10;
            $res = LookupCareer::model()->findAll($cdb);

            $val = array();
            if ($res) {
                foreach ($res as $r) {
                    $val[] = array(
                        'id' => $r->attributes['career_id'],
                        'label' => $r->attributes['career_name'],
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionLeftNav() {
        if(!isset(Yii::app()->user->sub_id)) {
            echo "<script>window.location.href = '/app/login/logout';</script>";
        }
        $section = Yii::app()->request->getParam('section');
        $user_id = Yii::app()->request->getParam('user_id');

        $this->renderPartial('left_nav', compact('user_id', 'section'));
    }

    public function actionSaveBasicInfo() {
        $postData = $_POST['ProfileData'];

        if($postData['user_id'])
        {
            $obj = TblUserMaster::model()->findByPk($postData['user_id']);
            $boardInfo = LookupBoardEquivalent::model()->findByPk($postData['study_board']);
            $class_data = $this->DynamicPassoutYearAndMonth($postData['present_class']);
            if(in_array($class_data['present_class'], array(9,10))) {
                unset($postData['passout_year']);
                unset($postData['passout_month']);
            }
            $obj->attributes = $postData;
            if($postData['present_class']) {
                if($class_data) {
                    $obj->present_class = $class_data['present_class'];
                    $obj->class_status = $class_data['class_status'];
                    Yii::app()->session['present_class'] = $class_data['present_class'];
                    Yii::app()->session['class_status'] = $class_data['class_status'];
                    $user = TblUserMaster::model()->findByPk($postData['user_id']);
                    Yii::app()->session['db_present_class'] = $user->present_class;
                    Yii::app()->session['db_class_status'] = $user->class_status;
                }
            }
            if($postData['first_name'])
            {
                $name = $this->separateFirstAndLastName($postData['first_name']);
                $obj->last_name  = $name['last_name'];
                $obj->first_name  = $name['first_name'];
            }
            if(Yii::app()->session['present_class']>Yii::app()->session['db_present_class']){
                $obj->class_change = 1;
            }
            if($postData['city_ref_id'])
            {
                $cityRes = TblCityMaster::model()->findByPk($postData['city_ref_id']);
                if($cityRes->state_ref_id){
                    $obj->state_ref_id = $cityRes->state_ref_id;
                } else {
                    $obj->state_ref_id = NULL;
                }
            } else {
                $obj->state_ref_id = NULL;
                $obj->city_ref_id = NULL;
            }
            $obj->present_board_ref_id = $boardInfo->board_ref_id;
            $obj->modified_on = date('Y-m-d H:i:s');
            $obj->save(false);
            if(in_array(Yii::app()->session['present_class'], array(10, 11, 12)) && Yii::app()->session['present_class']>Yii::app()->session['db_present_class'] ) {
               SignupSteps::model()->deleteAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "' "));
            } else if(in_array(Yii::app()->session['present_class'], array(11, 12)) && Yii::app()->session['present_class'] == Yii::app()->session['db_present_class'] && Yii::app()->session['class_status'] != Yii::app()->session['db_class_status']) {
                SignupSteps::model()->deleteAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "' AND step_no>2"));
                /*$education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$postData['user_id']));

                foreach(StudentEducationDetail::model()->findAll('student_education_ref_id=' . $education_12->student_education_id) as $_StudentEducationDetail) $_StudentEducationDetail->delete();
                foreach(StudentGradeCount::model()->findAll('student_education_ref_id=' . $education_12->student_education_id) as $_StudentGradeCount) $_StudentGradeCount->delete();
                foreach(StudentEducation::model()->findAll('student_education_id=' . $education_12->student_education_id) as $_StudentEducation) $_StudentEducation->delete();*/
            }
            //StudentCitizenship::model()->deleteAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "'"));
            foreach(StudentCitizenship::model()->findAll(array("condition" => "user_ref_id = '" . $postData['user_id'] . "'")) as $_StudentCitizenship){
                $_StudentCitizenship->delete();
            }

            if($postData['citizenship_ref_id1']){
                $citizenModel = new StudentCitizenship;
                $citizenModel->user_ref_id = $postData['user_id'];
                $citizenModel->citizenship_ref_id = $postData['citizenship_ref_id1'];
                $citizenModel->save(false);
            }
            if($postData['citizenship_ref_id2']){
                $citizenModel = new StudentCitizenship;
                $citizenModel->user_ref_id = $postData['user_id'];
                $citizenModel->citizenship_ref_id = $postData['citizenship_ref_id2'];
                $citizenModel->save(false);
            }

            $prospectSes = new StudentRegistration();
            $prospectSes->calculateLikelyStartPeriod($postData['user_id']);

            if($obj->present_class)
            {
                $this->updateStudentClass($obj->user_id, $postData['passout_year'], $postData['passout_month']);
            }
            $criticalFields = array('name' => 1, 'gender' => 1, 'edu_study_level' => 1, 'completion_year' => 1,'citizenship' => 1,'board'=>1,'preferred_course_duration'=>1);
            TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);
        }

        $section = $postData['section'];

        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $section = $this->get_section($postData['user_id']);

        $return['user_id'] = $postData['user_id'];
        $return['first_name'] = $obj->first_name;
        $return['last_name'] = $obj->last_name;
        $return['section'] = $section;
        $return['present_class'] = Yii::app()->session['present_class'];
        $return['db_present_class'] = Yii::app()->session['db_present_class'];
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionOtherAddMore() {
        $this->renderPartial('addmore_other',array('i'=>$_POST['id']));
    }

    public function actionSaveOtherInfo() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $loginId = Yii::app()->user->id;
        $userMasterModel = TblUserMaster::model()->findByPk($user_id);

        $urlDetails = LookupUrl::getUrlByModel(array('class_level' => '0','label' => 'dashboard'), 1);
        $redirectUrlRefId = $urlDetails[0]['url_id'];
        TblUserMaster::updateUserFields($user_id, array('redirect_url_ref_id' => $redirectUrlRefId));
        Yii::app()->user->redirectUrl =  $urlDetails[0]['url'];

        //StudentContactNumber::model()->deleteAll('user_ref_id = "'.$user_id.'" AND contact_type_ref_id != 1 ');
        foreach(StudentContactNumber::model()->findAll('user_ref_id = "'.$user_id.'" AND contact_type_ref_id != 1 ') as $_StudentContactNumber) $_StudentContactNumber->delete();
        //StudentAlternateEmail::model()->deleteAll('login_ref_id = "'.$userMasterModel->login_ref_id.'" AND contact_type_ref_id != 1 ');
        foreach(StudentAlternateEmail::model()->findAll('login_ref_id = "'.$userMasterModel->login_ref_id.'" AND contact_type_ref_id != 1 ') as $_StudentAlternateEmail) $_StudentAlternateEmail->delete();

        //$userMasterModel->introduce_yourself = $postData['introduce_yourself'];
        //$userMasterModel->country_ref_id = $postData['country_ref_id'];
        //$userMasterModel->address1 = $postData['address1'];
        //$userMasterModel->address2 = $postData['address2'];
        //$userMasterModel->post_code = $postData['post_code'];
        //$userMasterModel->city_ref_id = $postData['city_ref_id'];

        if($postData['alternate_email'])
        {
            $emailModel = StudentAlternateEmail::model()->find(array("condition" => "login_ref_id = '" . $userMasterModel->login_ref_id . "' AND  contact_type_ref_id = 1"));
            if(!$emailModel){
                $emailModel = new StudentAlternateEmail();
            }
            $emailModel->login_ref_id = $userMasterModel->login_ref_id;
            $emailModel->is_primary = 0;
            $emailModel->is_active = 1;
            $emailModel->contact_type_ref_id = 1;
            $emailModel->email_id = $postData['alternate_email'];
            $emailModel->modified_by = $loginId;
            $emailModel->modified_on = date('Y-m-d H:i:s');
            $emailModel->added_by = $loginId;
            $emailModel->save(false);
        }
        if($postData['phone'])
        {
            $contactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = '" . $postData['user_id'] . "' AND  contact_type_ref_id = 1 AND is_primary = 1"));
            if(!$contactModel){
                $contactModel = new StudentContactNumber;
            }
            $contactModel->user_ref_id = $postData['user_id'];
            $contactModel->contact_type_ref_id = 1;
            $contactModel->phone_type = 'Mobile';
            $contactModel->country_code = $postData['country_code'];
            $contactModel->number = $postData['phone'];
            $contactModel->is_primary = 1;
            $contactModel->added_by = Yii::app()->user->id;
            $contactModel->added_on = date('Y-m-d H:i:s');
            $contactModel->save(false);
        }
        $userMasterModel->father_first_name = NULL; $userMasterModel->father_last_name = NULL;
        $userMasterModel->mother_first_name = NULL; $userMasterModel->mother_last_name = NULL;
        $userMasterModel->guardian_first_name = NULL; $userMasterModel->guardian_last_name = NULL;

        foreach ($postData['contact_type_ref_id'] as $key=>$value) {
            $fname = $postData['pfname']; //$lname = $postData['plname'];

            if ($fname[$key] != '' && $value) {
                if ($postData['contact_type_ref_id'][$key] == 2) {
                    $userMasterModel->father_first_name = ucwords(strtolower(trim($fname[$key])));
                    //$userMasterModel->father_last_name = ucwords(strtolower(trim($lname[$key])));

                } elseif ($postData['contact_type_ref_id'][$key] == 3) {
                    $userMasterModel->mother_first_name = ucwords(strtolower(trim($fname[$key])));
                    //$userMasterModel->mother_last_name = ucwords(strtolower(trim($lname[$key])));

                } elseif ($postData['contact_type_ref_id'][$key] == 4) {
                    $userMasterModel->guardian_first_name = ucwords(strtolower(trim($fname[$key])));
                    //$userMasterModel->guardian_last_name = ucwords(strtolower(trim($lname[$key])));
                }

                if ($postData['country_codes'][$key] && $postData['phones'][$key]) {
                    $contactModel = new StudentContactNumber();
                    $contactModel->user_ref_id = $user_id;
                    $contactModel->is_primary = 0;
                    $contactModel->contact_type_ref_id = $postData['contact_type_ref_id'][$key];
                    $contactModel->phone_type = 'Mobile';
                    $contactModel->country_code = $postData['country_codes'][$key];
                    $contactModel->number = $postData['phones'][$key];
                    $countryId = TblCountryMaster::getCountryInfoByCode($postData['country_codes'][$key]);
                    $contactModel->country_ref_id = $countryId->country_id;
                    $contactModel->modified_by = $loginId;
                    $contactModel->modified_on = date('Y-m-d H:i:s');
                    $contactModel->added_by = $loginId;
                    $contactModel->save(false);
                }
                if ($postData['emails'][$key]) {
                    $emailModel = new StudentAlternateEmail();
                    $emailModel->login_ref_id = $userMasterModel->login_ref_id;
                    $emailModel->is_primary = 0;
                    $emailModel->is_active = 1;
                    $emailModel->contact_type_ref_id = $postData['contact_type_ref_id'][$key];
                    $emailModel->email_id = $postData['emails'][$key];
                    $emailModel->modified_by = $loginId;
                    $emailModel->modified_on = date('Y-m-d H:i:s');
                    $emailModel->added_by = $loginId;
                    $emailModel->save(false);
                }
            }
            $userMasterModel->save(false);
        }
        $criticalFields = array(
            'phone' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);

        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $section = $this->get_section($user_id);

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionDeleteParentInfo() {
        $userId = Yii::app()->request->getParam('uid') ? Yii::app()->request->getParam('uid') : Yii::app()->user->sub_id;
        $getUserData = TblUserMaster::getUserDetails($userId);
        $id = Yii::app()->request->getPost('id');
        $count1 = StudentAlternateEmail::deleteAlternateEmail($getUserData->login_ref_id, $id);
        echo $count1;
        $count2 = StudentContactNumber::deleteContactNumbers($userId, $id);
        echo $count2;
        $userMasterModel = TblUserMaster::model()->findByPk($userId);
        if ($id == 2) {
            $userMasterModel->father_first_name = NULL;
            $userMasterModel->father_last_name = NULL;
        } elseif ($id == 3) {
            $userMasterModel->mother_first_name = NULL;
            $userMasterModel->mother_last_name = NULL;
            ;
        } elseif ($id == 4) {
            $userMasterModel->guardian_first_name = NULL;
            $userMasterModel->guardian_last_name = NULL;
            ;
        }
        $userMasterModel->save(false);
        Yii::app()->end();
    }

    public function ActionAddMoreEntrance()
    {
        $i = Yii::app()->request->getParam('id');
        $userId = Yii::app()->request->getParam('UserId');
        $studentPreferredDepartmentIds = array();
        $userInfo = TblUserMaster::getUserDetails($userId);

        $studentPreferredDepartmentIds = array();
        $userInfo = TblUserMaster::getUserDetails($userId);
        $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
            }
        }
        $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);


        $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails($userId);
        if(count($preferredCountryListData) > 0) {
            foreach ($preferredCountryListData as $key => $value) {
                $studentPreferredCountryIds[] = $value->country_ref_id;
            }
        }

        $result1 = UserEntranceExam::getUserInternationexams($userId);
        $result = EntranceExam::getIntTestDetailsByCountryDepartmentArr($studentPreferredCountryIds, $studentPreferredDepartmentIds,true);
        $exams = CHtml::listData($result,'entrance_id','entrance_short_name');
        if(count($result1+$exams))
            $examlist['International']  = $result1+$exams;

        $otherResult = UserEntranceExam::getUserotherexams($userId);
        $examResult = EntranceExam::getIntTestDetailsByCountryDepartmentArr($studentPreferredCountryIds, $studentPreferredDepartmentIds,false);
        $otherlist = CHtml::listData($examResult,'entrance_id','entrance_short_name');
        if(count($otherResult+$otherlist))
            $examlist['Others'] = $otherResult+$otherlist;

        $this->renderPartial('addmore_entrance_exam', compact('i','userId','examlist'));
    }


    public function ActionAddMoreSubjects()
    {
        $i = Yii::app()->request->getParam('id');
        $subId = Yii::app()->request->getParam('subId');
        $testId = Yii::app()->request->getParam('testId');
        $testId = Yii::app()->request->getParam('testId');

        $testModulelist = EntranceExamModule::getEntranceModuleList($testId);
        $moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
        $data['moduleList'] = $moduleList;
        $entranceExam = EntranceExam::getTestAttributeById($testId, 'max_marks');
        $data['maxMarks'] = $entranceExam->max_marks;
        Yii::app()->session['dropdownOptionsCount']=count($data['moduleList']);
        //echo json_encode($data);

        $this->renderPartial('addmore_test_subjects', compact('i','subId','testId','moduleList'));
    }


    public function actionSaveExamInfo() {

        $model = new ProfileData('entrance');
        $model->attributes = $_POST['ProfileData'];

        $user_id = $model->user_id;
        $loginId = Yii::app()->user->id;
        $user = TblUserMaster::model()->findByPk($user_id);

        $criteria = new CDbCriteria;
        $criteria->condition = " user_ref_id = '".$user->user_id."' AND shortlist_status = '1' ";
        $examShortList = array();
        foreach(UserEntranceExam::model()->findAll($criteria) as $_UserEntranceExam){
            if($_UserEntranceExam->shortlist_status) {
                $examShortList[$_UserEntranceExam->shortlist_status] = $_UserEntranceExam->entrance_exam_ref_id;
            }
        }

        $criteria = new CDbCriteria;
        $criteria->condition = " user_ref_id = '".$user->user_id."' AND exam_year IS NOT NULL";
        foreach(UserEntranceExam::model()->findAll($criteria) as $_UserEntranceExam){
            foreach($_UserEntranceExam->userEntranceExamModules as $_userEntranceExamModules) $_userEntranceExamModules->delete();
            $_UserEntranceExam->delete();
        }

        if($model->exam_yesno)
        {
            $user->exams_required = $model->exam_yesno;
            $user->save(false);

            if($model->exam_yesno == 'Y'){
                foreach ($model->exams_info as $examID=>$examInfo) {
                    if(!$examID) continue;
                    $status = $examInfo['status'];
                    $year = $examInfo['year'];
                    $existExam = UserEntranceExam::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND entrance_exam_ref_id = '" . $examID. "' "));
                    if($existExam) {
                        $ExamModel = UserEntranceExam::model()->findByPk($existExam->user_entrance_exam_id);
                    }
                    else {
                        $ExamModel = new UserEntranceExam();
                        $ExamModel->shortlist_status = count($examShortList) ? array_search($examID,$examShortList) : 0;
                    }
                    //$ExamModel = new UserEntranceExam();
                    $ExamModel->setAttributes(array(
                        'user_ref_id' => $user_id,
                        'entrance_exam_ref_id' => $examID,
                        'exam_status' => $status,
                        'exam_year' => $year,
                        'added_by' => $loginId,
                        'added_on' => date('Y-m-d H:i:s'),
                    ), false);
                    //$ExamModel->shortlist_status = count($examShortList) ? array_search($examID,$examShortList) : 0;

                    if($status == 'Planned'){
                        $ExamModel->joined_coaching_inst = $examInfo['joined_coaching_inst'];
                    }
                    elseif($status == 'Completed'){
                        $ExamModel->reappear_exam = $examInfo['reappear_exam'];
                        $ExamModel->overall_marks = $examInfo['overall_marks'];
                    }

                    $ExamModel->save(false);
                    if($status == 'Completed')
                    {
                        if($ExamModel) {
                            foreach($examInfo['modules'] as $moduleID => $moduleScore) {
                                if($moduleScore)
                                {
                                    $examModuleModel = new UserEntranceExamModule();
                                    $examModuleModel->setAttributes(array(
                                        'entrance_exam_module_entrance_exam_ref_id' => $moduleID,
                                        'user_entrance_exam_ref_id' => $ExamModel->user_entrance_exam_id,
                                        'marks' => $moduleScore,
                                        'added_on' => date('Y-m-d H:i:s'),
                                        'added_by' => $loginId
                                    ),false);
                                    $examModuleModel->save(false);
                                }
                            }
                        }
                    }
                }
            }
        }

        $postData = $_POST['ProfileData'];
        $section = $postData['section'];
        $key = array_search ($section, $this->steps);
        if ($key < 6) {
            $key++;
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>$key));
        $section = '';
        if (!$det) {
            $det = new SignupSteps();
            $det->added_on = date('Y-m-d H:i:s');
            $det->user_ref_id = $postData['user_id'];
            $det->step_no = $key;
            $det->save();
        }
        //$section = $this->steps[$key];
        $section = $this->get_section($user_id);

        $return['user_id'] = $postData['user_id'];
        $return['section'] = $section;
        echo json_encode($return);
        Yii::app()->end();
    }

    public function checkCssAccess(){

        $domainArray = explode('.', $_SERVER['HTTP_HOST'], 2);
        $subDomain = strtolower($domainArray[0]);
        $this->instId = TblSiDi::isCssSchool($subDomain);
        if($this->instId){
            $this->isCssAccess = TRUE;
            $result = StudentUploadMasterNoEmail::getPendingStudentDetailByClass($this->instId);
            foreach($result as $studentDetails){
                if($studentDetails['first_name'] != ''){
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['first_name'] = $studentDetails['first_name'];
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['last_name'] = $studentDetails['last_name'];
                    //$this->cssStudentNamesList[$studentDetails['student_upload_master_no_email_id']] = $studentDetails['first_name'].' '.$studentDetails['last_name'];
                    $this->cssStudentNamesList[$studentDetails['first_name'].' '.$studentDetails['last_name']] = $studentDetails['first_name'].' '.$studentDetails['last_name'];
                }

            }
        }
    }

    public function updateStudentClass($userId, $year, $month) {
        if ($year && $month && $userId) {
            $user_details = TblUserMaster::model()->findByPk($userId);
            if ($user_details->user_id) {
                if (!$user_details->present_class && !$user_details->class_status) {
                    $current_year = date('Y');
                    $status = 'Pursuing';
                    $class = 12;
                    if ($year == $current_year) {
                        if ($month <= 6) {
                        } else {
                            $status = 'Completed';
                        }
                    } elseif ($year < $current_year) {
                        $class = 12;
                        $status = 'Completed';
                    } else {
                        $diff = $year - $current_year;
                        $class = $class - $diff;
                        if ($month > 6) {
                            $class += 1;
                        }
                    }

                    $user_details->present_class = $class;
                    $user_details->class_status = $status;
                    $user_details->save(false);
                }
            }
        }
    }

    public function actionSelectCountry() {

        $result = array();
        $cid = Yii::app()->request->getParam('cid');
        $city = Yii::app()->request->getParam('city');
        $res = TblCountryMaster::model()->find(array("condition" => "country_code = '".$cid."'  "));
        $cityRes = TblCityMaster::model()->find(array("condition" => "city_name LIKE '%".$city."' OR synonym_names LIKE '%".$city."' AND is_active = 'Y'"));
        $result['country_id'] = $res->country_id;
        $result['city_id'] = $cityRes->city_id;

        echo json_encode($result);
    }

    public function actionGetModuleList() {
        $testId = Yii::app()->request->getParam('testId');
        $testModulelist = EntranceExamModule::getEntranceModuleList($testId);
        $moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
        if($moduleList){
            $data['moduleList'] = $moduleList;
        }
        $entranceExam = EntranceExam::getTestAttributeById($testId, 'max_marks');
        $data['maxMarks'] = $entranceExam->max_marks;
        Yii::app()->session['dropdownOptionsCount']=count($data['moduleList']);
        echo json_encode($data);
    }

    public function actionGetCityList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $stateId = Yii::app()->request->getQuery('stateId');
        $result = array();
        if ($stateId > 0) {
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND state_ref_id = '" . $stateId . "'", "order" => "city_name"));
        } else if ($countryId > 0) {
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '" . $countryId . "' GROUP BY city_name ", "order" => "city_name"));
        }
        $cityResults = array();
        foreach ($result as $city) {
            $cityResults['key'.$city->attributes['city_id']] = $city->attributes['city_name'];
        }
        echo json_encode($cityResults);
    }

    public function actionCalculatePassoutYearByBoard() {

        $user_id = Yii::app()->request->getParam('user_id');
        $boardId = Yii::app()->request->getParam('boardId');
        $present_class = Yii::app()->request->getParam('class');
        if (!$user_id) { //if userId is not set return 0
            return 0;
        }

        $user = TblUserMaster::model()->findByPk($user_id);

        $currentYear = date('Y', strtotime($user->added_on));
        $currentMonth = date('n', strtotime($user->added_on));
        $return = array();

        $boardRes = LookupBoardEquivalent::model()->findByPk($boardId);
        $board = $boardRes->board_ref_id;
        $class = $user->present_class;
        $class_status = ($user->class_status == "Pursuing") ? 'p' : 'c';
        $class = $class.$class_status;
        $class = $user->present_class ? $class : $present_class;
        switch ($class) {
            case '9p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] = 3;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear+3;
                        } else {
                            $return['year'] = $currentYear+4;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                    default:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear+3;
                        }
                        else {
                            $return['year'] = $currentYear+4;
                        }
                        break;
                }
                break;
            case '10p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] = 3;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear+2;
                        } else {
                            $return['year'] = $currentYear+3;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                    default:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear+2;
                        } else {
                            $return['year'] = $currentYear+3;
                        }
                        break;
                }
                break;
            case '11p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  3;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear+1;
                        } else {
                            $return['year'] = $currentYear+2;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                    default:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear+1;
                        } else {
                            $return['year'] = $currentYear+2;
                        }
                        break;
                }
                break;
            case '12p':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  3;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear;
                        } else {
                            $return['year'] = $currentYear+1;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                    default:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear;
                        } else {
                            $return['year'] = $currentYear+1;
                        }
                        break;
                }
                break;
            case '12c':
                switch ($board) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return['month'] =  3;
                        if ($currentMonth <= 2) {
                            $return['year'] = $currentYear - 1;
                        } else {
                            $return['year'] = $currentYear;
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                    default:
                        $return['month'] =  6;
                        if ($currentMonth <= 6) {
                            $return['year'] = $currentYear - 1;
                        } else {
                            $return['year'] = $currentYear;
                        }
                        break;
                }
                break;
        }
        //return $return;
        echo json_encode($return);
    }

    public function actionSearch(){
        $res = array();
        if (isset($_GET['term'])) {
            $term = $_GET['term'];
            $criteria = new CDbCriteria;
            $criteria->select = '*';
            $criteria->condition = " course_name like '%$term%' AND user_entered = '0' ";
            $criteria->with = array('mainDeptRef'=>array('select'=>'mainDeptRef.department_name', 'joinType'=>'LEFT JOIN' ), 'subDeptRef'=>array('select'=>'subDeptRef.department_name', 'joinType'=>'LEFT JOIN'));
            $criteria->limit = 5;
            $data = Courses::model()->findAll($criteria);

            foreach ($data as $result) {
                $res[] = array(
                    'id'=>$result->course_id,
                    'value'=>$result->course_name,
                    'dept_id'=>$result->main_dept_ref_id,
                    'dept_name'=>$result->mainDeptRef->department_name,
                    'sub_dept_id'=>$result->sub_dept_ref_id,
                    'sub_dept_name'=>$result->subDeptRef->department_name,
                );
            }
        }
        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function parseOthers($arr) {
        $return = array();$others = 0;
        foreach ($arr as $key=>$value) {
            $v1 = strtolower($value);
            if (strpos($v1,'others') !== false) {
                $others = $key;
            } else {
                $return[$key] = $value;
            }
        }
        if ($others != 0) {
            $return[$others] = 'Others';
        }
        return $return;
    }

    public function actionGetStatesList() {
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblState::getStateByCountry($countryId);
        if($result) {
            echo json_encode($result); }
        else {
            $result['data'] =  0;
            echo json_encode($result);}
    }

    public function actionGetECOptions() {
        $interestTypeList = CHtml::listData(LookupUserInterestType::getUserInterestType($_POST['status']), 'user_interest_type_id', 'interest_type');
        echo json_encode($interestTypeList);
        Yii::app()->end();
    }
    public function actionGetECLevel() {
        $interestLevelList = CHtml::listData(LookupUserInterestLevel::getUserInterestLevel($_POST['status']), 'user_interest_level_id', 'interest_level');
        echo json_encode($interestLevelList);
        Yii::app()->end();
    }

    public function ActionTestSubjects()
    {
        $i = Yii::app()->request->getParam('id');
        $subId = Yii::app()->request->getParam('subId');
        $testId = Yii::app()->request->getParam('testId');

        $testModulelist = EntranceExamModule::getEntranceModuleList($testId);
        $moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
        $data['moduleList'] = $moduleList;
        $length = count($testModulelist);
        $entranceExam = EntranceExam::getTestAttributeById($testId, 'max_marks');
        $data['maxMarks'] = $entranceExam->max_marks;
        Yii::app()->session['dropdownOptionsCount']=count($data['moduleList']);
        //echo json_encode($data);

        $this->renderPartial('_test_subjects', compact('i','length','testId','moduleList','subId'));
    }

    public function actionGetPrefLocations()
    {
        $countryId = Yii::app()->request->getParam('cid');
        $term = Yii::app()->request->getParam('q');
        if ($countryId > 0) {
            $limit = ($countryId == 100) ? 5: 10;
            $locations = array();
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '" . $countryId . "' AND (city_name LIKE '".$term."%' OR synonym_names LIKE '%".$term."%') GROUP BY city_name ", "order" => "city_name","limit"=>$limit));
            foreach ($result as $city) {
                $locations[] = array('id' => 'c'.$city->attributes['city_id'], 'name' => $city->attributes['city_name']);
            }

            $result = TblState::model()->findAll(array("condition" => "country_ref_id = '" . $countryId . "' AND (name LIKE '".$term."%' OR synonym_names LIKE '%".$term."%') ", "order" => "name","limit"=>5));
            foreach ($result as $city) {
                $locations[] = array('id' => 's'.$city->attributes['id'], 'name' => $city->attributes['name']);
            }
            if ($countryId == 100) {
                $result = LookupRegion::model()->findAll(array("condition" => "country_ref_id = '" . $countryId . "' AND region_name LIKE '".$term."%' ", "order" => "region_name","limit"=>5));
                foreach ($result as $city) {
                    $locations[] = array('id' => 'r'.$city->attributes['region_id'], 'name' => $city->attributes['region_name']);
                }
            }
            if ($countryId == 100) {
                $result = LookupCityCluster::model()->findAll(array("condition" => "is_active = 'Y' AND (cluster_name LIKE '".$term."%' OR synonym_names LIKE '%".$term."%')", "order" => "cluster_name","limit"=>5));
                foreach ($result as $cluster) {
                    $locations[] = array('id' => 't'.$cluster->attributes['city_cluster_id'], 'name' => $cluster->attributes['cluster_name']); // t means cluster here
                }
            }
            echo json_encode($locations);
        }
    }

    public function actionCheckHomeCountry()
    {
        $jsonArr = array();
        $countryId = Yii::app()->request->getParam('cid');
        $user_id = Yii::app()->request->getParam('uid') ? Yii::app()->request->getParam('uid') : Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($user_id);
        $jsonArr['country'] = ($user->country_ref_id != $countryId && $countryId) ? 1 : 0;
        $cites = TblCityMaster::model()->count(array('condition' => "country_id='".$countryId."' "));
        $jsonArr['city'] = $cites>1 ? 1: 0;
        echo json_encode($jsonArr);
    }

    public function actionGetPrefExams()
    {
        $user_id = Yii::app()->request->getParam('uid') ? Yii::app()->request->getParam('uid') : Yii::app()->user->sub_id;
        $studentPreferredDepartmentIds = array();
        $userInfo = TblUserMaster::getUserDetails($user_id);
        $studentPreferredDepartments = $userInfo->studentPreferredDepartments;
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
            }
        }
        $studentPreferredDepartmentIds = array_filter($studentPreferredDepartmentIds);

        $preferredCountryListData = StudentPreferredCountry::getStudentPreferredCountryDetails($user_id);
        if(count($preferredCountryListData) > 0) {
            foreach ($preferredCountryListData as $key => $value) {
                $studentPreferredCountryIds[] = $value->country_ref_id;
            }
        }

        $exams = array();
        $term = Yii::app()->request->getParam('q');
        /*$result = UserEntranceExam::getUserTest($term, $user_id);
        foreach ($result as $exam) {
            $exams[] = array('id' => $exam['entrance_exam_ref_id'], 'name' => $exam['entrance_short_name']);
        }*/

        $prefResult = EntranceExam::getTestByCountryDepartment($studentPreferredCountryIds, $studentPreferredDepartmentIds,$term);
        foreach ($prefResult as $exam) {
            $exams[] = array('id' => $exam['entrance_id'], 'name' => $exam['entrance_short_name']);
        }

        echo json_encode($exams);

    }

    public function actionPartialExam(){

        $examID = Yii::app()->request->getParam('examID', false);
        $examName = Yii::app()->request->getParam('examName', false);

        $model = new ProfileData('entrance');
        $this->renderPartial('_entrance_exam', compact('model', 'examID', 'examName'), true);

        echo $this->clips['examOfInterest'];
    }

    public function DynamicPassoutYearAndMonth($currentClass) {
        $current_month = date('n');
        $year = date('Y');
        $return = array();
        switch ($currentClass) {
            case '9p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 3;
                } else {
                    $return['passout_year'] = $year + 4;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 9;
                $return['class_status'] = 'Pursuing';
                break;
            case '10p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 2;
                } else {
                    $return['passout_year'] = $year + 3;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 10;
                $return['class_status'] = 'Pursuing';
                break;
            case '11p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 1;
                } else {
                    $return['passout_year'] = $year + 2;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 11;
                $return['class_status'] = 'Pursuing';
                break;
            case '12p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year;
                } else {
                    $return['passout_year'] = $year + 1;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 12;
                $return['class_status'] = 'Pursuing';
                break;
            case '12c':
                $return['passout_year'] = 0;
                $return['passout_month'] = 0;
                $return['present_class'] = 12;
                $return['class_status'] = 'Completed';
                break;
        }
        return $return;
    }

    public function actionUpdateCareerOptions(){

        $user_id =  Yii::app()->session->get('studentID');
        $section ='preferences';
        $forIframe = true;
        $this->renderPartial('preferences_9_edit', compact('user_id', 'section', 'forIframe'), false, true);
    }

    public function separateFirstAndLastName($fullName)
    {
        $name = array();
        $stringToSplit = trim($fullName);
        $split = explode (
            ' ', implode (
                ' ', explode (
                    ".", $stringToSplit
                )
            )
        );

        if(count($split) == 1){
            $name['first_name'] = trim($split[0]);
        }
        else{
            $name['last_name'] = end($split); // taking last word as last name
            array_pop($split);
            $name['first_name'] = trim(implode(" ",$split)); // taking except last word as first name
        }
        return $name;
    }
    public function actionGetBoardsBySchool() {
        $schoolId = Yii::app()->request->getParam('schoolId', false);
            $instData = TblSiDi::GetInstIdFromSchoolId($schoolId);
            $inst_det = TblSiDi::model()->findByPk($instData->inst_id);
            if ($instData->inst_id) {
                $boardList12 = TblSiBoard::getSchoolBoardByCategory($instData->inst_id, '12');
            } else {
                $boardList12 = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
            }
            echo CHtml::dropDownList('ProfileData[board_12]', '', $boardList12, array('empty' => ' Curriculum', 'class'=>'grid_2', 'onchange'=>'getMarks("12", this.value)'));
    }

    public function actionGetSubjectListSuggest() {
        $term = Yii::app()->getRequest()->getParam('term', false);
        $user_id = Yii::app()->request->getParam('user_id');
        $user = TblUserMaster::model()->findByPk($user_id);
        $prefCourses = $user->getPreferredCourses();
        $keys = array();
        foreach($prefCourses as $prefCourse) {
            $keys[] = $prefCourse['main_dept_ref_id'];
        }
        $board = Yii::app()->request->getParam('board');

        if ($term) {
            $subjects = LookupStudentSubject::getPreferredSubjectsByDepartmentByTerm($term, $board, $keys);
            $val = array();
            if ($subjects) {;
                foreach ($subjects as $key=>$value) {
                    $val[] = array(
                        'id' => $key,
                        'label' => $value,
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionGetTenthSubjectListSuggest() {
        $term = Yii::app()->getRequest()->getParam('term', false);
        $user_id = Yii::app()->request->getParam('user_id');
        $board = Yii::app()->request->getParam('board');
        if ($term) {
            $subjects = LookupStudentSubject::getAutoSubjectListByBoard($term, 10);
            $val = array();
            if ($subjects) {
                foreach ($subjects as $key=>$value) {
                    $val[] = array(
                        'id' => $value->student_subject_id,
                        'label' => $value->subject_name,
                    );
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }
	public function actionThankyou(){
		Yii::app()->theme = 'new_grid_theme';
        //$this->layout = "//layouts/new_grid_inner";
        $this->layout = "//layouts/new_grid_signup";
        $this->render('thankyou');
    }
}