<?php
class EditProfile extends CFormModel
{
    public $first_name;
    public $middle_name;
    public $last_name;
    public $gender;

    public $present_school;

    public $dob_date;
    public $dob_month;
    public $dob_year;
    public $dob;
    public $ethnicity_ref_id;
    public $email_address;
    public $address1;
    public $address2;
    public $post_code;
    //public $city;

    public $country_code;
    public $phone_num;
    public $contact_num;
    public $country_ref_id;
    public $state_ref_id;
    public $city_ref_id;
    public $parent_first_name;
    public $parent_last_name;
    public $parent_country_code;
    public $parent_phone_num;
    public $parent_email_address;
    public $contact_type;
    public $introduce_yourself;

    public $selSports;
    public $selSportsLevel;
    public $selMusic;
    public $selMusicLevel;
    public $selVoice;
    public $selVoiceLevel;
    public $selVisualArt;
    public $selVisualLevel;
    public $selPerform;
    public $selPerformLevel;
    public $leadership_activity;
    public $other_activity;
    public $duplicate_interests;
    public $duplicate_interests1;
    public $duplicate_interests2;
    public $duplicate_interests3;
    public $duplicate_interests4;
    public $duplicate_country_preferences;
    public $duplicate_major_preferences;
    public $duplicate_session_preferences;

    public $levelOfStudy;
    public $countryPref1;
    public $countryPref2;
    public $countryPref3;
    public $targetCourse1;
    public $targetCourse2;
    public $targetCourse3;
    public $subCourse1;
    public $subCourse2;
    public $subCourse3;
    public $likely_session1;
    public $likely_session2;
    public $likely_session3;
    public $session_year1;
    public $session_year2;
    public $session_year3;

    public $present_studylevel;
    public $present_school12;
    public $present_school10;
    public $board10;
    public $board12;
    public $passout_month10;
    public $passout_year10;
    public $passout_month12;
    public $passout_year12;

    public $overall_10;
    public $overall_11;
    public $overall_12;
    public $overall_score_10;
    public $overall_score_11;
    public $overall_score_12;
    public $subject_10;
    public $subject_12;
    public $subjectpoints_10;
    public $subjectpoints_12;
    public $subjectgrades_10;
    public $subjectgrades_12;
    public $subject_score_10 = 0;
    public $subject_score_12 = 0;
    public $subject_points_10;
    public $subject_points_12;
    public $subject_grades_10;
    public $subject_grades_12;
    public $entrance_exam;
    public $entrance_exam_status;
    public $entrance_exam_appear;
    public $entrance_overall_score = 0;
    public $entrance_module_score = 0;
    public $entrance_exam_module;
    public $overall_marks_aa_10;
    public $overall_marks_a_10;
    public $overall_marks_b_10;
    public $overall_marks_c_10;
    public $overall_marks_d_10;
    public $overall_marks_aa_12;
    public $overall_marks_a_12;
    public $overall_marks_b_12;
    public $overall_marks_c_12;
    public $overall_marks_d_12;
    public $hidModuleRandIds;




    /**
     * Declares attribute labels.
     */
    public function attributeLabels()
    {
        return array(
            'first_name' => 'first name',
            'middle_name' => 'middle name',
            'last_name' => 'last name',
            'parent_first_name' => 'parent first name',
            'parent_last_name' => 'parent last name',
            'gender' => 'gender',
            'email_address' => 'email_address',
            'ethnicity_ref_id' => 'ethnicity',
            'present_school' => 'school name',
            'address1' => 'address line1',
            'address2' => 'address line2',
            'dob_date' => 'Birth date',
            'dob_month' => 'Birth month',
            'dob_year' => 'Birth year',
            'dob' => 'Date of Birth',
            //'city' => 'city name',
            'post_code' => 'zip code',
            'country_ref_id' => 'country',
            'state_ref_id' => 'state',
            'city_ref_id' => 'city',
            'country_code' => 'Country Code',
            'phone_num' => 'Phone Number',
            'contact_num' => 'contact number',
            'contact_type' => 'contact_type',
            'parent_phone_num' => 'parent phone number',
            'parent_country_code' => 'parent country code',
            'parent_email_address' => 'parent email address',
            'introduce_yourself' => 'Introduce yourself',
            'selSports' => 'Select Sports',
            'selSportsLevel' => 'Select Sports Level',
            'selMusic' => 'Select Music',
            'selMusicLevel' => 'Select Music Level',
            'selVoice' => 'Select Voice',
            'selVoiceLevel' => 'Select Voice Level',
            'selVisualArt' => 'Select Visual',
            'selVisualLevel' => 'Select Visual Level',
            'selPerform' => 'Select Perform',
            'selPerformLevel' => 'Select Perform Level',
            'leadership_activity' => 'Leadership Activity',
            'other_activity' => 'other extra curricular activity',
            'duplicate_interests' => 'Checking duplicate interests',
            'duplicate_interests1' => 'Checking duplicate interests',
            'duplicate_interests2' => 'Checking duplicate interests',
            'duplicate_interests3' => 'Checking duplicate interests',
            'duplicate_interests4' => 'Checking duplicate interests',
            'duplicate_country_preferences' => 'Checking duplicate country preferences',
            'duplicate_major_preferences' => 'Checking duplicate major preferences',
            'duplicate_session_preferences' => 'Checking duplicate session preferences',
            'levelOfStudy' => 'Study Level',
            'countryPref1' => 'Country Preference 1',
            'countryPref2' => 'Country Preference 2',
            'countryPref3' => 'Country Preference 3',
            'targetCourse1' => 'Mains 1',
            'targetCourse2' => 'Mains 2',
            'targetCourse3' => 'Mains 3',
            'subCourse1' => 'Sub Department 1',
            'subCourse2' => 'Sub Department 2',
            'subCourse3' => 'Sub Department 3',
            'session_year1' => 'Likely start period 1',
            'session_year2' => 'Likely start period 2',
            'session_year3' => 'Likely start period 3',
            'likely_session1' => 'Likely session 1',
            'likely_session2' => 'Likely session 2',
            'likely_session3' => 'Likely session 3',
            'present_studylevel' => 'Current Study Level',
            'board10' => 'Current Board',
            'board12' => 'Current Board',
            'passout_month10' => 'Passed month',
            'passout_year10' => 'Passed year',
            'overall_10' => 'Overall marks',
            'overall_11' => 'Overall marks',
            'overall_12' => 'Overall marks',
            'overall_score_10' => '10th Score Overall',
            'overall_score_11' => '11th Score Overall',
            'overall_score_12' => '12th Score Overall',
            'subject_10' => '10th Subject ',
            'subject_12' => '12th Subject ',
            'subject_score_10' => '10th Subject Marks',
            'subject_score_12' => '12th Subject Marks',
            'entrance_exam_status' => 'Status of entrance exam',
            'entrance_exam' => 'Entrance exam',
            'entrance_exam_appear' => 'Year of Appearance',
            'entrance_overall_score' => 'Entance Exam Overall score',
            'entrance_module_score' => 'Entrance Module Score',
            'entrance_exam_module' => 'Entrance Exam Module',
        );
    }


    /**s
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules()
    {
        return array(
            array('first_name, last_name', 'required', 'message' => 'Enter your {attribute}', 'on' => 'basicInfo'),
            array('first_name, middle_name, last_name, parent_first_name, parent_last_name', 'match', 'pattern' => '/^[a-z\.\'\)\( ]*$/i', 'message' => 'Only alphabets allowed', 'on' => 'basicInfo'),
            //array('gender, country_ref_id, city_ref_id, dob_date, dob_month, dob_year', 'required', 'message' => 'Select your {attribute}.', 'on' => 'basicInfo'),
            array('gender', 'required', 'message' => 'Select your {attribute}.', 'on' => 'basicInfo'),
            //array('phone_num, country_code', 'required', 'message' => 'Enter {attribute} ', 'on' => 'basicInfo'),
            array('email_address, parent_email_address', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/',
                'message' => ' Enter valid {attribute}', 'on' => 'basicInfo'),
            //array('parent_email_address', 'required', 'message' => "Enter parent's email", 'on' => 'basicInfo'),
            array('email_address', 'validateEmailAddress', 'on' => 'basicInfo'),
            array('dob', 'validateDOB', 'on' => 'basicInfo'),
            array('state_ref_id', 'validateState', 'on' => 'basicInfo'),
            array('present_school', 'validateSchool', 'on' => 'basicInfo'),
            array('post_code', 'match', 'pattern' => '/^[a-z0-9 ]*$/i', 'message' => 'zipcode invalid', 'on' => 'basicInfo'),
            //array('city', 'match', 'pattern' => '/^[a-z ]*$/i', 'message' => 'Please enter valid city', 'on' => 'basicInfo'),
            array('country_code', 'match', 'pattern' => '/^[0-9 ]*$/i', 'message' => '{attribute} invalid', 'on' => 'basicInfo'),
            array('parent_country_code', 'match', 'pattern' => '/^[0-9 ]*$/i', 'message' => '{attribute} invalid', 'on' => 'basicInfo'),
            array('phone_num, parent_phone_num', 'match', 'pattern' => '/^[0-9 ]*$/i', 'message' => 'phone number invalid', 'on' => 'basicInfo'),
            array('contact_num', 'validateContactNum', 'on' => 'basicInfo'),
            array('duplicate_country_preferences', 'validateCountryDuplicatePreferences', 'on' => 'PreferencesInfo'),
            array('duplicate_major_preferences', 'validateMajorDuplicatePreferences', 'on' => 'PreferencesInfo'),
            array('duplicate_session_preferences', 'validateSessionDuplicatePreferences', 'on' => 'PreferencesInfo'),
            array('duplicate_interests', 'validateDuplicateInterests', 'on' => 'CurricularInfo'),
            array('duplicate_interests1', 'validateDuplicateInterests1', 'on' => 'CurricularInfo'),
            array('duplicate_interests2', 'validateDuplicateInterests2', 'on' => 'CurricularInfo'),
            array('duplicate_interests3', 'validateDuplicateInterests3', 'on' => 'CurricularInfo'),
            array('duplicate_interests4', 'validateDuplicateInterests4', 'on' => 'CurricularInfo'),
            array('present_studylevel', 'required', 'message' => 'Select your {attribute}.', 'on' => 'EducationInfo'),
            array('duplicate_subjects12', 'validateDuplicateSubjects', 'on' => 'EducationInfo'),
            array('duplicate_subjects10', 'validateDuplicateSubjects', 'on' => 'EducationInfo'),
            array('duplicate_exams', 'validateDuplicateExams', 'on' => 'EducationInfo'),

            array('present_school12, board12, passout_month12, passout_year12, overall_score_12, subject_12, subject_score_12, subjectpoints_12
                  , subject_points_12, overall_marks_aa_12, overall_marks_a_12, overall_marks_b_12, overall_marks_c_12, overall_marks_d_12,
                  subjectgrades_12, subject_grades_12, present_school10, board10, passout_month10, passout_year10, overall_score_10, subject_10,
                  subject_score_10,subjectpoints_10
                  , subject_points_10, overall_marks_aa_10, overall_marks_a_10, overall_marks_b_10, overall_marks_c_10, overall_marks_d_10,
                  subjectgrades_10, subject_grades_10,entrance_exam,entrance_exam_status,entrance_exam_appear,entrance_overall_score,hidModuleRandIds,
                  entrance_exam_module,entrance_module_score,
                  ', 'safe', 'on' => 'EducationInfo'),

            //array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'basicInfo'),
        );
    }

    public function validateEmailAddress($attribute, $params){
        $emailAddress = $_POST['EditProfile']['email_address'];
        $loginRefID = $_POST['loginRefId'];
        $emailExist = LoginMaster::isDuplicateEmail($emailAddress,$loginRefID);

        if($emailExist)
        {
            $this->addError($attribute, 'Email Id is already exists. Please enter another Email Id');
        }
    }

    public function validateDOB($attribute, $params){
        $dobdate = $_POST['EditProfile']['dob_date'];
        $dobmonth = $_POST['EditProfile']['dob_month'];
        $dobyear = $_POST['EditProfile']['dob_year'];

        if(!@checkdate($dobmonth,$dobdate,$dobyear)) {
            $this->addError($attribute, 'Select a valid birth date ');
        }
    }

    public function validateState($attribute, $params){
        $countryId = $_POST['EditProfile']['country_ref_id'];
        $state = $_POST['EditProfile']['state_ref_id'];
        if($countryId == 100 && $state == "") {
            $this->addError($attribute, 'Please select state');
        }
    }

    public function validateContactNum($attribute, $params){
        $countrycode = $_POST['EditProfile']['parent_country_code'];
        $contactnum = $_POST['EditProfile']['parent_phone_num'];

        if($countrycode != '' && $contactnum == '') {
            $this->addError($attribute, 'Please enter valid parent contact number with country code');
        } else if($countrycode == '' && $contactnum != '') {
            $this->addError($attribute, 'Please enter valid parent contact number with country code');
        }
    }

    public function validateSchool($attribute, $params){
        $schoolname = $_POST['EditProfile']['present_school'];
        $userRefID = $_POST['userRefId'];
        $memberId = TblUserMaster::getMembershipId($userRefID);
        if($memberId > 1 && $schoolname == "") {
            $this->addError($attribute, 'Please enter school name');
        }
    }

    public function validateDuplicateInterests($attribute, $params){
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selSports']); $i++){
            if(($_POST['EditProfile']['selSports'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selSports'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selSports'][$i];
            }
        }
        /*$userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selMusic']); $i++){
            if(($_POST['EditProfile']['selMusic'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selMusic'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selMusic'][$i];
            }
        }
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selVoice']); $i++){
            if(($_POST['EditProfile']['selVoice'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selVoice'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selVoice'][$i];
            }
        }
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selVisualArt']); $i++){
            if(($_POST['EditProfile']['selVisualArt'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selVisualArt'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selVisualArt'][$i];
            }
        }
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selPerform']); $i++){
            if(($_POST['EditProfile']['selPerform'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selPerform'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selPerform'][$i];
            }
        }*/
    }

    public function validateDuplicateInterests1($attribute, $params){
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selMusic']); $i++){
            if(($_POST['EditProfile']['selMusic'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selMusic'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selMusic'][$i];
            }
        }
    }

    public function validateDuplicateInterests2($attribute, $params){
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selVoice']); $i++){
            if(($_POST['EditProfile']['selVoice'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selVoice'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selVoice'][$i];
            }
        }
    }

    public function validateDuplicateInterests3($attribute, $params){
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selVisualArt']); $i++){
            if(($_POST['EditProfile']['selVisualArt'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selVisualArt'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selVisualArt'][$i];
            }
        }
    }

    public function validateDuplicateInterests4($attribute, $params){
        $userInterests = array();
        for($i=0; $i<count($_POST['EditProfile']['selPerform']); $i++){
            if(($_POST['EditProfile']['selPerform'][$i] != 0)){
                if(in_array($_POST['EditProfile']['selPerform'][$i], $userInterests)){
                    $this->addError($attribute, 'Please remove duplicated interests');
                }
                $userInterests[] = $_POST['EditProfile']['selPerform'][$i];
            }
        }
    }

    public function validateCountryDuplicatePreferences($attribute, $params){
        $userPreferences = array();
        for($i=1; $i<4; $i++){
            if(($_POST['EditProfile']['countryPref'.$i] != 0)){
                if(in_array($_POST['EditProfile']['countryPref'.$i], $userPreferences)){
                    $this->addError($attribute, 'Please remove duplicated countries');
                }
            }
            $userPreferences[] = $_POST['EditProfile']['countryPref'.$i];
        }
    }

    public function validateMajorDuplicatePreferences($attribute, $params){
        $userPreferences = array();
        for($i=1; $i<4; $i++){
            if(($_POST['EditProfile']['targetCourse'.$i] != 0)){
                if(in_array($_POST['EditProfile']['targetCourse'.$i], $userPreferences)){
                    $this->addError($attribute, 'Please remove duplicated majors');
                }
            }
            $userPreferences[] = $_POST['EditProfile']['targetCourse'.$i];
        }
    }

    public function validateSessionDuplicatePreferences($attribute, $params){
        $userPreferences = array();
        for($i=1; $i<4; $i++){
            if(($_POST['EditProfile']['likely_session'.$i] != 0)){
                $sessionVal = $_POST['EditProfile']['likely_session'.$i].''.$_POST['EditProfile']['session_year'.$i];
                if(in_array($sessionVal, $userPreferences)){
                    $this->addError($attribute, 'Please remove duplicated sessions');
                }
            }
            $userPreferences[] = $_POST['EditProfile']['likely_session'.$i].''.$_POST['EditProfile']['session_year'.$i];
        }
    }

    public function validateDuplicateSubjects($attribute, $params){
        $studentClassDetails = array('12','10');
        foreach($studentClassDetails as $class) {
            if($_POST['EditProfile']['board'.$class][0] == '11' || $_POST['EditProfile']['board'.$class][0] == '13' || $_POST['EditProfile']['board'.$class][0] == '14'
                || $_POST['EditProfile']['board'.$class][0] == '17' || $_POST['EditProfile']['board'.$class][0] == '1' || $_POST['EditProfile']['board'.$class][0] == '2'
                || $_POST['EditProfile']['board'.$class][0] == '4' || $_POST['EditProfile']['board'.$class][0] == '15') {

                $userSubjects = array();
                for($i=0; $i<count($_POST['EditProfile']['subject_'.$class]); $i++){
                    if(($_POST['EditProfile']['subject_'.$class][$i] != 0)){
                        if(in_array($_POST['EditProfile']['subject_'.$class][$i], $userSubjects)){
                            $this->addError($attribute, 'Please remove duplicated subjects');
                        }
                        $userSubjects[] = $_POST['EditProfile']['subject_'.$class][$i];
                    }
                }
            } else if($_POST['EditProfile']['board'.$class][0] == '10' || $_POST['EditProfile']['board'.$class][0] == '20' || $_POST['EditProfile']['board'.$class][0] == '3'
                || $_POST['EditProfile']['board'.$class][0] == '18') {

                $userSubjects = array();
                for($i=0; $i<count($_POST['EditProfile']['subjectgrades_'.$class]); $i++){
                    if(($_POST['EditProfile']['subjectgrades_'.$class][$i] != 0)){
                        if(in_array($_POST['EditProfile']['subjectgrades_'.$class][$i], $userSubjects)){
                            $this->addError($attribute, 'Please remove duplicated subjects');
                        }
                        $userSubjects[] = $_POST['EditProfile']['subjectgrades_'.$class][$i];
                    }
                }
            } else if($_POST['EditProfile']['board'.$class][0] == '12' || $_POST['EditProfile']['board'.$class][0] == '27') {

                $userSubjects = array();
                for($i=0; $i<count($_POST['EditProfile']['subjectpoints_'.$class]); $i++){
                    if(($_POST['EditProfile']['subjectpoints_'.$class][$i] != 0)){
                        if(in_array($_POST['EditProfile']['subjectpoints_'.$class][$i], $userSubjects)){
                            $this->addError($attribute, 'Please remove duplicated subjects');
                        }
                        $userSubjects[] = $_POST['EditProfile']['subjectpoints_'.$class][$i];
                    }
                }
            }
        }

    }

    public function validateDuplicateExams($attribute, $params){
        $userEntrance = array();
        $maxmodule_marks = array();
        for($km=0;$km<count($_POST['EditProfile']['entrance_exam']);$km++) {
            $randVal = $_POST['EditProfile']['hidModuleRandIds'][$km];
            $userEntranceModule[$randVal] = array();
            if(($_POST['EditProfile']['entrance_exam'][$km] != 0)){
                $cdbcriteria = new CDbCriteria();
                $cdbcriteria->condition = 'entrance_id = '.$_POST['EditProfile']['entrance_exam'][$km];
                $EntranceExam = EntranceExam::model()->find($cdbcriteria);
                $ExamModulesList = $EntranceExam->entranceExamModuleEntranceExams;
                foreach($ExamModulesList as $ExamModulesLists) {
                    $maxmodule_marks[$_POST['EditProfile']['entrance_exam'][$km]][$ExamModulesLists->attributes['entrance_exam_module_entrance_exam_id']][] = $ExamModulesLists->attributes['max_marks'];
                }

                if($randVal !="inputRandId") {
                    for($j=0;$j<count($_POST['EditProfile']['entrance_exam_module'][$randVal]);$j++) {
                        if($_POST['EditProfile']['entrance_exam_module'][$randVal][$j] !=0) {
                            $maxmodulemarks = $maxmodule_marks[$_POST['EditProfile']['entrance_exam'][$km]][$_POST['EditProfile']['entrance_exam_module'][$randVal][$j]][0];
                            if($_POST['EditProfile']['entrance_module_score'][$randVal][$j] > $maxmodulemarks) {
                                $this->addError($attribute, 'Please enter modules less than max marks '.$maxmodulemarks);
                            }
                            if(in_array($_POST['EditProfile']['entrance_exam_module'][$randVal][$j], $userEntranceModule[$randVal])){
                                $this->addError($attribute, 'Please remove duplicated exam modules');
                            }
                            $userEntranceModule[$randVal][] = $_POST['EditProfile']['entrance_exam_module'][$randVal][$j];
                        }
                    }
                }
                $max_marks = $EntranceExam->attributes['max_marks'];
                if($_POST['EditProfile']['entrance_overall_score'][$km] > $max_marks) {
                    $this->addError($attribute, 'Please enter overall score less than max marks '.$max_marks);
                }
                if(in_array($_POST['EditProfile']['entrance_exam'][$km], $userEntrance)){
                    $this->addError($attribute, 'Please remove duplicated exams');
                }
                $userEntrance[] = $_POST['EditProfile']['entrance_exam'][$km];

            }
        }
    }



}

?>