<?php
yii::import('zii.widgets.CPortlet');

class BasicInformation extends CPortlet
{
    public $rbacRole = '';
    public $_hasEdit = false;
    public $_isDI = false;
    public $userData;
    public $userParams = array();
    public $isFullVisibilty = true;
    public $profileValidationAccess = false;
    public $citizenships = array();
    public $pdfDownload = false;

    public function init() {
        // pre-process if any
    }

    public function run() {
        //$this->printr($this->userData);
        $student_id = $this->userData->user_id;
		if($this->_isDI){
			// For Di User Default Visibilty will be false
			// But it can be tru only if di user Bought this profile
			$this->isFullVisibilty = false;
			$di_id = Yii::app()->user->di_id;
			if(DiHelper::isDiBoughtStudentProfile($di_id,$student_id)){
			$this->isFullVisibilty = true;
			}
		}

        $expertVendor = Yii::app()->user->getState('isVendor');
        if($expertVendor){
            $this->isFullVisibilty = false;
            $expertID = Yii::app()->user->sub_id;
            if(DiHelper::isVendorBoughtStudentProfile($expertID,$student_id)){
                $this->isFullVisibilty = true;
            }
        }

		//Citizenship Start
        $citizenshipArray = array();
        foreach($this->userData->studentCitizenships as $citizenship){
                $citizenshipArray[] = $citizenship->citizenshipRef->country_name;
        }
        if(count($citizenshipArray) > 0){
                $this->citizenships['citizenship'] = implode('<br>', $citizenshipArray);
        }else{
                $this->citizenships['citizenship'] = 'N/A';
        }
        //Citizenship Start

        if(strtolower(Yii::app()->controller->action->id) == 'viewpdfdownload')
            $this->pdfDownload = true;
                    
        if(Yii::app()->request->getParam('ptype') == 'ext'){
            $this->render('external_basic_info', array("Attachment" => false));
        }

        else if(Yii::app()->request->getParam('ptype') == 'intrnl'){
            $this->render('internal_basic_info', array("Attachment" => false));
        }

        else
            $this->render('basic_info');

    }

    public function printr($array=array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }
}