<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 5);
$milestone = UserMilestone::model()->find($criteria);


$typeLabels = StudentIdealList::getTypeLabels();
?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 5,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->
		
		<?php
           if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>
		Student did not finish this milestone yet.
		</div>
		<div class="clear">&nbsp;</div>
		<?php
		    else:
		?>
		
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="adminform">
          <tr>
            <th scope="col">Confirmed date - <?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?></th>
            <th scope="col" style="text-align:right;">
            	<?php
					echo CHtml::ajaxButton(
						"Invalidate", 
						Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
						array ( 
							'type' => 'POST',
							'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
							'dataType' => 'json',
							'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
							'beforeSend' => 'js:  function(){ }',
							'complete' => 'js:  function(){ }',
						),
						array(
							'id' => 'invalidate-button',
							'class' =>'alertbutton on'
						)
					);
				?>
            </th>
          </tr>
        </table>

		<div class="clear">&nbsp;</div>
        <div class="tabs">
			
				<?php
				/**  code to highlight the selected link */
				$alertOn = "";
				if($idealType == StudentIdealList::TYPE_ASPIRATIONAL)
				    $aOn = 'on';
				else if($idealType == StudentIdealList::TYPE_BEST_FIT)
				    $bOn = 'on';
				else if($idealType == StudentIdealList::TYPE_SAFE)
				    $sOn = 'on';
				 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_ASPIRATIONAL], 
				Yii::app()->createUrl('sms/milestone/Ms5Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_ASPIRATIONAL,
			            'departmentId' => $departmentId,
				)),
				array(
							'class' => 'alertbutton '.$aOn,
	            )
				);
				?>
				<?php 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_BEST_FIT], 
				Yii::app()->createUrl('sms/milestone/Ms5Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_BEST_FIT,
			            'departmentId' => $departmentId,
				)),
				array(
							  'class' => 'alertbutton '.$bOn,
	            )
				);
				?>
				<?php 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_SAFE], 
				Yii::app()->createUrl('sms/milestone/Ms5Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_SAFE,
			            'departmentId' => $departmentId,
				)),
				array(
							  'class' => 'alertbutton '.$sOn,
	            )
				);
				?>
				
		</div>

		
		<div class="clear"></div>
		<div id="<?php echo $idealType; ?>Container" style="background:#fff; padding:3px 8px; border:1px solid #eee; margin-top:5px;">
       <div class="clear">&nbsp;</div>
        <div>
			
			<?php
			$departments = $student->studentPreferredDepartments;
			foreach($departments as $department):
				if($department->subDeptRef->department_id == $departmentId)
				 $alertOn = 'on';
				else
				 $alertOn = ''; 
				echo CHtml::link($department->subDeptRef->department_name,
				Yii::app()->createUrl('sms/milestone/Ms5Helper', array(
                		    'studentId' => $student->user_id,
        			        'type' => $idealType,
                		    'departmentId' => $department->subDeptRef->department_id,
				)),
				array(
							  'class' => 'alertbutton '.$alertOn,
	            )
				);
				?>				
				<?php
				endforeach;
				?>
			
		</div>
			<div class="form">
				<h3><?php echo $typeLabels[$idealType]; ?> List</h3>
				
				<div id="<?php echo $idealType; ?>List" class=" padding border_radius2 filters" >
				<ol id="<?php echo $idealType; ?>Colleges" style="list-style-type: decimal; color:#555; font:14px/20px Arial, Helvetica, sans-serif;">
				<?php
				$universities = $studentIdealList->applyingCollegeList;
				$i = 0;
				foreach($universities as $university):
				?>
				    <li style="list-style-type: decimal;">
				    	<label><?php echo $university->university->uni_name; ?></label>
				    	<span><?php ?></span>
				    </li>
                <?php
				endforeach;
				?>
				</ol>
				</div>
                <div class="float_rt">
                <?php
                    if($studentIdealList->status != StudentIdealList::STATUS_CONFIRMED):
                ?>
                <input type="button" class="button border_radius2 save-order" value="Save Preference Order" class="save-order" />
                <span id="order-message" style=" color: #999; display: none;"></span>
                <?php
                    endif;
                ?>
                </div>
                <div class="clear">&nbsp;</div>
			</div>
		</div>
<?php 
	endif;
?>
		
	</div>
</div>

