<?php
$user = TblUserMaster::model()->findByPk($user_id);
$education_10 = StudentEducation::model()->findByAttributes(array('class_level'=>'9', 'user_ref_id'=>$user_id));

$classes = array('9'=>'9th', '10'=>'10th');

$boardList = array();
$boardList = LookupBoardEquivalent::getBoardCategoryByClass('9','',true);
?>
<div class="visible clearfix">
    <div class="grid_3 pull small_gutter_r rwd_no_ft text-right small_gutter_t"><strong><?php echo ($user->present_class == '10') ? '9th' : '10th';?> (Completed)</strong></div>
    <div class="grid_8 pull small_gutter_r small_gutter_t small">
        <div data-class="10class">
            <div class="gutter_vertical visible clearfix">
                <div class="left small-right relative">
                    <?php
                    $model->school_name_10 = $education_10->school_name;
                    $this->widget('zii.widgets.jui.CJuiAutoComplete', array(
                        'model' =>$model,
                        'attribute' => 'school_name_10',
                        'source' => $this->createUrl('/myProfile/getSchoolList', $userParams),
                        'options' => array(
                            'minLength' => '2',
                        ),
                        'htmlOptions' => array(
                            'placeholder' => 'Enter School Name',
                            'class' => 'grid_2'
                        ),
                    ));
                    echo $form->error($model, 'school_name_10', array('class'=>'popup errorMessage'));
                    ?>
                </div>
                <div class="left small-right relative styledSelect2 resp_rwd">
                    <?php
                    $years = array();$year = date('Y');
                    for ($i = 0;$i < 5;$i++) {
                        $y = $year - $i;
                        $years[$y] = $y;
                    }
                    $model->year_10 = $education_10->year;
                    echo $form->dropDownList($model, 'year_10', $years, array('empty' => 'Completion Year', 'class'=>'grid_2'));
                    echo $form->error($model, 'year_10', array("class" => "errorMessage popup"));
                    ?>
                </div>
                <div class="left small-right relative styledSelect2 resp_rwd">
                    <?php
                    $model->board_10 = $education_10->board_ref_id;
                    echo $form->dropDownList($model, 'board_10', $boardList, array('empty' => ' Curriculum', 'class'=>'grid_2', 'onchange'=>'getMarks("9", this.value)'));
                    echo $form->error($model, 'board_10', array("class" => "errorMessage popup"));

                    $disp_marks_10 = $disp_marks_gpa_10 = $disp_points_10 = $disp_grades_10 = 'none';
                    if ($education_10->board_ref_id) {
                        $board_10 = LookupBoardEquivalent::model()->findByPk($education_10->board_ref_id);
                        switch ($board_10->overall_type) {
                            case 'Marks':
                                $disp_marks_10 = 'block';
                                $education_10->overall_marks = (float)$education_10->overall_marks;
                                $model->overall_marks_10 = $education_10->overall_marks;
                                break;
                            case 'Marks-GPA':
                                $disp_marks_gpa_10 = 'block';
                                $education_10->overall_marks = (float)$education_10->overall_marks;
                                $model->overall_marks_gpa_10 = $education_10->overall_marks;
                                break;
                            case 'Points':
                                $disp_points_10 = 'block';
                                $education_10->overall_marks = (int)$education_10->overall_marks;
                                $model->overall_points_10 = $education_10->overall_marks;
                                break;
                            case 'Grades':
                                $disp_grades_10 = 'block';
                                break;
                        }
                    } else {
                        $disp_marks_10 = 'block';
                    }
                    ?>
                </div>
                <?php if ($education_10->board_ref_id) { ?>
                <script>
                    $(document).ready(function(){
                        getMarks("9", <?php echo $education_10->board_ref_id; ?>);
                    });
                </script>

                <?php } ?>
                <div class="left small-right marks_9 visible  relative resp_rwd" id="9_board_marks" style="display: <?php echo $disp_marks_10; ?>" >
                    <?php
                    echo $form->textField($model,'overall_marks_10', array( 'class'=>'grid_2','placeholder' => 'Overall Score', 'maxlength'=>'3'));
                    echo $form->error($model, 'overall_marks_10', array('class'=>'popup errorMessage'));
                    ?>
                </div>

                <div class="left small-right marks_9 visible  relative resp_rwd" id="9_board_marks-gpa" style="display: <?php echo $disp_marks_gpa_10; ?>">
                    <?php
                    echo $form->textField($model,'overall_marks_gpa_10', array( 'class'=>'grid_2','placeholder' => 'Overall Score', 'maxlength'=>'3'));
                    echo $form->error($model, 'overall_marks_gpa_10', array('class'=>'popup errorMessage'));
                    ?>
                </div>

                <div class="left small-right marks_9 visible relative  styledSelect2 resp_rwd" id="9_board_points" style="display: <?php echo $disp_points_10; ?>">
                    <?php
                    $pointsList = array();
                    for($i = 63; $i > 0; $i--) {
                        $pointsList[$i] = $i;
                    }
                    echo $form->dropDownList($model, 'overall_points_10', $pointsList, array('empty' => ' Points ', 'class'=>'grid_2'));
                    echo $form->error($model, 'overall_points_10', array('class'=>'popup errorMessage'));
                    ?>
                </div>

                <div class="clearfix grid_7 pull small_gutter_t marks_9 visible " id="9_board_grades" style="display: <?php echo $disp_grades_10; ?>">
                    <div class="small small_gutter_t"> <?php echo ($user->class_status == 'Completed') ? 'Grades Received' : 'Grades Expected';?></div>
                    <?php
                    if ($disp_grades_10 == 'block') {
                        $grade_count = StudentGradeCount::model()->findAll(array('condition' => 'student_education_ref_id = '.$education_10->student_education_id));
                        foreach ($grade_count as $grade) {
                            $ref = $grade['board_conversion_ref_id'];
                            $model->overall_grade_10[$ref] = $grade['grade_count'];
                        }
                    }
                    $grades = LookupBoardConversion::getGradesByBoard(23,true);
                    $alphabet = array('A*','A','B','C','D','E','F','G');
                    $j = 0;
                    echo '<div class="clearfix small_gutter_t">';
                    foreach($grades as $k=>$val) {
                        if($j==4){
                            echo '</div><div class="clearfix small_gutter_t">';
                        }
                        ?>
                        <div class="left small-right relative styledSelect2 resp_rwd" style="width: 85px">
                            <?php
                            $aa = array();
                            for($i=1;$i<10;$i++){
                                $aa[$i] = $i.' '.$val;
                            }
                            echo $form->dropDownList($model, "overall_grade_10[$k]", $aa, array('empty' => "#".$alphabet[$j], 'class'=>'full-width', 'style'=>'font-family: verdana;'));
                            if($j == 0){
                                echo $form->error($model, "overall_grade_10[$k]", array("class" => "errorMessage popup"));
                            }
                            ?>
                        </div>
                        <?php $j++;} ?>
                </div>
            </div>
        </div>
   </div>
</div>
</div>
<script>
    var marks_type = new Array();
    marks_type[23] = 'grades';
    marks_type[28] = 'points';
    marks_type[21] = marks_type[22] = marks_type[24] = marks_type[25] = marks_type[26] = 'marks';

    var user_id = <?php echo $user_id ?>;
    function getMarks(id, board) {
        var val = marks_type[board];
        if(val) {
            var val = marks_type[board];
        } else {
            var val = 'marks';
        }
        $('.marks_'+id).hide();
        $('#'+id+'_board_'+val).show();
    }
</script>