<?php
class  MyProfileController extends Controller {

    public $instId = '';
    public $isCssAccess = false;
    public $cssStudentNames = array();
    public $cssStudentNamesList = array();
    public $rbacRole = '';


    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";

        $this->checkCssAccess();
        $rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if ($rbacRole == 'Student'){
            $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
            $contactNo = StudentContactNumber::model()->count('user_ref_id=:user_ref_id AND contact_type_ref_id = 1', array('user_ref_id' => Yii::app()->user->sub_id));
            $signUpSteps = SignupSteps::model()->count('user_ref_id=:user_ref_id', array('user_ref_id' => Yii::app()->user->sub_id));
            if($contactNo && $signUpSteps<5)
            {
                $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'new_profile',), 1);
                $redirectUrl = $urlDetails[0]['url'];
                if($redirectUrl) {
                    $this->redirect($redirectUrl) ;
                }
            }
        }
    }

    public function actionIndex() {
        $model = new ProfileData();
        $user_id = Yii::app()->user->sub_id;

        $user = TblUserMaster::model()->findByPk($user_id);

        if(!Yii::app()->user->isGuest) {
            $country_id = $dept_id = 0;
            $objShortList = new ShortListEngine();
            $shortList = $objShortList->getShortList(array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY));

            //For recommended colleges (Start)
            $limit = 3;
            $offset = 0;
            $result_count = 0;
            $aspirationList=array();
            if (!empty($_POST)) {
                $limit = $_POST['limit'];
                $offset = $_POST['offset'];
            }

            $user = TblUserMaster::model()->findByPk($user_id);
            if($user->present_class > 10) { // If student full filling all eligibility cirteria
            $result_sql=" SELECT tum.uni_id FROM tbl_university_master tum
            JOIN di ON di.uni_ref_id = tum.uni_id
            JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
            JOIN lookup_department ld ON ld.department_id = tuc.department_ref_id
            WHERE ld.main_dept_id IN (SELECT main_dept_ref_id FROM student_preferred_department WHERE user_ref_id = ".$user_id.")
            AND country_ref_id IN (SELECT country_ref_id FROM student_preferred_country WHERE user_ref_id = ".$user_id.")
            AND di.di_type_ref_id != 1 AND tum.is_active='Y' AND di.is_test = 'N' AND di.is_active = 1 AND tum.uni_id NOT IN
            (SELECT stdu.uni_ref_id FROM student_shortlist_university stdu WHERE stdu.user_ref_id=".$user_id." AND stdu.shortlist_status!='Reject')
            GROUP BY uni_id";
                $list= Yii::app()->db->createCommand($result_sql)->queryAll();
                $result_count=count($list);
                //$aspirationList=$this->getRecomendedData($user_id,$limit,$offset);
                Yii::import('application.controllers.ShortlistCollegesController');
                $obj = new ShortlistCollegesController(); // preparing object
                $aspirationList = $obj->getRecomendedData($user_id,$limit,$offset);
            }
            //Recommended collges (End).

        }

        $this->render('index', compact('user_id', 'model','user','shortList','aspirationList','result_count','offset'));
	}

    public function actionValidate() {
        $model = new ProfileData('profile');
        if (Yii::app()->request->isAjaxRequest) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }


    public function actionSaveProfile() {

        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$user_id."'";
        foreach(StudentPreferredCountry::model()->findAll($criteria) as $_StudentPreferredCountry) $_StudentPreferredCountry->delete();

        $i = 0;
        if ($postData['country_not_sure']) {
            $obj = new StudentPreferredCountry();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->not_sure = 1;
            $obj->{preference_order} = 1;
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save();
        } else {
            $user->is_location_entered = $postData['is_location_entered'];
            $user->save(false);
            foreach ($postData['country_pref'] as $key=> $value) {
                if ($value['countryids'])
                {   $i++;
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $postData['user_id'];
                    $obj->{country_ref_id} = $value['countryids'];
                    $obj->{preference_order} = $i;
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save();
                }
            }
            $prefLocations = $postData['country_pref'][0]['pref_location'];
            $locations = explode(',',$prefLocations);
            if($prefLocations)
            {
                foreach ($locations as $k => $loc)
                {
                    $model = new StudentPreferredLocation();
                    $model->{preferred_country_ref_id} = $obj->preferred_country_id;
                    $subString = substr($loc,0,1);
                    $clrLoc = substr($loc,1);
                    if($subString == 'c') {
                        $model->{city_ref_id} = $clrLoc;
                        $res = TblCityMaster::model()->findByPk($clrLoc);
                        $prefCountry = StudentPreferredCountry::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  country_ref_id = '".$res->country_id."' "));
                        $model->{preferred_country_ref_id} = $prefCountry->preferred_country_id;
                    } elseif($subString == 's') {
                        $model->{state_ref_id} = $clrLoc;
                        $res = TblState::model()->findByPk($clrLoc);
                        $prefCountry = StudentPreferredCountry::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  country_ref_id = '".$res->country_ref_id."' "));
                        $model->{preferred_country_ref_id} = $prefCountry->preferred_country_id;
                    } elseif($subString == 'r') {
                        $model->{region_ref_id} = $clrLoc;
                        $res = LookupRegion::model()->findByPk($clrLoc);
                        $prefCountry = StudentPreferredCountry::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  country_ref_id = '".$res->country_ref_id."' "));
                        $model->{preferred_country_ref_id} = $prefCountry->preferred_country_id;
                    } elseif($subString == 't') {
                        $model->{cluster_ref_id} = $clrLoc;
                        $res = TblCityMaster::model()->find(array("condition" => "cluster_ref_id = '" . $clrLoc . "' "));;
                        $prefCountry = StudentPreferredCountry::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  country_ref_id = '".$res->country_id."' "));
                        $model->{preferred_country_ref_id} = $prefCountry->preferred_country_id;
                    }
                    $model->added_on = date('Y-m-d H:i:s');
                    $model->save(false);
                }
            }
        }
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$postData['user_id']."'";
        foreach(StudentPreferredDepartment::model()->findAll($criteria) as $_StudentPreferredDepartment) $_StudentPreferredDepartment->delete();

        $i = 0;
        if ($postData['dept_not_sure']) {
            $obj = new StudentPreferredDepartment();
            $obj->{user_ref_id} = $postData['user_id'];
            $obj->{preference_order} = 1;
            $obj->not_sure = 1;
            $obj->added_on = date('Y-m-d H:i:s');
            $obj->save();
        } else {
            foreach ($postData['dept_pref'] as $key=>$value) {$course_id = '';
                if ($value) { $i++;

                    if ($postData['dept_others'][$i] != "") {
                        $criteria = new CDbCriteria;
                        $criteria->select = 'course_id';
                        $criteria->condition = " course_name = '".$postData['dept_others'][$i]."' AND user_entered = '0' ";
                        $data = Courses::model()->find($criteria);
                        if ($data) {
                            $course_id = $data->course_id;
                        } else {
                            $obj = new Courses();
                            $obj->course_name = $postData['dept_others'][$i];
                            $obj->main_dept_ref_id = $postData['dept_pref'][$i];
                            $obj->sub_dept_ref_id = ($postData['sub_dept_pref'][$i]) ? $postData['sub_dept_pref'][$i] : '';
                            $obj->user_entered = '1';
                            $obj->added_on = date('Y-m-d H:i:s');
                            $obj->save(false);

                            $criteria->select = 'course_id';
                            $criteria->condition = " course_name = '".$postData['dept_others'][$i]."' AND user_entered = '1' ";
                            $data = Courses::model()->find($criteria);
                            $course_id = $data->course_id;
                        }
                    }

                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $postData['user_id'];
                    $obj->{main_dept_ref_id} = $value;
                    $obj->{sub_dept_ref_id} = $postData['sub_dept_pref'][$key];
                    $obj->{preference_order} = $i;
                    if ($course_id != '') {
                        $obj->{course_ref_id} = $course_id;
                    }
                    $obj->added_on = date('Y-m-d H:i:s');
                    $obj->save();
                }
            }
        }

        $criticalFields = array(
            'country' => 1,
            'intended_subjects' => 1,
            'likely_start_period' => 1,
        );

        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);
        if(in_array($user->present_class, array(11, 12))) {
            $step2 = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>2));
            if (!$step2) {
                $step2 = new SignupSteps();
                $step2->added_on = date('Y-m-d H:i:s');
                $step2->user_ref_id = $postData['user_id'];
                $step2->step_no = 2;
                $step2->save();
            }
        }
        $shortList = new ShortListEngine();
        $shortList->profileUpdated();

        // Save Education
        if(in_array($user->present_class, array(11, 12))){
            $this->saveEducation();
        } elseif($user->present_class == '10') {
            $this->saveEducation9();
        }

    }

    public function saveEducation() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];

        $board_12 = LookupBoardEquivalent::model()->findByPk($postData['board_12']);
        $user = TblUserMaster::model()->findByPk($user_id);
        $user->passout_year = $postData['year_12'];
        $user->present_board_ref_id = $board_12->board_ref_id;
        $user->save(false);

        $obj = new StudentRegistration();
        $obj->calculateLikelyStartPeriod($user_id);

        $education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$user_id));

        if ($education_12) {
            foreach(StudentGradeCount::model()->findAll('student_education_ref_id=' . $education_12->student_education_id) as $_StudentGradeCount) $_StudentGradeCount->delete();
            foreach(StudentEducation::model()->findAll('student_education_id=' . $education_12->student_education_id) as $_StudentEducation) $_StudentEducation->delete();
        }
        $education_12 = new StudentEducation();
        $education_12->added_on = date('Y-m-d H:i:s');
        $education_12->user_ref_id = $user_id;
        $education_12->class_level = '12';

        $education_12->board_ref_id = $postData['board_12'];
        if ($board_12->overall_type == 'Marks') {
            $education_12->overall_marks = $postData['overall_marks_12'];
        } elseif ($board_12->overall_type == 'Marks-GPA') {
            $education_12->overall_marks = $postData['overall_marks_gpa_12'];
        } elseif ($board_12->overall_type == 'Points') {
            $education_12->overall_marks = $postData['overall_points_12'];
        }
        $education_12->status = $user->class_status;
        $education_12->year = $postData['year_12'];
        $education_12->school_name = $postData['school_name_12'];
        $education_12->save(false);

        $education_12 = StudentEducation::model()->findByAttributes(array('class_level'=>'12', 'user_ref_id'=>$user_id));

        if ($board_12->overall_type == 'Grades') {
            foreach($postData['overall_grade_12'] as $key=>$val){
                if($val) {
                    StudentGradeCount::setStudentGrades($education_12->student_education_id, $key, $val);
                }
            }
        }

        if(trim($postData['school_name_12']) != ''){
            $schoolExistID = $postData['school_id'];
            if(!$schoolExistID){
                $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name_12']));
            }
            $siDiData = TblSiDi::GetInstIdFromSchoolId($user->school_ref_id);
            // If Change School Delete the record
            if($schoolExistID != $user->school_ref_id){
                $findInstId = TblSiStudents::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  inst_ref_id = '".$siDiData->inst_id."' "));
                if($findInstId){
                    $findInstId->delete();
                }
            }
            if($schoolExistID){
                $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
                if($siDiData->inst_id){
                    $instId = $siDiData->inst_id;
                    //inserting to tbl_si_students if he is related to a School
                    if($schoolExistID != $user->school_ref_id) {
                        $studentSignupModel = new StudentSignup('firstPage');
                        $studentSignupModel->setSiStudents($user_id, $instId);
                    }
                } else {
                    $instId = 'null';
                }
            }
            $userMembershipRefId = ($instId > 0) ? 2 : 1; // 2 for SI and 1 for guest
            $user->membership_ref_id = $userMembershipRefId;
            $user->save(false);

            if ($schoolExistID) {
                $user->school_ref_id = $schoolExistID;
            } else {
                $checkSchool = LookupSchool::getUserSchoolID(trim($postData['school_name_12']));
                if(!$checkSchool){
                LookupSchool::addStudentSchool(trim($postData['school_name_12']));
                }
                $schoolExistID = LookupSchool::getUserSchoolID(trim($postData['school_name_12']));
                $user->school_ref_id = $schoolExistID;
            }
            $user->save(false);
        }

        $education_10 = StudentEducation::model()->findByAttributes(array('class_level'=>'10', 'user_ref_id'=>$user_id));
        $board_10 = LookupBoardEquivalent::model()->findByPk($postData['board_10']);
        if ($education_10) {
            foreach(StudentGradeCount::model()->findAll('student_education_ref_id=' . $education_10->student_education_id) as $_StudentGradeCount) $_StudentGradeCount->delete();
            foreach(StudentEducation::model()->findAll('student_education_id=' . $education_10->student_education_id) as $_StudentEducation) $_StudentEducation->delete();
        }
        $education_10 = new StudentEducation();
        $education_10->added_on = date('Y-m-d H:i:s');
        $education_10->user_ref_id = $user_id;
        $education_10->class_level = '10';

        $education_10->board_ref_id = $postData['board_10'];
        if ($board_10->overall_type == 'Marks') {
            $education_10->overall_marks = $postData['overall_marks_10'];
        } elseif ($board_10->overall_type == 'Marks-GPA') {
            $education_10->overall_marks = $postData['overall_marks_gpa_10'];
        } elseif ($board_10->overall_type == 'Points') {
            $education_10->overall_marks = $postData['overall_points_10'];
        }
        $education_10->status = $user->class_status;
        $education_10->year = $postData['year_10'];
        $education_10->school_name = $postData['school_name_10'];
        $education_10->save(false);

        $education_10 = StudentEducation::model()->findByAttributes(array('class_level'=>'10', 'user_ref_id'=>$user_id));

        if ($board_10->overall_type == 'Grades') {
            foreach($postData['overall_grade_10'] as $key=>$val){
                if($val) {
                    StudentGradeCount::setStudentGrades($education_10->student_education_id, $key, $val);
                }
            }
        }

        foreach ($postData['subject_10'] as $key=>$value) {
            if ($postData['subject_marks_10'][$key]) {
                if($value == 'others') {
                    $student_subject_id = LookupSubjectMaster::saveTenthSubjects($postData,$key);
                }

                $obj = new StudentEducationDetail();
                $obj->student_education_ref_id = $education_10->student_education_id;
                if($value == 'others') {
                    $obj->student_subject_ref_id = $student_subject_id;
                } else {
                    $obj->student_subject_ref_id = $value;
                }
                $obj->added_on = date('Y-m-d H:i:s');
                if (($board_10->overall_type == 'Grades') || ($board_10->overall_type == 'Marks-GPA') || $board_10->board_ref_id == 7) {
                    $grade_det = LookupBoardConversion::model()->findByPk($postData['subject_marks_10'][$key]);
                    $obj->board_conversion_ref_id = $postData['subject_marks_10'][$key];
                    $obj->grade = $grade_det->board_marks;

                } else {
                    $obj->marks = $postData['subject_marks_10'][$key];
                }

                $obj->save();
            }
        }

        $criticalFields = array(
            'edu_study_level' => 1,
            'school_name' => 1,
            'completion_year' => 1,
            'board' => 1,
            'overall_marks' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);
        if(in_array($user->present_class, array(11, 12))) {
            $step3 = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$postData['user_id'], 'step_no'=>3));
            if (!$step3) {
                $step3 = new SignupSteps();
                $step3->added_on = date('Y-m-d H:i:s');
                $step3->user_ref_id = $postData['user_id'];
                $step3->step_no = 3;
                $step3->save();
            }
        }
        $return['user_id'] = $postData['user_id'];
        echo json_encode($return);
        Yii::app()->end();
    }

    public function saveEducation9() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $user = TblUserMaster::model()->findByPk($user_id);

        if ($user->present_class == 10) {
            $education_9 = StudentEducation::model()->findByAttributes(array('class_level'=>'9', 'user_ref_id'=>$user_id));
            $board_9 = LookupBoardEquivalent::model()->findByPk($postData['board_10']);

            if (!$education_9) {
                $education_9 = new StudentEducation();
                $education_9->added_on = date('Y-m-d H:i:s');
                $education_9->user_ref_id = $user_id;
                $education_9->class_level = '9';
            }
            $education_9->board_ref_id = $postData['board_10'];
            if ($board_9->overall_type == 'Marks') {
                $education_9->overall_marks = $postData['overall_marks_10'];
            } elseif ($board_9->overall_type == 'Marks-GPA') {
                $education_9->overall_marks = $postData['overall_marks_gpa_10'];
            } elseif ($board_9->overall_type == 'Points') {
                $education_9->overall_marks = $postData['overall_points_10'];
            }
            $education_9->status = $user->class_status;
            $education_9->year = $postData['year_10'];
            $education_9->school_name = $postData['school_name_10'];
            $education_9->save(false);

            if(trim($postData['school_name_10']) != ''){
                $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name_10']));
                $siDiData = TblSiDi::GetInstIdFromSchoolId($user->school_ref_id);
                // If Change School Delete the record
                if($schoolExistID != $user->school_ref_id){
                    $findInstId = TblSiStudents::model()->find(array("condition" => "user_ref_id = '" . $user_id . "' AND  inst_ref_id = '".$siDiData->inst_id."' "));
                    if($findInstId){
                        $findInstId->delete();
                    }
                }
                if($schoolExistID){
                    $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolExistID);
                    if($siDiData->inst_id){
                        $instId = $siDiData->inst_id;
                        if($schoolExistID != $user->school_ref_id) {
                            $studentSignupModel = new StudentSignup('firstPage');
                            $studentSignupModel->setSiStudents($user_id, $instId);
                        }
                    } else {
                        $instId = 'null';
                    }
                }
                $userMembershipRefId = ($instId > 0) ? 2 : 1; // 2 for SI and 1 for guest
                $user->membership_ref_id = $userMembershipRefId;
                $user->save(false);

                if ($schoolExistID) {
                    $user->school_ref_id = $schoolExistID;
                } else {
                    LookupSchool::addStudentSchool(trim($postData['school_name_10']));
                    $schoolExistID = LookupSchool::getSchoolID(trim($postData['school_name_10']));
                    $user->school_ref_id = $schoolExistID;
                }
                $user->save(false);
            }

            $education_9 = StudentEducation::model()->findByAttributes(array('class_level'=>'9', 'user_ref_id'=>$user_id));
            StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $education_9->student_education_id);

            if ($board_9->overall_type == 'Grades') {
                foreach($postData['overall_grade_10'] as $key=>$val){
                    if($val) {
                        StudentGradeCount::setStudentGrades($education_9->student_education_id, $key, $val);
                    }
                }
            }
        }

        $criticalFields = array(
            'edu_study_level' => 1,
            'school_name' => 1,
            'completion_year' => 1,
            'board' => 1,
            'overall_marks' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);
        $return['user_id'] = $postData['user_id'];
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionGetPrefLocations()
    {
        $countryId = Yii::app()->request->getParam('cid');
        $term = Yii::app()->request->getParam('q');
        $countries = explode(',',$countryId);
        //$countryId = implode(",",$countries);
        if ($countryId) {
            $locations = array();
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id IN (" . $countryId . ") AND (city_name LIKE '".$term."%' OR synonym_names LIKE '".$term."%') GROUP BY city_name ", "order" => "city_name","limit"=>10));
            foreach ($result as $city) {
                $locations[] = array('id' => 'c'.$city->attributes['city_id'], 'name' => $city->attributes['city_name']);
            }

            $result = TblState::model()->findAll(array("condition" => "country_ref_id IN (" . $countryId . ") AND (name LIKE '".$term."%' OR synonym_names LIKE '%".$term."%') ", "order" => "name","limit"=>5));
            foreach ($result as $city) {
                $locations[] = array('id' => 's'.$city->attributes['id'], 'name' => $city->attributes['name']);
            }
                $result = LookupRegion::model()->findAll(array("condition" => "country_ref_id IN (" . $countryId . ") AND region_name LIKE '".$term."%' ", "order" => "region_name","limit"=>5));
                foreach ($result as $city) {
                    $locations[] = array('id' => 'r'.$city->attributes['region_id'], 'name' => $city->attributes['region_name']);
                }
                if($countries[0] == 100 || $countries[1] == 100) {
                $result = LookupCityCluster::model()->findAll(array("condition" => "is_active = 'Y' AND (cluster_name LIKE '".$term."%' OR synonym_names LIKE '%".$term."%') ", "order" => "cluster_name","limit"=>5));
                foreach ($result as $cluster) {
                    $locations[] = array('id' => 't'.$cluster->attributes['city_cluster_id'], 'name' => $cluster->attributes['cluster_name']); // t means cluster here
                }
                }
            echo json_encode($locations);
        }
    }


    public function parseOthers($arr) {
        $return = array();$others = 0;
        foreach ($arr as $key=>$value) {
            $v1 = strtolower($value);
            if (strpos($v1,'others') !== false) {
                $others = $key;
            } else {
                $return[$key] = $value;
            }
        }
        if ($others != 0) {
            $return[$others] = 'Others';
        }
        return $return;
    }

    public function actionGetAjaxdata()
    {
        try{
            if(!Yii::app()->user->isGuest) {
                $userId = Yii::app()->user->sub_id;
                $user = TblUserMaster::model()->findByPk($userId);
                //To get shortListed colleges
                $objShortList = new ShortListEngine();
                $shortList = $objShortList->getShortList(array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY));

                //To get Recommended colleges
                $limit=3;
                $offset=0;
                $result_count=0;
                $aspirationList=array();
                if($user->present_class > 10) { // If student full filling all eligibility cirteria
                    $result_sql=" SELECT tum.uni_id FROM tbl_university_master tum
					JOIN di ON di.uni_ref_id = tum.uni_id
					JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
					JOIN lookup_department ld ON ld.department_id = tuc.department_ref_id
					WHERE ld.main_dept_id IN (SELECT main_dept_ref_id FROM student_preferred_department WHERE user_ref_id = ".$userId.")
					AND country_ref_id IN (SELECT country_ref_id FROM student_preferred_country WHERE user_ref_id = ".$userId.")
					AND di.di_type_ref_id != 1 AND tum.is_active='Y' AND di.is_test = 'N' AND di.is_active = 1 AND tum.uni_id NOT IN
					(SELECT stdu.uni_ref_id FROM student_shortlist_university stdu WHERE stdu.user_ref_id=".$userId." AND stdu.shortlist_status!='Reject')
					GROUP BY uni_id";
                    $list= Yii::app()->db->createCommand($result_sql)->queryAll();
                    $result_count=count($list);
                    Yii::import('application.controllers.ShortlistCollegesController');
                    $obj = new ShortlistCollegesController(); // preparing object
                    $aspirationList = $obj->getRecomendedData($userId,$limit,$offset);
                }
            }
            $this->renderPartial('_load_ajax_data',array('shortList'=>$shortList,'aspirationList'=>$aspirationList,'result_count'=>$result_count,'offset'=>$offset),false,true);
        }
        catch(Exception $ex)
        {
            echo $ex;
        }
    }

    public function actionContactValidate() {
        $model = new ProfileData('contact');
        if (Yii::app()->request->isAjaxRequest) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionSaveContactInfo() {
        $postData = $_POST['ProfileData'];
        $user_id = $postData['user_id'];
        $cityRes = TblCityMaster::model()->findByPk($postData['city_id']);
        $user = TblUserMaster::model()->findByPk($user_id);
        $user->city_ref_id = $postData['city_id'];
        $user->country_ref_id = $cityRes->country_id;
        $user->save(false);

        foreach(StudentCitizenship::model()->findAll('user_ref_id = "'.$user_id.'" ') as $_StudentCitizenShip) $_StudentCitizenShip->delete();

        $citizen = new StudentCitizenship;
        $citizen->user_ref_id = $postData['user_id'];
        $citizen->citizenship_ref_id = $cityRes->country_id;
        $citizen->added_on = date('Y-m-d H:i:s');
        $citizen->save(false);

        foreach(StudentContactNumber::model()->findAll('user_ref_id = "'.$user_id.'" AND contact_type_ref_id != 1 ') as $_StudentContactNumber) $_StudentContactNumber->delete();

        if($postData['phone'])
        {
            $contactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = '" . $postData['user_id'] . "' AND  contact_type_ref_id = 1 AND is_primary = 1"));
            if(!$contactModel){
                $contactModel = new StudentContactNumber;
            }
            $contactModel->user_ref_id = $postData['user_id'];
            $contactModel->contact_type_ref_id = 1;
            $contactModel->phone_type = 'Mobile';
            $contactModel->country_code = $postData['country_code'];
            $contactModel->number = $postData['phone'];
            $contactModel->is_primary = 1;
            $contactModel->added_by = Yii::app()->user->id;
            $contactModel->added_on = date('Y-m-d H:i:s');
            $contactModel->save(false);
        }
        $criticalFields = array(
            'phone' => 1,
        );
        TblUserProfCriticalCompletion::updateCriticalFields($postData['user_id'], $criticalFields);
        //$this->redirect(Yii::app()->urlManager->createUrl('dashboard'));
        $return['user_id'] = $postData['user_id'];
        echo json_encode($return);
        Yii::app()->end();
    }

    public function actionGetRecommendedColleges() {
        $userId = Yii::app()->user->sub_id;
        Yii::import('application.controllers.ShortlistCollegesController');
        $obj = new ShortlistCollegesController(); // preparing object
        $aspirationList = $obj->getRecomendedData($userId,3,0);
        $this->renderPartial('_recommended_colleges',array('aspirationList'=>$aspirationList));
    }

    public function checkCssAccess(){
        $domainArray = explode('.', $_SERVER['HTTP_HOST'], 2);
        $subDomain = strtolower($domainArray[0]);
        $this->instId = TblSiDi::isCssSchool($subDomain);
        if($this->instId){
            $this->isCssAccess = TRUE;
            $result = StudentUploadMasterNoEmail::getPendingStudentDetailByClass($this->instId);
            foreach($result as $studentDetails){
                if($studentDetails['first_name'] != ''){
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['first_name'] = $studentDetails['first_name'];
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['last_name'] = $studentDetails['last_name'];
                    $this->cssStudentNamesList[$studentDetails['first_name'].' '.$studentDetails['last_name']] = $studentDetails['first_name'].' '.$studentDetails['last_name'];
                }

            }
        }
    }
}