<?php
 
/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

 /* import path is customized by adding modules.Di */
Yii::import('application.modules.diadmin.models.base.BaseDiProduct');

class DiProduct extends BaseDiProduct
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('di_ref_id, product_ref_id, currency_ref_id, price, is_active, added_on, added_by', 'required'),
            array('di_ref_id, product_ref_id, currency_ref_id, is_active', 'numerical', 'integerOnly'=>true),
           // array('product_ref_id', 'CustomRule'),
            array('start_date', 'isDateRangeOverlapping'),
            array('price, added_by, modified_by', 'length', 'max'=>10),
            array('price', 'numerical','min'=>0.01),
            array('start_date, end_date, modified_on', 'safe'),
            array(
                'end_date',
                'compare',
                'compareAttribute'=>'start_date',
                'operator'=>'>',
                'allowEmpty'=>false ,
                'message'=>'{attribute} must be greater than "{compareValue}".'
            ),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('di_product_id, di_ref_id, product_ref_id, currency_ref_id, price, start_date, end_date, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
        );
    }

    public function isDateRangeOverlapping($attribute,$params)
    {
        /*
         * Check if current start date is between existing start_date and end_date
         */
        $criteria               =  new CDbCriteria();
        $criteria->condition    =  "(:start_date <= end_date AND start_date <= :end_date) AND di_ref_id= :x AND product_ref_id=:y";

        // This is fix
        // When we edit the record and save, it through error that range alreay exist
        // because it match current record's date also
        if( isset($this->di_product_id) && ($this->di_product_id>0) ){
         $criteria->addCondition('di_product_id!='.$this->di_product_id);
        }

        $criteria->params       = array(
            ':start_date'=>$this->start_date,
			':end_date'=>$this->end_date,
            ':x'=>$this->di_ref_id,
            ':y'=>$this->product_ref_id
        );

        $result                 =    DiProduct::model()->exists($criteria);
        if($result)
            $this->addError($attribute, 'This date range overlapping another date, Please select another date range');
    }

    public function CustomRule($attribute,$params)
    {
        if(isset($this->di_product_id)){
            $result =    DiProduct::model()->exists('di_ref_id= :x AND product_ref_id =:y AND di_product_id !=:z',array(':x'=>$this->di_ref_id,':y'=>$this->$attribute,':z'=>$this->di_product_id));
        }else{
            $result =    DiProduct::model()->exists('di_ref_id= :x AND product_ref_id =:y',array(':x'=>$this->di_ref_id,':y'=>$this->$attribute));
        }
        if($result)
            $this->addError($attribute, 'Already Exist in database. Please select another Product');
    }

    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('di_product_id',$this->di_product_id,true);
        $criteria->compare('di_ref_id',Yii::app()->getRequest()->getQuery('di_id'));
        $criteria->compare('product_ref_id',$this->product_ref_id);
        $criteria->compare('currency_ref_id',$this->currency_ref_id);
        $criteria->compare('price',$this->price,true);
        $criteria->compare('start_date',$this->start_date,true);
        $criteria->compare('end_date',$this->end_date,true);
        $criteria->compare('is_active',$this->is_active);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'di_product_id' => 'DI Product',
            'di_ref_id' => 'DI',
            'product_ref_id' => 'Product',
            'currency_ref_id' => 'Currency',
            'price' => 'Price',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'is_active' => 'Is Active',
            'added_on' => 'Added On',
            'added_by' => 'Added By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
        );
    }


}