<div class="row gutter_vertical gray">
    <div class="grid_7 pull gutter-left-35"><small>College Name</small></div>
    <div class="grid_3 pull center"><small>Avg. Tuition Fees / Year</small></div>
    <div class="grid_2 pull center"><small>Admission Chance</small></div>
</div>
<?php
    $counter = 0;
    foreach ($bestFitList as $bestFitUni) {
        if ($counter == 10) { break; } $counter++;

        if($selected_country  == 100){
            $data = UniversityCostSummary::getAvgUniFeesByUniIdAndMainDeptId($bestFitUni['uni_id'], $bestFitUni['department']);
            $countryname = TblCountryMaster::model()->findByPk($selected_country);
            $currencySymbol = LookupCurrency::model()->find('country_name = :name',array(':name' =>$countryname['country_name']));
            $averageFee = LookupCurrencyConversion::convertCurrency($data->currency_ref_id, $currencySymbol->currency_id, $data->fees_per_year);
        }else{
            $data = TblUniCourses::getAvgFeeOfCollegeByIdAndDept($bestFitUni['uni_id'], $bestFitUni['department']);
            $countryname = TblCountryMaster::model()->findByPk($selected_country);
            $currencySymbol = LookupCurrency::model()->find('country_name = :name',array(':name' =>$countryname['country_name']));
            $averageFee = LookupCurrencyConversion::convertCurrency($data[0]['currency_ref_id'], $currencySymbol->currency_id, $data[0]['fees_per_year']);
        }
        $admissionScore = UniversityHelper::displayAdmissionChance($bestFitUni['score']);
        $universityData = TblUniversityMaster::getExpandUniversityBlockDetails($bestFitUni['uni_id']);
?>
<div class="row multi_line border-top relative visible clearfix hover" id="<?php echo $blockId; ?>Block1_<?php echo $bestFitUni['uni_id']; ?>">
    <div class="heading grid_7 pull">
        <div class="gutter_vertical gutter_horizontal_left">
            <span class="uniName" style="display: none"><?php echo $universityData['uni_name']; ?></span>
            <h4 class=""><a  title="<?php echo $universityData['uni_name']; ?>" href="javascript:void(0)" onclick="showUniversityDetails('<?php echo $bestFitUni['uni_id'] ?>', '<?php echo $blockId; ?>'); return false;" ><?php echo UniversityHelper::chopString($universityData['uni_name'], 50); ?></a></h4>
            <div class="row  multi_line no-gutter lightgray"><?php echo $universityData['city'] . $universityData['state'] . $universityData['country']; ?></div>
        </div>
        <?php
        $deps_csv = implode(',', $depts);
        $deps  =array();
        if (count($depts) > 0) {
        $deps = Yii::app()->db->createCommand()
            ->select('DISTINCT(department_ref_id)')
            ->from('tbl_uni_courses')
            ->where('uni_ref_id='.$bestFitUni['uni_id']." AND department_ref_id IN ($deps_csv) "." AND course_level in (6,7) ")
            ->queryAll();
        }
            if (count($deps)) {
        ?>
        <h6 style="margin-top: 7px;" class="gutter_horizontal_left">
            <span class="left">Also in</span>
            <?php
                $disp_val = array();
                foreach ($deps as $dep) {
                    $m_id = $m_depts_with_sub[$dep['department_ref_id']];
                    $sub_id = $dep['department_ref_id'];
                    if ($m_id != $selected_dept) {
                        $disp_val[] = $depts_name[$m_id];
                    }

                    if ($sub_id != $selected_dept) {
                        $disp_val[] = $depts_name[$sub_id];
                    }
                }

                $cnt = count($disp_val) - 1;
                foreach ($disp_val as $key=>$value) {
                    if ($key == $cnt) {
                        echo '<span class="color-gray ">'.$value."</span>";
                    } else {
                        echo '<span class="color-gray element-partition">'.$value."</span>";
                    }
                }
            ?>
        </h6>
        <?php } ?>
    </div>
    <div class="grid_2 pull center"><?php if($averageFee) { if($selected_country == 100){
            echo '<span class="WebRupee">Rs. </span><strong>'.  number_format($averageFee).'</strong>';
        }
            if($selected_country  != 100){
                echo '<span class="">'.$currencySymbol['html_entity'].'</span><strong>'.  number_format($averageFee).'</strong>';
            }  } else { echo "--"; } ?></div>
    <div class="grid_2 right center">
        <?php echo str_replace(array('</strong>', '<span>', '</span>'), array('</strong></br>', '<small class="color-gray">', '</small>'), $admissionScore); ?>
    </div>
    <div class="hidden right visible multi_line row no-clear small-gutter" style="background: none repeat scroll 0% 0% rgb(255, 255, 255); right: 0px; position: absolute; width: 390px; height: 65px; text-align: right; padding-right: 60px !important;">
                        <span class="colapse" id="togglefilter">
                <span class="toggleTxt grid_2" id="toggleTxt_<?php echo $blockId.$bestFitUni['uni_id']; ?>" onclick="showUniversityDetails('<?php echo $bestFitUni['uni_id'] ?>', '<?php echo $blockId; ?>'); return false;" >Click to expand</span>
                <span class="arrow on" style="left: 105%; right: 0;" onclick="showUniversityDetails('<?php echo $bestFitUni['uni_id'] ?>', '<?php echo $blockId; ?>'); return false;"></span>
                </span>
    </div>

    <div class="clearfix"></div>
    <div class="expand_container" id="<?php echo $blockId; ?>Block_<?php echo $bestFitUni['uni_id']; ?>" style="display: none;">
        <div class="row border-bottom">
            <?php
            $universityData = TblUniversityMaster::getExpandUniversityBlockDetails($bestFitUni['uni_id']);

            $relatedScholarshipCount = ScholarshipHostInstitute::getScholarshipCountByUniId($bestFitUni['uni_id'], '', $parent_dept);

            $university = TblUniversityMaster::model()->findByPk($bestFitUni['uni_id']);
            ?>
            <div class="left grid_5">
                <label class="grid_3 pull">Average Tuition Fees / Year</label>
                <?php if($averageFee) {  if($selected_country == 100){
                    echo '<span class="WebRupee">Rs. </span><strong>'. number_format($averageFee).'</strong>';
                }
                    if($selected_country  != 100){

                        echo '<span class="">'.$currencySymbol['html_entity'].'</span><strong>'. number_format($averageFee).'</strong>';
                    } } else { echo "--"; } ?>
            </div>
            <div class="grid_5 right">
                <label class="grid_2 pull">Admission Chance</label>
                <div class="grid_3 pull ">
                    <div class="center"><?php echo $admissionScore ? str_replace(array('<span>', '</span>'), array('<small class="color-gray"> ', '</small>'), $admissionScore) : '--'; ?></div>
                </div>
            </div>
        </div>
        <?php
        if ($selected_country != 100) {
            $rankData = Yii::app()->db->createCommand()
                ->select('uni_ref_id, source_name, rank_year, rank')
                ->from('university_dept_ranking as udr')
                ->join('lookup_rank_source as lrs', 'udr.rank_source_ref_id = lrs.rank_source_id')
                ->where('uni_ref_id=:id', array(':id' => $bestFitUni['uni_id']))
                ->order('rank_year DESC, source_type,source_name ASC')
                ->limit(4)
                ->queryAll();
        } else {
            $rankData = Yii::app()->db->createCommand()
                ->select('uni_ref_id, source_name, rank_year, rank, department_name')
                ->from('university_dept_ranking as udr')
                ->join('lookup_rank_source as lrs', 'udr.rank_source_ref_id = lrs.rank_source_id')
                ->join('lookup_department as ld', 'udr.department_ref_id = ld.department_id')
                ->where('uni_ref_id=:id', array(':id' => $bestFitUni['uni_id']))
                ->order('rank_year DESC')
                ->limit(4)
                ->queryAll();
        }
        $rankData;

        if (count($rankData)) {
            $class = 'split-four';
            if (count($rankData) == 3) {
                $class = 'split-three';
            } elseif (count($rankData) == 2) {
                $class = 'split-two';
            } elseif (count($rankData) == 1) {
                $class = 'split-one';
            }
            ?>
            <div class="row white cols ">
                <?php foreach ($rankData as $data) { ?>
                <ul class="<?php echo $class; ?> center">
                    <li class="border-bottom"><?php echo $data['source_name']; ?></li>
                    <li class="row gray"><strong>#<?php echo $data['rank']; ?><?php echo UniversityHelper::getNumberSuffix($data['rank']); ?></strong></li>
                    <li class="lightgray"><?php echo $data['rank_year']; ?></li>
                </ul>
                <?php } ?>
            </div>
            <?php } ?>
        <div class="row border-bottom">
            <div class="left grid_5">
                <label class="grid_3 pull">Year of Establishment</label>
                <?php echo $universityData['vintage'] ? '<strong>'.$universityData['vintage']."</strong>" : '--'; ?>
            </div>

            <div class="right grid_5">
                <label class="grid_3 pull">Total Students</label>
                <?php echo $university->total_students ? '<strong>'.number_format($university->total_students)."</strong>" : '--'; ?>
            </div>
        </div>
        <div class="row border-bottom">
            <div class="left grid_5">
                <label class="grid_3 pull">No. of relevant courses</label>
                <?php
                    if ($selected_dept == $parent_dept) {
                    $courseData = TblUniCourses::getUniverstityMainDepartmentWithCourseCount($bestFitUni['uni_id'], 'ug', $parent_dept);
                    foreach($courseData as $courseDetail){
                        if($courseDetail['department_id'] == $parent_dept) {
                            $courseCount = $courseDetail['course_count'];
                            break;
                        }
                    }
                    } else {
                        $courseCount = TblUniCourses::getCourseCountByUniversityAndCourse($bestFitUni['uni_id'], $selected_dept);
                    }
                    echo $courseCount ? "<strong>".$courseCount."</strong>" : '--';
                    $relatedScholarshipCount = ScholarshipHostInstitute::getScholarshipCountByUniId($bestFitUni['uni_id'], '', $parent_dept);
                    ?>
            </div>
            <div class="right grid_5">
                <label class="grid_3 pull">Related Scholarships</label>
                <?php echo $relatedScholarshipCount ? "<strong>".$relatedScholarshipCount."</strong>" : '--'; ?>
            </div>
        </div>
        <div class="row">
            <div class="left grid_5">
                <label class="grid_3 pull">Acceptance Rate</label>
                <?php echo $university->acceptance_rate ? "<strong>".$university->acceptance_rate."</strong>" : '--'; ?>
            </div>
            <div class="right grid_5">
                <label class="grid_3 pull">International Student</label>
                <?php echo $university->international_stud_per ? "<strong>".$university->international_stud_per."%</strong>" : '--'; ?>
            </div>
        </div>
    </div>
    <?php
    if(isset($shortList[$bestFitUni['uni_id']]) && $shortList[$bestFitUni['uni_id']]['intent'] != "Reject"){
        $textToDisplay = 'Remove from Shortlist';
        $class = 'addedtag';
    }else{
        $textToDisplay = 'Add to Shortlist';
        $class = 'addtag';
    }
    ?>
    <div class="tag-image missedContent <?php echo $class; ?> shortlistTag" rel="<?php echo $bestFitUni['uni_id']."_".$bestFitUni['idealListUniversityId']; ?>">
        <div class="popup">
            <div class="holder">
                <p><?php echo $textToDisplay; ?></p>
            </div>
        </div>
    </div>

</div>
<?php } ?>

