<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitScheduleAttachments is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_schedule_attachments".
 *
 * The followings are the available columns in table 'uni_visit_schedule_attachments':
 * @property string $attachment_id
 * @property string $uni_visit_schedule_ref_id
 * @property string $attachment_name
 * @property string $attachment_file
 *
 * The followings are the available model relations:
 * @property UniVisitSchedule $uniVisitScheduleRef
 */
class BaseUniVisitScheduleAttachments extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitScheduleAttachments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_schedule_attachments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_schedule_ref_id, attachment_name, attachment_file', 'required'),
			array('uni_visit_schedule_ref_id', 'length', 'max'=>10),
			array('attachment_name, attachment_file', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('attachment_id, uni_visit_schedule_ref_id, attachment_name, attachment_file', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitScheduleRef' => array(self::BELONGS_TO, 'UniVisitSchedule', 'uni_visit_schedule_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'attachment_id' => 'Attachment',
			'uni_visit_schedule_ref_id' => 'Uni Visit Schedule Ref',
			'attachment_name' => 'Attachment Name',
			'attachment_file' => 'Attachment File',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('attachment_id',$this->attachment_id,true);
		$criteria->compare('uni_visit_schedule_ref_id',$this->uni_visit_schedule_ref_id,true);
		$criteria->compare('attachment_name',$this->attachment_name,true);
		$criteria->compare('attachment_file',$this->attachment_file,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}