<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreSuccessfulStudents is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_successful_students".
 *
 * The followings are the available columns in table 'vendor_centre_successful_students':
 * @property string $vendor_centre_successful_student_id
 * @property string $vendor_centre_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property string $course_name
 * @property integer $entrance_ref_id
 * @property string $rank_grade
 * @property string $rank_year
 * @property string $student_picture
 * @property string $testimonial
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property VendorCentre $vendorCentreRef
 * @property EntranceExam $entranceRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseVendorCentreSuccessfulStudents extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreSuccessfulStudents the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_successful_students';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('entrance_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('first_name, last_name, course_name, student_picture, testimonial', 'length', 'max'=>255),
			array('rank_grade, rank_year', 'length', 'max'=>50),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_successful_student_id, vendor_centre_ref_id, first_name, last_name, course_name, entrance_ref_id, rank_grade, rank_year, student_picture, testimonial, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'entranceRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_successful_student_id' => 'Vendor Centre Successful Student',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'course_name' => 'Course Name',
			'entrance_ref_id' => 'Entrance Ref',
			'rank_grade' => 'Rank Grade',
			'rank_year' => 'Rank Year',
			'student_picture' => 'Student Picture',
			'testimonial' => 'Testimonial',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_successful_student_id',$this->vendor_centre_successful_student_id,true);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('rank_grade',$this->rank_grade,true);
		$criteria->compare('rank_year',$this->rank_year,true);
		$criteria->compare('student_picture',$this->student_picture,true);
		$criteria->compare('testimonial',$this->testimonial,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}