<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailExceptions is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_exceptions".
 *
 * The followings are the available columns in table 'umail_exceptions':
 * @property integer $exception_id
 * @property integer $gmail_unique_id
 * @property string $from_email_id
 * @property string $subject
 * @property string $message
 * @property string $from_date
 * @property string $status
 * @property integer $modified_by
 * @property string $modified_on
 */
class BaseUmailExceptions extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailExceptions the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_exceptions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gmail_unique_id, modified_by', 'numerical', 'integerOnly'=>true),
			array('from_email_id', 'length', 'max'=>255),
			array('subject', 'length', 'max'=>500),
			array('status', 'length', 'max'=>10),
			array('message, from_date, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('exception_id, gmail_unique_id, from_email_id, subject, message, from_date, status, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'exception_id' => 'Exception',
			'gmail_unique_id' => 'Gmail Unique',
			'from_email_id' => 'From Email',
			'subject' => 'Subject',
			'message' => 'Message',
			'from_date' => 'From Date',
			'status' => 'Status',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('exception_id',$this->exception_id);
		$criteria->compare('gmail_unique_id',$this->gmail_unique_id);
		$criteria->compare('from_email_id',$this->from_email_id,true);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('from_date',$this->from_date,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}