<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTemplateMail is autogenerate by UniModel generator
 *
 * This is the model class for table "template_mail".
 *
 * The followings are the available columns in table 'template_mail':
 * @property integer $template_mail_id
 * @property integer $audience_ref_id
 * @property string $template_title
 * @property string $template_text
 * @property integer $created_by
 * @property string $added_on
 * @property string $modified_on
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property LookupEvent[] $lookupEvents
 */
class BaseTemplateMail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TemplateMail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'template_mail';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('audience_ref_id, created_by', 'required'),
			array('audience_ref_id, created_by, is_active', 'numerical', 'integerOnly'=>true),
			array('template_title', 'length', 'max'=>255),
			array('template_text, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('template_mail_id, audience_ref_id, template_title, template_text, created_by, added_on, modified_on, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupEvents' => array(self::HAS_MANY, 'LookupEvent', 'template_mail_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'template_mail_id' => 'Template Mail',
			'audience_ref_id' => 'Audience Ref',
			'template_title' => 'Template Title',
			'template_text' => 'Template Text',
			'created_by' => 'Created By',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('template_mail_id',$this->template_mail_id);
		$criteria->compare('audience_ref_id',$this->audience_ref_id);
		$criteria->compare('template_title',$this->template_title,true);
		$criteria->compare('template_text',$this->template_text,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}