<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTaskSchool is autogenerate by UniModel generator
 *
 * This is the model class for table "task_school".
 *
 * The followings are the available columns in table 'task_school':
 * @property string $task_school_id
 * @property string $task_ref_id
 * @property integer $si_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblSiDi $siRef
 * @property Task $taskRef
 */
class BaseTaskSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TaskSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'task_school';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_ref_id, si_ref_id', 'required'),
			array('si_ref_id', 'numerical', 'integerOnly'=>true),
			array('task_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('task_school_id, task_ref_id, si_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
			'taskRef' => array(self::BELONGS_TO, 'Task', 'task_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'task_school_id' => 'Task School',
			'task_ref_id' => 'Task Ref',
			'si_ref_id' => 'Si Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('task_school_id',$this->task_school_id,true);
		$criteria->compare('task_ref_id',$this->task_ref_id,true);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}