<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredBoard is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_board".
 *
 * The followings are the available columns in table 'student_preferred_board':
 * @property string $student_preferred_board_id
 * @property string $user_ref_id
 * @property integer $board_ref_id
 * @property integer $not_sure
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupBoard $boardRef
 */
class BaseStudentPreferredBoard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredBoard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_board';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, board_ref_id', 'required'),
			array('board_ref_id, not_sure', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_preferred_board_id, user_ref_id, board_ref_id, not_sure', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_preferred_board_id' => 'Student Preferred Board',
			'user_ref_id' => 'User Ref',
			'board_ref_id' => 'Board Ref',
			'not_sure' => 'Not Sure',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_preferred_board_id',$this->student_preferred_board_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('not_sure',$this->not_sure);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}