<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentCareerPlanCode is autogenerate by UniModel generator
 *
 * This is the model class for table "student_career_plan_code".
 *
 * The followings are the available columns in table 'student_career_plan_code':
 * @property string $student_career_plan_code_id
 * @property integer $inst_ref_id
 * @property string $user_ref_id
 * @property string $coupon_code
 * @property integer $band_ref_id
 * @property string $used_on
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblSiDi $instRef
 * @property TblUserMaster $userRef
 * @property LookupBand $bandRef
 */
class BaseStudentCareerPlanCode extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentCareerPlanCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_career_plan_code';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inst_ref_id, band_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('coupon_code', 'length', 'max'=>100),
			array('used_on, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_career_plan_code_id, inst_ref_id, user_ref_id, coupon_code, band_ref_id, used_on, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'bandRef' => array(self::BELONGS_TO, 'LookupBand', 'band_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_career_plan_code_id' => 'Student Career Plan Code',
			'inst_ref_id' => 'Inst Ref',
			'user_ref_id' => 'User Ref',
			'coupon_code' => 'Coupon Code',
			'band_ref_id' => 'Band Ref',
			'used_on' => 'Used On',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_career_plan_code_id',$this->student_career_plan_code_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('coupon_code',$this->coupon_code,true);
		$criteria->compare('band_ref_id',$this->band_ref_id);
		$criteria->compare('used_on',$this->used_on,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}