<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStandardExamCompleted is autogenerate by UniModel generator
 *
 * This is the model class for table "standard_exam_completed".
 *
 * The followings are the available columns in table 'standard_exam_completed':
 * @property string $standard_exam_completed_id
 * @property integer $user_ref_id
 * @property integer $standard_exam_ref_id
 * @property integer $standard_exam_module_ref_id
 * @property double $marks
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupStandardExamModule $standardExamModuleRef
 * @property LookupStandardExam $standardExamRef
 */
class BaseStandardExamCompleted extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StandardExamCompleted the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'standard_exam_completed';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, standard_exam_ref_id, standard_exam_module_ref_id, marks', 'required'),
			array('user_ref_id, standard_exam_ref_id, standard_exam_module_ref_id', 'numerical', 'integerOnly'=>true),
			array('marks', 'numerical'),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('standard_exam_completed_id, user_ref_id, standard_exam_ref_id, standard_exam_module_ref_id, marks, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'standardExamModuleRef' => array(self::BELONGS_TO, 'LookupStandardExamModule', 'standard_exam_module_ref_id'),
			'standardExamRef' => array(self::BELONGS_TO, 'LookupStandardExam', 'standard_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'standard_exam_completed_id' => 'Standard Exam Completed',
			'user_ref_id' => 'User Ref',
			'standard_exam_ref_id' => 'Standard Exam Ref',
			'standard_exam_module_ref_id' => 'Standard Exam Module Ref',
			'marks' => 'Marks',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('standard_exam_completed_id',$this->standard_exam_completed_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id);
		$criteria->compare('standard_exam_ref_id',$this->standard_exam_ref_id);
		$criteria->compare('standard_exam_module_ref_id',$this->standard_exam_module_ref_id);
		$criteria->compare('marks',$this->marks);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}