<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProfileVerificationScore is autogenerate by UniModel generator
 *
 * This is the model class for table "profile_verification_score".
 *
 * The followings are the available columns in table 'profile_verification_score':
 * @property string $profile_verification_score_id
 * @property string $user_ref_id
 * @property string $profile_score
 * @property string $profile_score_date
 * @property string $passout_year
 * @property string $passout_year_date
 * @property string $board_10
 * @property string $board_10_date
 * @property string $board_12
 * @property string $board_12_date
 * @property string $marks_10
 * @property string $marks_10_date
 * @property string $marks_12
 * @property string $marks_12_date
 * @property string $marks_100
 * @property string $marks_100_date
 * @property string $marks_above_95
 * @property string $marks_above_95_date
 * @property string $marks_diff
 * @property string $marks_diff_date
 * @property string $subject_marks_10_100
 * @property string $subject_marks_10_100_date
 * @property string $pref_country
 * @property string $pref_country_date
 * @property string $pref_country_score
 * @property string $pref_country_score_date
 * @property string $pref_dept
 * @property string $pref_dept_date
 * @property string $pref_dept_score
 * @property string $pref_dept_score_date
 * @property string $contact_number
 * @property string $contact_number_date
 * @property string $subject_marks_12_100
 * @property string $subject_marks_12_100_date
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseProfileVerificationScore extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProfileVerificationScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'profile_verification_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('profile_score, passout_year, board_10, board_12, marks_10, marks_12, marks_100, marks_above_95, marks_diff, subject_marks_10_100, pref_country, pref_country_score, pref_dept, pref_dept_score, contact_number, subject_marks_12_100', 'length', 'max'=>1),
			array('profile_score_date, passout_year_date, board_10_date, board_12_date, marks_10_date, marks_12_date, marks_100_date, marks_above_95_date, marks_diff_date, subject_marks_10_100_date, pref_country_date, pref_country_score_date, pref_dept_date, pref_dept_score_date, contact_number_date, subject_marks_12_100_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('profile_verification_score_id, user_ref_id, profile_score, profile_score_date, passout_year, passout_year_date, board_10, board_10_date, board_12, board_12_date, marks_10, marks_10_date, marks_12, marks_12_date, marks_100, marks_100_date, marks_above_95, marks_above_95_date, marks_diff, marks_diff_date, subject_marks_10_100, subject_marks_10_100_date, pref_country, pref_country_date, pref_country_score, pref_country_score_date, pref_dept, pref_dept_date, pref_dept_score, pref_dept_score_date, contact_number, contact_number_date, subject_marks_12_100, subject_marks_12_100_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_verification_score_id' => 'Profile Verification Score',
			'user_ref_id' => 'User Ref',
			'profile_score' => 'Profile Score',
			'profile_score_date' => 'Profile Score Date',
			'passout_year' => 'Passout Year',
			'passout_year_date' => 'Passout Year Date',
			'board_10' => 'Board 10',
			'board_10_date' => 'Board 10 Date',
			'board_12' => 'Board 12',
			'board_12_date' => 'Board 12 Date',
			'marks_10' => 'Marks 10',
			'marks_10_date' => 'Marks 10 Date',
			'marks_12' => 'Marks 12',
			'marks_12_date' => 'Marks 12 Date',
			'marks_100' => 'Marks 100',
			'marks_100_date' => 'Marks 100 Date',
			'marks_above_95' => 'Marks Above 95',
			'marks_above_95_date' => 'Marks Above 95 Date',
			'marks_diff' => 'Marks Diff',
			'marks_diff_date' => 'Marks Diff Date',
			'subject_marks_10_100' => 'Subject Marks 10 100',
			'subject_marks_10_100_date' => 'Subject Marks 10 100 Date',
			'pref_country' => 'Pref Country',
			'pref_country_date' => 'Pref Country Date',
			'pref_country_score' => 'Pref Country Score',
			'pref_country_score_date' => 'Pref Country Score Date',
			'pref_dept' => 'Pref Dept',
			'pref_dept_date' => 'Pref Dept Date',
			'pref_dept_score' => 'Pref Dept Score',
			'pref_dept_score_date' => 'Pref Dept Score Date',
			'contact_number' => 'Contact Number',
			'contact_number_date' => 'Contact Number Date',
			'subject_marks_12_100' => 'Subject Marks 12 100',
			'subject_marks_12_100_date' => 'Subject Marks 12 100 Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_verification_score_id',$this->profile_verification_score_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('profile_score',$this->profile_score,true);
		$criteria->compare('profile_score_date',$this->profile_score_date,true);
		$criteria->compare('passout_year',$this->passout_year,true);
		$criteria->compare('passout_year_date',$this->passout_year_date,true);
		$criteria->compare('board_10',$this->board_10,true);
		$criteria->compare('board_10_date',$this->board_10_date,true);
		$criteria->compare('board_12',$this->board_12,true);
		$criteria->compare('board_12_date',$this->board_12_date,true);
		$criteria->compare('marks_10',$this->marks_10,true);
		$criteria->compare('marks_10_date',$this->marks_10_date,true);
		$criteria->compare('marks_12',$this->marks_12,true);
		$criteria->compare('marks_12_date',$this->marks_12_date,true);
		$criteria->compare('marks_100',$this->marks_100,true);
		$criteria->compare('marks_100_date',$this->marks_100_date,true);
		$criteria->compare('marks_above_95',$this->marks_above_95,true);
		$criteria->compare('marks_above_95_date',$this->marks_above_95_date,true);
		$criteria->compare('marks_diff',$this->marks_diff,true);
		$criteria->compare('marks_diff_date',$this->marks_diff_date,true);
		$criteria->compare('subject_marks_10_100',$this->subject_marks_10_100,true);
		$criteria->compare('subject_marks_10_100_date',$this->subject_marks_10_100_date,true);
		$criteria->compare('pref_country',$this->pref_country,true);
		$criteria->compare('pref_country_date',$this->pref_country_date,true);
		$criteria->compare('pref_country_score',$this->pref_country_score,true);
		$criteria->compare('pref_country_score_date',$this->pref_country_score_date,true);
		$criteria->compare('pref_dept',$this->pref_dept,true);
		$criteria->compare('pref_dept_date',$this->pref_dept_date,true);
		$criteria->compare('pref_dept_score',$this->pref_dept_score,true);
		$criteria->compare('pref_dept_score_date',$this->pref_dept_score_date,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('contact_number_date',$this->contact_number_date,true);
		$criteria->compare('subject_marks_12_100',$this->subject_marks_12_100,true);
		$criteria->compare('subject_marks_12_100_date',$this->subject_marks_12_100_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}