<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMasterInteraction is autogenerate by UniModel generator
 *
 * This is the model class for table "master_interaction".
 *
 * The followings are the available columns in table 'master_interaction':
 * @property integer $interaction_id
 * @property string $interaction_type
 *
 * The followings are the available model relations:
 * @property GemLeadProspectInteraction[] $gemLeadProspectInteractions
 * @property LookupWorkplan[] $lookupWorkplans
 * @property ProspectInteraction[] $prospectInteractions
 * @property StudentWorkplan[] $studentWorkplans
 * @property StudentWorkplan[] $studentWorkplans1
 */
class BaseMasterInteraction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MasterInteraction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'master_interaction';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('interaction_type', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('interaction_id, interaction_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'gemLeadProspectInteractions' => array(self::HAS_MANY, 'GemLeadProspectInteraction', 'interaction_ref_id'),
			'lookupWorkplans' => array(self::HAS_MANY, 'LookupWorkplan', 'interaction_ref_id'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'interaction_ref_id'),
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'interaction_ref_id'),
			'studentWorkplans1' => array(self::HAS_MANY, 'StudentWorkplan', 'parent_interaction_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'interaction_id' => 'Interaction',
			'interaction_type' => 'Interaction Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('interaction_id',$this->interaction_id);
		$criteria->compare('interaction_type',$this->interaction_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}