<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupReservation is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_reservation".
 *
 * The followings are the available columns in table 'lookup_reservation':
 * @property integer $reservation_id
 * @property string $reservation_name
 *
 * The followings are the available model relations:
 * @property CourseFees[] $courseFees
 * @property MdmNewCourseFees[] $mdmNewCourseFees
 * @property MdmNewCourseReservation[] $mdmNewCourseReservations
 * @property UniCourseReservation[] $uniCourseReservations
 */
class BaseLookupReservation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupReservation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_reservation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reservation_name', 'required'),
			array('reservation_name', 'length', 'max'=>75),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('reservation_id, reservation_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'reservation_ref_id'),
			'mdmNewCourseFees' => array(self::HAS_MANY, 'MdmNewCourseFees', 'reservation_ref_id'),
			'mdmNewCourseReservations' => array(self::HAS_MANY, 'MdmNewCourseReservation', 'reservation_ref_id'),
			'uniCourseReservations' => array(self::HAS_MANY, 'UniCourseReservation', 'reservation_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'reservation_id' => 'Reservation',
			'reservation_name' => 'Reservation Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('reservation_id',$this->reservation_id);
		$criteria->compare('reservation_name',$this->reservation_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}