<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupMilestone is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_milestone".
 *
 * The followings are the available columns in table 'lookup_milestone':
 * @property integer $milestone_id
 * @property string $milestone_name
 * @property string $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property UserMilestoneTracking[] $userMilestoneTrackings
 */
class BaseLookupMilestone extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupMilestone the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_milestone';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('milestone_name', 'length', 'max'=>100),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('milestone_id, milestone_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userMilestoneTrackings' => array(self::HAS_MANY, 'UserMilestoneTracking', 'milestone_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'milestone_id' => 'Milestone',
			'milestone_name' => 'Milestone Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('milestone_id',$this->milestone_id);
		$criteria->compare('milestone_name',$this->milestone_name,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}