<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupInstituteControl is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_institute_control".
 *
 * The followings are the available columns in table 'lookup_institute_control':
 * @property integer $institute_control_id
 * @property string $control_name
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster[] $tblUniversityMasters
 */
class BaseLookupInstituteControl extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupInstituteControl the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_institute_control';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('control_name, added_on', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('control_name', 'length', 'max'=>60),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('institute_control_id, control_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'institute_control_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'institute_control_id' => 'Institute Control',
			'control_name' => 'Control Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('institute_control_id',$this->institute_control_id);
		$criteria->compare('control_name',$this->control_name,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}