<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCourseFeesDuration is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_course_fees_duration".
 *
 * The followings are the available columns in table 'lookup_course_fees_duration':
 * @property integer $course_fees_duration_id
 * @property string $duration
 *
 * The followings are the available model relations:
 * @property CourseFees[] $courseFees
 * @property MdmNewCourseFees[] $mdmNewCourseFees
 */
class BaseLookupCourseFeesDuration extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCourseFeesDuration the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_course_fees_duration';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('duration', 'required'),
			array('duration', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_fees_duration_id, duration', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'course_fees_duration_ref_id'),
			'mdmNewCourseFees' => array(self::HAS_MANY, 'MdmNewCourseFees', 'course_fees_duration_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_fees_duration_id' => 'Course Fees Duration',
			'duration' => 'Duration',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_fees_duration_id',$this->course_fees_duration_id);
		$criteria->compare('duration',$this->duration,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}