<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamVendorBranch is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_vendor_branch".
 *
 * The followings are the available columns in table 'entrance_exam_vendor_branch':
 * @property string $entrance_vendor_branch_id
 * @property integer $entrance_exam_ref_id
 * @property string $vendor_ref_id
 * @property string $vendor_branch_ref_id
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property Vendor $vendorRef
 * @property EntranceExam $entranceExamRef
 * @property VendorBranch $vendorBranchRef
 * @property TblAdmin $addedBy
 */
class BaseEntranceExamVendorBranch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamVendorBranch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_vendor_branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, vendor_branch_ref_id', 'required'),
			array('entrance_exam_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('vendor_ref_id, vendor_branch_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_vendor_branch_id, entrance_exam_ref_id, vendor_ref_id, vendor_branch_ref_id, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'vendorBranchRef' => array(self::BELONGS_TO, 'VendorBranch', 'vendor_branch_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_vendor_branch_id' => 'Entrance Vendor Branch',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'vendor_ref_id' => 'Vendor Ref',
			'vendor_branch_ref_id' => 'Vendor Branch Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_vendor_branch_id',$this->entrance_vendor_branch_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id,true);
		$criteria->compare('vendor_branch_ref_id',$this->vendor_branch_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}