<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamModuleDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_module_department".
 *
 * The followings are the available columns in table 'entrance_exam_module_department':
 * @property integer $entrance_exam_module_department_id
 * @property string $entrance_exam_module_entrance_exam_ref_id
 * @property integer $department_ref_id
 *
 * The followings are the available model relations:
 * @property ZDELETEUniversityDepartmentEntranceExamModuleWeightage[] $zDELETEUniversityDepartmentEntranceExamModuleWeightages
 * @property EntranceExamModuleEntranceExam $entranceExamModuleEntranceExamRef
 * @property LookupDepartment $departmentRef
 * @property UniversityDepartmentEntranceExamModuleCutoff[] $universityDepartmentEntranceExamModuleCutoffs
 */
class BaseEntranceExamModuleDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamModuleDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_module_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_module_entrance_exam_ref_id, department_ref_id', 'required'),
			array('department_ref_id', 'numerical', 'integerOnly'=>true),
			array('entrance_exam_module_entrance_exam_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_module_department_id, entrance_exam_module_entrance_exam_ref_id, department_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'zDELETEUniversityDepartmentEntranceExamModuleWeightages' => array(self::HAS_MANY, 'ZDELETEUniversityDepartmentEntranceExamModuleWeightage', 'entrance_exam_module_department_ref_id'),
			'entranceExamModuleEntranceExamRef' => array(self::BELONGS_TO, 'EntranceExamModuleEntranceExam', 'entrance_exam_module_entrance_exam_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'universityDepartmentEntranceExamModuleCutoffs' => array(self::HAS_MANY, 'UniversityDepartmentEntranceExamModuleCutoff', 'entrance_exam_module_department_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_module_department_id' => 'Entrance Exam Module Department',
			'entrance_exam_module_entrance_exam_ref_id' => 'Entrance Exam Module Entrance Exam Ref',
			'department_ref_id' => 'Department Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_module_department_id',$this->entrance_exam_module_department_id);
		$criteria->compare('entrance_exam_module_entrance_exam_ref_id',$this->entrance_exam_module_entrance_exam_ref_id,true);
		$criteria->compare('department_ref_id',$this->department_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}