<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailTypeResponse is autogenerate by UniModel generator
 *
 * This is the model class for table "email_type_response".
 *
 * The followings are the available columns in table 'email_type_response':
 * @property string $email_type_response_id
 * @property string $email_type_ref_id
 * @property string $parameter
 * @property string $value
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EmailRecipient[] $emailRecipients
 * @property EmailType $emailTypeRef
 */
class BaseEmailTypeResponse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailTypeResponse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_type_response';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_type_ref_id', 'required'),
			array('added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('email_type_ref_id', 'length', 'max'=>10),
			array('parameter, value', 'length', 'max'=>45),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_type_response_id, email_type_ref_id, parameter, value, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailRecipients' => array(self::HAS_MANY, 'EmailRecipient', 'email_type_response_ref_id'),
			'emailTypeRef' => array(self::BELONGS_TO, 'EmailType', 'email_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_type_response_id' => 'Email Type Response',
			'email_type_ref_id' => 'Email Type Ref',
			'parameter' => 'Parameter',
			'value' => 'Value',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_type_response_id',$this->email_type_response_id,true);
		$criteria->compare('email_type_ref_id',$this->email_type_ref_id,true);
		$criteria->compare('parameter',$this->parameter,true);
		$criteria->compare('value',$this->value,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}