<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailTrackerType is autogenerate by UniModel generator
 *
 * This is the model class for table "email_tracker_type".
 *
 * The followings are the available columns in table 'email_tracker_type':
 * @property integer $email_tracker_type_id
 * @property string $email_name
 * @property string $email_type
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EmailTracker[] $emailTrackers
 */
class BaseEmailTrackerType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailTrackerType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_tracker_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('', 'required'),
			array('email_name', 'length', 'max'=>50),
			array('email_type', 'length', 'max'=>256),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_tracker_type_id, email_name, email_type, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailTrackers' => array(self::HAS_MANY, 'EmailTracker', 'email_tracker_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_tracker_type_id' => 'Email Tracker Type',
			'email_name' => 'Email Name',
			'email_type' => 'Email Type',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_tracker_type_id',$this->email_tracker_type_id);
		$criteria->compare('email_name',$this->email_name,true);
		$criteria->compare('email_type',$this->email_type,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}