<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiOnboard is autogenerate by UniModel generator
 *
 * This is the model class for table "di_onboard".
 *
 * The followings are the available columns in table 'di_onboard':
 * @property string $di_onboard_id
 * @property integer $country_ref_id
 * @property integer $uni_ref_id
 * @property integer $slab
 * @property string $is_active
 * @property string $added_on
 * @property string $university_text
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property TblUniversityMaster $uniRef
 */
class BaseDiOnboard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiOnboard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_onboard';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_ref_id, uni_ref_id, slab', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			array('university_text', 'length', 'max'=>500),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_onboard_id, country_ref_id, uni_ref_id, slab, is_active, added_on, university_text', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_onboard_id' => 'Di Onboard',
			'country_ref_id' => 'Country Ref',
			'uni_ref_id' => 'Uni Ref',
			'slab' => 'Slab',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'university_text' => 'University Text',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_onboard_id',$this->di_onboard_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('slab',$this->slab);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('university_text',$this->university_text,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}