<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCourses is autogenerate by UniModel generator
 *
 * This is the model class for table "courses".
 *
 * The followings are the available columns in table 'courses':
 * @property string $course_id
 * @property string $course_name
 * @property integer $main_dept_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $user_entered
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDepartment $mainDeptRef
 * @property LookupDepartment $subDeptRef
 * @property StudentPreferredDepartment[] $studentPreferredDepartments
 */
class BaseCourses extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Courses the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'courses';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('course_name, added_on', 'required'),
			array('main_dept_ref_id, sub_dept_ref_id', 'numerical', 'integerOnly'=>true),
			array('course_name', 'length', 'max'=>50),
			array('user_entered', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_id, course_name, main_dept_ref_id, sub_dept_ref_id, user_entered, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
			'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_id' => 'Course',
			'course_name' => 'Course Name',
			'main_dept_ref_id' => 'Main Dept Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'user_entered' => 'User Entered',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_id',$this->course_id,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('user_entered',$this->user_entered,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}