<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticle is autogenerate by UniModel generator
 *
 * This is the model class for table "article".
 *
 * The followings are the available columns in table 'article':
 * @property integer $article_id
 * @property string $category
 * @property string $title
 * @property string $message
 * @property string $small_img_name
 * @property string $big_img_name
 * @property string $author
 * @property string $url
 * @property string $expires_on
 * @property string $comment_option
 * @property string $img_cat_tiltle
 * @property string $unique_code
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $published_on
 * @property string $category_type
 * @property string $source_name
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property ArticleBoards[] $articleBoards
 * @property ArticleCategoryTags[] $articleCategoryTags
 * @property ArticleComments[] $articleComments
 * @property ArticleCountries[] $articleCountries
 * @property ArticleDepartements[] $articleDepartements
 * @property ArticleKnowldegeSequence[] $articleKnowldegeSequences
 * @property ArticleKnowledgeMailTracker[] $articleKnowledgeMailTrackers
 * @property ArticleNewsMailTracker[] $articleNewsMailTrackers
 * @property ArticlePassoutYears[] $articlePassoutYears
 * @property ArticleTags[] $articleTags
 */
class BaseArticle extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Article the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('category, title, message, author', 'required'),
			array('category', 'length', 'max'=>9),
			array('title, small_img_name, big_img_name, author, url, source_name', 'length', 'max'=>255),
			array('comment_option', 'length', 'max'=>8),
			array('img_cat_tiltle', 'length', 'max'=>50),
			array('unique_code', 'length', 'max'=>20),
			array('is_active', 'length', 'max'=>1),
			array('added_by, modified_by, category_type', 'length', 'max'=>10),
			array('expires_on, added_on, modified_on, published_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_id, category, title, message, small_img_name, big_img_name, author, url, expires_on, comment_option, img_cat_tiltle, unique_code, is_active, added_on, added_by, modified_on, modified_by, published_on, category_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'articleBoards' => array(self::HAS_MANY, 'ArticleBoards', 'article_ref_id'),
			'articleCategoryTags' => array(self::HAS_MANY, 'ArticleCategoryTags', 'article_ref_id'),
			'articleComments' => array(self::HAS_MANY, 'ArticleComments', 'article_ref_id'),
			'articleCountries' => array(self::HAS_MANY, 'ArticleCountries', 'article_ref_id'),
			'articleDepartements' => array(self::HAS_MANY, 'ArticleDepartements', 'article_ref_id'),
			'articleKnowldegeSequences' => array(self::HAS_MANY, 'ArticleKnowldegeSequence', 'article_ref_id'),
			'articleKnowledgeMailTrackers' => array(self::HAS_MANY, 'ArticleKnowledgeMailTracker', 'article_ref_id'),
			'articleNewsMailTrackers' => array(self::HAS_MANY, 'ArticleNewsMailTracker', 'article_ref_id'),
			'articlePassoutYears' => array(self::HAS_MANY, 'ArticlePassoutYears', 'article_ref_id'),
			'articleTags' => array(self::HAS_MANY, 'ArticleTags', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_id' => 'Article',
			'category' => 'Category',
			'title' => 'Title',
			'message' => 'Message',
			'small_img_name' => 'Small Img Name',
			'big_img_name' => 'Big Img Name',
			'author' => 'Author',
			'url' => 'Url',
			'expires_on' => 'Expires On',
			'comment_option' => 'Comment Option',
			'img_cat_tiltle' => 'Img Cat Tiltle',
			'unique_code' => 'Unique Code',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'published_on' => 'Published On',
			'category_type' => 'Category Type',
                        'source_name' => 'Source Name',
                        'no_views'=>'No.Of views',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_id',$this->article_id);
		$criteria->compare('category',$this->category,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('small_img_name',$this->small_img_name,true);
		$criteria->compare('big_img_name',$this->big_img_name,true);
		$criteria->compare('author',$this->author,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('expires_on',$this->expires_on,true);
		$criteria->compare('comment_option',$this->comment_option,true);
		$criteria->compare('img_cat_tiltle',$this->img_cat_tiltle,true);
		$criteria->compare('unique_code',$this->unique_code,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('published_on',$this->published_on,true);
		$criteria->compare('category_type',$this->category_type,true);
        $criteria->compare('source_name',$this->source_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}