<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseUmailHeader');

class UmailHeader extends BaseUmailHeader
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  static function insertToUmail($param)
  {
    // 
	    $headerresult = self::getUMailDetails($param['headerId'],'Draft');
		$result = UmailMessage::getUMailMessageDetails($param['headerId']);	
		 
		if($headerresult)
		{
			$messageId = $result->attributes['message_id'];
			  
			// Step 1. - Create log with action_type = 'Reply	
	        UmailLog::insertUmailLog($param['headerId'],$messageId ,$param);
		   
		     // Step 2. - Update header status to draft
	          $status = $param['headerStatus'];
			  $umailUniqueId = md5($param['headerId']);
			  $sql='update umail_header set status =:status,unique_id =:uniqueId where header_id=:headerId';
			  $command=Yii::app()->db->createCommand($sql);
              $command->bindParam(":status",$status,PDO::PARAM_STR);
			  $command->bindParam(":uniqueId",$umailUniqueId,PDO::PARAM_STR);
	          $command->bindParam(":headerId",$param['headerId'],PDO::PARAM_STR);
			  $command->execute(); 
			  
			  // Step 3. - update into `umail_message` table
			  UmailMessage::updateUMailMessage($param,$messageId);
			  /***  get umail attachments**/		
		      $umailAttachments = $result['umailAttachments'];
			  if($umailAttachments)
			  {
			    UmailAttachment::deleteUmailAttachment($messageId);
			  }
			  	
			   /** inserting into umail attachment  **/		

			   
			  UmailAttachment::insertUmailAttachment($param,$messageId);
			  
			  /***  get umail Recipients**/ 
			  $umailRecipients = $result['umailRecipients'];
			  
			  if($umailRecipients)
			  {
			    UmailRecipient::deleteUmailRecipient($messageId);
			  }
			  
			   /** inserting into umail recipient  **/		
			   UmailRecipient::insertUmailRecipient($param['cc'],'CC',$messageId);
			   UmailRecipient::insertUmailRecipient($param['parent'],'Parent',$messageId);
			   UmailRecipient::insertUmailRecipient($param['univariety'],'Univar',$messageId);	
		}
		else
		{

			$userID = LoginMaster::getUserDetails($param['emails']);

			 /** inserting into umail header **/

            if(isset($_SESSION['extadv']) && $_SESSION['extadv']==1){
                $headerID =  UmailHeader::insertExtUmailHeader($param,$userID['user_id'],$param['headerStatus']);
            }
            else{
                $headerID =  UmailHeader::insertUmailHeader($param,$userID['user_id'],$param['headerStatus']);
            }
			$umailUniqueId = md5($headerID);
			 
			 $sql='update umail_header set unique_id =:uniqueId where header_id=:headerId';
			 $command=Yii::app()->db->createCommand($sql);
             $command->bindParam(":uniqueId",$umailUniqueId,PDO::PARAM_STR);			
	         $command->bindParam(":headerId",$headerID,PDO::PARAM_STR);
			 $command->execute(); 
						
			 /** inserting into umail message  **/	
			 $messageId =  UmailMessage::insertUmailMessage($param,$headerID,$userID['user_id']);	
			
			  /** inserting into umail log **/			
			 UmailLog::insertUmailLog($headerID,$messageId,$param);
			 
			 /** inserting into umail recipient  **/			
			 UmailRecipient::insertUmailRecipient($param['cc'],'CC',$messageId);
			 UmailRecipient::insertUmailRecipient($param['parent'],'Parent',$messageId);
			 UmailRecipient::insertUmailRecipient($param['univariety'],'Univar',$messageId);				  
			
			 /** inserting into umail attachment  **/												
			 UmailAttachment::insertUmailAttachment($param,$messageId);	
		}		 
		return $umailUniqueId;
    }
	
	static function insertExtUmailHeader($param=false,$userID=false,$type=false)
	{
       

	       if(!empty($param['guidemeRecipientId']))
		   $adminId = $param['guidemeRecipientId'];
		else if(!empty(Yii::app()->user->sub_id)){

            $siAdminRes = TblAdmin::getExtAdminDetails(Yii::app()->user->sub_id);

        }

      
		if(!empty($siAdminRes))
		   $adminId = $siAdminRes->attributes['admin_id'];
		
		//$guidemeRecipient)?$guidemeRecipient:$siAdminRes->attributes['admin_id'];
		
		 $headerModel = new UmailHeader();
		 $headerModel->sender_type = 1;		 
		 $headerModel->sender_id = 	$userID;	 
		 $headerModel->recipient_type = !empty($param['recipientType'])?$param['recipientType']:4;
		// $headerModel->recipient_id = $siAdminRes->attributes['admin_id'];	
	    $headerModel->recipient_id =  $adminId;	
		 
		//echo "treste";
		//echo "<pre>"; print_r($headerModel->attributes); echo "</pre>"; exit;
		
		 $headerModel->querytype_id = 1;
		 $headerModel->added_on = date('Y-m-d H:i:s');
		 $headerModel->last_replied_on = date('Y-m-d H:i:s');
		 $headerModel->university_ref_id = NULL;
		 /*$headerModel->original_advisor_id =  $siAdminRes->attributes['admin_id']; 
		 $headerModel->current_advisor_id =  $siAdminRes->attributes['admin_id']; */
		 
		 $headerModel->original_advisor_id = $adminId;	
		 $headerModel->current_advisor_id =  $adminId;	
		 
		 $headerModel->status = $type;
		 $headerModel->unique_id = 11; 		 
		 $headerModel->save();				 
		 $headerID = $headerModel->header_id;	
		 if($headerID > 0)
		 {
			 return $headerID;
		 }
    }
 
	
	
	
	
	
 static function insertUmailHeader($param=false,$userID=false,$type=false)
  {
		
	    if(!empty($param['guidemeRecipientId']))
		   $adminId = $param['guidemeRecipientId'];
		else if(!empty(Yii::app()->user->sub_id))
		  $siAdminRes = TblAdmin::getSiAdminDetails(Yii::app()->user->sub_id);
		   
		
		if(!empty($siAdminRes))
		   $adminId = $siAdminRes->attributes['admin_id'];
		
		   //$guidemeRecipient)?$guidemeRecipient:$siAdminRes->attributes['admin_id'];
		
		 $headerModel = new UmailHeader();
		 $headerModel->sender_type = 1;		 
		 $headerModel->sender_id = 	$userID;	 
		 $headerModel->recipient_type = !empty($param['recipientType'])?$param['recipientType']:4;
		// $headerModel->recipient_id = $siAdminRes->attributes['admin_id'];	
	     $headerModel->recipient_id =  $adminId;	
		
		 $headerModel->querytype_id = 1;
		 $headerModel->added_on = date('Y-m-d H:i:s');
		 $headerModel->last_replied_on = date('Y-m-d H:i:s');
		 $headerModel->university_ref_id = NULL;
		 /*$headerModel->original_advisor_id =  $siAdminRes->attributes['admin_id']; 
		 $headerModel->current_advisor_id =  $siAdminRes->attributes['admin_id']; */
		 
		 $headerModel->original_advisor_id = $adminId;	
		 $headerModel->current_advisor_id =  $adminId;	
		 
		 $headerModel->status = $type;
		 $headerModel->unique_id = 11; 
		 
		 $headerModel->save();
				 
		 $headerID = $headerModel->header_id;
		 
		 if($headerID > 0)
		 {
			 return $headerID;
		 }
    }
 static function getUMailDetails($headerId = false,$type=false)
{
    try{		
	    $criteria=new CDbCriteria;
		$criteria->condition = 'header_id="'.$headerId.'" AND status="'.$type.'"';		
        $umailList = self::model()->find($criteria);
  	    return $umailList;
	}
	catch(Exception $ex)
	{
		echo $ex;
	}		
  }
  
	//public static function getUmailList($type = 'inbox', $view = 'all', $siRefId = 0, $limitStart = 0, $limitEnd = 100, $searchString = '', $returnCount = false,$extstatus)
	public static function getUmailList($type = 'inbox', $view = 'all', $siRefId = 0, $limitStart = 0, $limitEnd = 100, $searchString = '', $returnCount = false)
	{
		/**
		get SI Admin Details			
		**/			
		$result = TblAdmin::getSiAllAdminDetails($siRefId);
		$siref_condition="ta.si_ref_id=";
		if(!empty($result)){
			$str = $res = "";
    		foreach($result as $rs){
				$res .= $str.$rs['admin_id'];
				$str = ",";
			}
		}
		if(isset($_SESSION['extadv']) && $_SESSION['extadv']==1) {
			$result = TblAdmin::getExtAdminDetails($siRefId);
			$res =$siRefId;
			$siref_condition="ta.admin_id=";
		}		
		
		$msgSearchCondition = $subjectSearchCondition = '';
		$sql = "SELECT DISTINCT uh.status uh_status,CONCAT(tum.first_name, ' ', tum.last_name) student_name, qt.type_name , um.*, um.added_on date_order 
				FROM umail_header uh
				LEFT JOIN umail_message um ON uh.header_id = um.header_ref_id
				LEFT JOIN query_type qt ON qt.type_id = uh.querytype_id
				LEFT JOIN tbl_admin ta ON (ta.admin_id = uh.recipient_id )
				LEFT JOIN tbl_user_master tum ON tum.user_id = uh.sender_id
				WHERE ".$siref_condition." :siRefId ";
		switch($type){
			case 'draft':{
				$sql .= "AND uh.current_advisor_id = ta.admin_id
						AND uh.original_advisor_id = ta.admin_id
						AND uh.status IN ('Draft')
						GROUP BY um.header_ref_id";
				break;
			}
			case 'sent':{
				/*$sql .= "AND uh.original_advisor_id = ta.admin_id
						AND uh.current_advisor_id = ta.admin_id
						AND uh.status IN ('Replied', 'Read')  AND uh.recipient_type = 4
						GROUP BY um.header_ref_id";*/
				$sql = "SELECT DISTINCT uh.status uh_status,CONCAT(tum.first_name, ' ', tum.last_name) student_name, qt.type_name , um.*, um.added_on date_order 
				FROM umail_header uh
				LEFT JOIN umail_message um ON uh.header_id = um.header_ref_id
				LEFT JOIN query_type qt ON qt.type_id = uh.querytype_id
				LEFT JOIN tbl_admin ta ON  (ta.admin_id = uh.recipient_id)
				LEFT JOIN tbl_user_master tum ON tum.user_id = uh.sender_id
				WHERE ( ".$siref_condition." :siRefId AND uh.current_advisor_id IN (".$res.") AND uh.status IN ('Replied', 'Read'))  OR (uh.escalate_advisor_id IN (".$res.") AND uh.status IN ('Replied', 'Read'))					
				GROUP BY um.header_ref_id";						
				break;
			}			
			case 'escalate':{
				$sql = "SELECT DISTINCT uh.status uh_status, uh.escalate_advisor_id, CONCAT(tum.first_name, ' ', tum.last_name) student_name, qt.type_name , um.*, 
						um.added_on date_order
						FROM umail_header uh 
						LEFT JOIN umail_message um ON uh.header_id = um.header_ref_id 
						LEFT JOIN query_type qt ON qt.type_id = uh.querytype_id 
						LEFT JOIN tbl_admin ta ON (ta.admin_id = uh.escalate_advisor_id) 
						LEFT JOIN tbl_user_master tum ON tum.user_id = uh.sender_id 
						 WHERE ".$siref_condition." :siRefId 
						AND uh.escalate_advisor_id > 0
						AND uh.status NOT IN ('Replied', 'Read')
						GROUP BY um.header_ref_id";
				break;
			}			
			case 'search':{
				$sql .= "AND uh.original_advisor_id = ta.admin_id
						AND uh.current_advisor_id = ta.admin_id
						AND uh.status IN ('Replied', 'Read')";			
				$strLen           		= strlen($searchString);
				$searchOption     		= 'Any Term';
				$uMailSearchCondition 	= "";
				
				if ($searchString[0] == '"' && $searchString[$strLen - 1] == '"') {
					$searchString = substr($searchString, 1, ($strLen - 2));
					$searchOption = 'Exactly';
				}else if (strpos($searchString, '+') > 0) {
					$searchOption = 'Like';
				}
				//echo "<br>###".$searchOption;
				switch ($searchOption) {
					case 'Like': {
						$messageSearchStrs = explode('+', $searchString);
						$andGlue = '';
						foreach ($messageSearchStrs as $str) {
							if(trim($str) != ''){
								$msgSearchCondition 	.= $andGlue."um.message LIKE '%" . trim($str) . "%'";
								$subjectSearchCondition .= $andGlue."um.subject LIKE '%" . trim($str) . "%'";
								$andGlue = " AND ";
							}
						}						
						break;
					}
					case 'Exactly': {
						$messageSearchStrs[0] = $searchString;
						$msgSearchCondition 	.= "um.message LIKE '%" . trim($messageSearchStrs[0]) . "%'";
						$subjectSearchCondition .= "um.subject LIKE '%" . trim($messageSearchStrs[0]) . "%'";
						break;
					}
					case 'Any Term': {
						$messageSearchStrs = explode(' ', $searchString);
						$tempArr           = array();
						$tempArr2           = array();
						foreach ($messageSearchStrs as $str) {
							if(trim($str) != ''){
								$tempArr[] 	= "um.message LIKE '%" . trim($str) . "%'";
								$tempArr2[] = "um.subject LIKE '%" . trim($str) . "%'";
							}
						}
						//echo "<br>\$msgSearchCondition:".
						$msgSearchCondition 	.= "( " . implode(" OR ", $tempArr) . ")";
						$subjectSearchCondition .= "( " . implode(" OR ", $tempArr2) . ")";
						
						break;
					}
				}				
				if($msgSearchCondition != ''){
					$uMailSearchCondition = " AND (".$msgSearchCondition;
				}
				if($subjectSearchCondition != ''){
					$uMailSearchCondition .= " OR ".$subjectSearchCondition;
				}
				if($uMailSearchCondition != ''){
					$uMailSearchCondition .= ")";	
				}
				$sql .= $uMailSearchCondition."	GROUP BY um.header_ref_id";
				//die($sql);
				break;
			}				
			case 'inbox':
			default :{
				$type = 'inbox';				
				$sqlInboxStudents = $sql . "AND uh.current_advisor_id = ta.admin_id
											AND uh.original_advisor_id = ta.admin_id
											AND uh.status IN ('New', 'Open', 'Locked')
											GROUP BY um.header_ref_id";
											
				$sqlInboxUnivariety = $sql . "AND uh.original_advisor_id = ta.admin_id
											  AND uh.current_advisor_id != ta.admin_id
											  AND uh.status IN ('Replied', 'Read')
											  GROUP BY um.header_ref_id";
				switch($view){
					case 'students':{
						$sql = $sqlInboxStudents;
						break;
					}
					case 'univariety':{
						$sql = $sqlInboxUnivariety;
						break;
					}					
					case 'all':
					default :{
						$view = 'all';
						$sql = $sqlInboxStudents . " UNION ALL " . $sqlInboxUnivariety;
						break;
					}
				}
				break;
			}
		}
		$umailInboxMessages = array();	
		
		//echo "<pre>"; print_r($sql); echo "</pre>";
		///echo "<pre>"; print_r($siRefId); echo "</pre>";
		//exit;
		
		
		if($sql != ''){					
			$cmd = Yii::app()->db->createCommand($sql);
			$cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
			$res = $cmd->queryAll();
			$totalRecords = count($res);
			
			$sql .= " ORDER BY date_order DESC";
			if($limitStart >= 0 && $limitEnd >= 0){
				$sql .= " LIMIT " . $limitStart . ", " . $limitEnd;
			}
			//die($totalRecords."<br>".$sql);
			$cmd = Yii::app()->db->createCommand($sql);
			$cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
			$res = $cmd->queryAll();
			
			foreach($res as $tempArr){
				$tempArr = array_merge(array('total_records' => $totalRecords), $tempArr);
				$umailInboxMessages[] = $tempArr;
			}
		}		
		return $returnCount ? $totalRecords : $umailInboxMessages;
	}
	
	public function updateUmailHeaderRecordValue($pk, $fieldName, $fieldValue = NULL){
		self::model()->updateByPk($pk, array($fieldName => $fieldValue));
	}
	
	static function replyToUmail($param,$umailType)
	{   		 
	   
		$query  = "SELECT message_id, sender_type FROM umail_message 
				WHERE header_ref_id = (SELECT header_id FROM umail_header 
				WHERE header_id = " . $param['headerId'] . " 
				AND (STATUS = 'Draft'))						
				ORDER BY added_on 
				DESC LIMIT 0,1"; 
							
		$cmd = Yii::app()->db->createCommand($query);	   
		$res = $cmd->queryAll();
		if ($res > 0)
		{			
			$messageId = ($res['sender_type'] == 4)? $res['message_id'] : '';					
			$draftattachArr =  UmailAttachment::getUmailAttachment($messageId);			
			if (!empty($draftattachArr))
			{
				$comma = $filestr = $originalfilestr = '';
				foreach ($draftattachArr as $row)
				{
					$filestr .= $comma . $row['filename'];
					$originalfilestr .= $comma . $row['filename'].'|'.$row['original_file_name'];
					$comma = ',';
				}
				$fldImageName        = $filestr;
				$fldoriginalFileName = $originalfilestr;
			} 
		}
			 
		 $headerResult = self::getUMailDetails($param['headerId'],$type=false);			  
		 $param['currentAdvisorId'] = $headerResult->attributes['current_advisor_id'];
			 
		 if($messageId > 0)
		 {
			// Step 3. - update into `umail_message` table
			UmailMessage::updateUMailMessage($param,$messageId);
			   
			// Step 1. - Create log with action_type = 'draft
			
	        UmailLog::insertUmailLog($param['headerId'],$messageId,$param);
			   
			 /***  get umail attachments**/			      
			$umailAttachments =  UmailAttachment::getUmailAttachment($messageId);
			  
			if($umailAttachments)
			{
			   UmailAttachment::deleteUmailAttachment($messageId);
			}
			  	
			/** inserting into umail attachment  **/		
										
			UmailAttachment::insertUmailAttachment($param,$messageId);
			  
			/***  get umail Recipients**/ 
			  			
			$umailRecipients = UmailRecipient::getUmailRecipient($messageId);
			  
			if($umailRecipients)
			{
			  UmailRecipient::deleteUmailRecipient($messageId);
			}			  
			 /** inserting into umail recipient  **/		
			 UmailRecipient::insertUmailRecipient($param['cc'],'CC',$messageId);
			 UmailRecipient::insertUmailRecipient($param['parent'],'Parent',$messageId);
			 UmailRecipient::insertUmailRecipient($param['univariety'],'Univar',$messageId);				   
		  }
		 else
		 {				
			$userID = LoginMaster::getUserDetails($param['emails']); 
				
			// Step 2. - Update header status to draft
			$status = $param['headerStatus'];
			$umailUniqueId = md5($param['headerId']);
			$sql='update umail_header set status =:status,unique_id =:uniqueId where header_id=:headerId';
			$command=Yii::app()->db->createCommand($sql);
			$command->bindParam(":status",$status,PDO::PARAM_STR);
			$command->bindParam(":uniqueId",$umailUniqueId,PDO::PARAM_STR);
			$command->bindParam(":headerId",$param['headerId'],PDO::PARAM_STR);
			$command->execute(); 
				 
		    $messageId = UmailMessage::insertUmailMessage($param,$param['headerId'],$userID['user_id']); 
				
			 /** inserting into umail log **/
							
			UmailLog::insertUmailLog($param['headerId'],$messageId,$param);
				
			 /** inserting into umail recipient  **/
			
			UmailRecipient::insertUmailRecipient($param['cc'],'CC',$messageId);	
			UmailRecipient::insertUmailRecipient($param['parent'],'Parent',$messageId);
			UmailRecipient::insertUmailRecipient($param['univariety'],'Univar',$messageId);			 				  
				
			/** inserting into umail attachment  **/												
			UmailAttachment::insertUmailAttachment($param,$messageId);				 
		  }
		
    }
	
	function escalateUmail($headerId = false,$recipientType = false,$sId = false)
	{
		 $UmailLimit = 3;
		 $modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));	
		 $adminMasterDetails = TblAdmin::model()->find(array("condition"=>"si_ref_id = '".$sId."' and is_primary_si = 1"));
		// $adminId = !empty(Yii::app()->user->sub_id)?Yii::app()->user->sub_id:'';
		 
		 $umailRes =  UmailMessage::getUMailMessageDetails($headerId,$senderType=1);
		 		 
		 $countExists = UmailMessage::getumailCount($umailRes->attributes['sender_id'],$umailRes->attributes['sender_type']);
				 
		if($countExists >= $UmailLimit){
			$day = 4;
		}else{
			$day = 2;
		}									
		$last_date = UmailHeader::getWorkingDays2(date("Y-m-d H:i"),$day);
		$last_val = $last_date['next'];	
		$expectedDate = end($last_val);			
			  
		$status = 'New';
		$sql='update umail_header set status =:status,recipient_type=:recipientType,current_advisor_id=:currentAdvisorId,recipient_id=:recipientId,
		   escalate_advisor_id = :escalateAdvisorId where header_id=:headerId';
		$command=Yii::app()->db->createCommand($sql);
		$command->bindParam(":status",$status,PDO::PARAM_STR);
		$command->bindParam(":recipientType",$recipientType,PDO::PARAM_STR);
		$command->bindParam(":recipientId",$modelAdminMaster->attributes['admin_id'],PDO::PARAM_STR);		
		$command->bindParam(":currentAdvisorId",$modelAdminMaster->attributes['admin_id'],PDO::PARAM_STR);		 
		$command->bindParam(":escalateAdvisorId",$adminMasterDetails->attributes['admin_id'],PDO::PARAM_STR);
		 //$command->bindParam(":escalateAdvisorId",$adminId,PDO::PARAM_STR);
	
		$command->bindParam(":headerId",$headerId,PDO::PARAM_STR);
		$command->execute(); 
				
		$messageSql='update umail_message set added_on = :addedOn,expected_reply_date = :expectedReplyDate where message_id=:messageId';
		$command1=Yii::app()->db->createCommand($messageSql);		
	    $command1->bindParam(":addedOn",date('Y-m-d H:i:s'),PDO::PARAM_STR);
		$command1->bindParam(":expectedReplyDate",$expectedDate,PDO::PARAM_STR); 
		$command1->bindParam(":messageId",$umailRes->attributes['message_id'] ,PDO::PARAM_STR);
		$command1->execute(); 
		
		  // Step 1. - Create log with action_type = 'Reply	
		$param['logStatus'] =  'Escalate';
		//$param['currentAdvisorId'] =  $modelAdminMaster->attributes['admin_id'];
        $status = 'Escalate';
	    UmailLog::insertUmailLog($headerId,$umailRes->attributes['message_id'],$param);
	}
	
		
	
	public function getQAUmailList($list_criteria,$pgcount)
	{
		try{
			$where='SA.end_date IS NULL AND A.admin_full_name <> "" AND UH.status IN ("Replied","read")  AND UH.is_publish="W" AND UH.sender_type=1 AND UM.sender_type=1 ';
			if(!empty($list_criteria))
			{				
				if(!empty($list_criteria['txtFromDate'])) {
					$frm_date=DateTime::createFromFormat('m-d-Y', $list_criteria['txtFromDate'])->format('Y-m-d');
					$where.=' AND UH.added_on >= "'.$frm_date.'" ';
				}
				if(!empty($list_criteria['txtToDate'])) {						
					$to_date1=DateTime::createFromFormat('m-d-Y', $list_criteria['txtToDate'])->format('Y-m-d');					
					$to_date=date('Y-m-d', strtotime($to_date1 . '+1 days')); 
					
					$where.=' AND UH.added_on <= "'.$to_date.'" ';
				}
				if(!empty($list_criteria['txtSearchMessage'])) {					
					$where.=' AND UM.subject like "%'.$list_criteria['txtSearchMessage'].'%" ';
				}			
		
			}		
			if($pgcount==0)
			{
				$select="count(UH.header_id) as maxcount";
				$grp="";
				$order="";
				$limit=1;
				
				$res_qry='SELECT COUNT(header_id) as maxcount FROM `umail_header`
 WHERE header_id IN(SELECT UH.header_id FROM umail_header UH 
 LEFT JOIN `umail_message` `UM` ON UM.header_ref_id = UH.header_id 
 LEFT JOIN `si_advisor` `SA` ON SA.advisor_id = UH.recipient_id 
 LEFT JOIN `tbl_user_master` `U` ON U.user_id = UH.sender_id 
 LEFT JOIN `query_type` `QT` ON QT.type_id = UH.querytype_id 
 LEFT JOIN `tbl_admin` `A` ON A.admin_id = UH.recipient_id 
 WHERE '. $where .' GROUP BY `UH`.`header_id`)';
				
				$res=Yii::app()->db->createCommand($res_qry)->queryAll();
				
				
				/*$res= Yii::app()->db->createCommand()
					->select($select)
					->from('umail_header UH')
					->leftJoin('umail_message UM','UM.header_ref_id = UH.header_id')
					->leftJoin('si_advisor SA','SA.advisor_id = UH.recipient_id')
					->leftJoin('tbl_user_master U','U.user_id = UH.sender_id')
					->leftJoin('query_type QT','QT.type_id = UH.querytype_id')
					->leftJoin('tbl_admin A','A.admin_id = UH.recipient_id')
					->where($where)								
					->queryAll();	*/			
			}
			else {
				$offset=($pgcount >1)? (($pgcount-1)*20) : '';
			//Modified the limit size.
				$select="UH.header_id,UH.status, UH.sender_type, UH.sender_id, UH.recipient_type, UH.recipient_id, UH.querytype_id, UH.added_on, UH.last_replied_on, UH.original_advisor_id, UH.current_advisor_id, SA.si_id, UM.message, UM.subject, UM.added_on AS msg_added_on, QT.type_name,  CONCAT(IFNULL(U.first_name,''), ' ',IFNULL(U.middle_name,''),' ',IFNULL(U.last_name,'')) AS stud_name,U.country_ref_id AS country_ref_id,A.admin_full_name AS recipient, (SELECT SE1.school_name FROM student_education SE1 WHERE SE1.user_ref_id = U.user_id ORDER BY SE1.class_level DESC LIMIT 0,1) AS inst_name,(SELECT LB.board_name FROM student_education SE1 LEFT JOIN lookup_board_equivalent LB ON LB.board_equivalent_id = SE1.board_ref_id WHERE SE1.user_ref_id = U.user_id ORDER BY SE1.class_level DESC LIMIT 0,1) AS school_board, U.user_id";
				$grp="UH.header_id";
				$order="UM.added_on DESC";				
				$res= Yii::app()->db->createCommand()
					->select($select)
					->from('umail_header UH')
					->leftJoin('umail_message UM','UM.header_ref_id = UH.header_id')
					->leftJoin('si_advisor SA','SA.advisor_id = UH.recipient_id')
					->leftJoin('tbl_user_master U','U.user_id = UH.sender_id')
					->leftJoin('query_type QT','QT.type_id = UH.querytype_id')
					->leftJoin('tbl_admin A','A.admin_id = UH.recipient_id')
					->where($where)
					->group($grp)
					->order($order)
					->limit(20)
					->offset($offset)
					->queryAll();
			}
			return $res;			
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}

	
	public  function getWorkingDays2($date,$workingday){
		$workdays['next'] = array();
		$workdays['next'] = array();
		$holidays = UmailHeader::getHolidays();										
		$date     = strtotime($date);
	
		$start_date = $date;
		$date = $start_date;
		/* if($this->count_exists > $this->UmailLimit){
			 $day = 4;
		 }else{
			 $day = 2;
		 }*/
		 
		while(count($workdays['next']) <= $workingday){		
							
	
			if(date('N',$date) <= 7 && !in_array(date('Y-m-d',$date),$holidays)){
				$workdays['next'][] = date('Y-m-d H:i',$date);												
			}
			 $date = strtotime("+1 day", $date);		
				
		}
	
		//krsort($workdays['prev']);
		return $workdays;
	}
		
	public function getHolidays()
	{										
		$stringsHolidays =  UmailHeader::getHolidaysfromDb();									  
		$holidays = explode(',',$stringsHolidays);										
		return $holidays;
	}
	public function getHolidaysfromDb()
	{
		$holidates = "";
		$row = LookupHoliday::model()->findAll();	
				
		foreach($row as $res){
					$holidates.= ','.$res->attributes['dates'];
		 }
		return substr($holidates,1);
			
	}
		
	public function umailAutoEscalationFromCSS()
	{
		$cur_date=date('Y-m-d H:i:s');
		
		$modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));	
		$criteria=new CDbCriteria;		
		
		$query  = "SELECT t.header_id,um.message_id,um.header_ref_id,t.original_advisor_id,t.current_advisor_id,um.expected_reply_date,um.added_on
				   FROM 
						umail_header t
						JOIN umail_message um ON um.header_ref_Id = t.header_id 
						JOIN tbl_admin ta ON ta.admin_id = t.recipient_id 
						JOIN tbl_si_di tsidi ON tsidi.inst_id = ta.si_ref_id							
					WHERE 
						(t.status = 'New' OR t.status = 'Open') AND t.recipient_type = '4' AND tsidi.css_access = '1'  AND tsidi.auto_escalate_flag='N' AND ((TIME_TO_SEC(TIMEDIFF('".$cur_date."',um.expected_reply_date))/60)/60) > 48"; 
					
		$cmd = Yii::app()->db->createCommand($query);	
		
		$res = $cmd->queryAll();


		if(!empty($res))
		{
			foreach($res as $rs)
			{

				$last_date = UmailHeader::getWorkingDays2(date("Y-m-d H:i"),2);
				$last_val = $last_date['next'];	
				$expectedDate = end($last_val);	
				 
				 $res=  self::model()->updateByPk($rs['header_id'], array('recipient_type'=>2,'recipient_id'=>$modelAdminMaster->attributes['admin_id'],'escalate_advisor_id'=>$rs['original_advisor_id'],'current_advisor_id'=>$modelAdminMaster->attributes['admin_id']));						
				
				 $umailMessageRes=  UmailMessage::model()->updateByPk($rs['message_id'], array('expected_reply_date'=>$expectedDate,'auto_escalate'=>1));
				 
				$status = 'Escalate';						
				$adminId = $rs['current_advisor_id'];
				$modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));	
				$umailLogModel = new UmailLog();
				$umailLogModel->header_ref_id  = $rs['header_id'];
				$umailLogModel->message_ref_id = $rs['message_id'];
				$umailLogModel->action_type    = $status;						
				$umailLogModel->current_advisor = $adminId;
				$umailLogModel->new_advisor	    = $modelAdminMaster->attributes['admin_id'];
				
				$umailLogModel->added_on        = date('Y-m-d H:i:s');
				$umailLogModel->added_by        = $adminId;
				$umailLogModel->sender_type     = 4; 	
				$umailLogModel->sender_id       = $adminId;
				$umailLogModel->save();	
			}
		}
		
		//return $res; 			
	}
		
 public function umailAutoEscalationIntervalFromCSSClient()
  {
			    $cur_date=date('Y-m-d H:i:s');
				
				$modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));
			    $modelTblSis = TblSiDi::getAutoEscalateInstituteDetails();
				
			     if(!empty($modelTblSis))
				 {
					foreach($modelTblSis as $modelTblSi)
					{
					   $query  = "SELECT t.header_id,um.message_id,um.header_ref_id,t.original_advisor_id,t.current_advisor_id,um.expected_reply_date,um.added_on
							   FROM 
									umail_header t
									JOIN umail_message um ON um.header_ref_Id = t.header_id 
									JOIN tbl_admin ta ON ta.admin_id = t.recipient_id 
									JOIN tbl_si_di tsidi ON tsidi.inst_id = ta.si_ref_id							
								WHERE 
									(t.status = 'New' OR t.status = 'Open') AND t.recipient_type = '4' AND tsidi.css_access = '1'  AND tsidi.auto_escalate_flag='Y' AND 
									ta.si_ref_id='".$modelTblSi['inst_id']."' AND ta.is_primary_si = 1 AND ((TIME_TO_SEC(TIMEDIFF('".$cur_date."',um.added_on))/60)/60) > ".$modelTblSi['auto_escalate_interval'].""; 
								
					   $cmd = Yii::app()->db->createCommand($query);	
					
					   $res = $cmd->queryAll();
	
				
					   if(!empty($res))
					   {
						foreach($res as $rs)
						 {
			
							$last_date = UmailHeader::getWorkingDays2(date("Y-m-d H:i"),2);
							$last_val = $last_date['next'];	
							$expectedDate = end($last_val);	
							 
							$res=  self::model()->updateByPk($rs['header_id'], array('recipient_type'=>2,'recipient_id'=>$modelAdminMaster->attributes['admin_id'],'escalate_advisor_id'=>$rs['original_advisor_id'],'current_advisor_id'=>$modelAdminMaster->attributes['admin_id']));						
							
							$umailMessageRes=  UmailMessage::model()->updateByPk($rs['message_id'], array('expected_reply_date'=>$expectedDate,'auto_escalate'=>1));
							 
							$status = 'Escalate';
						
							$adminId = $rs['current_advisor_id'];
							$modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));	
							$umailLogModel = new UmailLog();
							$umailLogModel->header_ref_id  = $rs['header_id'];
							$umailLogModel->message_ref_id = $rs['message_id'];
							$umailLogModel->action_type    = $status;
						
							$umailLogModel->current_advisor = $adminId;
							$umailLogModel->new_advisor	    = $modelAdminMaster->attributes['admin_id'];
							
							$umailLogModel->added_on        = date('Y-m-d H:i:s');
							$umailLogModel->added_by        = $adminId;
							$umailLogModel->sender_type     = 4; 	
							$umailLogModel->sender_id       = $adminId;
							$umailLogModel->save();	
						 }
					   }
					 }
				 }
   }
 public function emailReaderGmailToUmail()
  {
			  $mktime = mktime(0,0,0,date('m'),date('d'),date('Y'));				
			  $mktime_yesterday = $mktime-2;				
			  $date = date('d F Y',$mktime_yesterday);				
			  $failedEmailsArray = array();			  
			  $hostname = '{imap.gmail.com:993/imap/ssl}INBOX';				
			  $username = Yii::app()->params['params']['UmailEmailReader'];			 			
			  $password = 'Un!help301';			
			  /* try to connect */
				
			  $inbox = imap_open($hostname,$username,$password) or die('Cannot connect to Gmail: ' . imap_last_error());				
			  $searchCriteria = 'ALL SINCE "'.$date.'"';
				
			  $emails = imap_search($inbox, $searchCriteria);
				
			/* if emails are returned, cycle through each... */
				
			  if($emails) 
			  {
				/* begin output var */
				/* if emails are returned, cycle through each... */
	            $arr = array();
                rsort($emails);
	            /* for every email... */

	            foreach($emails as $email_number)
				{
				 /* get information specific to this email */			
				  $overview = imap_fetch_overview($inbox,$email_number,0);				
				  $message  = imap_fetchbody($inbox,$email_number, 1, FT_PEEK);
		          // GET TEXT BODY

		          $dataTxt = UmailHeader::get_part($inbox, $email_number, "TEXT/PLAIN");
		          // GET HTML BODY
		          $dataHtml = UmailHeader::get_part($inbox, $email_number, "TEXT/HTML");
				  if ($dataHtml != "")
				  {
				    $msgBody = $dataHtml;
				    $mailformat = "html";
			       } 
				   else 
				   {	
					 $msgBody = str_replace("\n","<br>",$dataTxt);
					 $mailformat = "text";
				   }

			 	   if ($mailformat == "text")					
				      $message=$msgBody;				   
				   else					
				      $message=$msgBody; // It contains all HTML HEADER tags so we don't have to make them.  
			 	      
		            preg_match("#Delivery to the following recipient failed permanently:(.*?)Technical details#s", $message, $arr);
					  
		            if (count($arr)>0)
					{

		            } 
					else
					{					
				      $from    = $overview[0]->from;
				      $subject = $overview[0]->subject;				
				      $date    = $overview[0]->date;
				      $header  = imap_headerinfo($inbox, $email_number);
				      $fromaddr = $header->from[0]->mailbox . "@" . $header->from[0]->host;	
					  
					  $guidemeCount = UmailGuidememailDetail::findByUniqueKey($email_number,$date);
					 
					  
					  if($guidemeCount == 0)
					  {
						 $userRes = LoginMaster::getUserDetails($fromaddr);
                         $userID  = $userRes['user_id'];
						
                          /**
                           * email id checking in
                           */
                          if(empty($userID))
                         {
                            $alternateEmailRes = StudentAlternateEmail::findByEmail($fromaddr);
                            if($alternateEmailRes)
                            {
                              $alternateloginId = $alternateEmailRes->attributes['login_ref_id'];
                              $userRes = TblUserMaster::findById($alternateloginId);
                              $userID  = $userRes['user_id'];
                            }
                          }

						
						 if($userID > 0)
						 {
						   $studentType = TblUserMaster::getUserDetails($userID);	 
						   $prospectResult = Prospect::getProspectDetails($userID);
						   
						   if(!empty($prospectResult) && ($studentType->attributes['membership_ref_id'] == 1 || $studentType->attributes['membership_ref_id'] == 2) )
							{
								$fldRecipientType = 2;
								$fldRecipientId =$prospectResult->attributes['advisor_ref_id'] ;		
							}
						   
						   else if(!empty($studentType) && ($studentType->attributes['membership_ref_id'] == 3 || $studentType->attributes['membership_ref_id'] == 4) )
							{
								$fldRecipientType = 2;
								$siAdvisorId = StudentAssignedAdvisor::getStudentAssignedAdvisor($userID);
								if($siAdvisorId)
								$fldRecipientId   = $siAdvisorId->attributes['primary_advisor_ref_id'];
							}
							
							else if($studentType->attributes['membership_ref_id'] == 2)
							{										 
						        $sql = "SELECT  ta.admin_id,ta.si_ref_id
										 FROM    tbl_admin ta
												 LEFT JOIN tbl_si_students tss ON tss.inst_ref_id = ta.si_ref_id
												 LEFT JOIN tbl_user_master tum on tum.user_id = tss.user_ref_id
										 WHERE 
												 tss.user_ref_id = '".$userID."' AND ta.is_active = 'Y' AND tum.membership_ref_id NOT IN
												(SELECT membership_id FROM lookup_membership WHERE membership_name 
							  					IN ('GEM Student', 'SI and GEM Student'))";								
							     $cmd = Yii::app()->db->createCommand($sql);					
							     $result = $cmd->queryAll();
							     if($result > 0)						    
								   $fldRecipientId = (isset($result[0]['admin_id'])) ? $result[0]['admin_id'] : '';								 
								   $fldRecipientType = (isset($result[0]['si_ref_id'])) ? 4 : 2;
							  }	
							 if($fldRecipientId == "")
							 {								  
							    $modelAdminMaster = TblAdmin::model()->find(array("condition"=>"admin_name = 'Unassigned'"));	
								$fldRecipientId   = $modelAdminMaster->attributes['admin_id'];
								$fldRecipientType = 2;
							  }
							  							   
							  $param['guidemeRecipientId'] = $fldRecipientId;
							  $type = 'New';
							  $param['recipientType'] = $fldRecipientType;
							
		
		
							  $headerID    = UmailHeader::insertUmailHeader($param,$userID,$type);
							 
							  
							  $UmailLimit = 3;
							  $countExists = UmailMessage::getumailCount($userID,1);	
							  
							   if($countExists >= $UmailLimit)							   
								 $day = 4;						  
							   else							  
								 $day = 2;												 
													
							  $last_date = UmailHeader::getWorkingDays2(date("Y-m-d H:i"),$day);
							  $last_val = $last_date['next'];	
							  $expectedDate = end($last_val);
							  
							  $param['guidemesenderType'] = 1;
							  $param['currentAdvisorId'] = $userID;
							  $param['subject'] = $subject;
							  $param['message'] = $message;
							  $param['fldRecipientType'] = $fldRecipientType;	
							  $param['expectedReplyDate'] = $expectedDate;		
							  
							  $messageId  = UmailMessage::insertUmailMessage($param,$headerID,$fldRecipientId);
							
							  $param['currentAdvisorId'] = $fldRecipientId;
							  $param['senderId'] = $userID;
							  $param['logStatus'] = 'New';
							  $param['senderType'] = '1';							  
							  
							   UmailLog::insertUmailLog($headerID,$messageId ,$param);
							  
							   $params['fromaddr'] = $fromaddr;
							   $params['gmailUniqueId'] = $email_number;
							   $params['headerId'] = $headerID;
							   $params['date'] = $date;	
							   UmailGuidememailDetail::insertUmailGuidemeDetails($params);
							  
							        // Reading Attachments // 	
							   $attachments = UmailHeader::extract_attachments($inbox, $email_number);	
							   $dbdocName = "";
	
							   for($i = 0; $i < count($attachments); $i++)
							   {
								 if($attachments[$i]['is_attachment'] == 1)
								 {									
	
									$mypath = "/home/univarie/public_html/demo/uploads/umail_attahment/";
	
									$fldUserDocIDName = uniqid("U_");	
									$dbdocName = $fldUserDocIDName.".".$attachments[$i]['filename'];	
									$docName=$mypath.$fldUserDocIDName.".".$attachments[$i]['filename'];	
								    $fp=fopen($docName,'w+');		
									fwrite($fp,$attachments[$i]['attachment']);		
									fclose($fp);									
									$param['messageId'] = $messageId; 
									$param['fileName'] = $dbdocName;
									$param['originalFileName'] = $attachments[$i]['filename'];
									UmailAttachment::insertGuidemeUmailAttachment($param);						
											
								  }
							    }	
					         }
							 else
					         {
								$params['fromaddr'] = $fromaddr;
							    $params['gmailUniqueId'] = $email_number;
							    $params['headerId'] = '';
							    $params['date'] = $date;
							    UmailGuidememailDetail::insertUmailGuidemeDetails($params);
									
                                $params['subject'] = $subject;
                                $params['message'] = $message;;

							    $exceptionalMessagelastID = UmailExceptions::insertUmailExceptions($params);

								$exceptional_attachments  = UmailHeader::extract_attachments($inbox, $email_number);

								 for($i = 0; $i < count($exceptional_attachments); $i++)
								  {
									if($exceptional_attachments[$i]['is_attachment'] == 1)
									{

									      $mypath = "/home/univarit/public_html/uploads/umail_attahment/";		

										  $fldUserDocIDName = uniqid("U_");
                                          $path_info = pathinfo($exceptional_attachments[$i]['filename']);

										  $dbdocName = $fldUserDocIDName.".".$path_info['extension'];

										  $docName=$mypath.$fldUserDocIDName.".".$exceptional_attachments[$i]['filename'];
										  $fp=fopen($docName,'w+');

										  fwrite($fp,$exceptional_attachments[$i]['attachment']);	

										  fclose($fp);
										  
										  $params['exceptionId'] = $exceptionalMessagelastID;
		                                  $params['attachmentName'] = $dbdocName;
                                          $params['originalattachmentName'] = $exceptional_attachments[$i]['filename'];
										
										  UmailExceptionAttachment::insertGuidemeUmailExceptionsAttachment($params);
										}
								       }			

							       }	/*** end of umail exceptions ***/						
					           }   /*** end of reading guideme detail  ***/		
					       }   // end of valid email. 
				      } // end of reading each email
			      } // end of emails exists
			  
		} // end of function
		
		
 public static function get_mime_type(&$structure)
{

		 $primary_mime_type = array("TEXT", "MULTIPART","MESSAGE", "APPLICATION", "AUDIO","IMAGE", "VIDEO", "OTHER");
		 if($structure->subtype) 
		 {
			return $primary_mime_type[(int) $structure->type] . '/' .$structure->subtype;
		 }
		  return "TEXT/PLAIN";
	  }

	 public static  function get_part($stream, $msg_number, $mime_type, $structure = false,$part_number= false)
	  {	   

		if(!$structure)
		{
		   $structure = imap_fetchstructure($stream, $msg_number);
		}

 	  	if($structure)
		{
   		  if($mime_type == UmailHeader::get_mime_type($structure))
		  {
   			if(!$part_number) 
			{
   				$part_number = "1";
   			}

   			$text = imap_fetchbody($stream, $msg_number, $part_number);

   			if($structure->encoding == 3)
			{
   			   return imap_base64($text);
   			} 
			else if($structure->encoding == 4)
			{
   			   return imap_qprint($text);
   			}
			else
			{
   			   return $text;
   		    }
          }

		 if(!empty($structure->type) && ($structure->type == 1)) /* multipart */ 
		 {

			$prefix = ""; 
   		    while(list($index, $sub_structure) = each($structure->parts))
			{
   			  if($part_number)
			  {
   				$prefix = $part_number . '.';
   			  }

   			  $data = UmailHeader::get_part($stream, $msg_number, $mime_type, $sub_structure,$prefix.($index + 1));

   			  if($data)
			  {
   				return $data;
   			  }
   		     } // END OF WHILE
   		   } // END OF MULTIPART
   	    } // END OF STRUTURE
   	  return false;
   } // END OF FUNCTION
   
   
   public static function extract_attachments($connection, $message_number) 
   {

	  $attachments = array();
	  $structure = imap_fetchstructure($connection, $message_number); 

	  if(isset($structure->parts) && count($structure->parts))
	  {
	    for($i = 0; $i < count($structure->parts); $i++)
		{
	      $attachments[$i] = array(
	                'is_attachment' => false,
	                'filename' => '',
	                'name' => '',
	                'attachment' => ''
	            );
	     if($structure->parts[$i]->ifdparameters)
	     {
           foreach($structure->parts[$i]->dparameters as $object)
		   {
	         if(strtolower($object->attribute) == 'filename')
			 {
               $attachments[$i]['is_attachment'] = true;
	           $attachments[$i]['filename'] = $object->value;
	          }
	         }
	       }

	       if($structure->parts[$i]->ifparameters)
		   {
	         foreach($structure->parts[$i]->parameters as $object)
		     {
	           if(strtolower($object->attribute) == 'name') 
			   {
	              $attachments[$i]['is_attachment'] = true;
	              $attachments[$i]['name'] = $object->value;
	            }
	          }
	        }           

	       if($attachments[$i]['is_attachment']) 
		   {
	         $attachments[$i]['attachment'] = imap_fetchbody($connection, $message_number, $i+1);

	           if($structure->parts[$i]->encoding == 3)
			   { // 3 = BASE64
	            $attachments[$i]['attachment'] = base64_decode($attachments[$i]['attachment']);
	           }
	           else if($structure->parts[$i]->encoding == 4)
			   { // 4 = QUOTED-PRINTABLE

	            $attachments[$i]['attachment'] = quoted_printable_decode($attachments[$i]['attachment']);
	           }
		     }
	      }
	    }
	    return $attachments;

	 }
         
    public static function getUserumailQueries($userId,$limit=false)
    {
        $umailSql = "SELECT DISTINCT um.message_id, um.header_ref_id, um.message,um.subject, uh.sender_id, uh.added_on
        FROM umail_header uh
        LEFT JOIN umail_message um ON uh.header_id = um.header_ref_id
        LEFT JOIN query_type qt ON qt.type_id = uh.querytype_id
        WHERE uh.sender_id = ".$userId."  AND um.sender_type=1 AND um.sender_id = ".$userId." ORDER BY uh.added_on DESC";
        if(!empty($limit))
        {
            $umailSql.= " LIMIT $limit";
        }
        $command =Yii::app()->db->createCommand($umailSql);
        $res = $command->queryAll();
        return $res;
    }

    public static function getUserumailCount($userId)
    {
        $umailSql = "SELECT CONCAT(UM.first_name,' ',UM.last_name) AS NAME,COUNT(DISTINCT(UME.message_id)) AS umail_count
            FROM umail_message UME
            JOIN umail_header UH ON UH.header_id = UME.header_ref_id
            JOIN tbl_user_master UM ON (UM.user_id = UME.sender_id)
            WHERE UME.sender_type = 1 AND UME.sender_id = ".$userId." ";

        $command =Yii::app()->db->createCommand($umailSql);
        $res = $command->queryAll();
        return $res;
    }
}