<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblState');

class TblState extends BaseTblState {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, country_ref_id, added_on', 'required'),
            array('country_ref_id', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 25),
            array('state_code', 'length', 'max' => 3),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, name, country_ref_id, state_code, added_on', 'safe', 'on' => 'search'),
        );
    }

    public function getStateByCountry($countryId) {
        $criteria = New CDbCriteria;
        $criteria->select = 'id,name';
        $criteria->condition = 'country_ref_id=:id';
        $criteria->params = array(':id' => $countryId);
        $criteria->order = 'name';
        $data = self::model()->findAll($criteria);
        if ($data) {
            foreach ($data as $value) {
                $stateList[$value->attributes['id']] = $value->attributes['name'];
            }
        } else {
            $stateList = null;
        }
        return $stateList;
    }


    public static function getStateListOfIndiaOfEast($countryId){

        $value=array();
        $sql=' SELECT DISTINCT ts.id,ts.name,lr.region_name FROM tbl_state ts
                INNER JOIN tbl_university_master tum
                ON tum.state_ref_id = ts.id
                JOIN lookup_region lr
                ON ts.region_ref_id=lr.region_id
                WHERE ts.country_ref_id='.$countryId.' AND tum.is_active = "Y" AND ts.region_ref_id=1
                ORDER BY NAME';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        if(count($data)>1)
        {
            $stateList=array();
            foreach($data as $value)
            {
                $stateList[$value['id']] = $value['name'];

            }

        }

        else{
            $stateList=array();
        }
        return $stateList;
    }
    public static function getStateListOfIndiaOfNorth($countryId){

        $value=array();
        $sql='
             SELECT DISTINCT ts.id,ts.name,lr.region_name FROM tbl_state ts
                INNER JOIN tbl_university_master tum
                ON tum.state_ref_id = ts.id
                JOIN lookup_region lr
                ON ts.region_ref_id=lr.region_id
                WHERE ts.country_ref_id='.$countryId.' AND tum.is_active = "Y" AND ts.region_ref_id=2
                ORDER BY NAME';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        if(count($data)>0)
        {
            $stateList=array();
            foreach($data as $value)
            {
                $stateList[$value['id']] = $value['name'];

            }

        }


        else{
            $stateList=array();
        }
        return $stateList;
    }
    public static function getStateListOfIndiaOfNortheast($countryId){

        $value=array();
        $sql='  SELECT DISTINCT ts.id,ts.name,lr.region_name FROM tbl_state ts
                INNER JOIN tbl_university_master tum
                ON tum.state_ref_id = ts.id
                JOIN lookup_region lr
                ON ts.region_ref_id=lr.region_id
                WHERE ts.country_ref_id='.$countryId.' AND tum.is_active = "Y" AND ts.region_ref_id=3
                ORDER BY NAME';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        if(count($data)>1)
        {
            $stateList=array();
            foreach($data as $value)
            {
                $stateList[$value['id']] = $value['name'];

            }

        }

        else{
            $stateList=array();
        }
        return $stateList;
    }
    public static function getStateListOfIndiaOfSouth($countryId){

        $value=array();
        $sql='  SELECT DISTINCT ts.id,ts.name,lr.region_name FROM tbl_state ts
                INNER JOIN tbl_university_master tum
                ON tum.state_ref_id = ts.id
                JOIN lookup_region lr
                ON ts.region_ref_id=lr.region_id
                WHERE ts.country_ref_id='.$countryId.' AND tum.is_active = "Y" AND ts.region_ref_id=4
                ORDER BY NAME';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        if(count($data)>1)
        {
            $stateList=array();
            foreach($data as $value)
            {
                $stateList[$value['id']] = $value['name'];

            }

        }


        else{
            $stateList=array();
        }
        return $stateList;
    }



    public static function getStateListOfIndiaOfWest($countryId){

        $value=array();
        $sql=' SELECT DISTINCT ts.id,ts.name,lr.region_name FROM tbl_state ts
                INNER JOIN tbl_university_master tum
                ON tum.state_ref_id = ts.id
                JOIN lookup_region lr
                ON ts.region_ref_id=lr.region_id
                WHERE ts.country_ref_id='.$countryId.' AND tum.is_active = "Y" AND ts.region_ref_id=5
                ORDER BY NAME';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        if(count($data)>1)
        {
            $stateList=array();
            foreach($data as $value)
            {
                $stateList[$value['id']] = $value['name'];
                //$cityList['city_id']= $value['city_name'];
            }

        }


        else{
            $stateList=array();
        }
        return $stateList;
    }




    public static function getStateListByCountry($searchTerm, $countryId) {
        $criteria = new CDbCriteria;
        if ($countryId > 0) {
            $criteria->compare('country_ref_id', $countryId);
        }
        $criteria->compare('name', $searchTerm, true);
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), name";
        $criteria->limit = 15;
        return self::model()->findAll($criteria);
    }

    public static function getStateName($stateId) {
        $criteria = new CDbCriteria;
        $criteria->compare('id', $stateId);
        $res = self::model()->find($criteria);
        return $res->name;
    }

    
}