<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblSiDi');

class TblSiDi extends BaseTblSiDi
{
	
	public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  public static function GetSiList()
  {
    $result = parent::model()->findAllBySql("select distinct t.inst_id,t.inst_name from tbl_si_di t , workshop_si w where t.inst_id=w.si_ref_id order by t.inst_name asc");
	
	if($result)
	{
	  return $result;
	}
	else
	{
	  return false;	
	}
  }
  
   public static function GetSchoolLookupId($instId = false)
  {
    $result = self::model()->find('inst_id=:Instid', array(':Instid' => $instId));
	
	if($result)
	{
	  return $result;
	}
	else
	{
	  return false;	
	}
  }

  public static function GetInstIdFromSchoolId($schoolId) {
        $result = self::model()->find('school_ref_id=:sId', array(':sId' => $schoolId));
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }
	/*
	 * Returns logged in Institute Id
	 */
	 // !todo: Need to bring actual instId
	 
	public static function getInstId(){
		  $instId = Yii::app()->request->getQuery('uid');
		  if(!isset($instId)){
			//echo $instId = CommonUtils::getSessionValue('sPartnersSlug', 'instituteID');			
			//$instId = (isset(Yii::app()->user) && isset(Yii::app()->user->sub_id)) ? Yii::app()->user->sub_id : '';
			  $loginId = (isset(Yii::app()->user) && isset(Yii::app()->user->id)) ? Yii::app()->user->id : '';
			  $results = self::getInstituteDetails($loginId);
			  $instId  =  $results['inst_id'];
		  }
	 return $instId;
	}
	
	public static function getSchoolName(){
		$schoolNameModel = self::model()->findByPk(self::getInstId());
		
	 return (isset($schoolNameModel->inst_name)) ? $schoolNameModel->inst_name : '';
	}
	
	public static function formatArrayData($arr2 = array(),$multi=true) {
	if($multi) {
	$arr = array ();
		foreach($arr2 as $key=>$a) {
		$keys = array_keys($a);
		$current_key = $a[$keys[0]];
		$current_val = $a[$keys[1]];
		$arr[$current_key] = $current_val;
		}
		
	} else {
	$arr = $arr2;
	}
	 
	$keys = array_keys($arr); 
				$new = '[';
				foreach($arr as $key=>$a) {
					$tmp = '["'.$key.'",';
					
				  if(count($arr)-1 === array_search($key, $keys)){
					 $tmp .= (is_numeric($a)) ?  $a.']' :  '"'.$a.'"]'  ;
					} else {
					 $tmp .= (is_numeric($a)) ?  $a.'],' :  '"'.$a.'"], '  ;
 					} 
 					$new .= $tmp;
				}
				$new .= "]";
		return $new; 
	}
	
	public static function getBoardwiseInfo(){
	$instId = TblSiDi::getInstId();
	$query = "SELECT COUNT(*) registered, um.present_class, lb.board_name FROM tbl_si_students tss 
	LEFT JOIN tbl_user_master um ON (tss.user_ref_id = um.user_id)	
	LEFT JOIN lookup_board lb ON (um.present_board_ref_id = lb.board_id)
	WHERE tss.inst_ref_id = ".$instId."
	AND um.present_board_ref_id IN (
	SELECT board_id FROM lookup_board 
	JOIN tbl_si_board WHERE board_ref_id = board_id AND si_ref_id = ".$instId."
	)
	AND um.present_class !=''
	GROUP BY present_class, present_board_ref_id";
	/*$query = "SELECT present_class,board_name,COUNT(*) registered
			FROM tbl_user_master um 
			JOIN tbl_si_students tss ON tss.user_ref_id = um.user_id
			JOIN lookup_board lb ON lb.board_id = um.present_board_ref_id
			WHERE inst_ref_id = '".$instId."'			
			GROUP BY present_class,present_board_ref_id";*/
	
if($instId) {
	$cmd = Yii::app()->db->createCommand($query)->queryAll();
	} else {
	$cmd = array();
	}
	$html = '';
	foreach($cmd as $row) {
		 
	    $html .= '<tr>
			<td>'.$row['present_class'].'</td>
			<td>'.$row['board_name'].'</td>
			<td>'.$row['registered'].'</td>
			</tr>';

	 } 
	 return $html;
	}
	public static function getCountryPreferenceChartData($class = NULL){
	$class_condition = "";
	if($class) { $class_condition = "AND um.present_class = '".$class."'"; }
	$instId = TblSiDi::getInstId();
	$query = "SELECT  lfa.`display_label`,
 (SELECT COUNT(*) FROM `workshop_si_group_student_feedback_answer` wsgsfa1
 WHERE wsgsfa1.`feedback_answer_ref_id` = wsgsfa.`feedback_answer_ref_id`
 ) /
 (SELECT COUNT(*) FROM tbl_si_students WHERE inst_ref_id = ws.si_ref_id) * 100  AS answercount
FROM `lookup_feedback_answer` lfa
LEFT JOIN `workshop_si_group_student_feedback_answer` wsgsfa ON lfa.`feedback_answer_id` = wsgsfa.`feedback_answer_ref_id`
LEFT JOIN `workshop_si_group_student_feedback` wsgsf ON wsgsf.`workshop_si_group_student_feedback_id` = wsgsfa.`workshop_si_group_student_feedback_ref_id`
LEFT JOIN `workshop_si_group_student` wsgs ON wsgs.`workshop_si_group_student_id` = wsgsf.`workshop_si_group_student_ref_id`
LEFT JOIN `workshop_si_group` wsg ON wsg.`workshop_si_group_id` = wsgs.`workshop_si_group_ref_id`
LEFT JOIN `workshop_si` ws ON ws.`workshop_si_id` = wsg.`workshop_si_ref_id`
LEFT JOIN tbl_user_master um ON um.user_id = wsgs.`user_ref_id`
WHERE ws.`si_ref_id` = ".$instId."
AND wsgsfa.`feedback_question_ref_id` = 6
".$class_condition."
GROUP BY lfa.`feedback_answer_id`;";
if($instId) {
	$results = Yii::app()->db->createCommand($query)->queryAll();
	} else {
	$results = array();
	}
	if(count($results) > 0) { $final = array('1'=>'Students'); } else {  $final = array ( "1" => "Students", "WithinIndia" => 0, "OutsideIndia" => 0, "OpenToBoth" => 0);  }
	foreach($results as $key=>$r){
	(isset($r['display_label']) &&  $r['display_label'] == 'Within India') ? $final['WithinIndia'] = $r['answercount'] : '';
	(isset($r['display_label']) &&  $r['display_label'] == 'Open to both') ? $final['OpenToBoth'] = $r['answercount'] : '';
	(isset($r['display_label']) &&  $r['display_label'] == 'Outside India') ? $final['OutsideIndia'] = $r['answercount'] : '';
	}
	return self::formatArrayData($final,false);
	}
	
	public static function getPieChartData($class = NULL){
	$instId = TblSiDi::getInstId();
	$class_condition = "";
	if($class) { $class_condition = " AND um.present_class = '".$class."'"; }
		$queryPie = 'SELECT ld.department_name,
	COUNT(*) AS "Count"
	FROM `student_preferred_department` spd
	JOIN lookup_department ld ON ld.department_id = spd.`main_dept_ref_id`
	JOIN tbl_si_students si ON si.user_ref_id = spd.user_ref_id
	JOIN tbl_user_master um ON si.user_ref_id = um.user_id
	WHERE si.inst_ref_id = '.$instId.$class_condition.'
	GROUP BY spd.`main_dept_ref_id`;';
	if($instId){
	$row = Yii::app()->db->createCommand($queryPie);
	$result = $row->queryAll();
	} else {
		$result = NULL;
		}
	if(count($result) > 0) {
	return TblSiDi::formatArrayData($result);
	} else {
	$result = array ( "0" => array ( "department_name" => "Art & Design", "Count" => 0 ), "1" => array ( "department_name" => "Architecture", "Count" => 0 ), "2" => array ( "department_name" => "Science", "Count" => 0 ), "3" => array ( "department_name" => "Business Management", "Count" => 0 ), "4" => array ( "department_name" => "Computer Science & Information Technology", "Count" => 0 ), "5" => array ( "department_name" => "Education & Teaching", "Count" => 0 ), "6" => array ( "department_name" => "Engineering & Technology", "Count" => 0 ), "7" => array ( "department_name" => "Healthcare", "Count" => 0 ), "8" => array ( "department_name" => "Humanities", "Count" => 0 ), "9" => array ( "department_name" => "Journalism, Media ,PR & Communication", "Count" => 0 ), "10" => array ( "department_name" => "Law", "Count" => 0 ), "11" => array ( "department_name" => "Medicine", "Count" => 0 ), "12" => array ( "department_name" => "MBA", "Count" => 0 ) );
	return TblSiDi::formatArrayData($result);
	}
	}
	
	public static function dataQuery1()
	{
		$inst_ref_id = self::getInstId();
		$umail_query3 = "SELECT COUNT(*) as low
		FROM (
		SELECT um1.message_id,um1.header_ref_id,inst_ref_id
		,um1.`expected_reply_date` AS Expected_Date
		,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1) AS 'ReplyDate'
		,ROUND(TIME_TO_SEC(TIMEDIFF(um1.`expected_reply_date`,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1)))/60)/60 AS 'difference' 
		FROM umail_header uh 
		LEFT JOIN umail_message um1 ON um1.header_ref_id = uh.header_id AND um1.sender_type = 1 
		LEFT JOIN tbl_user_master us ON us.user_id = um1.sender_id
		LEFT JOIN tbl_si_students si ON si.user_ref_id = us.user_id
		WHERE si.inst_ref_id = ".$inst_ref_id."
		ORDER BY 6
		) AS tbl
		WHERE tbl.difference BETWEEN 0 AND 24;";
		if($inst_ref_id){
		$cmd7 = Yii::app()->db->createCommand($umail_query3);
		$row7 = $cmd7->queryRow();
		return $row7['low'];
		} else {
		return false;
		}
	}
	public static function dataQuery2(){
		$inst_ref_id = self::getInstId();
		$umail_query2 = "SELECT COUNT(*) as medium
		FROM (
		SELECT um1.message_id,um1.header_ref_id,inst_ref_id
		,um1.`expected_reply_date` AS Expected_Date
		,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1) AS 'ReplyDate'
		,ROUND(TIME_TO_SEC(TIMEDIFF(um1.`expected_reply_date`,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1)))/60)/60 AS 'difference' 
		FROM umail_header uh 
		LEFT JOIN umail_message um1 ON um1.header_ref_id = uh.header_id AND um1.sender_type = 1 
		LEFT JOIN tbl_user_master us ON us.user_id = um1.sender_id
		LEFT JOIN tbl_si_students si ON si.user_ref_id = us.user_id
		WHERE si.inst_ref_id = ".$inst_ref_id."
		ORDER BY 6
		) AS tbl
		WHERE tbl.difference > 24 and tbl.difference <= 48;";
		if($inst_ref_id){
		$cmd6 = Yii::app()->db->createCommand($umail_query2);
		$row6 = $cmd6->queryRow();
		return $row6['medium'];
		} else {                
		return false;
		}
	}
	public static function dataQuery3(){
		$inst_ref_id = self::getInstId();
		$umail_query1 = "SELECT COUNT(*) as high
		FROM (
		SELECT um1.message_id,um1.header_ref_id,inst_ref_id
		,um1.`expected_reply_date` AS Expected_Date
		,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1) AS 'ReplyDate'
		,ROUND(TIME_TO_SEC(TIMEDIFF(um1.`expected_reply_date`,(SELECT um2.`added_on` FROM umail_message um2 WHERE um2.header_ref_id = uh.header_id AND um2.sender_type = 2  AND um2.message_id > um1.message_id ORDER BY um1.message_id LIMIT 1)))/60)/60 AS 'difference' 
		FROM umail_header uh 
		LEFT JOIN umail_message um1 ON um1.header_ref_id = uh.header_id AND um1.sender_type = 1 
		LEFT JOIN tbl_user_master us ON us.user_id = um1.sender_id
		LEFT JOIN tbl_si_students si ON si.user_ref_id = us.user_id
		WHERE si.inst_ref_id = ".$inst_ref_id."
		ORDER BY 6
		) AS tbl
		WHERE tbl.difference > 48 
		OR tbl.difference < 0;";
		if($inst_ref_id){
		$cmd5 = Yii::app()->db->createCommand($umail_query1);
		$row5 = $cmd5->queryRow();
		return $row5['high'];
		} else {
		return false;
		}
	}
	public static function dataQuery4(){
		$inst_ref_id = self::getInstId();
		$query4 = 'SELECT COUNT(*) as "registerStudents" FROM tbl_user_master 
		JOIN tbl_si_students ON (user_ref_id = user_id)
		WHERE inst_ref_id = "'.$inst_ref_id.'"';
		if($inst_ref_id){
		$cmd4 = Yii::app()->db->createCommand($query4);
		$row4 = $cmd4->queryRow();
		return $row4['registerStudents'];	
		} else {
		return false;
		}
	}
	
	public static function dataQuery5(){
		$inst_ref_id = self::getInstId();
		$query3 = 'SELECT COUNT(*) "unansweredMails"
		FROM umail_message umsg 
		LEFT JOIN umail_header uh ON uh.header_id = umsg.header_ref_id
		LEFT JOIN tbl_user_master um ON (umsg.sender_id=um.user_id)
		LEFT JOIN login_master lm ON lm.login_id=um.login_ref_id
		WHERE umsg.sender_type = 1 
		AND umsg.sender_id IN (
		SELECT user_ref_id FROM tbl_si_students WHERE inst_ref_id = '.$inst_ref_id.' AND uh.status  not IN (\'Replied\',\'Read\')
		)';
		if($inst_ref_id){
		$cmd3 = Yii::app()->db->createCommand($query3);
		$row3 = $cmd3->queryRow();
		return $row3['unansweredMails'];
		} else {
		return false;
		}
	}
	public static function dataQuery6(){
		$inst_ref_id = self::getInstId();
		$query2 = 'SELECT COUNT(*) "answeredMails"
		FROM umail_message umsg 
		LEFT JOIN umail_header uh ON uh.header_id = umsg.header_ref_id
		LEFT JOIN tbl_user_master um ON (umsg.sender_id=um.user_id)
		LEFT JOIN login_master lm ON lm.login_id=um.login_ref_id
		WHERE umsg.sender_type = 1 
		AND umsg.sender_id IN (
		SELECT user_ref_id FROM tbl_si_students WHERE inst_ref_id = '.$inst_ref_id.' AND uh.status  IN (\'Replied\',\'Read\')
		)';
		if($inst_ref_id){
		$cmd2 = Yii::app()->db->createCommand($query2);
		$row2 = $cmd2->queryRow();
		return $row2['answeredMails'];
		} else {
		return false;
		}
	}
	public static function dataQuery7(){
		$inst_ref_id = self::getInstId();
		$query1 = 'SELECT COUNT(*) "totalMails"
		FROM umail_message umsg 
		LEFT JOIN umail_header uh ON uh.header_id = umsg.header_ref_id
		LEFT JOIN tbl_user_master um ON (umsg.sender_id=um.user_id)
		LEFT JOIN login_master lm ON lm.login_id=um.login_ref_id
		WHERE umsg.sender_type = 1 
		AND umsg.sender_id IN (
		SELECT user_ref_id FROM tbl_si_students WHERE inst_ref_id = '.$inst_ref_id.'
		)';
		if($inst_ref_id){
		$cmd = Yii::app()->db->createCommand($query1);
		$row = $cmd->queryRow();
		return $row['totalMails'];
		} else {
		return false;
		}
	}
	
		
	 public  function getSchoolUserMilestone($instRefId = false)
    {
	 $sql = "SELECT milestone_id,COUNT(*) as mileStoneCount 
					FROM (
					SELECT um.user_ref_id,      
					  CASE
						   WHEN ( milestone_id = 61 OR milestone_id = 62 OR milestone_id = 63) THEN 5
						   ELSE milestone_id
						   END AS milestone_id
					FROM tbl_si_di si
					JOIN tbl_si_students tss ON tss.inst_ref_id = si.inst_id
					JOIN user_milestone um ON um.user_ref_id = tss.user_ref_id
					WHERE inst_id ='".$instRefId."'
					AND um.status = 'Confirmed'
					) AS tbl
					GROUP BY `milestone_id";	 
		
	  $cmd = Yii::app()->db->createCommand($sql);	   
	  $res = $cmd->queryAll();	  
	  return $res;
  }

  public  function getPrincipalName($instRefId = false)
    {
	 $sql = "select admin_full_name from tbl_admin where login_ref_id = $instRefId";

	  $cmd = Yii::app()->db->createCommand($sql);
	  $res = $cmd->queryRow();
	  return $res;
  }
  
   public  function getInstituteDetails($loginRefId = false)
    {
	   $instituteDetails = self::model()->find('login_ref_id=:loginRefId', array(':loginRefId' => $loginRefId));
  	
		if($instituteDetails)
		{
		  return $instituteDetails;
		}
		else
		{
		  return false;	
		}	
  }
   public  function getAutoEscalateInstituteDetails()
    {
                $criteria=new CDbCriteria;					
				$criteria->condition = "t.auto_escalate_flag = 'Y' AND auto_escalate_interval!=0 ";
				//$criteria->compare('auto_escalate_flag',Y,true);
				$modelTblSis = TblSiDi::model()->findAll($criteria);		
				return $modelTblSis;
    }
    
    public static function updateInstStatus($instId,$status){
        if($instId){
            self::model()->updateByPk($instId,array("is_active"=>$status));
        }
    }

    public static function isCssSchool($subDomain=''){
        $sql = "SELECT inst_id FROM tbl_si_di WHERE subdomain_slug_name = :subDomain AND css_access = 1 AND is_active = 'Y'";
        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindValue(":subDomain", $subDomain, PDO::PARAM_STR);
        $res = $cmd->queryRow();
        return $res['inst_id'];
    }
    
    public static function getAllSchoolList(){
        $criteria = new CDbCriteria;
        $criteria->select = 'inst_id, inst_name';
        $criteria->order = 'inst_name';
        return self::model()->findAll($criteria);
    }

    public static function getSchoolList(){
        $sql="SELECT inst_id, inst_name FROM tbl_si_di WHERE inst_name NOT IN('autoescalate') ORDER BY inst_name ASC";
        $cmd=Yii::app()->db->createCommand($sql);
        $result=$cmd->queryAll();
        $school=Array();

        foreach($result as $row){
            $school[$row['inst_id']] = $row['inst_name'];
        }
        return $school;
    }

    public static function getSubdomainSlugName($userId){
        $sql="SELECT tsd.subdomain_slug_name FROM tbl_si_di tsd
              INNER JOIN tbl_si_students tss ON tss.inst_ref_id = tsd.inst_id
              WHERE user_ref_id=".$userId;
        $cmd=Yii::app()->db->createCommand($sql);
        $result=$cmd->queryRow();
        return $result;
    }

    public static function getInstDetails($instId){
        $sql="SELECT inst_id,inst_name,city_name,country_name FROM tbl_si_di sd
              LEFT JOIN tbl_city_master cm ON cm.city_id = sd.city_ref_id
              LEFT JOIN tbl_country_master tc ON tc.country_id = sd.inst_country
              WHERE inst_id=".$instId;
        $cmd=Yii::app()->db->createCommand($sql);
        $result=$cmd->queryRow();
        return $result;
    }

    public static function getPopularSchoolsList($limit = false, $offset = false){
        $sql = "SELECT tsd.inst_id,tsd.inst_name, tcm.city_name, ts.name, cm.country_name, tsd.inst_logo, COUNT(*)AS cnt
        FROM tbl_si_students tss
        LEFT JOIN tbl_si_di tsd ON tsd.inst_id = tss.inst_ref_id
        LEFT JOIN tbl_user_master um ON um.user_id = tss.user_ref_id
        LEFT JOIN `tbl_city_master` tcm ON tcm.city_id = tsd.city_ref_id
        LEFT JOIN `tbl_state` ts ON ts.id = tcm.state_ref_id
        LEFT JOIN `tbl_country_master` cm ON cm.country_id = tcm.country_id
        WHERE 1=1
        AND is_popular = 'Y'
        AND um.is_test = 'N'
        AND tsd.is_test = 'N'
        AND tsd.is_active ='Y'
        GROUP BY inst_id
        ORDER BY cnt DESC ";
        if($limit){
            $sql.= "LIMIT ".$limit." ";
        }
        if($offset){
            $sql.= "OFFSET ".$offset." ";
        }
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;
    }

    public static function getInstIdFromSchoolCode($schoolCode) {
        $result = self::model()->find('school_code=:school_code', array(':school_code' => $schoolCode));
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }
}
