<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredPeriod');

class StudentPreferredPeriod extends BaseStudentPreferredPeriod
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
  
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'periodRef' => array(self::BELONGS_TO, 'LookupLikelyPeriod', 'period_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'fromMonth' => array(self::BELONGS_TO, 'LookupLikelyPeriod', 'from_month'),
			'toMonth' => array(self::BELONGS_TO, 'LookupLikelyPeriod', 'to_month'),
		);
	} 
	
	
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'period_ref_id, from_month, to_month, year' => 'prospective_sessions',
        );
    }
        
    public function getStudentPreferredPeriods($userId=0){
        $result = self::model()
            ->with(array("fromMonth" => array("JOINTYPE" => "left outer join",)))
            ->findAll(array("condition" => "`user_ref_id` = " . $userId));
        return $result;
    }

    public function studentPreferredPeriods($userId){
        $result = self::model()
            ->with(array("fromMonth" => array("JOINTYPE" => "left outer join",)))
            ->findAll(array("condition" => "user_ref_id = " . $userId, 'order'=> ' year ASC, period_ref_id ASC '));
        return $result;
    }

    public static function addStudentPreferences($preferences=array()){
        $model = new StudentPreferredPeriod();
        $model->setAttributes($preferences);
        $model->save(false);
    }
    
    public function deletePreferredPeriodByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertPreferredPeriodByUserId($userId, $session, $year) {
        $criteria = new CDbCriteria;
        $criteria->condition = "period_id = '" . $session . "'";
        $likelyVal = LookupLikelyPeriod::model()->find($criteria);

        $obj = new StudentPreferredPeriod();
        $obj->{user_ref_id} = $userId;
        $obj->{period_ref_id} = $session;
        $obj->{from_month} = $likelyVal['from_month'];
        $obj->{to_month} = $likelyVal['to_month'];
        $obj->{year} = $year;
        $obj->save();
    }
	
	
    public function getuserPreferredPeriods($userId=0){
        
        $criteria = new CDbCriteria;
        $criteria->select = 'period_ref_id,year';
        $criteria->with = 'periodRef';
        $criteria->addCondition("user_ref_id = '".$userId."'");
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
}