<?php

/**
 * Model class for StudentOutplacementSubdepartment
 *
 *
 * @author Shiva <shiva.dharana@univariety.com>
 * @version 1.0
 * @package application.models
 *
 */

Yii::import('application.models.base.BaseStudentOutplacementUniversity');


/**
 * @author shiva.dharana@univariety.com
 * @package application.models
 *
 * BaseStudentOutplacementUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "student_outplacement_university".
 *
 * The followings are the available columns in table 'student_outplacement_university':
 * @property string $student_outplacement_university_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property string $course_ref_id
 * @property string $uni_name
 * @property string $course_name
 * @property string $uni_type
 * @property string $fees
 * @property integer $fees_currency_ref_id
 * @property string $loan_amount
 * @property integer $loan_currency_ref_id
 * @property string $loan_source
 * @property string $bank_name
 * @property string $added_on
 * @property string $added_by
 * @property string $list_type
 * @property string $has_loan
 * @property string $has_scholarship
 *
 * The followings are the available model relations:
 * @property TblUserMaster $student
 * @property TblUniversityMaster $university
 * @property TblUniCourses $course
 * @property LookupCurrency $feesCurrencyRef
 * @property LookupCurrency $loanCurrencyRef
 * @property StudentOutplacementUniversityScholarship $scholarships
 */
class StudentOutplacementUniversity extends BaseStudentOutplacementUniversity{

    const TYPE_APPLIED = 'Applied';
    const TYPE_RECEIVED_ADMISSION = 'ReceiveAdmission';
    const TYPE_JOINED = 'Joined';

    const LOAN_TYPE_BANK = 'Bank';
    const LOAN_TYPE_PERSONAL = 'Personal';

    static $loanTypes = array(
    self::LOAN_TYPE_BANK => self::LOAN_TYPE_BANK,
    self::LOAN_TYPE_PERSONAL => self::LOAN_TYPE_PERSONAL
    );


    public static function model($className=__CLASS__){
        return parent::model($className);
    }

    public static function getLoanTypes(){
        return self::$loanTypes;
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'student' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'university' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'course' => array(self::BELONGS_TO, 'TblUniCourses', 'course_ref_id'),
			'feesCurrency' => array(self::BELONGS_TO, 'LookupCurrency', 'fees_currency_ref_id'),
			'loanCurrency' => array(self::BELONGS_TO, 'LookupCurrency', 'loan_currency_ref_id'),
            'scholarships' => array(self::HAS_MANY, 'StudentOutplacementUniversityScholarship', 'student_outplacement_university_ref_id'),
        	'scholarshipsCount' => array(self::STAT, 'StudentOutplacementUniversityScholarship', 'student_outplacement_university_ref_id'),
        );
        
    }

    protected function beforeSave(){
        if(parent::beforeSave()){
            $this->added_on = date('Y-m-d H:i:s');
            return true;
        }
        return false;
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules(){
        return array(
            array('user_ref_id', 'required'),
            array('uni_ref_id, fees_currency_ref_id, loan_currency_ref_id, loan_amount, fees, has_loan, has_scholarship', 'numerical', 'integerOnly' => true, 'message' => 'Please enter a numeric value for {attribute}'),
            array('uni_name, course_name, bank_name, list_type', 'length', 'max'=>255),
            
            //Rules for add-joined scenario
            array('user_ref_id, fees_currency_ref_id, fees, uni_type', 'required', 'on' => 'add-joined'),
            array('loan_currency_ref_id, loan_source, loan_amount, bank_name', 'validateLoan', 'on' => 'add-joined'),
            array('uni_ref_id, uni_name', 'validateUniversity', 'on' => 'add-joined'),
            
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('student_outplacement_university_id, user_ref_id, uni_ref_id, course_ref_id, uni_name, course_name, uni_type, fees, fees_currency_ref_id, loan_amount, loan_currency_ref_id, loan_source, bank_name, added_on, added_by', 'safe', 'on'=>'search'),
            
        );
        
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels(){
        return array(
			'student_outplacement_university_id' => 'Student Outplacement University',
			'user_ref_id' => 'Student',
			'uni_ref_id' => 'University',
			'course_ref_id' => 'Course',
			'uni_name' => 'University',
			'course_name' => 'Course',
			'uni_type' => 'University Type',
			'fees' => 'Fees',
			'fees_currency_ref_id' => 'currency',
			'loan_amount' => 'loan amount',
			'loan_currency_ref_id' => 'Loan Currency',
			'loan_source' => 'Loan Type',
			'bank_name' => 'bank name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
            'list_type' => 'List Type',
            'has_loan' => 'Has Loan',
            'has_scholarship' => 'Has Scholarship',
        );
    }
    
    /**
     * Validates whether university is give or not,
     * It can either be uni-ref-id or uni_name
     * @param string $attribute
     * @param array $params
     * @return boolean
     */
    public function validateUniversity($attribute, $params){
        if($this->uni_ref_id < 1 && empty($this->uni_name)){
            $attributeLabels = $this->attributeLabels();
            $this->addError($attribute, $attributeLabels[$attribute]. ' cannot be blank.');
            return false;
        }
        return true;
    }
    
    /**
     * Validates loan fields, either all should be given or none
     * @return boolean
     */
    public function validateLoan($attribute, $params){
        //loan_currency_ref_id, loan_source, loan_amount, bank_name
        //either all should be empty or non-empty
        if(!$this->hasLoan()){
            return true;
        }
        
        $attributeLabels = $this->attributeLabels();
        
        if(empty($this->$attribute) && $attribute == 'bank_name' && $this->loan_source == self::LOAN_TYPE_BANK){
            $this->addError($attribute, 'Please enter bank name.');
            return false;
        }
        
        if(empty($this->$attribute) && $attribute != 'bank_name'){
            if(in_array($attribute, array('loan_currency_ref_id', 'loan_source')))
                $this->addError($attribute, 'Please select ' . $attributeLabels[$attribute] . '.');
            else
                $this->addError($attribute, 'Please enter ' . $attributeLabels[$attribute] . '.');
                
           return false;
        }
        return true;
    }
    
    /**
     * Returns true if any of the loan fields or set else false
     * Used mostly in view purpose of show/hide loan div
     */
    public function hasLoan(){
        if($this->loan_currency_ref_id || $this->loan_source || $this->loan_amount){
            return true;
        }
        return false;
    }
    
    public static function getOutplacementUniversityByUserId($userId) {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.user_ref_id = ". $userId, "AND");
        //$cdbCriteria->addCondition("t.status = ". $status, "AND");
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
    public static function getJoiningUniversityByUserId($userId) {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = " inner join student_shortlist_university AS ssu ON ssu.uni_ref_id = t.uni_ref_id AND ssu.shortlist_status = 'Applied'";
        $cdbCriteria->addCondition("t.user_ref_id = ". $userId, "AND");
        $cdbCriteria->addCondition("t.uni_type = 'Joining'", "AND");
        $result = self::model()->with('university')->find($cdbCriteria);
        return $result;
    }
	
}