<?php
class ProfileData extends CFormModel {

    public $user_id;
    public $section;

    public $country_pref = array();
    public $country_not_sure;
    public $dept_pref = array();
    public $dept_not_sure;
    public $sub_dept_pref = array();
    public $dept_others = array();
    public $prospective_years = array();
    public $prospective_session = array();

    public $school_name_12;
    public $board_12;
    public $year_12;
    public $overall_marks_12;
    public $overall_marks_gpa_12;
    public $overall_points_12;
    public $overall_grade_12_1;
    public $overall_grade_12_2;
    public $overall_grade_12_3;
    public $overall_grade_12_4;
    public $overall_grade_12_5;
    public $school_name_10;
    public $board_10;
    public $year_10;
    public $overall_marks_10;
    public $overall_marks_gpa_10;
    public $overall_points_10;
    public $overall_grade_10_1;
    public $overall_grade_10_2;
    public $overall_grade_10_3;
    public $overall_grade_10_4;
    public $overall_grade_10_5;
    public $subject_12 = array();
    public $other_subject_12 = array();
    public $subject_marks_12 = array();
    public $subject_10 = array();
    public $other_subject_10 = array();
    public $subject_marks_10 = array();
    public $subject_9 = array();
    public $other_subject_9 = array();
    public $subject_marks_9 = array();

    public $extra_type = array();
    public $extra_interest = array();
    public $extra_level = array();
    public $extraCurriculum_other;
    public $ethnicity_ref_id;
    public $dob_date;
    public $dob_month;
    public $dob_year;
    public $state_ref_id;

    public $class_9;
    public $strong_subj = array();
    public $weak_subj = array();

    public $status;
    public $status_shown;
    public $career_1;
    public $career_2;

    public $first_name;
    public $last_name;
    public $country_code;
    public $passout_month;
    public $passout_year;
    public $gender;
    public $citizenship_ref_id1;
    public $citizenship_ref_id2;
    public $phone;
    public $country_ref_id;
    public $city_ref_id;
    public $address1;
    public $address2;
    public $study_board;
    public $hiddenFlag;

    public $entrance_exam_ref_id = array();
    public $exam_status = array();
    public $exams_info = array();
    public $exam_year = array();
    public $overall_marks = array();
    public $entrance_exam_module_entrance_exam_ref_id = array();
    public $exam_scores = array();

    public $introduce_yourself;
    public $pfname = array();
    public $plname = array();
    public $contact_type_ref_id = array();
    public $country_codes = array();
    public $phones = array();
    public $emails = array();
    public $post_code = array();
    public $alternate_email;
    public $cssStudentNames;
    public $cssStudentNamesList;

    public $overall_grade_10 = array();
    public $overall_grade_12 = array();
    public $pref_location = array();
    public $no_scholarship = array();
    public $exam_yesno;
    public $parent_choice1;
    public $parent_choice2;
    public $know_subjects;
    public $parent_career_1;
    public $parent_career_2;
    public $parent_career_3;
    public $agree_parent_choice;
    public $summer_plan_id;
    public $summer_plan;
    public $summer_plan2;

    public $present_class;
    public $is_location_entered;

    public function rules() {

        return array(
            array('user_id', 'required', 'on' => 'preferences'),
            array('user_id', 'validatePreferences', 'on' => 'preferences'),

            array('user_id', 'required', 'on' => 'education'),
            array('school_name_12', 'validateEducation', 'on' => 'education'),

            array('user_id', 'required', 'on' => 'extra'),
            array('user_id', 'validateExtra', 'on' => 'extra'),
            array('user_id', 'validateSummerPlan', 'on' => 'extra'),

            array('class_9', 'required', 'on' => 'education_9'),
            array('class_9', 'validateEducation_9', 'on' => 'education_9'),

            array('user_id', 'required', 'on' => 'preferences_9'),
            array('user_id', 'validatePreferences_9', 'on' => 'preferences_9'),

            array('user_id,', 'NameRequired', 'on' => 'basic'),
            array('first_name', 'match', 'pattern' => '/^[a-zA-Z.\' ][a-zA-Z.\'\s]+$/', 'message' => 'No special characters allowed.', 'on' => 'basic'),
            array('gender', 'required', 'message' => 'Select your gender', 'on' => 'basic'),
            //array('citizenship_ref_id1, passout_year, passout_month,study_board', 'required', 'on' => 'basic'),
            array('citizenship_ref_id1', 'required', 'on' => 'basic'),
            array('present_class, passout_year, passout_month, study_board', 'validateBasicInfo', 'on' => 'basic'),
            array('country_ref_id', 'required','message' => 'Please select country', 'on' => 'extra,basic'),
            array('citizenship_ref_id2', 'validateCitizen', 'on' => 'basic'),
            array('city_ref_id,address1', 'validateAddress', 'on' => 'basic'),
            //array('pfname, plname, contact_type_ref_id, emails, country_codes, phones', 'validateParentInfo', 'on' => 'others'),
            array('pfname, contact_type_ref_id, emails, country_codes, phones', 'validateParentInfo', 'on' => 'others'),
            array('country_code, phone', 'ValidateCountryPhone', 'on' => 'others'),
            array('alternate_email', 'CheckAlternateEmail', 'on' => 'others'),
            array('post_code', 'match', 'pattern' => '/^[0-9]*$/', 'message' => 'Enter Valid Zip code', 'on' => 'others'),
            //array('alternate_email', 'match', 'pattern' => '/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => 'Enter a valid email', 'on' => 'others'),
            array('dob_date, dob_month, dob_year', 'validateDOB', 'on' => 'extra'),
            array('country_ref_id,state_ref_id,city_ref_id', 'validateAddressExtra', 'on' => 'extra'),
            array('exam_yesno', 'validateEntranceExam', 'on' => 'entrance'),

            array('user_id,country_pref, dept_pref, sub_dept_pref, prospective_years, prospective_session,school_name_12,board_12,year_12,overall_marks_12,overall_marks_gpa_12,
            overall_points_12,overall_grade_12_1,overall_grade_12_2,overall_grade_12_3,overall_grade_12_4,overall_grade_12_5,school_name_10,board_10,year_10,overall_marks_10,overall_marks_gpa_10,
            overall_points_10,overall_grade_10_1,overall_grade_10_2,overall_grade_10_3,overall_grade_10_4,overall_grade_10_5,subject_marks_12,subject_12,subject_marks_10,
            subject_10,subject_marks_9,subject_9,extra_type,extra_interest,extra_level,extraCurriculum_other,class_9,strong_subj,weak_subj, status, career_1, career_2,status_shown,
            other_subject_12, other_subject_10, other_subject_9,
            country_not_sure,dept_not_sure,dept_others,overall_grade_10,overall_grade_12,

            first_name,  gender, phone,citizenship_ref_id1, pfname, phones, exam_status,entrance_exam_module_entrance_exam_ref_id,exam_scores,overall_marks,citizenship_ref_id2,hiddenFlag,ethnicity_ref_id, dob_date, dob_year, dob_month,state_ref_id,post_code,pref_location,no_scholarship, exams_info, parent_choice1, parent_choice2, parent_career_1, parent_career_2,parent_career_3, agree_parent_choice, know_subjects, summer_plan_id, summer_plan, summer_plan2, present_class, is_location_entered
            ', 'safe'),
        );
    }

    public function attributeLabels() {

        return array(
            'country_ref_id' => 'Country',
            'citizenship_ref_id1' => 'Citizenship',
            'phone' => 'Phone Number'
        );
    }

    public function validatePreferences_9() {
        $validate = 0;
        if ($this->status_shown == 1) {
            if (!$this->status) {
                $this->addError('status', 'Select status');
            }
            if ($this->status != 'Yes') {
                $validate = 1;
            }
        } else {
            $validate = 1;
        }
        if ($this->status && $validate == 1) {

            if (!$this->country_pref[1] && !$this->country_pref[2] ) {
                $this->addError('country_pref[1]', 'Select country');
            } elseif ($this->country_pref[1] && $this->country_pref[2] ) {
                if ($this->country_pref[1]  == $this->country_pref[2] ) {
                    $this->addError('country_pref[2]', 'Select different country');
                }
            }
        }

        if (!$this->parent_choice1 && !$this->parent_choice2) {
            $this->addError('parent_choice1', 'Select option');
        }
        if ($this->parent_choice1 && ($this->parent_choice1 == $this->parent_choice2) ) {
            $this->addError('parent_choice2', 'Select different career');
        }
        if ($this->parent_choice1 == Yii::app()->session['Others'] && (!trim($this->parent_career_1) && !trim($this->parent_career_2)) ) {
            $this->addError('parent_career_1', 'Enter atleast one career');
        }
        if ($this->parent_choice2 == Yii::app()->session['Others'] && !trim($this->parent_career_3) ) {
            $this->addError('parent_career_3', 'Enter career');
        }
        if (trim($this->parent_career_1) && trim($this->parent_career_2)) {

            $cdb = new CDbCriteria();
            $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
            $cdb->addCondition(' career_name = "'.trim($this->parent_career_1).' "', 'AND');
            $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
            $cdb->addCondition('is_active = 1', 'AND');
            $career_det1 = LookupCareer::model()->find($cdb);

            $cdb = new CDbCriteria();
            $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
            $cdb->addCondition(' career_name = "'.trim($this->parent_career_2).' "', 'AND');
            $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
            $cdb->addCondition('is_active = 1', 'AND');
            $career_det2 = LookupCareer::model()->find($cdb);

            if ($career_det1 && ($career_det1->career_id == $career_det2->career_id)) {
                $this->addError('parent_career_2', 'Select different career');
            }
        }

        if ($this->agree_parent_choice == '' && $this->parent_choice1 != Yii::app()->session['Havent'])
        {
            $this->addError('agree_parent_choice', 'Select option');
        }
        if ($this->agree_parent_choice == 'N' || $this->parent_choice1 == Yii::app()->session['Havent']) // 210 - Haven't discussed , 209 - others
        {
            if (!trim($this->career_1) && !trim($this->career_2)) {
                $this->addError('career_1', 'Enter atleast one career');
            }

            if (trim($this->career_1) && trim($this->career_2)) {

                $cdb = new CDbCriteria();
                $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                $cdb->addCondition(' career_name = "'.trim($this->career_1).' "', 'AND');
                $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                $cdb->addCondition('is_active = 1', 'AND');
                $career_det1 = LookupCareer::model()->find($cdb);

                $cdb = new CDbCriteria();
                $cdb->join = " LEFT JOIN career_country cc ON cc.career_ref_id = t.career_id ";
                $cdb->addCondition(' career_name = "'.trim($this->career_2).' "', 'AND');
                $cdb->addCondition('country_ref_id = '.Yii::app()->user->visitorCountry.' ', 'AND');
                $cdb->addCondition('is_active = 1', 'AND');
                $career_det2 = LookupCareer::model()->find($cdb);

                if ($career_det1 && ($career_det1->career_id == $career_det2->career_id)) {
                    $this->addError('career_2', 'Select different career');
                }
            }
        }
        if ($this->know_subjects == '')
        {
            $this->addError('know_subjects', 'Select status');
        }

    }

    public function validateEducation_9() {
        if ($this->class_9 == 10) {
            if (!trim($this->school_name_10)) {
                $this->addError('school_name_10', 'Enter School');
            }
            if (is_numeric(trim($this->school_name_10))) {
                $this->addError('school_name_10', 'Enter valid School');
            }
            if (!trim($this->year_10)) {
                $this->addError('year_10', 'Select Year');
            }


            if (!trim($this->board_10)) {
                $this->addError('board_10', 'Select Board');
            } else {
                $board_det = LookupBoardEquivalent::model()->findByPk($this->board_10);
                if ($board_det->overall_type == 'Marks') {
                    $this->checkNumericValues('overall_marks_10', $this->overall_marks_10);
                }
                if ($board_det->overall_type == 'Marks-GPA') {
                    $this->checkNumericValues('overall_marks_gpa_10', $this->overall_marks_gpa_10);
                }

                if (($board_det->overall_type == 'Marks') || ($board_det->overall_type == 'Marks-GPA')) {
                    $selected = array();
                    foreach ($this->subject_9 as $key=>$value) {
                        if ($this->subject_marks_9[$key]) {
                            if($board_det->board_ref_id != 7){
                                $this->checkNumericValues('subject_marks_9['.$key.']', $this->subject_marks_9[$key]);
                            }

                            if (in_array($value, $selected)) {
                                $this->addError('subject_9['.$key.']', 'Subject selected again');
                            }
                            $selected[] = $value;

                        }
                    }
                } elseif ($board_det->overall_type == 'Grades') {
                    $flag = 0; $j = 0;
                    foreach ($this->overall_grade_10 as $key=>$value) {
                        if($value) {
                            $flag = 1;
                        }
                        if($j == 0){
                            $FirstKey = $key;
                        }
                        $j++;
                    }
                    if(!$flag){
                        $this->addError('overall_grade_10['.$FirstKey.']', 'Select Grades');
                    }
                    $selected = array();
                    foreach ($this->subject_9 as $key=>$value) {
                        if ($this->subject_marks_9[$key]) {
                            //$this->checkNumericValues('subject_marks_9['.$key.']', $this->subject_marks_9[$key]);

                            if (in_array($value, $selected)) {
                                $this->addError('subject_9['.$key.']', 'Subject selected again');
                            }
                            $selected[] = $value;

                        }
                    }
                } elseif ($board_det->overall_type == 'Points') {
                    if (!$this->overall_points_10) {
                        $this->addError('overall_points_10', 'Select Points');
                    }

                    $selected = array();
                    foreach ($this->subject_9 as $key=>$value) {
                        if ($this->subject_marks_9[$key]) {
                            $this->checkNumericValues('subject_marks_9['.$key.']', $this->subject_marks_9[$key]);

                            if (in_array($value, $selected)) {
                                $this->addError('subject_9['.$key.']', 'Subject selected again');
                            }
                            $selected[] = $value;

                        }
                    }
                }
            }
        }

        $selectedSub = array();
        foreach ($this->strong_subj as $key=>$value) {
            if ($this->strong_subj[$key]) {
                if (in_array($value, $selectedSub)) {
                    $this->addError('strong_subj['.$key.']', 'Same Subject chosen');
                }
                $selectedSub[] = $value;
            }
        }
        foreach ($this->weak_subj as $key=>$value) {
            if ($this->weak_subj[$key]) {
                if (in_array($value, $selectedSub)) {
                    $this->addError('weak_subj['.$key.']', 'Same Subject chosen');
                }
                $selectedSub[] = $value;
            }
        }

        /*if ($this->strong_subj[1] && $this->strong_subj[2] && ($this->strong_subj[1] == $this->strong_subj[2])) {
            $this->addError('strong_subj[2]', 'Subject already selected');
        }
        if ($this->strong_subj[1] && $this->weak_subj[2] && ($this->strong_subj[1] == $this->weak_subj[2])) {
            $this->addError('weak_subj[2]', 'Subject already selected');
        }
        if ($this->strong_subj[1] && $this->weak_subj[1] && ($this->strong_subj[1] == $this->weak_subj[1])) {
            $this->addError('weak_subj[1]', 'Subject already selected');
        }
        if ($this->strong_subj[2] && $this->weak_subj[1] && ($this->strong_subj[2] == $this->weak_subj[1])) {
            $this->addError('weak_subj[1]', 'Subject already selected');
        }
        if ($this->strong_subj[2] && $this->weak_subj[2] && ($this->strong_subj[2] == $this->weak_subj[2])) {
            $this->addError('weak_subj[2]', 'Subject already selected');
        }
        if ($this->weak_subj[1] && $this->weak_subj[2] && ($this->weak_subj[1] == $this->weak_subj[2])) {
            $this->addError('weak_subj[2]', 'Subject already selected');
        }*/
    }

    public function validateExtra() {
        $selected_ids = array();
        foreach ($this->extra_type as $id=>$value) {
            if ($this->extra_type[$id] && $this->extra_interest[$id]) {
                if (in_array($this->extra_interest[$id], $selected_ids)) {
                    $this->addError('extra_interest['.$id.']', 'You have selected the same interest again.');
                }
                $selected_ids[] = $this->extra_interest[$id];
            }
        }
    }

    public function validateSummerPlan()
    {
        $user = TblUserMaster::model()->findByPk($this->user_id);
        if(in_array($user->present_class, array(9, 10)))
        {
            if(!$this->summer_plan_id)
            {
                //$this->addError('summer_plan_id', 'Select summer plan');
            }
            if($this->summer_plan_id == 6 && !$this->summer_plan && !$this->summer_plan2)
            {
                $this->addError('summer_plan', 'Please enter atleast one summer plan');
            }
            if ($this->summer_plan_id == 6  && !trim($this->summer_plan) && $this->summer_plan)
            {
                $this->addError('summer_plan', 'Empty values are not allowed');
            }
            if ($this->summer_plan_id == 6  && !trim($this->summer_plan2) && $this->summer_plan2)
            {
                $this->addError('summer_plan2', 'Empty values are not allowed');
            }
        }
    }

    public function validateEducation() {
        if (!trim($this->school_name_10)) {
            $this->addError('school_name_10', 'Enter School');
        }
        if (!trim($this->school_name_12)) {
            $this->addError('school_name_12', 'Enter School');
        }
        if (is_numeric(trim($this->school_name_12))) {
            $this->addError('school_name_12', 'Enter valid School');
        }
        if (is_numeric(trim($this->school_name_10))) {
            $this->addError('school_name_10', 'Enter valid School');
        }
        if (!trim($this->year_10)) {
            $this->addError('year_10', 'Select Year');
        }
        if (!trim($this->year_12)) {
            $this->addError('year_12', 'Select Year');
        }
        if ($this->year_10 && $this->year_12) {
            if (($this->year_12 - $this->year_10) < 2) {
                $this->addError('year_10', 'Atleast 2 years Less than 12th passout');
            }
        }


        if (!trim($this->board_12)) {
            $this->addError('board_12', 'Select Board');
        } else {
            $board_det = LookupBoardEquivalent::model()->findByPk($this->board_12);
            if ($board_det->overall_type == 'Marks') {
                $this->checkNumericValues('overall_marks_12', $this->overall_marks_12);
            }
            if ($board_det->overall_type == 'Marks-GPA') {
                $this->checkNumericValues('overall_marks_gpa_12', trim($this->overall_marks_gpa_12));
            }

            if (($board_det->overall_type == 'Marks') || ($board_det->overall_type == 'Marks-GPA')) {
                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_12 as $key=>$value) {
                    if ($this->subject_marks_12[$key]) {
                        if($board_det->board_ref_id != 7){
                            $this->checkNumericValues('subject_marks_12['.$key.']', $this->subject_marks_12[$key]);
                        }

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;

                        if (in_array($this->other_subject_12[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_12['.$key.']', 'Subject selected again');
                        }
                        $selectedOthers[] = $this->other_subject_12[$key];

                    }
                }
            } elseif ($board_det->overall_type == 'Grades') {
                $flag = 0; $j = 0;
                foreach ($this->overall_grade_12 as $key=>$value) {
                    if($value) {
                        $flag = 1;
                    }
                    if($j == 0){
                        $FirstKey = $key;
                    }
                    $j++;
                }
                if(!$flag){
                    $this->addError('overall_grade_12['.$FirstKey.']', 'Select Grades');
                }

                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_12 as $key=>$value) {
                    if ($this->subject_marks_12[$key]) {
                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;

                        if (in_array($this->other_subject_12[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_12['.$key.']', 'Same subject entered');
                        }
                        $selectedOthers[] = $this->other_subject_12[$key];

                    }
                }

            } elseif ($board_det->overall_type == 'Points') {
                if (!$this->overall_points_12) {
                    $this->addError('overall_points_12', 'Select Points');
                }

                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_12 as $key=>$value) {
                    if ($this->subject_marks_12[$key]) {
                        $this->checkNumericValues('subject_marks_12['.$key.']', $this->subject_marks_12[$key]);

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_12['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;

                        if (in_array($this->other_subject_12[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_12['.$key.']', 'Same subject entered');
                        }
                        $selectedOthers[] = $this->other_subject_12[$key];
                    }
                }
            }
        }
        if (!trim($this->board_10)) {
            $this->addError('board_10', 'Select Board');
        } else {
            $board_det = LookupBoardEquivalent::model()->findByPk($this->board_10);
            if ($board_det->overall_type == 'Marks') {
                $this->checkNumericValues('overall_marks_10', $this->overall_marks_10);
            }
            if ($board_det->overall_type == 'Marks-GPA') {
                $this->checkNumericValues('overall_marks_gpa_10', $this->overall_marks_gpa_10);
            }

            if (($board_det->overall_type == 'Marks')) {
                $max = 100;
                if ($this->overall_marks_10 && $this->overall_marks_10 <= 10) {
                    $max = 10;
                }

                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_10 as $key=>$value) {
                    if ($this->subject_marks_10[$key]) {
                        if($board_det->board_ref_id != 7){
                            $this->checkNumericValues('subject_marks_10['.$key.']', $this->subject_marks_10[$key]);
                        }

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;
                        if (in_array($this->other_subject_10[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_10['.$key.']', 'Same subject entered');
                        }
                        $selectedOthers[] = $this->other_subject_10[$key];
                    }
                }

            } elseif (($board_det->overall_type == 'Marks-GPA')) {
                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_10 as $key=>$value) {
                    if ($this->subject_marks_10[$key]) {
                        $this->checkNumericValues('subject_marks_10['.$key.']', $this->subject_marks_10[$key]);

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;
                        if (in_array($this->other_subject_10[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_10['.$key.']', 'Same subject entered');
                        }
                        $selectedOthers[] = $this->other_subject_10[$key];
                    }
                }
            } elseif ($board_det->overall_type == 'Grades') {
                $flag = 0; $j = 0;
                foreach ($this->overall_grade_10 as $key=>$value) {
                    if($value) {
                        $flag = 1;
                    }
                    if($j == 0){
                        $FirstKey = $key;
                    }
                    $j++;
                }
                if(!$flag){
                    $this->addError('overall_grade_10['.$FirstKey.']', 'Select Grades');
                }

                $selected_p = $selected = $selectedOthers = array();
                foreach ($this->subject_10 as $key=>$value) {
                    if ($this->subject_marks_10[$key]) {
                        //$this->checkNumericValues('subject_marks_10['.$key.']', $this->subject_marks_10[$key]);

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;
                        if (in_array($this->other_subject_10[$key], $selectedOthers) && $value == 'others') {
                            $this->addError('other_subject_10['.$key.']', 'Same subject entered');
                        }
                        $selectedOthers[] = $this->other_subject_10[$key];
                    }
                }
            } elseif ($board_det->overall_type == 'Points') {
                if (!$this->overall_points_10) {
                    $this->addError('overall_points_10', 'Select Points');
                }

                $selected_p = $selected = array();
                foreach ($this->subject_10 as $key=>$value) {
                    if ($this->subject_marks_10[$key]) {
                        $this->checkNumericValues('subject_marks_10['.$key.']', $this->subject_marks_10[$key]);

                        $det = LookupStudentSubject::model()->findByPk($value);
                        if (in_array($det->subject_master_ref_id, $selected_p) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected_p[] = $det->subject_master_ref_id;

                        if (in_array($value, $selected) && $value != 'others') {
                            $this->addError('subject_10['.$key.']', 'Subject selected again');
                        }
                        $selected[] = $value;

                    }
                }
            }
        }

    }

    public function validatePreferences() {
        if ($this->country_not_sure) {
        } else {
            if (!$this->country_pref[0]['countryids'] && !$this->country_pref[1]['countryids'] && !$this->country_pref[2]['countryids']) {
                $this->addError("country_pref[0][countryids]", 'Select country');
            } else {
                $selected = array();
                foreach ($this->country_pref as $key=>$value) {
                    if ($value['countryids']) {
                        if (in_array($value['countryids'], $selected)) {
                            $this->addError('country_pref['.$key.'][countryids]', 'Select different country');
                        }
                        $user = TblUserMaster::model()->findByPk($this->user_id);
                        $error = ($user->country_ref_id != $value['countryids'] && $value['countryids']) ? 1 : 0;
                        if($error && $this->country_pref[$key]['no_scholarship'] == '') {
                            //$this->addError('country_pref['.$key.'][no_scholarship]', 'Select scholarship status');
                        }
                        $cites = TblCityMaster::model()->count(array('condition' => 'country_id=' . $value['countryids']. ''));
                        if(($this->country_pref[$key]['is_location_entered'] == 'Y' && ($cites>1) && $this->country_pref[$key]['pref_location'] == '')) {
                            $this->addError('country_pref['.$key.'][pref_location]', 'Enter preferred location');
                        }
                        $selected[] = $value['countryids'];
                    }
                }
            }
        }

        $selected = 0;$first = '';$k = 0;
        if ($this->dept_not_sure) {
        } else {
            foreach ($this->dept_pref as $key=>$value) {
                if ($k == 0) {
                    $first = $key;
                } $k++;
                if ($value) {
                    $selected = 1;
                }
            }
            if ($selected == 0) {
                $this->addError('dept_pref['.$first.']', 'Select department');
            } else {
                $selected_val = array();
                foreach ($this->dept_pref as $key=>$value) {
                    if ($value && $value == 'others') {
                        $this->addError('dept_others['.$key.']', 'Select a valid course');
                    }
                }

                foreach ($this->dept_pref as $key=>$value) {
                    if ($value && $this->sub_dept_pref[$key]) {
                        $val = $value.'=='.$this->sub_dept_pref[$key].'=='.$this->dept_others[$key];
                        if (in_array($val, $selected_val)) {
                            if ($this->dept_others[$key]) {
                                $this->addError('dept_others['.$key.']', 'Select different course');
                            } else {
                                if ($this->sub_dept_pref[$key] != 'others' && $this->dept_pref[$key] != 'others') {
                                    $this->addError('sub_dept_pref['.$key.']', 'Select different department');
                                }
                            }
                        }
                        $selected_val[] = $val;
                    }
                }
                $no_dept = array();
                foreach ($this->dept_pref as $key=>$value) {
                    $val = $value;
                    if ($value) {
                        if (in_array($val, $no_dept) && !$this->sub_dept_pref[$key]) {
                            if ($this->dept_others[$key]) {
                                $this->addError('dept_others['.$key.']', 'Select different course');
                            } else {
                                $this->addError('sub_dept_pref['.$key.']', 'Select different department');
                            }
                        }
                        $no_dept[] = $val;
                    }
                }

            }
        }
        $det = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$this->user_id, 'step_no'=>2));
        if($det)
        {
            $selected = 0;$first = '';$k = 0;
            foreach ($this->prospective_session as $key=>$value) {
                if ($k == 0) {
                    $first = $key;
                } $k++;
                if ($value) {
                    $selected = 1;
                }
            }
            if ($selected == 0) {
                $this->addError('prospective_session['.$first.']', 'Select session');
            } else {
                $selected_val = array();
                foreach ($this->prospective_session as $key=>$value) {
                    if ($value) {
                        $val = $value;
                        if (in_array($val, $selected_val)) {
                            $this->addError('prospective_session['.$key.']', 'Duplicate selection');
                        }
                        $selected_val[] = $val;
                    }
                }
            }
        }
    }

    public function checkNumericValues($attribute, $value, $max = 100) {
        if ($value) {
            if (!is_numeric($value)) {
                $this->addError($attribute, 'Enter numeric values');
            }

            if ($value > $max) {
                $this->addError($attribute, 'Enter marks between 1 to '.$max);
            }

            if ($value < 1 ) {
                $this->addError($attribute, 'Value should be greater than 1');
            }
        } else {
            $this->addError($attribute, 'Enter marks');
        }
    }


    public function validatePhone() {
        if ($this->country_code == 91) {
            if ($this->phone[0] > 6) {

            } else {
                $this->addError('phone', 'Enter a valid phone number');
            }
        }

        if ($this->phone && !$this->country_code) {
            $this->addError('country_code', 'Select Your country code');
        }

        if ($this->phone) {
            if (!(int)$this->phone) {
                $this->addError('phone', 'Should contain numbers only');
            }

            if (strlen($this->phone) < 7) {
                $this->addError('phone', 'Enter a valid phone number');
                //$this->addError('phone', '<div class="holder"><p>Enter a valid phone number</p></div>');
            }
        }
    }

    public function validateParentInfo() {

        $selected = array();
        foreach ($this->contact_type_ref_id as $key=>$value) {
            if ($value) {
                if(!$this->pfname[$key]){
                    $this->addError('pfname['.$key.']', 'Parent\'s name is required');
                }
                /*if(!$this->plname[$key]){
                    $this->addError('plname['.$key.']', 'Last name is required');
                }*/
                if (in_array($value, $selected)) {
                    $this->addError('contact_type_ref_id['.$key.']', 'You selected the same relation again.Please change');
                }
                $selected[] = $value;
                if($this->emails[$key]){
                    if (!preg_match('/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/',$this->emails[$key] )) {
                        $this->addError('emails['.$key.']', 'Enter a valid email');
                    }
                }
                if($this->pfname[$key]){
                    if (!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->pfname[$key] )) {
                        $this->addError('pfname['.$key.']', 'Strange name ! Check again');
                    }
                    /*if (!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->plname[$key] )) {
                        $this->addError('plname['.$key.']', 'No special characters allowed');
                    }*/
                }
                if ($this->country_codes[$key] == 91) {
                    if (strlen($this->phones[$key])!= 10 || !preg_match('/^[7-9]+[0-9]*$/',$this->phones[$key]) ) {
                        $this->addError('phones['.$key.']', 'Enter a valid phone number');
                    }
                }
                if ($this->phones[$key] && !$this->country_codes[$key]) {
                    $this->addError('country_codes['.$key.']', 'Select country code');
                }
                if ($this->phones[$key]) {
                    if (!is_numeric($this->phones[$key])) {
                        $this->addError('phones['.$key.']', 'Should contain numbers only');
                    }
                    if (strlen($this->phones[$key]) < 7 && $this->country_codes[$key] != 91) {
                        $this->addError('phones['.$key.']', 'Enter a valid phone number');
                    }
                }
            }
        }
    }

    public function validateEntranceExam() {

        if($this->exam_yesno == 'N') return true;
        foreach ($this->exams_info as $examID=>$examInfo) {
            if(!$examID) continue;
            $status = $examInfo['status'];
            $year = $examInfo['year'];

            if(!$status)
                $this->addError('exams_info_'.$examID.'_status', 'Status is required');

            if(!$year)
                $this->addError('exams_info_'.$examID.'_year', 'Year is required');

            if($status == 'Completed'){

                $model = EntranceExam::model()->findByPk($examID);
                $marksLimit = $model && $model->max_marks ? $model->max_marks+0 : 0;

                $overAllScore = $examInfo['overall_marks'];
                if($overAllScore == '')
                    $this->addError('exams_info_'.$examID.'_overall_marks', "Score is required.");
                else if(!is_numeric($overAllScore))
                    $this->addError('exams_info_'.$examID.'_overall_marks', 'This must be a number.');

                if($marksLimit && !($overAllScore > 0 && $overAllScore <= $marksLimit))
                    $this->addError('exams_info_'.$examID.'_overall_marks', 'Must be 1 - '.$marksLimit.' only.');

                $modules = $examInfo['modules'];
                if(!isset($modules)) continue;
                $sum = $cnt = 0;
                foreach($modules as $moduleID => $moduleScore){

                    $sectionModel = EntranceExamModuleEntranceExam::model()->findByPk($moduleID);
                    $SmarksLimit = $sectionModel && $sectionModel->max_marks ? $sectionModel->max_marks+0 : 0;

                    if($moduleScore != ''){
                        $sum += $moduleScore;
                        if($moduleScore && !is_numeric($moduleScore))
                            $this->addError('exams_info_'.$examID.'_modules_'.$moduleID, 'This must be a number.');
                        if($marksLimit && !($moduleScore > 0 && $moduleScore <= $SmarksLimit))
                            $this->addError('exams_info_'.$examID.'_modules_'.$moduleID, 'Must be 1 - '.$SmarksLimit.' only.');                           }
                    $cnt++;
                }

                switch($examID){
                    case 137:
                    case 78://For ACT or IELTS
                        if($sum != 0 && $overAllScore > 0 && $overAllScore != ($sum/$cnt) ){
                            $this->addError('exams_info_'.$examID.'_overall_marks', 'Your individual score is not matched with your overall score');
                        }
                        break;

                    case 93:
                    case 77://For SAT or TOEFL
                        if($sum && $overAllScore != $sum ){
                            $this->addError('exams_info_'.$examID.'_overall_marks', 'Your individual score is not matched with your overall score');
                        }
                        break;
                }

            }elseif($status == 'Planned'){
                $joined_coaching_inst = $examInfo['joined_coaching_inst'];
                if(!$joined_coaching_inst)
                    $this->addError('exams_info_'.$examID.'_joined_coaching_inst', 'This is required');
            }

        }
        //echo '<pre>'; print_r($this->exams_info); exit;
    }

    public function validateCitizen()
    {
        if($this->citizenship_ref_id2 && ($this->citizenship_ref_id2 == $this->citizenship_ref_id1) ){
            $this->addError('citizenship_ref_id2', 'You selected the same citizenship.Please change');
        }
    }

    public function validateAddress()
    {
        if(!$this->address1 && !$this->city_ref_id){
            $this->addError('city_ref_id', 'Please select city');
        }
    }

    public function validateAddressExtra()
    {
        $stateRes = TblState::model()->count(array("condition" => "country_ref_id = " . $this->country_ref_id));
        if($stateRes){
            if(!$this->state_ref_id){
                $this->addError('state_ref_id', 'Please select state');
            }
        }
        if(!$this->city_ref_id){
            $this->addError('city_ref_id', 'Please select City');
        }
    }

    /*public function validateNames()
    {
        $domainArray = explode('.', $_SERVER['HTTP_HOST'], 2);
        $subDomain = strtolower($domainArray[0]);
        $this->instId = TblSiDi::isCssSchool($subDomain);
        if($this->instId){
            $this->isCssAccess = TRUE;
            $result = StudentUploadMasterNoEmail::getPendingStudentDetailByClass($this->instId);
        }
        if(count($result))
        {
            if(!$this->first_name){
                $this->addError('first_name', 'First name is required');
            }
        }
    }*/

    public function ValidateCountryPhone()
    {
        if(!$this->country_code){
            $this->addError('country_code', 'Select your country code');
        }
        else if($this->country_code)
        {
            if ($this->country_code == 91) {
                if (strlen($this->phone) != 10 || !preg_match('/^[7-9]+[0-9]*$/',$this->phone) ) {
                    $this->addError('phone', 'Enter a valid phone number');
                }
            }
            if ($this->phone) {
                if (!(int)$this->phone) {
                    $this->addError('phone', 'Should contain numbers only');
                }

                if (strlen($this->phone) < 7 && $this->country_code != 91) {
                    $this->addError('phone', 'Enter a valid phone number');
                }
            }
            else if($this->country_code){
                if(!$this->phone){
                    $this->addError('phone', 'Phone number is required');
                }
            }
        }

    }

    public function NameRequired()
    {
        $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
        $instId = $userSession['institute_id'];

        $res = TblUserMaster::model()->findByPk($this->user_id);
        //if((!$this->cssStudentNames && $instId && $this->hiddenFlag == 1 && !$res->first_name)){
        if((!$this->cssStudentNames && $instId && $this->hiddenFlag == 1)){
            $this->addError('cssStudentNames', 'Select your name');
        }
        else{
            if(!$this->first_name){
                $this->addError('first_name', 'Name cannot be blank');
            }
            /*if(!$this->last_name){
                $this->addError('last_name', 'last name cannot be blank');
            }*/
        }

    }

    public function CheckAlternateEmail()
    {
        $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
        $res = TblUserMaster::model()->findByPk($this->user_id);
        $mail = $res->loginRef->username;
        //$mail = $userSession['fldUserEmail'];

        if($mail == $this->alternate_email && $this->alternate_email){
            $this->addError('alternate_email', 'Email and alternate email should not be same');
        }
        if($this->alternate_email)
        {
            if (!preg_match('/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/',$this->alternate_email )) {
                $this->addError('alternate_email', 'Enter a valid email');
            }
        }
    }

    public function ValidateDOB()
    {
        if($this->dob_date || $this->dob_month || $this->dob_year){
            if(!$this->dob_date){
                $this->addError('dob_date', 'Select date');
            }
            if(!$this->dob_month){
                $this->addError('dob_month', 'Select month');
            }
            if(!$this->dob_year){
                $this->addError('dob_year', 'Select year');
            }
        }
        if($this->dob_date && $this->dob_month && $this->dob_year){
            if($this->dob_month == 2 || $this->dob_month == 4 || $this->dob_month == 6 || $this->dob_month == 9 || $this->dob_month == 11)
            {
                if($this->dob_date >30){
                    $this->addError('dob_date', 'Invalid date');
                }
                if (($this->dob_year%100) == 0 || ($this->dob_year%400) == 0 || ($this->dob_year%4 == 0))
                {
                    if($this->dob_date >29 && $this->dob_month == 2){
                        $this->addError('dob_date', 'Invalid date');
                    }
                }
                if(($this->dob_date >28 && $this->dob_month == 2) && ($this->dob_year%4!=0)){
                    $this->addError('dob_date', 'Invalid date');
                }
            }

        }
    }

    public function validateBasicInfo()
    {
        $res = TblUserMaster::model()->findByPk($this->user_id);
        if(!$this->study_board){
            $this->addError('study_board', 'Study Board cannot be blank');
        }
        $stepsDet = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$this->user_id, 'step_no'=>1));
        if($stepsDet) {
            if(!$this->present_class){
                $this->addError('present_class', 'Present class cannot be blank');
            }
        }
        if(in_array($res->present_class, array(11, 12)))
        {
            if(!$this->passout_year){
                $this->addError('passout_year', 'Passout Year cannot be blank');
            }
            if(!$this->passout_month){
                $this->addError('passout_month', 'Passout Month cannot be blank');
            }
        }
    }

    public static function calculateYear($board)
    {
        $currentYear = date('Y');
        $currentMonth = date('n');
        switch ($board) {
            case 1:
            case 2:
            case 3:
            case 4:
            case 7:
                if ($currentMonth <= 2) {
                    return $currentYear;
                } else {
                    return $currentYear+1;
                }
                break;
            case 5:
            case 6:
            case 8:
                if ($currentMonth <= 6) {
                    return $currentYear;
                } else {
                    return $currentYear+1;
                }
                break;
            default:
                if ($currentMonth <= 6) {
                    return $currentYear;
                } else {
                    return $currentYear+1;
                }
        }
    }
    public function _ce($error){

        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {

        parent::addError($attribute, $this->_ce($error));
    }
}