<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseEntranceExam');

class EntranceExam extends BaseEntranceExam {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getEntranceListAuto($searchTerm, $limit = 10) {
        $criteria = new CDbCriteria;
        $criteria->alias = 'em';
        $criteria->select = array('entrance_id', 'entrance_short_name', 'max_marks', 'entrance_full_name');
        $criteria->compare('em.entrance_short_name', $searchTerm, true);
        $criteria->condition = 'is_active=1 AND entrance_short_name!=""';
        $criteria->group = 'em.entrance_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN em.entrance_short_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), em.entrance_short_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    } 

    public static function getEntranceFullnameListAuto($searchTerm, $limit = 10) {
        $criteria = new CDbCriteria;
        $criteria->alias = 'em';
        $criteria->select = array('entrance_id', 'entrance_short_name', 'max_marks', 'entrance_full_name');
        //$criteria->compare('em.entrance_full_name', $searchTerm, true);
        $criteria->addCondition("em.entrance_short_name like '%".$searchTerm."%' OR em.entrance_full_name like '%".$searchTerm."%'", "AND");

        $criteria->addCondition('em.is_active=1 AND em.entrance_short_name !="" ', "AND");
        //$criteria->group = 'em.entrance_id';
        $criteria->group = 'em.entrance_short_name';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN em.entrance_short_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), em.entrance_full_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }

    public static function getEntranceMarks($entranceId) {
        $criteria = new CDbCriteria;
        $criteria->alias = 'em';
        $criteria->compare('em.entrance_id', $entranceId, true);
        $res = self::model()->findAll($criteria);
        return $res;
    }

    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getTestAttributeById($id, $columns = '') {
        $criteria = new CDbCriteria();
        if (strlen($columns)) {
            $criteria->select = $columns;
        } else {
            $criteria->select = '*';
        }

        $criteria->condition = 'entrance_id=:id';
        $criteria->params = array(':id' => $id);
        $data = self::model()->find($criteria);
        return $data;
    }
    
    public static function getRelatedTestByTestId($mainDept) {
        $deptArr = explode(",", $mainDept);
        
        $data = Yii::app()->db->createCommand()
                ->select('entrance_short_name')
                ->selectDistinct('ee.entrance_short_name, ee.entrance_id')
                ->from('entrance_exam_applicable_department AS eea')
                ->join('entrance_exam AS ee', 'eea.entrance_exam_ref_id = ee.entrance_id')
                ->where("main_department_ref_id IN (" . $mainDept . ") AND entrance_short_name != ''")
                ->queryAll();

        foreach ($data as $key => $value) {
            $testArr[$value['entrance_id']] = $value['entrance_short_name'];
        }
        return $testArr;
    }
    
   
    
    public static function getTestUrlData($testId, $byTestHash = 0) {
        $criteria = new CDbCriteria();
        $criteria->select = 'entrance_id, entrance_short_name, entrance_full_name, url_primary_key, seo_keyword';
        
        if($byTestHash) {
            $criteria->condition = "url_primary_key=:id";
            $criteria->params = array(':id' => $testId);
        } else {
            $criteria->condition = "entrance_id=:id";
            $criteria->params = array(':id' => $testId);
        }

        $data = self::model()->find($criteria);

        $testUrlData['url_primary_key'] = $data->url_primary_key;
        $testUrlData['keyword'] = $data->seo_keyword;
        $testUrlData['entrance_full_name'] = $data->entrance_full_name;
        $testUrlData['entrance_short_name'] = $data->entrance_short_name;        

        return $testUrlData;
    }

    public static function getStandardTestDepartment($dept,$country) {       
        
        $sql ="SELECT ee.entrance_id, ee.entrance_short_name FROM entrance_exam ee
                   INNER JOIN department_entrance_exam dee ON dee.entrance_exam_ref_id = ee.entrance_id                   
                   WHERE dee.country_ref_id = :countryid AND dee.department_ref_id= :departmentid";
            $command =Yii::app()->db->createCommand($sql);            
            $command->bindValue(":countryid", $country, PDO::PARAM_INT);
            $command->bindValue(":departmentid", $dept, PDO::PARAM_INT);
            $res =$command->queryAll();
            
        return $res;        
    }
    
    public static function getStandardTestModule($departmentID,$entranceExamID) {       
                   
         $sql ="SELECT eem.* FROM entrance_exam_module eem
               INNER JOIN entrance_exam_module_entrance_exam eemee ON eemee.entrance_exam_module_ref_id = eem.entrance_exam_module_id
               INNER JOIN entrance_exam_module_department eemd ON eemd.entrance_exam_module_entrance_exam_ref_id = eemee.entrance_exam_module_entrance_exam_id 
               WHERE eemd.department_ref_id= :departmentid AND eemee.entrance_exam_ref_id= :entranceexamid";
        
        $command =Yii::app()->db->createCommand($sql);        
        $command->bindValue(":departmentid", $departmentID, PDO::PARAM_INT);
        $command->bindValue(":entranceexamid", $entranceExamID, PDO::PARAM_INT);
        $res =$command->queryAll();
        
        return $res;        
    }
    
 public function getUniqueUrlPrimarykey($var1, $var2) {
        static $count = 0;
        $gereratedKey = hash('crc32b', $var1 . $var2);
        $rowData = self::model()->find('url_primary_key ="' . $gereratedKey . '"');
        $count++;
        if (!$rowData->entrance_id) {
            return $gereratedKey;
        } else {
            echo $var2 = $var2 . $count;
            return $this->getUniqueUrlPrimarykey($var1, $var2);
        }
    }
    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    


    
    
    public static function getTestIdFromHash($hashTestId) {
        $criteria = new CDbCriteria();
        $criteria->select = 'entrance_id, url_primary_key, entrance_full_name, seo_keyword';
        $criteria->condition = "url_primary_key=:id";
        $criteria->params = array(':id' => $hashTestId);

        $data = self::model()->find($criteria);

        $testUrl['entrance_id'] = $data->entrance_id;
        $testUrl['url_primary_key'] = $data->url_primary_key;
        $testUrl['entrance_full_name'] = $data->entrance_full_name;
        $testUrl['keyword'] = $data->seo_keyword;        
        
        return $testUrl;
    }

    public static function getTestIdByAttribute($attribute, $attribute_value) {
        $criteria = new CDbCriteria();
        $criteria->select = 'entrance_id';

        $criteria->condition = $attribute.'=:id';
        $criteria->params = array(':id' => $attribute_value);
        $data = self::model()->find($criteria);

        return $data->entrance_id;
    }



    public static function getTestDetailsByCountryAndDepartment($typeOfExam='', $fields = array()){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = array('entrance_id', 'entrance_short_name', 'entrance_full_name', 'type_of_exam', 'is_entrance_exam', 't.url_primary_key');
                
        // when have country and department id
        if($fields['countryId'] > 0){
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
            if($typeOfExam) {
                $cdbCriteria->addCondition("t.type_of_exam = '".$typeOfExam."'", "AND");            
            }
            $cdbCriteria->addCondition("eeal.country_ref_id = '".$fields['countryId']."'", "AND");
            $cdbCriteria->addCondition("eead.main_department_ref_id = '".$fields['departmentId']."'", "AND");
        }
        
        // when have college and department id
        if($fields['uniId'] > 0){
        $cdbCriteria->join = "JOIN uni_course_test uct ON t.entrance_id = uct.entrance_ref_id
        JOIN tbl_uni_courses uc ON uct.uni_course_ref_id = uc.course_id
        JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
        ";            
            if($typeOfExam) {
                $cdbCriteria->addCondition("t.type_of_exam = '".$typeOfExam."'", "AND");
            }
            $cdbCriteria->addCondition("uc.uni_ref_id = '".$fields['uniId']."'", "AND");
            $cdbCriteria->addCondition("ld.main_dept_id = '".$fields['departmentId']."'", "AND"); 
        }
        
        //$cdbCriteria->params = array(':typeOfExam' => $typeOfExam, ':countryRefId' => $countryId, ':departmentRefId' => $departmentId);
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->group = "t.entrance_id";
        $cdbCriteria->order = "t.type_of_exam, t.entrance_full_name";

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getTestDetailsByCountryDepartment($country_id, $course_id,$offset=0,$limit=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.*';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN entrance_exam_ranking eer ON eer.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN entrance_exam_ranking_department erd ON erd.entrance_exam_ranking_ref_id = eer.entrance_exam_ranking_id ";

        //$cdbCriteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = t.entrance_id ";
        $cdbCriteria->addCondition("eeal.country_ref_id = ".$country_id." ", "AND");
        //$cdbCriteria->addCondition("(eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL) ", "AND");
        $cdbCriteria->addCondition("eead.main_department_ref_id = ".$course_id." ", "AND");
        $cdbCriteria->addCondition("eer.country_ref_id = ".$country_id." ", "AND");
        $cdbCriteria->addCondition("erd.main_department_ref_id = ".$course_id." ", "AND");

        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        if($country_id != 100){
            $cdbCriteria->order = "  t.category, ISNULL(erd.rank), erd.rank ASC ";
        }else{
            $cdbCriteria->order = " ISNULL(erd.rank), erd.rank ASC ";
        }
        
        $cdbCriteria->offset = $offset;
        if($limit)

            $cdbCriteria->limit = $limit;
        $result = self::model()->findAll($cdbCriteria);
        return $result;

    }

    public static function getTestListByType($country_id = 0, $course_id = 0,$uniId = 0, $type_of_exam = '', $offset = 0, $limit = 0, $skip = ''){
        $condition = '';

        if($course_id != 0){
           // $condition .= " AND eead.main_department_ref_id =" .$course_id;
            $condition .= " AND erd.main_department_ref_id =" .$course_id;
        }

        if($country_id != 0){
           // $condition .= " AND eeal.country_ref_id =" .$country_id;
            $condition .= " AND eer.country_ref_id = " .$country_id;
           // $condition .= " AND (eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL) ";
        }

         if($uniId != 0){
            $condition .= " AND ct.uni_ref_id = ".$uniId;
         }

        if($type_of_exam != ''){
            $condition .= " And t.type_of_exam='".$type_of_exam."'";
        }

        if ($skip != '') {
            $condition = " AND t.entrance_id NOT IN ($skip) ";
        }

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id),t.entrance_short_name,t.entrance_full_name, t.type_of_exam,t.category, t.coaching_required1, erd.rank, t.students_appeared_last_year';
        $cdbCriteria->condition = 't.is_active = 1' .$condition;
       // $cdbCriteria->join .= " JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id";
        //$cdbCriteria->join .= " JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN entrance_exam_ranking eer ON eer.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN entrance_exam_ranking_department erd ON erd.entrance_exam_ranking_ref_id = eer.entrance_exam_ranking_id ";
        
		//$cdbCriteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = t.entrance_id ";

        if($uniId != 0){
            $cdbCriteria->join .= " JOIN uni_course_test ct ON ct.entrance_ref_id = t.entrance_id";
        }
        if($type_of_exam == 'International'){
            $cdbCriteria->order = "  t.category, ISNULL(erd.rank), erd.rank ASC ";
        }else{
            $cdbCriteria->order = " ISNULL(erd.rank), erd.rank ASC ";
        }

        $cdbCriteria->offset= $offset;
        if(!$limit==0){
            $cdbCriteria->limit=$limit;
        }
        $cdbCriteria->group = "t.entrance_full_name";
        $result = self::model()->findAll($cdbCriteria);

        $data = array();
        foreach($result as $r){
            $data[$r->entrance_id] = $r->attributes;
        }
        return $data;
    }
    
    public static function getTestDetailsByCountryDepartmentArr($country_id = array(), $course_id = array()){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.entrance_id, t.entrance_short_name';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = t.entrance_id ";
        $cdbCriteria->addInCondition("eeal.country_ref_id", $country_id);
        $cdbCriteria->addInCondition("eead.main_department_ref_id", $course_id);
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("(eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL)", "AND");
        $cdbCriteria->group = "t.entrance_full_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
    
     public static function getAllEntranceExams() {
        $criteria = new CDbCriteria;
        $criteria->select = 'entrance_id, entrance_short_name';
        $criteria->condition = 'is_active=1';
        $criteria->order = 'entrance_short_name';
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    /* public static function getTestDetailsByCountryAndDepartment($typeOfExam='', $fields = array()){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->addCondition("t.type_of_exam = '".$typeOfExam."'", "AND");
        if($fields['countryId'] > 0){
            $cdbCriteria->addCondition("eeal.country_ref_id = '".$fields['countryId']."'", "AND");
        }
        if($fields['uniId'] > 0){
            $cdbCriteria->addCondition("eeal.uni_ref_id = '".$fields['uniId']."'", "AND");
        }
        $cdbCriteria->addCondition("eead.main_department_ref_id = '".$fields['departmentId']."'", "AND");
        //$cdbCriteria->params = array(':typeOfExam' => $typeOfExam, ':countryRefId' => $countryId, ':departmentRefId' => $departmentId);
        $cdbCriteria->group = "t.entrance_id";

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    } */

    public function getEntranceExamSearch($country_id, $search, $excludeList = 0) {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.*';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->addCondition("eeal.country_ref_id = ".$country_id." ", "AND");
        $cdbCriteria->addCondition("t.entrance_short_name like '%".$search."%' OR t.entrance_full_name like '%".$search."%' ", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");

        $excludeList_array = array();
        if ($excludeList != 0) {
            $excludeList_array = explode(',', $excludeList);
        }

        $result = self::model()->findAll($cdbCriteria);
        foreach($result as $dataPart) {
            if (!in_array($dataPart->entrance_id, $excludeList_array)) {
                $op = array(
                    'id' => $dataPart->entrance_id,
                    'value' => $dataPart->entrance_short_name,
                    'fullName' => $dataPart->entrance_full_name,
                );
                $return[$dataPart->entrance_id] = $op;
            }
        }

        return array_values($return);
    }

    public function checkEntranceExamInSuggest($examId, $countryIds, $courseIds) {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.*';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->addCondition("eeal.country_ref_id IN (".implode(',', $countryIds).") ", "AND");
        $cdbCriteria->addCondition("eead.main_department_ref_id IN (".implode(',', $courseIds).") ", "AND");
        $cdbCriteria->addCondition("t.entrance_id = ".$examId." ", "AND");

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
    // Using this function in header search
    public static function getTestHeaderSearchList($searchTerm, $limit = 20, $status = '', $uniIdArr = array()) {
        
//        if(count($uniIdArr)) {
//             $cond = " OR uni_ref_id IN (". implode(",", $uniIdArr) .")";
//        }
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';

        $criteria->join = "LEFT JOIN tag_entrance_exam as te ON um.entrance_id = te.entrance_exam_ref_id";
        $criteria->join .= " LEFT JOIN tag tg ON tg.tag_id = te.tag_ref_id";
        $criteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = um.entrance_id ";
        $criteria->condition = "(um.entrance_full_name LIKE '%$searchTerm%' OR um.entrance_short_name LIKE '%$searchTerm%' OR tg.tag_name LIKE '%$searchTerm%') AND um.is_active = '$status'" . $cond;
        $criteria->condition .= " AND (eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL)";
        if(Yii::app()->user->visitorCountry != 100)
            $criteria->condition.= " AND (um.is_international_serach = 'Y' OR um.is_international_serach IS NULL) ";
        //$criteria->group = 'um.entrance_id';
        $criteria->group = 'um.entrance_full_name';
        //$searchTerm = mysql_escape_string($searchTerm);
        //$criteria->order = "(CASE WHEN um.entrance_id LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.entrance_full_name";
        $criteria->order = "(CASE WHEN um.entrance_short_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.entrance_short_name, (CASE WHEN um.entrance_full_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.entrance_full_name,(CASE WHEN tg.tag_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), tg.tag_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getTestForSignup() {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 't.entrance_id, t.entrance_short_name';
        $cdbCriteria->addInCondition("entrance_short_name", array('SAT', 'ACT') );
        $cdbCriteria->addCondition("t.is_active = 1", "AND");

        $result = self::model()->findAll($cdbCriteria);

        return $result;
    }

    public function getTestNamesBYCourseRefId($courseRefId){
        /* $sql="SELECT e.entrance_id, e.entrance_short_name
        FROM `entrance_exam` e
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        WHERE u.uni_course_ref_id=".$courseRefId." AND e.entrance_short_name NOT IN('Admission Based on Cut Offs','None')
        ORDER BY e.entrance_short_name ASC";*/
        $sql = "SELECT e.entrance_id, e.entrance_short_name
        FROM `entrance_exam` e
        JOIN entrance_exam_date_section ed ON ed.entrance_exam_ref_id = e.entrance_id
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        WHERE u.uni_course_ref_id=".$courseRefId." AND e.entrance_short_name NOT IN('Admission Based on Cut Offs','None') AND e.is_active=1
        GROUP BY e.entrance_id ORDER BY e.entrance_short_name ASC";
        $command=Yii::app()->db->createCommand($sql);
        $data=$command->queryAll();
        return $data;
    }


    public function getFirstTestNameBYCourseRefId($courseRefId){
        /*$sql="SELECT e.entrance_id, e.entrance_short_name
        FROM `entrance_exam` e
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        WHERE u.uni_course_ref_id=".$courseRefId." LIMIT 1";*/
        $sql = "SELECT e.entrance_id, e.entrance_short_name
        FROM `entrance_exam` e
        JOIN entrance_exam_date_section ed ON ed.entrance_exam_ref_id = e.entrance_id
        JOIN uni_course_test u ON e.entrance_id=u.entrance_ref_id
        WHERE u.uni_course_ref_id=".$courseRefId." AND e.entrance_short_name NOT IN('Admission Based on Cut Offs','None') AND e.is_active=1
        GROUP BY e.entrance_id ORDER BY e.entrance_short_name ASC LIMIT 1";
        $command=Yii::app()->db->createCommand($sql);
        $data=$command->queryAll();
        return $data;
    }


    public static function getTestName($testId) {
        $criteria = new CDbCriteria;
        $criteria->select = array('entrance_full_name');
        $criteria->compare('entrance_id', $testId);
        $res = self::model()->find($criteria);
        if (count($res) > 0)
            return $res->entrance_full_name;
    }
    
    
    
    public static function get_entrance_exam_list_data_by_user_country($country_id = null, $active_only = true){
        
        if(!$country_id) $country_id = Yii::app()->user->visitorCountry;
        
        $criteria = new CDbCriteria();
        $criteria->with = array(
            'entranceExamCountries.countryRef' => array('condition' => 'countryRef.country_id = '.$country_id)
        );
        
        $criteria->select = 't.entrance_id,t.entrance_short_name,t.entrance_full_name';
        if($active_only) $criteria->condition = 't.is_active = 1';
        
        $result = self::model()->findAll($criteria);
        $data = array();
        
        foreach($result as $r){
           $data[$r->entrance_id] = $r->entrance_full_name.' ('.$r->entrance_short_name.')';
        }
        return $data;
    }
    
    
    public function get_exams_list(){
        
        $exam_results = Yii::app()->db->createCommand()
                ->select('EntranceExam.entrance_id, EntranceExam.seo_keyword, EntranceExam.entrance_short_name, EntranceExam.entrance_full_name, EntranceExam.type_of_exam')
                ->from(EntranceExam::model()->tableSchema->name.' EntranceExam')
                ->where('EntranceExam.type_of_exam <> ""')
                ->order('EntranceExam.entrance_full_name')
                ->queryAll();
        
        $data = array();
        foreach($exam_results as $exam){
            $data[$exam['entrance_id']]['id'] = $exam['entrance_id'];
            $data[$exam['entrance_id']]['slug'] = $exam['seo_keyword'];
            $data[$exam['entrance_id']]['title'] = $exam['entrance_full_name'];
            $data[$exam['entrance_id']]['short_name'] = $exam['entrance_short_name'];
            $data[$exam['entrance_id']]['type'] = $exam['type_of_exam'];
        }
        return $data;
    }

    public static function getIntTestDetailsByCountryDepartmentArr($country_id = array(), $course_id = array(),$int=false){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.entrance_id, t.entrance_short_name';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = t.entrance_id ";
        $cdbCriteria->addInCondition("eeal.country_ref_id", $country_id);
        $cdbCriteria->addInCondition("eead.main_department_ref_id", $course_id);
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        if($int){
            $cdbCriteria->addCondition("t.type_of_exam = 'International'", "AND");
        }
        else{
            $cdbCriteria->addCondition("t.type_of_exam != 'International'", "AND");
        }
        //$cdbCriteria->addCondition("(eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL)", "AND");
        $cdbCriteria->group = "t.entrance_full_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getAllTests(){
        $criteria = new CDbCriteria();
        $criteria->select = 'entrance_id,url_primary_key, entrance_full_name';
        $criteria->order = 'entrance_full_name ASC';
        return $criteria;
    }

    static public function GetEntranceExams($countries = false, $departments= false, $examIDs = false){

        $examInfo = $whereConditions = array();
        $Sql = "SELECT ee.* FROM entrance_exam ee ";
        if($countries){
            $Sql .=" INNER JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = ee.entrance_id";
            $whereConditions[] = "eeal.country_ref_id IN(".$countries.")";
        }

        if($departments){
            $Sql .=" INNER JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = ee.entrance_id";
            $whereConditions[] = "eead.main_department_ref_id IN(".$departments.")";
        }

        if($examIDs){
            $whereConditions[] = "ee.entrance_id IN(".$examIDs.")";
        }

        $Sql .= ' WHERE ee.entrance_short_name !="" AND ee.is_active="1"';
        $FinalSql = $Sql . (count($whereConditions) ?  " AND ".implode(" AND ", $whereConditions) : '');
        $FinalSql .= ' GROUP BY ee.entrance_full_name ORDER BY ee.type_of_exam, ee.entrance_short_name ASC';

        $command =Yii::app()->db->createCommand($FinalSql)->setFetchMode(PDO::FETCH_OBJ);
        $exams =$command->queryAll();

        foreach($exams as $exam){
            if($exam->type_of_exam == 'International')
                $examInfo['International'][$exam->entrance_id] = $exam->entrance_short_name;
            elseif($exam->type_of_exam == 'National')
                $examInfo['National'][$exam->entrance_id] = $exam->entrance_short_name;
            elseif($exam->type_of_exam == 'State')
                $examInfo['State'][$exam->entrance_id] = $exam->entrance_short_name;
            elseif($exam->type_of_exam == 'College')
                $examInfo['College'][$exam->entrance_id] = $exam->entrance_short_name;

        }
        return $examInfo;

    }

    public static function getAllValidTests(){
        $criteria = new CDbCriteria();
        $criteria->select = 'entrance_id,url_primary_key, entrance_full_name';
        $criteria->condition = "is_active = 1 AND url_primary_key != ''";
        $criteria->group = 'entrance_full_name';
        return $criteria;
    }

    public static function getTestByCountryDepartment($country_id = array(), $course_id = array(), $searchTerm = false){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT(t.entrance_id), t.entrance_id, t.entrance_short_name';
        $cdbCriteria->join = "JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_id
        JOIN entrance_exam_applicable_department eead ON eead.entrance_exam_ref_id = t.entrance_id";
        $cdbCriteria->join .= " LEFT JOIN `entrance_exam_country` eec ON eec.entrance_exam_ref_id = t.entrance_id ";
        $cdbCriteria->addInCondition("eeal.country_ref_id", $country_id);
        $cdbCriteria->addInCondition("eead.main_department_ref_id", $course_id);
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("(eec.country_ref_id = ".Yii::app()->user->visitorCountry." OR eec.country_ref_id IS NULL)", "AND");
        if($searchTerm){
            $cdbCriteria->addCondition("t.entrance_short_name LIKE '%".$searchTerm."%'", "AND");
        }

        $cdbCriteria->group = "t.entrance_full_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
}