<?php

/**
 * This is the model class for table "sys_email_settings_cfg".
 *
 * The followings are the available columns in table 'sys_email_settings_cfg':
 * @property integer $email_setting_id
 * @property integer $email_type_id
 * @property integer $status
 * @property integer $email_template_id
 * @property string $is_active
 * @property string $from_email_addres
 * @property integer $created_by
 * @property string $created_time
 * @property integer $modified_by
 * @property string $modified_time
 */
class EmailSettings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailSettings the static model class
	 */
	public $model_master_id;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_email_settings_cfg';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	 	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_type_id, created_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>11),
			array('from_email_addres', 'length', 'max'=>120),
			array('created_time, modified_time', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_setting_id, email_type_id, status, is_active, from_email_addres, created_by, created_time, modified_by, modified_time', 'safe', 'on'=>'search'),
		array(
                'modified_time',
                'default',
                'value' => new CDbExpression('NOW()'),
                'setOnEmpty' => false,
                'on' => 'update'
            ),
            array(
                'created_time,modified_time',
                'default',
                'value' => new CDbExpression('NOW()'),
                'setOnEmpty' => false,
                'on' => 'insert'
            )
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'emailconfitype'=>array(self::HAS_ONE, 'EmailTypeConf', 'email_type_id'),
		);
	}


	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		
		$filename = dirname(__FILE__).'/EmailSettings/Translations/EmailSettings_'.Yii::app()->session['lang'].'.php';
		if (file_exists($filename)) {
			return require($filename);
		} 
		else {
			return array(
				'email_setting_id' => 'Email Setting',
				'email_type_id' => 'Email Type',
				'email_template_id' => 'Email Template',
				'is_active' => 'Is Active',
				'from_email_addres' => 'From Email Addres',
				'created_by' => 'Created By',
				'created_time' => 'Created Time',
				'modified_by' => 'Modified By',
				'modified_time' => 'Modified Time',
			);
		}

	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_setting_id',$this->email_setting_id);
		$criteria->compare('email_type_id',$this->email_type_id);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('from_email_addres',$this->from_email_addres,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_time',$this->created_time,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_time',$this->modified_time,true);
		$criteria->addCondition('is_active=\'Y\'');

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function behaviors() {
       return array(
           'ERememberFiltersBehavior' => array(
               'class' => 'application.components.ERememberFiltersBehavior',
               'defaults'=>array(),          
               'defaultStickOnClear'=>false 
           ),
       );
	}
}
