<?php
return array(
    /**
     * Please add your rules before "Default url conditions",
     * don't add rules inbetween other rules, which will give code conflicts.
     * @usage 'urlManager'=>array(
	 *			'rules' => require_once 'urlRules.php',
	 *			...
	 *		),
	 *		in "components" of your config file.
     */

    'login/index/<rUrl>'=>'login/index',
    //url's for prospect controller
    'prospects/all' => 'prospect/list',
    'prospects/my' => 'prospect/myList',

    'search/<country:[\w\-]+>/<keyword:[\w\-]+>' => 'search/index',
    'search/<country:[\w\-]+>/<city_state:[\w\-]+>/<keyword:[\w\-]+>' => 'search/index',
    'questions/default/<action:\w+>' => 'questions/default/<action>',
    'question/<seoText:[\w\-]+>/<questionId:[\w\-]+>' => 'questions/faq/viewQuestion',
    'questions/faq/<action:\w+>' => 'questions/faq/<action>',

    // SMS milestones url's
    'my-progress/career-hypothesis' => 'sms/milestone/milestone1',
	'my-progress/country-course-finalisation' => 'sms/milestone/milestone2',
	'my-progress/tests-preparation' => 'sms/milestone/milestone3',
	'my-progress/aspiration-bestfit/<studentId:\d+>/<departmentId:\d+>' => 'sms/milestone/milestone4',
	'my-progress/aspiration-bestfit/<studentId:\d+>' => 'sms/milestone/milestone4',
	'my-progress/aspiration-bestfit' => 'sms/milestone/milestone4',
    'my-progress/ideal-colleges/<studentId:\d+>/<departmentId:\d+>' => 'sms/milestone/milestone5',
	'my-progress/ideal-colleges/<studentId:\d+>' => 'sms/milestone/milestone5',
	'my-progress/ideal-colleges' => 'sms/milestone/milestone5',
    'my-progress/admission-finalisation/step-1' => 'sms/milestone/milestone61',
    'my-progress/admission-finalisation/step-2' => 'sms/milestone/milestone62',
    'my-progress/admission-finalisation/step-3' => 'sms/milestone/milestone63',
    //'my-progress/aspiration-bestfit/<studentId:\d+>/<departmentId:\d+>' => 'sms/milestone/milestone4',
    //'sms/milestone/milestone4/<studentId:\d+>/<departmentId:\d+>' => 'sms/milestone/milestone4',
	//'sms/milestone/milestone4/<studentId:\d+>' => 'sms/milestone/milestone4',
    'sms/milestone/ideal-list-helper/<studentId:\d+>/<type:\w+>/<departmentId:\d+>' => 'sms/milestone/Ms4Helper',
	'sms/milestone/ideal-list-helper/<studentId:\d+>' => 'sms/milestone/Ms4Helper',
    'sms/milestone/ms1Helper/<studentId:\d+>' => 'sms/milestone/ms1Helper',
	'sms/milestone/ms2Helper/<studentId:\d+>' => 'sms/milestone/ms2Helper',
	'sms/milestone/ms61Helper/<studentId:\d+>' => 'sms/milestone/ms61Helper',
	'sms/milestone/ms62Helper/<studentId:\d+>' => 'sms/milestone/ms62Helper',
	'sms/milestone/ms63Helper/<studentId:\d+>' => 'sms/milestone/ms63Helper',
    //milestone urls for pts
    'PtsMilestones/milestone1/<studentId:\d+>' => 'PtsMilestones/milestone1',
	'PtsMilestones/milestone2/<studentId:\d+>' => 'PtsMilestones/milestone2',
	'PtsMilestones/milestone3/<studentId:\d+>' => 'PtsMilestones/milestone3',
    'PtsMilestones/milestone4/<studentId:\d+>' => 'PtsMilestones/milestone4',
    'PtsMilestones/milestone5/<studentId:\d+>' => 'PtsMilestones/milestone5',
	'PtsMilestones/milestone61/<studentId:\d+>' => 'PtsMilestones/milestone61',
    'PtsMilestones/milestone62/<studentId:\d+>' => 'PtsMilestones/milestone62',
    'PtsMilestones/milestone63/<studentId:\d+>' => 'PtsMilestones/milestone63',
    
    // User profile urls
    'profile/high-school-education'=>'profile/tenthClassEducation',
	'profile/choose-board-curriculum'=>'profile/tenthCurriculum',
	'profile/interests-and-hobbies'=>'profile/interesthobbies',
	'profile/edit-interests-and-hobbies'=>'profile/editinteresthobbies',
    
		// course details
    'course-details/<id:\d+>'=>'courseDetails/view',

    //Default url conditions
    'homepage' => 'site/index',
    '<controller:\w+>/<id:\d+>'=>'<controller>/view',
    '<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
    '<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
	'pms/<controller:\w+>/<action:\w+>'=>'pms/<controller>/<action>',
	'pms/<controller:\w+>/view/<ID:\w+>'=>'pms/<controller>/view',
    'di/<controller:\w+>/<action:\w+>'=>'di/<controller>/<action>',
    'di/<controller:\w+>/<action:\w+>/<ID:\d+>'=>'di/<controller>/<action>',
    'expert/<controller:\w+>/<action:\w+>'=>'expert/<controller>/<action>',
    'expert/<controller:\w+>/<action:\w+>/<ID:\d+>'=>'expert/<controller>/<action>',
    'offers/<controller:\w+>/detail/<offerType:\w+>/<ID:\w+>'=>'offers/<controller>/detail',
    'offers/<controller:\w+>/details/<offer_type:\w+>/<id:\w+>'=>'offers/<controller>/details',
    '<controller:\w+>/c/<ID:\w+>'=>'<controller>/c',
    '<controller:\w+>/l/<ID:\w+>'=>'<controller>/l',

    //'university/<keyword:[\w\-]+>/<countryName:[\w\-]+>/<deptName:[\w\-]+>/<seoText:[\w\-]+>/<universityId:[\w\-]+>' => 'university/profile/index',
    'course/<keyword:[\w\-]+>/<countryName:[\w\-]+>/<uniName:[\w\-]+>/<deptName:[\w\-]+>/<seoText:[\w\-]+>/<courseId:[\w\-]+>' => 'university/course/index',
    'test/profile/<action:[\w\-]+>' => 'test/profile/<action>',
    'test/index/getVendorDetails' => 'test/index/getVendorDetails',
    'test/index/recommanded_centers' => 'test/index/recommanded_centers',
    'test/index/getAjaxExamDates' => 'test/index/getAjaxExamDates',
    'test/index/request_call_back' => 'test/index/request_call_back',
    'test/index/register_account' => 'test/index/register_account',
    'test/index/load_centers' => 'test/index/load_centers',
    'test/index/thank_you' => 'test/index/thank_you',
    'test/index/login' => 'test/index/login',
    'test/index/discount_login'=>'test/index/discount_login',
    'test/index/avail_discount' => 'test/index/avail_discount',
    'test/index/avail_discount_form' => 'test/index/avail_discount_form',
    'test/index/success' => 'test/index/success',
    'test/index/avail_discount_register'=>'test/index/avail_discount_register',
    'test/index/joinunivariety' => 'test/index/joinunivariety',
    'test/<seoText:[\w\-]+>/<testId:[\w\-]+>' => 'test/index/index',
    'scholarship/<seoText:[\w\-]+>/<scholarshipId:[\w\-]+>' => 'scholarshipprofile/scholarshipsearch/index',
    'career/<seoText:[\w\-]+>/<careerId:[\w\-]+>' => 'studentcareer/careerpage/index',
    '<keyword:[\w\-]+>/<dept:[\w\-]+>/<seoText:[\w\-]+>/<careerId:[\w\-]+>' => 'studentcareer/careerpage/index',
    'college/search/<action:\w+>' => 'college/search/<action>',
    'college/<seoText:[\w\-]+>/<universityId:[\w\-]+>' => 'university/profile/index',
    'article/<seoText:[\w\-]+>/<id:[\w=\-]+>' => 'articles/article/articlesDetails',
    'articles' => 'articles/article',
    'college/<seoText:[\w\-]+>/<universityId:[\w\-]+>' => 'university/profile/index',
	  'FAQ/discussion-for-<seoText:[\w\-]+>/<universityId:[\w\-]+>' => 'university/profile/discussion',
   'invite/callback/<provider>' => 'invite/callback',
    'invite/auth/<provider>' => 'invite/oauth_destination',);
