<?php 

class StudentActivityFeedBehavior extends CActiveRecordBehavior{
    
    private $_oldattributes = array();
    private $_debug = FALSE;
    
    public function afterSave($event){
        // log only if a valid profile completed student logged in 
        if((int) Yii::app()->session->get('user_type_ref_id') != 1) return TRUE;
        if(!LoginMaster::model()->exists('login_id = :login_id AND is_email_confirmed = 1 AND is_class_status_confirmed = 1 AND is_preference_confirmed = 1', array(':login_id' => Yii::app()->user->id))) return TRUE;
        
        $new_attributes = $this->Owner->getAttributes();
        $old_attributes = $this->getOldAttributes();
        $loggleble_attributes = $this->_get_loggleble_attributes();
        
        $activity_feed = array();
        foreach($loggleble_attributes as $attribute_names => $log_lookup){
            foreach(array_map('trim', explode(',', $attribute_names)) as $attribute_name){
                if(method_exists($this->Owner, $log_lookup)){
                    $log_lookup = call_user_func(array($this->Owner, $log_lookup), $attribute_name);
                }
                if(!$log_lookup) continue;
                
                if(get_class($this->Owner) == 'UserEntranceExam' || get_class($this->Owner) == 'StudentEducation'){
                    $new_attributes['overall_marks'] = number_format($new_attributes['overall_marks'], 2);
                }
                
                $old_value = (!empty($old_attributes)) ? $old_attributes[$attribute_name] : '';
                $new_value = $new_attributes[$attribute_name];
                
                if(!$this->Owner->isNewRecord){
                    if($new_value != $old_value){
                        $activity_feed[trim($log_lookup)] = 'updated';
                        if($this->_debug) echo get_class($this->Owner).': UPDATED '.$attribute_name.' => '.$new_value.PHP_EOL;
                    }
                }else{
                    $_deleted_attribute_values = Yii::app()->cache->get('_deleted_attribute_values_'.Yii::app()->user->id) ? Yii::app()->cache->get('_deleted_attribute_values_'.Yii::app()->user->id) : array();
                    $tmp_array = (is_array($_deleted_attribute_values[get_class($this->Owner).$attribute_name])) ? $_deleted_attribute_values[get_class($this->Owner).$attribute_name] : array();
                    if(!is_object($new_value) && isset($tmp_array[$new_value])){
                        unset($_deleted_attribute_values[$attribute_name][$new_value]);
                        if(empty($_deleted_attribute_values[$attribute_name])) unset($_deleted_attribute_values[$attribute_name]);
                        Yii::app()->cache->set('_deleted_attribute_values_'.Yii::app()->user->id, $_deleted_attribute_values, 2);
                        if($this->_debug) echo get_class($this->Owner).': SKIPED '.$attribute_name.' => '.$new_value.PHP_EOL;
                        continue;
                    }
                    
                    if($this->_debug) echo get_class($this->Owner).': CREATED '.$attribute_name.' => '.$new_value.PHP_EOL;
                    $activity_feed[trim($log_lookup)] = 'created';
                }
            }
        }
        $this->_log_activity_feed($activity_feed);
        return TRUE;
    }
 
    protected function _log_activity_feed($activity_feed){
        
        foreach($activity_feed as $log_lookup => $action_type){
            
            $LookupActivity = LookupActivity::model()->find('slug = :slug', array(':slug' => $log_lookup));
            if(!$LookupActivity) continue;
            
            if(!StudentActivityFeed::model()->exists('user_ref_id = :user_id AND activity_ref_id = :activity_id AND activity_type = :action_type AND added_on = :added_on', array(':user_id' => Yii::app()->user->sub_id, ':activity_id' => $LookupActivity->activity_id, ':action_type' => $action_type, ':added_on' => date('Y-m-d H:i:s')))){
                $StudentActivityFeed = new StudentActivityFeed;
                $StudentActivityFeed->user_ref_id = Yii::app()->user->sub_id;
                $StudentActivityFeed->activity_ref_id = $LookupActivity->activity_id;
                $StudentActivityFeed->activity_type = $action_type;
                $StudentActivityFeed->added_on = date('Y-m-d H:i:s');
                $StudentActivityFeed->save(FALSE);
            }
            //Yii::log(sprintf('StudentActivityFeed %s %s ', $action_type, $log_lookup), CLogger::LEVEL_INFO);
        }
        return TRUE;
    }

    public function afterDelete($event){
        $loggleble_attributes = $this->_get_loggleble_attributes();
        $_deleted_attributes = $this->Owner->attributes;
        $_deleted_attribute_values = array();
        foreach($loggleble_attributes as $attribute_names => $log_lookup){
            foreach(array_map('trim', explode(',', $attribute_names)) as $attribute_name){
                $_deleted_attribute_values[get_class($this->Owner).$attribute_name][$_deleted_attributes[$attribute_name]] = $_deleted_attributes[$attribute_name];
                if($this->_debug) echo get_class($this->Owner).': DELETED '.$attribute_name.' => '.$_deleted_attributes[$attribute_name].PHP_EOL;
            }
        }
        $_old_cache = Yii::app()->cache->get('_deleted_attribute_values_'.Yii::app()->user->id) ? Yii::app()->cache->get('_deleted_attribute_values_'.Yii::app()->user->id): array();
        Yii::app()->cache->set('_deleted_attribute_values_'.Yii::app()->user->id, array_replace_recursive($_old_cache, $_deleted_attribute_values), 2);
        return TRUE;
    }
    
    public function afterFind($event){
        if(get_class($this->Owner) == 'UserEntranceExam' || get_class($this->Owner) == 'StudentEducation'){
            $this->Owner->overall_marks = number_format($this->Owner->overall_marks, 2);
        }
        
        $this->setOldAttributes($this->Owner->getAttributes());
        return TRUE;
    }
 
    public function getOldAttributes(){
        return $this->_oldattributes;
    }
 
    public function setOldAttributes($value){
        $this->_oldattributes = $value;
    }
    
    private function _get_loggleble_attributes(){
        return (method_exists($this->Owner, 'StudentActivityFeedLoggableAttributes')) ?  $this->Owner->StudentActivityFeedLoggableAttributes() : array();
    }
    
}