/*
 * Univariety Ads - jQuery plugin
 *
 * Do not make any changes to this plugin unless really required
 * Plugin author - Naresh Revoori
 * Version:  1.0
 *
 */

// Utility function to create object across all browsers
if ( typeof Object.create !== 'function' ) {
    Object.create = function( obj ) {
        function F() {};
        F.prototype = obj;
        return new F();
    };
}
(function($, window, document, undefined){

    $.fn.renderAds = function(){

        var BannerAd = {
            init: function(elem){
                var self = this;
                self.$elem = $(elem);

                self.adFetcher = ibase_url + 'di/ecrhandler/getbanner';
                self.postData  = self.$elem.data();
                self.postData.page_url = location.href;
                self.postData.ref_url  = document.referrer;

                self.adCount   = self.$elem.data('adcount');
                self.adFor     = self.$elem.data('adfor');
                self.adHeader  = self.$elem.data('adheader');
                self.adtype    = self.$elem.data('adtype');

                if(self.adCount > 0)
                    self.cycle(0);
            },
            cycle: function(i){
                var self = this;
                if (i < this.adCount) {

                    self.fetch().done(function(results){
                        if(!results.error){
                            if(results.hasOwnProperty('ad_heading')) self.adHeader = results.ad_heading;
                            self.buildFrag(results);
                            self.renderBannerData(!i ? true : false);
                            self.cycle(i + 1); // Fetch next banner
                        } else {
                            $('div.dummy_ad_'+self.adtype).show();
                        }
                    })
                }else{
                    self.$elem.find('div.item:last-child').removeClass('border-bottom gutter_vertical');
                }
            },
            fetch: function(){

                return $.post(this.adFetcher, this.postData, null, 'json');

            },
            buildFrag: function(data){
                var self = this;

                self.ad = self.adTemplate().processTemplate(
                    data.ad_link,
                    self.adFor == 'DASHBOARD_PAGE' ? data.ad_img_dashboard : data.ad_img_generic,
                    data.ad_link,
                    data.ad_text,
                    data.ad_sub_text
                );

            },
            renderBannerData: function(constructHeader) {
                var self = this;
                if(constructHeader)
                    self.constructBannerContainer();

                self.$elem.find('div.banner_holder').append(self.ad);
            },
            adTemplate: function(){
                var self = this;

                switch(self.adFor){
                    case "DASHBOARD_PAGE" :
                        return '<div class="row item multi_line small-gutter visible" style="height: 265px">' +
                            '<div style="line-height: 0;" class="row center gutter_vertical visible">' +
                            '<a href="{0}" target="_blank" title="{3}"><img src="{1}" alt="{3}"></a>' +
                            '</div>' +
                            '<div class="row multi_line no-gutter">' +
                            '<h4> <a href="{2}" target="_blank" title="{3}">{3}</a></h4>' +
                            '<h6 class="color-gray">{4}</h6>' +
                            '</div>' +
                        '</div>';
                    break;
                    case "UNIVERSITY_PAGE"  :
                    case "TEST_PAGE"        :
                    case "SCHOLARSHIP_PAGE" :
                        return '<div class="row border-bottom gutter_vertical item">' +
                            '<div style="line-height: 0;" class="row center gutter_vertical visible">' +
                            '<a href="{0}" target="_blank" title="{3}"><img src="{1}" alt="{3}"></a>' +
                            '</div>' +
                            '<div class="row multi_line no-gutter gutter_vertical">' +
                            '<h6> <a href="{2}" target="_blank" title="{3}">{3}</a></h6>' +
                            '<h6 class="color-gray">{4}</h6>' +
                            '</div>' +
                            '</div>';
                    break;
                }
            },
            constructBannerContainer:function(){
                var self = this, bannerContainer;

                switch(self.adFor){

                    case "DASHBOARD_PAGE" :
                        bannerContainer =
                            '<div class="row white pull grid_6 no-clear visible">' +
                                '<div class="row banner_holder">' +
                                '<div class="row multi_line white border-bottom">' +
                                '<h4 class="left">' +
                                '<i class="fa fa-bookmark small_gutter_r fa-lg"></i>' +
                                 self.adHeader +
                                '</h4></div>' +
                                '</div>' +
                                '</div>';
                    break;
                    case "UNIVERSITY_PAGE"  :
                    case "TEST_PAGE"        :
                    case "SCHOLARSHIP_PAGE" :
                    //case "IDEAL_LIST_PAGE"  :
                        self.$elem.prev('div').removeClass('grid_12').addClass('grid_8');
                        bannerContainer =
                            '<div class="grid_4 pull">' +
                                '<div class="row multi_line small-gutter white gutter_vertical banner_holder">' +
                                    '<div class="center gutter_vertical">'+self.adHeader+'</div>' +
                                '</div>' +
                            '</div>';
                    break;
                }

                self.$elem.append(bannerContainer);
            }
        };

        String.prototype.processTemplate = function() {
            var args = arguments;
            return this.replace(/{(\d+)}/g, function(match, number) {
                return typeof args[number] != 'undefined' ? args[number] : match;
            });
        };

        return this.each(function(){
            var banner = Object.create( BannerAd );
            banner.init(this);
        });
    }

    $(function(){
        $('div.bannerAds').renderAds();
    })

})(jQuery, window, document);

function getTextAd(obj, callback){
    var postData = obj || {};
    var adFetcher = ibase_url + 'di/ecrhandler/gettextad';
    postData.page_url = location.href;
    postData.ref_url  = document.referrer;

    var response = null;
    $.ajax(adFetcher, {
        async: false, type: 'POST', dataType : 'json', data : postData,
        success: function(resp){
            typeof callback == 'function' && callback(resp);
        }
    });
}