<section id="section1" class="section">
    <div class="div-inner-gutter-space relative">
        <div class="row border-bottom gutter_vertical relative">
            <div class="titles">
                <h2 class="center uppercase gutter_vertical">Accomplishments</h2>
                <h4 class="center normal gutter_vertical">Check all your educational achievements at one place</h4>
            </div>
        </div>
        <div class="row gutter_vertical">
            <ul class="portfolio-tabs clearfix">
                <?php
                echo CHtml::tag('li', array('class' => 'border-bottom no-inner-gutter'), '&nbsp;');
                echo CHtml::openTag('li', array('class' => 'no-inner-gutter active'));
                echo CHtml::link('Webinars', $this->createUrl('webinars'), array('class' => 'white'));
                echo CHtml::closeTag('li');
                echo CHtml::tag('li', array('class' => 'border-bottom no-inner-gutter'), '&nbsp;');
//                echo CHtml::openTag('li', array('class' => 'gray'));
//                echo CHtml::link('Psychometric Career Test', $this->createUrl('psychometric_career_test'), array('class' => 'gray'));
//                echo CHtml::tag('li', array('class' => 'border-bottom no-inner-gutter', 'style' => 'width: 638px;'), '&nbsp;')
                ?>
            </ul>
        </div>
        <div class="row gray multi_line small-gutter visible clearfix gutter_vertical">
            <div class="left small_gutter_t">Filter by</div>
            <?php
            $this->beginWidget('CActiveForm', array('id' => 'formwebinar', 'enableAjaxValidation' => true, 'method' => 'GET', 'action' => $this->createUrl('webinars')));
            echo CHtml::dropDownList('country', null, $webinars_data['countries'], array('empty' => 'All Countries', 'class' => 'grid_2 left small-right select webinar_filter'));
            echo CHtml::dropDownList('major', null, $webinars_data['departments'], array('empty' => 'All Majors', 'class' => 'left small-right grid_3 select webinar_filter'));
            echo CHtml::dropDownList('year', null, $webinars_data['year'], array('empty' => 'Year', 'class' => 'left small-right select webinar_filter'));
            echo CHtml::dropDownLIst('month', null, $webinars_data['month'], array('empty' => 'month', 'class' => 'left small-right select webinar_filter'));
            
            echo CHtml::image('/app/themes/new_grid_theme/views/layouts/images/icons/ajax_loading_bar.gif', '', array('class' => 'right small_gutter_l small_gutter_t', 'style' => 'display:none', 'id' => 'ajaxloader'));
            
            echo CHtml::textField('event_name', null, array('placeholder' => 'Search', 'class' => 'search tny2 input right grid_3', 'autocomplete' => 'off'));
            $this->endWidget();
            ?>
        </div>

        <?php if (empty($webinars_data['events'])): ?>
            <div class="row multi_line">
                <div class="row center div-inner-gutter-space">
                    <img src="/app/themes/new_grid_theme/views/layouts/images/empty-box.jpg" alt="">
                </div>
                <h4 class="row center ">No data found !</h4>
            </div>
        <?php endif; ?>

        <?php if (!empty($webinars_data['events'])): ?>
            <div class="row multi_line no-gutter" id="webinar_data">
                <table class="grid_view no-hover">
                    <tr class="gray-bg">
                        <th>Title & Major</th>
                        <th>Date & Time</th>
                        <th class="grid_2">Download Certificate</th>
                    </tr>

                    <?php foreach ($webinars_data['events'] as $event_id => $event): ?>
                        <tr>
                            <td>
                                <h4><a href="<?php echo $this->createUrl('/webinar/past',array('event' => $event['Event']['webinar_key'])) ?>"><?php echo $event['Event']['event_title']; ?></a></h4>
                                <div class="color-gray">
                                    <?php 
                                        if($event['Department']){
                                            echo array_shift($event['Department']);
                                            if(!empty($event['Department'])) echo sprintf(' and %d more..', count($event['Department']));
                                        }
                                    ?>
                                </div>
                            </td>
                            <td class="grid_3">
                                <?php
                                    $event_start_date_time = DateTime::createFromFormat('Y-m-d H:i:s', $event['Event']['event_start_time'], new DateTimeZone('UTC'));
                                    $event_start_date_time->setTimeZone(new DateTimeZone($event['Event']['timezone']));
                                    $event_end_date_time = DateTime::createFromFormat('Y-m-d H:i:s', $event['Event']['event_end_time'], new DateTimeZone('UTC'));
                                    $event_end_date_time->setTimeZone(new DateTimeZone($event['Event']['timezone']));
                                    
                                ?>
                                <div class="center"><?php echo $event_start_date_time->format('j\<\s\u\p\>S\<\/\s\u\p\> M, Y'); ?></div>
                                <div class="center">
                                    <?php
                                        echo sprintf('%s to %s %s',$event_start_date_time->format('g:ia'), $event_end_date_time->format('g:ia'), $event_end_date_time->format('T'));
                                    ?>
                                </div>
                            </td>
                            <td class="center">
                                <a href="<?php echo $this->createUrl('download_certificate',array('event' => $event['Event']['webinar_key'])); ?>">
                                    <i class="fa fa-file-pdf-o fa-lg"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
    </div>
</section>

<script type="text/javascript">
    var country_majors = JSON.parse('<?php echo json_encode($webinars_data['country_departments']); ?>');
    var all_majors = JSON.parse('<?php echo json_encode($webinars_data['departments']); ?>');
    $(function(){
        $('#country').live('change',function(){
            $("#major option").remove();
            var _c_id_selected = $('#country').val();
            if(_c_id_selected === ''){
                $("#major").append('<option value="">All Departments</option>');
                for(_d_id in all_majors){
                    $("#major").append('<option value="'+_d_id+'">'+all_majors[_d_id]+'</option>');
                }
                return false;
            }
            var options = country_majors[_c_id_selected];
            var select_country = $("#country option:selected").text();
            $("#major").append('<option value="">All Departments in '+select_country+'</option>');
            for(_d_id in options){
                $("#major").append('<option value="'+_d_id+'">'+options[_d_id]+'</option>');
            }
        });
    });
    
    function update_webinar(){
        ajaxRequest = $('#formwebinar').serialize();
        $.ajax({
            url: '<?php echo $this->createUrl('webinars'); ?>',
            data: ajaxRequest,
            beforeSend: function(){$('.webinar_filter').attr('disabled','disabled'); $('#ajaxloader').show();},
            success: function(data){$('.webinar_filter').removeAttr('disabled'); $('#ajaxloader').hide(); $('#webinar_data').html(data);}
        });
        
    }

    var ajaxUpdateTimeout;
    var ajaxRequest;
    $("input#event_name").keyup(function(){
        if($.trim($(this).val()) === ""){$(this).val(""); return false; };
        clearTimeout(ajaxUpdateTimeout);
        ajaxUpdateTimeout = setTimeout(function(){
            return update_webinar();
        },300);
    });

    $('body').on('change','.webinar_filter',function(){update_webinar();});


</script>
