<?php

class StudentTestModuleDetail extends CFormModel {

    public $user_entrance_exam_module_id;
    public $marks;
    public $entrance_exam_module_entrance_exam_ref_id;
    public $user_entrance_exam_ref_id;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'entrance_exam_module_entrance_exam_ref_id' => 'test module',
        );
    }

    /**
     * Declares the validation rules.
     * 
     */
    public function rules() {
        return array(
            array('marks', 'validateMarks'),
            array('user_entrance_exam_module_id, entrance_exam_module_entrance_exam_ref_id, marks, user_entrance_exam_ref_id', 'safe'),
                //array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'educationDetail'),
        );
    }

    public function validateMarks($attribute, $param) {
      
        if ($this->marks != '') {
            $compositeDetail = EntranceExamModuleEntranceExam::model()->find('entrance_exam_module_entrance_exam_id=' . $this->entrance_exam_module_entrance_exam_ref_id);

            if (!is_numeric($this->marks)) {
                $this->addError($attribute, '<div class="holder"><p>Numbers only</p></div>');
            } elseif ($this->marks <= 0) {
                $this->addError($attribute, '<div class="holder"><p>Maximum score allowed is ' . number_format($compositeDetail->max_marks) . '</p></div>');
            } elseif ($this->marks > $compositeDetail->max_marks) {
                $this->addError($attribute, '<div class="holder"><p>Maximum score allowed is ' . number_format($compositeDetail->max_marks) . '</p></div>');
            }

        }

     }

}
?>