<?php

class StudentEducationProfile extends CFormModel {

    public $present_class;
    public $school_name;
    public $board_equivalent_id;
    public $passout_month;
    public $passout_year;
    public $overall_marks;
    public $overall_marks_gpa;
    public $overall_grades_aa;
    public $overall_grades_a;
    public $overall_grades_b;
    public $overall_grades_c;
    public $overall_grades_d;
    public $overall_grades_e;
    public $overall_grades_f;
    public $overall_grades_g;
    public $overall_points;
    public $student_education_id;
    public $educationDetail;
    public $overall_grade_12 = array();
    public $overall_grade_10 = array();


    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'present_class' => 'Present class',
        );
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('present_class', 'required', 'message' => '<div class="holder"><p>Your present class is required</p></div>'),
            //array('school_name', 'required', 'message' => '<div class="holder"><p>School name cant be blank</p></div>'),
            //array('board_equivalent_id', 'required', 'message' => '<div class="holder"><p>Choose your board of education</p></div>'),

            array('passout_month, passout_year', 'checkPassoutMonthYear'),
            array('school_name', 'validateSchool'),
            //array('overall_marks', 'required', 'message' => '<div class="holder"><p>Overall marks is required</p></div>', 'on' => 'Marks'),
            //array('overall_marks', 'numerical', 'min' => 1, 'max' => 100, 'tooSmall' => '<div class="holder"><p>Marks between 1 - 100 </p></div>', 'tooBig' => '<div class="holder"><p>Marks between 1 - 100</p></div>','message' => '<div class="holder"><p>Numbers only</p></div>', 'on' => 'Marks'),
            array('overall_marks', 'checkOverallMarks', 'on' => 'Marks'),
            array('overall_marks', 'checkOverallMarksGrades', 'on' => 'Grades'),
            //array('overall_marks', 'checkOverallMarks', 'on' => 'Marks,Grades'),
            array('overall_marks', 'required', 'message' => '<div class="holder"><p>Overall marks is required</p></div>', 'on' => 'Marks-GPA10'),
            array('overall_marks', 'numerical', 'min' => 0.6, 'max' => 100, 'tooSmall' => '<div class="holder"><p>Marks between 0.6 - 100</p></div>', 'tooBig' => '<div class="holder"><p>Marks between 1 - 100</p></div>','message' => '<div class="holder"><p>Numbers only</p></div>', 'on' => 'Marks-GPA10'),
            
            array('overall_marks_gpa', 'required', 'message' => '<div class="holder"><p>Overall marks is required</p></div>', 'on' => 'Marks-GPA'),
            array('overall_marks_gpa', 'numerical', 'min' => 0.6, 'max' => 100, 'tooSmall' => '<div class="holder"><p>Marks between 0.6 - 100</p></div>', 'tooBig' => '<div class="holder"><p>Marks between 1 - 100</p></div>','message' => '<div class="holder"><p>Numbers only</p></div>', 'on' => 'Marks-GPA'),
            
            //array('overall_grades_aa, overall_grades_a, overall_grades_b, overall_grades_c, overall_grades_d', 'gradeCheck', 'on' => 'Grades'),
            array('overall_grade_12,overall_grades_b', 'gradeCheck', 'on' => 'Grades'),
            array('overall_points', 'required', 'message' => '<div class="holder"><p>Your overall points are required</p></div>', 'on' => 'Points'),
            array('board_equivalent_id, overall_grades_aa, overall_grades_a, overall_grades_b, overall_grades_c, overall_grades_d, overall_points, passout_year, passout_month', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Your {attribute} should be number</p></div>'),
            array('school_name,student_education_id,overall_grade_12,overall_grade_10,overall_marks', 'safe'),
                //array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'educationDetail'),
        );
    }

    public function gradeCheck($attribute, $params) {
        if($_POST['StudentEducationProfile']['12']['board_equivalent_id'] == 10)
        {
            $flag = 0; $j = 0;
            foreach ($_POST['StudentEducationProfile']['overall_grade_12'] as $key=>$value) {
                if($value) {
                    $flag = 1;
                }
                if($j == 0){
                    $FirstKey = $key;
                }
                $j++;
            }
           if(!$flag){
                $this->addError('overall_grade_12['.$FirstKey.']', '<div class="holder"><p>Your overall grade is required</p></div>');
           }
       }
        if($_POST['StudentEducationProfile']['10']['board_equivalent_id'] == 3)
        {
             $flag = 0; $j = 0;
            foreach ($_POST['StudentEducationProfile']['overall_grade_10'] as $key=>$value) {
                if($value) {
                    $flag = 1;
                }
                if($j == 0){
                    $FirstKey = $key;
                }
                $j++;
            }
            if(!$flag){
                $this->addError('overall_grade_10['.$FirstKey.']', '<div class="holder"><p>Your overall grade is required</p></div>');
            }
        }
        /*if ($this->overall_grades_aa == '' && $this->overall_grades_a == '' && $this->overall_grades_b == '' && $this->overall_grades_c == '' && $this->overall_grades_d == '') {
            $this->addError($attribute, '<div class="holder"><p>Your overall grade is required</p></div>');
        }*/
    }

    public function validateSchool($attribute, $params) {
        $schoolname = $this->school_name;
        $boardId = $this->board_equivalent_id;
        if ($boardId != '' && $schoolname == "") {
            $this->addError($attribute, '<div class="holder"><p>Your school name is required</p></div>');
        }elseif($this->educationDetail == '10' && $this->present_class == '10p' && $schoolname == ""){
            $this->addError($attribute, '<div class="holder"><p>Your school name is required</p></div>');
        }elseif($this->educationDetail == '10' && $this->present_class == '10p' && $boardId == ""){
            $this->addError('board_equivalent_id', '<div class="holder"><p>Your board name is required</p></div>');
        }elseif($this->present_class != '9p' && $schoolname == ""){
            $this->addError('board_equivalent_id', '<div class="holder"><p>Your school name is required</p></div>');
        }if($this->present_class != '9p' && $boardId  == ""){
            $this->addError('board_equivalent_id', '<div class="holder"><p>Your board name is required</p></div>');
        }
    }

    public function checkPassoutMonthYear($attribute, $params) {
        if ($this->educationDetail == '12' || $this->educationDetail == '10' && $this->present_class != '9p') {
            if ($this->passout_month == '') {
                $this->addError('passout_month', '<div class="holder"><p>Your month of passing is required</p></div>');
            } elseif ($this->passout_year == '') {
                $this->addError('passout_year', '<div class="holder"><p>Your Year of passing is required</p></div>');
            }
        } elseif($this->educationDetail == '10' && $this->present_class == '10p' && $this->passout_month == ""){
            $this->addError('passout_month', '<div class="holder"><p>Your month of passing is required</p></div>');
        } elseif ($this->educationDetail == '10' && $this->present_class != '9p') {
            if ($this->passout_month == '' && $this->passout_year != '') {
                $this->addError('passout_month', '<div class="holder"><p>Your month of passing is required</p></div>');
            } elseif ($this->passout_year == '' && $this->passout_month != '') {
                $this->addError('passout_year', '<div class="holder"><p>Year of passing is required</p></div>');
            }
        }
    }

    public function checkOverallMarks() {
        if ($this->overall_marks == '' || empty($this->overall_marks)) {
            $this->addError('overall_marks', '<div class="holder"><p>Overall marks is required</p></div>');
        }
        if($this->overall_marks && !is_numeric($this->overall_marks)){
            $this->addError('overall_marks', '<div class="holder"><p>Numbers only</p></div>');
        }
        if($this->overall_marks && ($this->overall_marks>100 || $this->overall_marks<1)) {
            $this->addError('overall_marks', '<div class="holder"><p>Marks between 1 - 100 </p></div>');
        }
    }

    public function checkOverallMarksGrades() {
        if($this->board_equivalent_id == 28 || $this->board_equivalent_id == 20 || $this->board_equivalent_id == 26){
            if ($this->overall_marks == '' || empty($this->overall_marks)) {
                $this->addError('overall_marks', '<div class="holder"><p>Overall marks is required</p></div>');
            }
            if($this->overall_marks && !is_numeric($this->overall_marks)){
                $this->addError('overall_marks', '<div class="holder"><p>Numbers only</p></div>');
            }
            if($this->overall_marks && ($this->overall_marks>100 || $this->overall_marks<1)) {
                $this->addError('overall_marks', '<div class="holder"><p>Marks between 1 - 100 </p></div>');
            }
        }
    }
}

?>