<?php
class CustomCareerPlan extends CComponent{

    private $studentID = null;
    private $studentObj = null;
    private $graduationDate= null;
    private $signupDate = null;
    private $profileCreationDate = null;
    private $applicationDate = null;
    private $isCountryNMajorValid = false;
    private $testPrepDuration = null;
    private $testMonthYear = null;

    private $planningSteps = null;
    private $completionYear10th = null;
    private $milestoneData = null;


    public function __construct($id){

        $this->studentID = $id;
        $this->studentObj = TblUserMaster::model()->findByPk($this->studentID);
        $this->signupDate = new DateTime(substr($this->studentObj->loginRef->added_on, 0, -8));
        $this->graduationDate = new DateTime($this->studentObj->passout_year.'-'.$this->studentObj->passout_month.'-01');

        $userMileStones = UserMilestoneTracking::model()->findAllByAttributes(array('user_ref_id' => $this->studentID));
        if($userMileStones){
            foreach($userMileStones as $userMileStone){
                $this->milestoneData[$userMileStone->milestone_ref_id] = $userMileStone;
            }
        }
    }


    public function getPlanningSteps(){

        if(in_array($this->studentObj->present_class, array(11, 12))){

            return $this->calculatePlanningStepsFor11n12th();

        }else if(in_array($this->studentObj->present_class, array(9, 10))){

            return $this->calculatePlanningStepsFor9n10th();
        }
    }

    private function getPlanningStepsFor11n12th(){

        $planningSteps = array(
            'finalizecountry'=>array(
                'title'=>'Finalise your country preferences',
                'iconcls' => 'icon-globe', 'colorcls'=> 'color1', 'milestoneid'=>'1'
            ),
            'finalizemajor'=>array(
                'title'=>'Select the courses you want to study',
                'iconcls' => 'icon-book-mark', 'colorcls'=> 'color2',
                'milestoneid'=>'2'
            ),
            'identifytest'=>array(
                'title'=>'Identify Entrance Test to appear for',
                'iconcls' => 'icon-edit-note', 'colorcls'=> 'color3',
                'milestoneid'=>'3'
            ),
            'findinstitute'=>array(
                'title'=>'Find Coaching Institutes for Test Preparation',
                'iconcls' => 'icon-find', 'colorcls'=> 'color4',
                'milestoneid'=>'4'
            ),
            'shortlistcollege'=>array(
                'title'=>'Shortlist Colleges to Apply for',
                'iconcls' => 'icon-shortlist', 'colorcls'=> 'color8',
                'milestoneid'=>'5'
            ),
            'applicationstatus'=>array(
                'title'=>'Update your application status',
                'iconcls' => 'icon-applications', 'colorcls'=> 'color6',
                'milestoneid'=>'6'
            ),
            'admissionstatus'=>array(
                'title'=>'Update your admission status & scholarships',
                'iconcls' => 'icon-upload', 'colorcls'=> 'color7',
                'milestoneid'=>'7'
            ),
        );

        return $planningSteps;
    }


    private function getPlanningStepsFor9n10th(){

        $planningSteps = array(
            'findcareer'=>array(
                'title'=>'Find the best career',
                'iconcls' => 'icon-briefcase', 'colorcls'=> 'color1',
                'milestoneid'=>'8'
            ),
            'selectstream'=>array(
                'title'=>'Select your stream',
                'iconcls' => 'icon-book-mark', 'colorcls'=> 'color5',
                'milestoneid'=>'9'
            ),
            'identifytest'=>array(
                'title'=>'Find Entrance tests',
                'iconcls' => 'icon-edit-note', 'colorcls'=> 'color2',
                'milestoneid'=>'3'
            ),
            'findinstitute'=>array(
                'title'=>'Find Coaching Institutes',
                'iconcls' => 'icon-find', 'colorcls'=> 'color3',
                'milestoneid'=>'4'
            ),
        );

        return $planningSteps;
    }

    private function calculatePlanningStepsFor11n12th(){

        $this->planningSteps = $this->getPlanningStepsFor11n12th();

        $this->profileCreationDate = $this->calcProfileCreationDate();
        $this->isCountryNMajorValid = $this->hasValidCountryNMajor();
        if($this->isCountryNMajorValid){
            $this->testPrepDuration  = $this->calcMaxPrepTimeCombination();
            $this->testMonthYear  = $this->calMonthYearForTestPrepDuration();
        }
        $this->applicationDate = $this->calcApplicationDate();
        /*echo 'signup '.$this->signupDate->format('Y-m-d').'<br>';
        echo 'graduation date '.$this->graduationDate->format('Y-m-d').'<br>';
        echo 'pcd date '.$this->profileCreationDate->format('Y-m-d').'<br>';
        echo 'Appl date '.$this->applicationDate->format('Y-m-d').'<br>';
        echo 'diff (grad - pcd )  '.$this->diffInDays($this->profileCreationDate, $this->graduationDate).' days<br>';*/
        if($this->isCountryNMajorValid){
            /*echo 'TestPrep Time '.$this->testPrepDuration->duration.'<br>';
            echo 'Test date '.$this->testMonthYear->format('Y-m-d').'<br>';*/
        }

        $planningSteps = array();
        if($this->isCountryNMajorValid){
            if($this->testPrepDuration){
                if($this->diffInDays($this->profileCreationDate, $this->testMonthYear) >= $this->testPrepDuration->duration * 30){
                    Yii::log('Plan Flow :: 1');
                    $planningSteps =  $this->stepsForFlow1();
                }else{
                    if($this->diffInDays($this->profileCreationDate, $this->applicationDate) >= 120){
                        Yii::log('Plan Flow :: 2');
                        $planningSteps =  $this->stepsForFlow2();
                    }else{
                        $admissionMonthYear = clone $this->applicationDate;
                        $admissionMonthYear->add(new DateInterval('P2M'));
                        if($this->diffInDays($this->profileCreationDate, $admissionMonthYear) >= 60){
                            Yii::log('Plan Flow :: 3');
                            $planningSteps =  $this->stepsForFlow3();
                        }else{
                            Yii::log('Plan Flow :: 9');
                            $planningSteps =  $this->stepsForFlow9();
                        }
                    }
                }
            }else{
                if($this->diffInDays($this->profileCreationDate, $this->applicationDate) >= 120){
                    Yii::log('Plan Flow :: 5');
                    $planningSteps =  $this->stepsForFlow5();
                }else{
                    Yii::log('Plan Flow :: 4');
                    $planningSteps =  $this->stepsForFlow4();
                }
            }
        }else{

            $customDate = clone $this->graduationDate;
            $customDate->setDate($customDate->format('Y'), 4, 1); // april month
            if($this->diffInDays($this->profileCreationDate, $customDate) >= 365){
                Yii::log('Plan Flow :: 6');
                $planningSteps =  $this->stepsForFlow6();
            }else{
                if($this->diffInDays($this->profileCreationDate, $customDate) >= 120){
                    Yii::log('Plan Flow :: 7');
                    $planningSteps =  $this->stepsForFlow7();
                }else{
                    Yii::log('Plan Flow :: 8');
                    $planningSteps =  $this->stepsForFlow8();
                }
            }
        }

        return array_values($planningSteps);

    }

    private function calculatePlanningStepsFor9n10th(){

        $this->planningSteps = $this->getPlanningStepsFor9n10th();
        $this->completionYear10th = $this->studentObj->passout_year - 2;

        if($this->signupDate < new DateTime(($this->completionYear10th - 1).'-12-01')) {

            Yii::log('Plan Flow 9::1');
            $careerYear = new DateTime(($this->completionYear10th - 1).'-11-30');
            $careerInfo = array('complete'=>$this->hasShortlistedCareers(), 'date'=>$careerYear);
            $this->addPlanningStep('findcareer', $careerInfo);

            $streamYear = new DateTime(($this->completionYear10th - 1).'-12-31');
            $streamInfo = array('complete'=>$this->hasShortlistedStreams(), 'date'=>$streamYear);
            $this->addPlanningStep('selectstream', $streamInfo);

            $testYear = new DateTime($this->completionYear10th.'-03-31');
            $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testYear);
            $this->addPlanningStep('identifytest', $testInfo);

            $vendorYear = clone $testYear;
            $vendorInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorYear);
            $this->addPlanningStep('findinstitute', $vendorInfo);

        }else if($this->signupDate < new DateTime($this->completionYear10th.'-04-01')) {

            Yii::log('Plan Flow 9::2');
            $daysFactor = round($this->diffInDays($this->signupDate, new DateTime(($this->completionYear10th).'-03-31'))/2);

            $careerYear = clone $this->signupDate;
            $careerYear->add(new DateInterval("P".($daysFactor*1)."D"));
            $careerInfo = array('complete'=>$this->hasShortlistedCareers(), 'date'=>$careerYear);
            $this->addPlanningStep('findcareer', $careerInfo);

            $streamYear = clone $this->signupDate;
            $streamYear->add(new DateInterval("P".($daysFactor*2)."D"));
            $streamInfo = array('complete'=>$this->hasShortlistedStreams(), 'date'=>$streamYear);
            $this->addPlanningStep('selectstream', $streamInfo);

            $testYear = new DateTime($this->completionYear10th.'-03-31');
            $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testYear);
            $this->addPlanningStep('identifytest', $testInfo);

            $vendorYear = clone $testYear;
            $vendorInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorYear);
            $this->addPlanningStep('findinstitute', $vendorInfo);

        }else {

            Yii::log('Plan Flow 9::3');
            $careerYear = clone $this->signupDate;
            $careerInfo = array('complete'=>$this->hasShortlistedCareers(), 'date'=>$careerYear);
            $this->addPlanningStep('findcareer', $careerInfo);

            $streamYear = clone $this->signupDate;
            $streamInfo = array('complete'=>$this->hasShortlistedStreams(), 'date'=>$streamYear);
            $this->addPlanningStep('selectstream', $streamInfo);

            $testYear = clone $this->signupDate;
            $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testYear);
            $this->addPlanningStep('identifytest', $testInfo);

            $vendorYear = clone $this->signupDate;
            $vendorInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorYear);
            $this->addPlanningStep('findinstitute', $vendorInfo);

        }

        return array_values($this->planningSteps);
    }

    private function calcProfileCreationDate(){

        $currentTime    = new DateTime('now');
        $currentTime->setTime(0, 0, 0);
        $graduationDate = clone $this->graduationDate;
        $graduationDate->sub(new DateInterval('P24M'));

        return $this->diffInDays($graduationDate, $currentTime) < $this->diffInDays($this->signupDate, $currentTime) ?
            $graduationDate : $this->signupDate;
    }

    private function calcApplicationDate(){

        if($this->isCountryNMajorValid){
            $date = $this->calcDynamicApplicationDate();
        }else{
            $date = clone $this->graduationDate;
            $date->setDate($date->format('Y'), 4, 1); // april month
        }
        return $date;
    }


    private function addPlanningStep($step, $info){

        $dateObj = $info['date'];
        $isComplete = $info['complete'] ? 1 : 0;
        $currentTime    = new DateTime('now');
        $currentTime->setTime(0, 0, 0);
        $timeLeft = !$isComplete ? $this->getTimeLeft($currentTime, $dateObj) : false;
        if($timeLeft){
            list($time, $timeStr, $timeElapsed) = $timeLeft;
            $info['timeleft'] = array($time, $timeStr, $timeElapsed ? 'passed':'left');
        }
        $info['stepname'] = $step;
        $info['complete'] = $isComplete;
        $info['date']     = $dateObj ? $dateObj->format('jS M Y') : null;
        //$info['timestamp'] = $dateObj ? $dateObj->getTimestamp() : null;

        $this->planningSteps[$step] = array_merge($this->planningSteps[$step], $info);

        // save for milestone progress
        $milestoneID = $this->planningSteps[$step]['milestoneid'];
        $this->saveMilestoneData($milestoneID, $isComplete, $dateObj);
    }

    private function saveMilestoneData($milestoneID = 0, $isComplete, $dateObj){

        if(!$milestoneID) return;

        if(isset($this->milestoneData[$milestoneID])){
            // if row info exists in table, update
            $updateNeeded = false;
            $milestoneRow = $this->milestoneData[$milestoneID];
            if(!$isComplete && $milestoneRow->completion_date){
                $milestoneRow->completion_date = new CDbExpression('NULL');
                $updateNeeded = true;
            }elseif($isComplete && !$milestoneRow->completion_date){
                $milestoneRow->completion_date = date('Y-m-d');
                $updateNeeded = true;
            }

            $deadline_date = $dateObj ? $dateObj->format('Y-m-d') : '';
            if($milestoneRow->deadline_date != $deadline_date){
                $milestoneRow->deadline_date = $deadline_date ? $deadline_date : new CDbExpression('NULL');
                $updateNeeded = true;
            }
            if($updateNeeded){
                $milestoneRow->modified_on = date('Y-m-d H:i:s');
                $milestoneRow->save();
            }

        }else {
            // else insert new row info
            $model = new UserMilestoneTracking;
            $model->setAttributes(array(
                'user_ref_id'=>$this->studentID,
                'milestone_ref_id'=> $milestoneID,
                'deadline_date'=> $dateObj ? $dateObj->format('Y-m-d') : new CDbExpression('NULL'),
                'completion_date'=> $isComplete ? date('Y-m-d') : new CDbExpression('NULL'),
                'added_on'=> date('Y-m-d H:i:s'),
            ));
            $model->save();
        }
    }

    private function removePlanningStep($step){

        unset($this->planningSteps[$step]);
    }

    private function stepsForFlow1(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $testMonthYear = clone $this->testMonthYear;
        $testMonthYear->sub(new DateInterval("P{$this->testPrepDuration->duration}M"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $testMonthYear;
        $vendorMonthYear->add(new DateInterval('P2W'));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $appDate = clone $this->applicationDate;
        $collegeMonthYear = $this->diffInDays($vendorMonthYear, $appDate) >= 120 ?
            $appDate->sub(new DateInterval('P4M')) : $appDate->sub(new DateInterval('P1W'));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $appDate = clone $this->applicationDate;
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }


    private function stepsForFlow2(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P1W"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval('P1W'));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $appDate = clone $this->applicationDate;
        $collegeMonthYear = $this->diffInDays($vendorMonthYear, $appDate) >= 120 ?
            $appDate->sub(new DateInterval('P4M')) : $appDate->sub(new DateInterval('P1W'));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $appDate = clone $this->applicationDate;
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow3(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $daysFactor = round($this->diffInDays($this->profileCreationDate, $this->applicationDate)/4);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P".($daysFactor*1)."D"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval("P".($daysFactor*2)."D"));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $collegeMonthYear = clone $this->profileCreationDate;
        $collegeMonthYear->add(new DateInterval("P".($daysFactor*3)."D"));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $applicationMonthYear = clone $this->profileCreationDate;
        $applicationMonthYear->add(new DateInterval("P".($daysFactor*4)."D"));
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$applicationMonthYear);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow4(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $this->removePlanningStep('identifytest');
        $this->removePlanningStep('findinstitute');

        $admissionMonthYear = clone $this->applicationDate;
        $admissionMonthYear->add(new DateInterval('P2M'));
        $daysFactor = round($this->diffInDays($this->profileCreationDate, $admissionMonthYear)/3);

        $collegeMonthYear = clone $this->profileCreationDate;
        $collegeMonthYear->add(new DateInterval("P".($daysFactor*1)."D"));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $applicationMothYear = clone $this->profileCreationDate;
        $applicationMothYear->add(new DateInterval("P".($daysFactor*2)."D"));
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$applicationMothYear);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $admissionMothYear = clone $this->profileCreationDate;
        $admissionMothYear->add(new DateInterval("P".($daysFactor*3)."D"));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$admissionMothYear);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow5(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $this->removePlanningStep('identifytest');
        $this->removePlanningStep('findinstitute');

        $appDate = clone $this->applicationDate;
        $collegeMonthYear = $this->diffInDays($this->profileCreationDate, $appDate) >= 120 ?
            $appDate->sub(new DateInterval('P4M')) : $appDate->sub(new DateInterval('P1W'));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $appDate = clone $this->applicationDate;
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow6(){

        $countryMonthYear = clone $this->profileCreationDate;
        $countryMonthYear->add(new DateInterval("P1M"));
        $countryInfo = array('complete'=> $this->hasValidCountryChoices(), 'date'=>$countryMonthYear);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorMonthYear = clone $this->profileCreationDate;
        $majorMonthYear->add(new DateInterval("P1M"));
        $majorInfo = array('complete'=>$this->hasValidMajorChoices(), 'date'=>$majorMonthYear);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P2M10D"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval("P3M27D"));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $appDate = clone $this->applicationDate;
        $collegeMonthYear = $this->diffInDays($vendorMonthYear, $appDate) >= 120 ?
            $appDate->sub(new DateInterval('P4M')) : $appDate->sub(new DateInterval('P1W'));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $appDate = clone $this->applicationDate;
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }


    private function stepsForFlow7(){

        $countryMonthYear = clone $this->profileCreationDate;
        $countryMonthYear->add(new DateInterval("P1M"));
        $countryInfo = array('complete'=>$this->hasValidCountryChoices(), 'date'=>$countryMonthYear);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorMonthYear = clone $this->profileCreationDate;
        $majorMonthYear->add(new DateInterval("P1M"));
        $majorInfo = array('complete'=>$this->hasValidMajorChoices(), 'date'=>$majorMonthYear);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P2M"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval("P2M10D"));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $appDate = clone $this->applicationDate;
        $collegeMonthYear = $this->diffInDays($vendorMonthYear, $appDate) >= 120 ?
            $appDate->sub(new DateInterval('P4M')) : $appDate->sub(new DateInterval('P1W'));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $appDate = clone $this->applicationDate;
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $appDate = clone $this->applicationDate;
        $appDate->add(new DateInterval('P2M'));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$appDate);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow8(){

        $daysFactor = round($this->diffInDays($this->profileCreationDate, $this->graduationDate)/7);
        $countryMonthYear = clone $this->profileCreationDate;
        $countryMonthYear->add(new DateInterval("P".($daysFactor*1)."D"));
        $countryInfo = array('complete'=>$this->hasValidCountryChoices(), 'date'=>$countryMonthYear);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorMonthYear = clone $this->profileCreationDate;
        $majorMonthYear->add(new DateInterval("P".($daysFactor*2)."D"));
        $majorInfo = array('complete'=>$this->hasValidMajorChoices(), 'date'=>$majorMonthYear);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P".($daysFactor*3)."D"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval("P".($daysFactor*4)."D"));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $collegeMonthYear = clone $this->profileCreationDate;
        $collegeMonthYear->add(new DateInterval("P".($daysFactor*5)."D"));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $applicationMonthYear = clone $this->profileCreationDate;
        $applicationMonthYear->add(new DateInterval("P".($daysFactor*6)."D"));
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$applicationMonthYear);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $admissionMonthYear = clone $this->profileCreationDate;
        $admissionMonthYear->add(new DateInterval("P".($daysFactor*7)."D"));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$admissionMonthYear);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }

    private function stepsForFlow9(){

        $countryInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizecountry', $countryInfo);

        $majorInfo = array('complete'=>true, 'date'=>null);
        $this->addPlanningStep('finalizemajor', $majorInfo);

        $admissionMonthYear = clone $this->applicationDate;
        $admissionMonthYear->add(new DateInterval('P2M'));
        $daysFactor = round($this->diffInDays($this->profileCreationDate, $admissionMonthYear)/5);

        $testMonthYear = clone $this->profileCreationDate;
        $testMonthYear->add(new DateInterval("P".($daysFactor*1)."D"));
        $testInfo = array('complete'=>$this->hasShortlistedTests(), 'date'=>$testMonthYear);
        $this->addPlanningStep('identifytest', $testInfo);

        $vendorMonthYear = clone $this->profileCreationDate;
        $vendorMonthYear->add(new DateInterval("P".($daysFactor*2)."D"));
        $instituteInfo = array('complete'=>$this->hasShortlistedVendors(), 'date'=>$vendorMonthYear);
        $this->addPlanningStep('findinstitute', $instituteInfo);

        $collegeMonthYear = clone $this->profileCreationDate;
        $collegeMonthYear->add(new DateInterval("P".($daysFactor*3)."D"));
        $collegeInfo = array('complete'=>$this->hasShortlistedColleges(), 'date'=>$collegeMonthYear);
        $this->addPlanningStep('shortlistcollege', $collegeInfo);

        $applicationMonthYear = clone $this->profileCreationDate;
        $applicationMonthYear->add(new DateInterval("P".($daysFactor*4)."D"));
        $applicationInfo = array('complete'=>$this->hasApplicationStatusChanged(), 'date'=>$applicationMonthYear);
        $this->addPlanningStep('applicationstatus', $applicationInfo);

        $admissionMonthYear = clone $this->profileCreationDate;
        $admissionMonthYear->add(new DateInterval("P".($daysFactor*5)."D"));
        $admissionInfo = array('complete'=>$this->hasAdmissionStatusChanged(), 'date'=>$admissionMonthYear);
        $this->addPlanningStep('admissionstatus', $admissionInfo);

        return $this->planningSteps;
    }


    private function hasValidCountryNMajor(){

        return $this->hasValidCountryChoices() && $this->hasValidMajorChoices();
    }

    private function getStudentPrefCountriesNDepartments(){

        $prefCountries = $this->getStudentPrefCountries();
        $prefDepartments = $this->getStudentPrefDepartments();
        return array($prefCountries, $prefDepartments);
    }

    public function getStudentPrefCountries(){

        $prefCountrySql = "SELECT GROUP_CONCAT(DISTINCT country_ref_id) AS countries FROM student_preferred_country WHERE user_ref_id='".$this->studentID."' AND not_sure=0 ORDER BY preference_order";
        $prefCountryRes = Yii::app()->db->createCommand($prefCountrySql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        return $prefCountryRes && $prefCountryRes->countries ? explode(',', $prefCountryRes->countries) : false;
    }

    public function getStudentPrefDepartments(){

        $prefDeptSql = "SELECT GROUP_CONCAT(DISTINCT main_dept_ref_id) AS depts FROM student_preferred_department WHERE user_ref_id='".$this->studentID."' AND not_sure=0 ORDER BY preference_order";
        $prefDeptRes = Yii::app()->db->createCommand($prefDeptSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        return $prefDeptRes && $prefDeptRes->depts ? explode(',', $prefDeptRes->depts) : false;
    }

    private function calcMaxPrepTimeCombination(){

        list($prefCountries, $prefDepartments) = $this->getStudentPrefCountriesNDepartments();
        $Sql = "SELECT country_ref_id AS countryID, department_ref_id AS deptID, duration FROM cp_test_duration WHERE country_ref_id IN (".implode(',', $prefCountries).") AND department_ref_id IN (".implode(',', $prefDepartments).") ORDER BY duration DESC LIMIT 1";
        $data = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        if(!$data){
            foreach($prefCountries as $country){
                foreach($prefDepartments as $dept){
                    if(!in_array($country, array(100, 224, 223, 12, 190, 36, 154, 222))){
                        $data = new stdClass();
                        $data->countryID = $country;
                        $data->deptID = $dept;
                        $data->duration = 1;
                        break 2;
                    }
                }
            }
        }
        return $data;
    }

    private function calcDynamicApplicationDate(){

        list($prefCountries, $prefDepartments) = $this->getStudentPrefCountriesNDepartments();
        $Sql = "SELECT * FROM cp_uni_application_month WHERE country_ref_id IN (".implode(',', $prefCountries).") AND department_ref_id IN (".implode(',', $prefDepartments).")";
        $data = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        if($data){
            $timeStamps = array();
            foreach($data as $row){
                $date = clone $this->graduationDate;
                $date->setDate($date->format('Y') + $row->cp_year, $row->cp_month, 1);
                $timeStamps[] = $date->getTimestamp();
            }
            rsort($timeStamps);
            $date = new DateTime();
            $date->setTimestamp($timeStamps[0]);
        }else {
            $date = clone $this->graduationDate;
            $date->setDate($date->format('Y'), 4, 1); // april month
        }
        return $date;
    }

    private function calMonthYearForTestPrepDuration(){

        $testPrepInfo = $this->testPrepDuration;
        $date = clone $this->graduationDate;

        $Sql = "SELECT * FROM cp_test_monthyear WHERE country_ref_id ='".$testPrepInfo->countryID."' AND department_ref_id ='".$testPrepInfo->deptID."'";
        $row = Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        if($row){
            $date->setDate($date->format('Y') + $row->cp_year, $row->cp_month, 1);
        }else if(!in_array($testPrepInfo->countryID, array(100, 224, 223, 12, 190, 36, 154, 222))){
            $date->setDate($date->format('Y'), 3, 1); // March month
        }else{
            $date = false;
        }

        return $date;
    }

    public function hasValidCountryChoices(){

        $prefCountries = $this->getStudentPrefCountries();
        if(!$prefCountries) return false;

        if(count($prefCountries) == 1) return true;

        $hasValidatedCountriesSql = "SELECT 1 FROM profile_verification_score WHERE user_ref_id = '".$this->studentID."' AND pref_country_score='1'";
        $hasValidatedCountries =  Yii::app()->db->createCommand($hasValidatedCountriesSql)->queryScalar();
        if($hasValidatedCountries) return true;

        Yii::import('application.components.profilevalidation.*');
        $country_obj = new ValidateCountry();
        $country_obj->userId = $this->studentID;
        return $country_obj->validateCountry() ? true : false;
    }

    public function hasValidMajorChoices(){

        $prefDepartments = $this->getStudentPrefDepartments();
        if(!$prefDepartments) return false;

        if(count($prefDepartments) == 1) return true;

        $hasValidatedMajorsSql = "SELECT 1 FROM profile_verification_score WHERE user_ref_id = '".$this->studentID."' AND pref_dept_score='1'";
        $hasValidatedMajors =  Yii::app()->db->createCommand($hasValidatedMajorsSql)->queryScalar();
        if($hasValidatedMajors) return true;

        Yii::import('application.components.profilevalidation.*');
        $conditions_obj = new Conditions();
        $conditions_obj->userId =  $this->studentID;
        return $conditions_obj->validateDepartment() ? true : false;
    }

    public function hasShortlistedCareers(){

        $Sql = "SELECT 1 FROM student_preferred_career spc
        LEFT JOIN lookup_career lc ON lc.career_id = spc.career_ref_id
        WHERE spc.not_sure='0' AND spc.user_ref_id = '".$this->studentID."' AND spc.parent_choice= IF( EXISTS (
        SELECT 1 FROM student_preferred_career WHERE user_ref_id = spc.user_ref_id AND not_sure='0'
         AND parent_choice='N'), 'N', 'Y') AND (lc.career_name IS NULL OR lc.career_name != 'Others')
         ORDER BY spc.added_on DESC";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function hasShortlistedStreams(){

        $Sql = "SELECT 1 FROM student_preferred_subject WHERE user_ref_id='".$this->studentID."'
        AND student_subject_ref_id IS NOT NULL AND type='Plan'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }


    public function hasShortlistedTests(){

        $Sql = "SELECT 1 FROM user_entrance_exam uee
        JOIN entrance_exam ee ON ee.entrance_id = uee.entrance_exam_ref_id
        WHERE ee.is_active=1 AND uee.shortlist_status=1 AND uee.user_ref_id='".$this->studentID."'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function hasShortlistedVendors(){

        $Sql = "SELECT 1 FROM tbl_user_master WHERE user_id='".$this->studentID."' AND need_coaching='N'";
        $coaching_not_needed = Yii::app()->db->createCommand($Sql)->queryScalar();
        if($coaching_not_needed) return true;

        $Sql = "SELECT 1 FROM student_shortlist_vendor ssv
        JOIN vendor_centre vc ON vc.vendor_centre_id = ssv.vendor_centre_ref_id
        WHERE vc.is_active=1 AND ssv.user_ref_id='".$this->studentID."'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function hasShortlistedColleges(){

        $Sql = "SELECT COUNT(*) > 4 FROM student_shortlist_university ssu
        JOIN tbl_university_master tum ON tum.uni_id = ssu.uni_ref_id
        WHERE tum.is_active='Y' AND ssu.shortlist_status != 'Reject' AND ssu.user_ref_id='".$this->studentID."'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function hasApplicationStatusChanged(){

        $Sql = "SELECT COUNT(*) > 1 FROM student_shortlist_university ssu
        JOIN tbl_university_master tum ON tum.uni_id = ssu.uni_ref_id
        WHERE tum.is_active='Y' AND ssu.shortlist_status IN ('Applied', 'WillApply')
        AND ssu.user_ref_id='".$this->studentID."'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function hasAdmissionStatusChanged(){

        $Sql = "SELECT COUNT(*) > 0 FROM student_outplacement_university sou
        JOIN student_shortlist_university ssu ON ssu.uni_ref_id = sou.uni_ref_id AND sou.user_ref_id = ssu.user_ref_id
        JOIN tbl_university_master tum ON tum.uni_id = ssu.uni_ref_id
        WHERE tum.is_active='Y' AND ssu.shortlist_status IN ('Applied', 'WillApply')
        AND sou.status=0 AND sou.user_ref_id='".$this->studentID."'";
        return Yii::app()->db->createCommand($Sql)->queryScalar();
    }

    public function getTimeLeft($time1, $time2){

        $interval = $time1->diff($time2);
        /*if($interval->y)
            return array($interval->y, 'year'.($interval->y>1 ? 's':''), $interval->invert);
        if($interval->m)
            return array($interval->m, 'month'.($interval->m>1 ? 's':''), $interval->invert);*/
        if($interval->days){
            return array($interval->days, 'day'.($interval->days>1 ? 's':''), $interval->invert);
        }else{
            return array('0', 'days', 0);
        }
    }

    private function diffInDays($time1, $time2){

        $interval = $time1->diff($time2);
        return $interval->format("%r%a") > 0 ? $interval->days : 0;
    }

}