<?php

/**
 * @author Shiva <shiva.dharana@univariety.com>
 * @package application.modules.sms.models.base
 *
 * BaseUserMilestoneSuggestion is autogenerate by UniModel generator
 *
 * This is the model class for table "user_milestone_suggestion".
 *
 * The followings are the available columns in table 'user_milestone_suggestion':
 * @property string $user_milestone_suggestion_id
 * @property string $user_ref_id
 * @property integer $milestone_id
 * @property string $suggestion
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LoginMaster $addedBy
 */
class BaseUserMilestoneSuggestion extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return UserMilestoneSuggestion the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'user_milestone_suggestion';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
        array('user_ref_id, milestone_id, added_on', 'required'),
        array('milestone_id', 'numerical', 'integerOnly'=>true),
        array('user_ref_id, added_by', 'length', 'max'=>10),
        array('suggestion', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('user_milestone_suggestion_id, user_ref_id, milestone_id, suggestion, added_by, added_on', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
			'user_milestone_suggestion_id' => 'User Milestone Suggestion',
			'user_ref_id' => 'User Ref',
			'milestone_id' => 'Milestone',
			'suggestion' => 'Suggestion',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('user_milestone_suggestion_id',$this->user_milestone_suggestion_id,true);
        $criteria->compare('user_ref_id',$this->user_ref_id,true);
        $criteria->compare('milestone_id',$this->milestone_id);
        $criteria->compare('suggestion',$this->suggestion,true);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('added_on',$this->added_on,true);

        return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
        ));
    }
}