<?php
Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/colorbox.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.colorbox.js");

$this->breadcrumbs=array(
	'Manage',
);

Yii::app()->clientScript->registerScript('search',"

    var delay = (function(){
      var timer = 0;
      return function(callback, ms){
        clearTimeout (timer);
        timer = setTimeout(callback, ms);
      };
    })();

    $('#searchUni').keyup(function() {

       var val = $(this).val();
        delay(function(){
          $.fn.yiiGridView.update('di-grid', {  data: { 'Di[uni_name]' : val }   });
        }, 500 );
    });

    ");
?>

<!-- Di Navigation -->
<table width="100%" cellspacing="0" cellpadding="0" border="0">
	<tbody><tr>
    <td width="50%" align="left">
    <h1>Manage DI Accounts</h1>
    </td>
	<td width="50%" align="right">
        &nbsp;
        <a href="<?php echo Yii::app()->createUrl('/diadmin/di/guestuniversity'); ?>" class="button"
           style="color: #FFF !important;">Send Criteria Form</a>
        &nbsp;
        <a href="<?php echo Yii::app()->createUrl('/diadmin/di/create'); ?>" class="button"
           style="color: #FFF !important;">Create DI Account</a>
	</td>
	</tr>
	</tbody>
</table>
<input type="text" id='searchUni' class="input-xlarge search-icon" style="width: 350px; float:left; margin-left: 15px" placeholder="Search by university name">
<!--// Di Navigation -->
<?php if(Yii::app()->user->hasFlash('updated')):?>
<div class="flash-success">
    <?php echo Yii::app()->user->getFlash('updated'); ?>
</div>
<?php endif;?>

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'di-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
        array(
		'name'=>'uni_ref_id',
		'header'=>'University',
		'value'=>'$data->uniRef->uni_name',
        'filter'=>DiHelper::getUsedUniversityList(),
		),
        array(
            'header'=>'Criteria Matches',
            'type' => 'raw',
            'value' => function($data){
                return CHtml::link( "View Students", Yii::app()->createUrl('disignup/l/'.MD5('univariety1@#'.$data->diUsers[0]->loginRef->username.'univariety1@#')), array ("target" => "_blank"));
            }
        ),
        array(
		'name'=>'di_type_ref_id',
		'header'=>'Di Type',
		'value'=>'$data->diTypeRef->type',
        'filter'=>DiHelper::getDiTypeList(),
		),
		array(
		'name'=>'currency_ref_id',
		'header'=>'Currency',
		'value'=>'$data->currencyRef->currency_code',
        'filter'=>DiHelper::getCurrencyList(),
		),
		array(
            'name' => 'credit_limit',
            'htmlOptions' => array(
                'style' => 'width: 50px; text-align: center;',
            ),
        ),
		array(
		'name'=>'is_active',
		'value'=>'($data->is_active==1) ? "Yes" : "No"',
        'filter'=>array(0=>"No",1=>"Yes"),
		),
        array(
            'name'=>'consumed',
            'header'=>'Last Month Consumed',
            'value'=>function($data){
                $lastMonth = date("m", strtotime("-1 months"));
                $lastMonthYear = date("Y", strtotime("-1 months"));
                $startDate = $lastMonthYear.'-'.$lastMonth.'-01 00:00:00';
                $endDate = $lastMonthYear.'-'.$lastMonth.'-31 23:59:59';
                $consumedAmount = AccountSummaryHelper::sumDiCashDebits($data->di_id,$endDate) - AccountSummaryHelper::sumDiCashDebits($data->di_id,$startDate);
                return number_format($consumedAmount, 2) + 0;
            },
            'filter'=>false,
        ),
        array(
            'header' => 'Moderators',
            'type' => 'raw',
            'htmlOptions' => array(
                'style' => 'width: 100px; text-align: center;',
            ),
            'value' => 'CHtml::link( "Moderators(".DiHelper::countDiModerators($data->di_id).")", Yii::app()->createUrl("/diadmin/moderators/index",array("di_id"=>$data->di_id)))',
        ),
		array(
			'header' => 'Manage:<br> -Product Cost <br>-Free Credits <br>-Paid Credits ',
			'type' => 'raw',
			'htmlOptions' => array(
				'style' => 'width: 100px; text-align: center;',
			),
			'value' => 'CHtml::link( "Manage", Yii::app()->createUrl("/diadmin/di/managepricing",array("id"=>$data->di_id)))',
		),
		array(
			'class'=>'CButtonColumn',
			'template'=>'{view}&nbsp;{update}&nbsp;{profile}&nbsp;{changePass}&nbsp;{sendLoginMail}&nbsp;{reviewUnfreeze}',
			'buttons'=>array
			(
				'changePass' => array
				(
					'label'=>'Change Password',
					'imageUrl'=>Yii::app()->theme->baseUrl.'/images/change-pass.png',
					'url'=>'Yii::app()->createUrl("/diadmin/di/changepassword", array("id"=>$data->di_id))',
				),
                'sendLoginMail' => array(
                    'label'=>'Send Login Email',
                    'imageUrl'=>Yii::app()->theme->baseUrl.'/images/send_email.png',
                    'url'=>'Yii::app()->createUrl("/diadmin/di/sendloginemail", array("id"=>$data->diUsers[0]->di_user_id))',
                    //'visible' => '($data->diUsers[0]->is_login_email_sent != 1)',
                    'click' => 'function(){ return confirm("Are you sure, you want to send login email?")}'
                ),
				'profile' => array
				(
					'label'=>'User profile settings',
					'imageUrl'=>Yii::app()->theme->baseUrl.'/images/small_icons/user_suit.png',
					'url'=>'Yii::app()->createUrl("/diadmin/di/updateprofile", array("id"=>$data->di_id))',
				),
                'reviewUnfreeze' => array
                (
                    'label'=>'Unblock review restriction',
                    'imageUrl'=>Yii::app()->theme->baseUrl.'/images/small_icons/lock_edit.png',
                    'visible' => '$data->review_unfreeze_scheduled_time ? true : false',
                    'url'=>'Yii::app()->createUrl("/diadmin/di/reviewunfreeze", array("id"=>$data->di_id))',
                    'options'=>array("class"=>"unfreeze_review"),
                ),
			),
            'htmlOptions' => array(
                'style' => 'width: 125px;',
            ),
		),

	),
	//'htmlOptions'=>array('style'=>'text-align:center'),
));

?>
<script>
    $(function(){
        $('body').on('click', '.unfreeze_review', function(e){
            e.preventDefault();
            $.colorbox({
                href: $(this).attr('href'),
                width:"800px"
            })
        });
    })
</script>