<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDi is autogenerate by UniModel generator
 *
 * This is the model class for table "di".
 *
 * The followings are the available columns in table 'di':
 * @property integer $di_id
 * @property integer $uni_ref_id
 * @property integer $di_type_ref_id
 * @property integer $currency_ref_id
 * @property integer $credit_limit
 * @property string $uniname_invoice
 * @property string $eoi_expires_in
 * @property string $is_autobuy_active
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 * @property string $is_test
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupCurrency $currencyRef
 * @property LookupDiType $diTypeRef
 * @property LoginMaster $modifiedBy
 * @property TblUniversityMaster $uniRef
 * @property DiBannerCampaign[] $diBannerCampaigns
 * @property DiBuyFollowupEmail[] $diBuyFollowupEmails
 * @property DiCashCredit[] $diCashCredits
 * @property DiCashDebit[] $diCashDebits
 * @property DiEmailCampaign[] $diEmailCampaigns
 * @property DiEmailCampaignSettings[] $diEmailCampaignSettings
 * @property DiInvoice[] $diInvoices
 * @property DiInvoiceTransaction[] $diInvoiceTransactions
 * @property DiProduct[] $diProducts
 * @property DiProductCredit[] $diProductCredits
 * @property DiProductDebit[] $diProductDebits
 * @property DiPurchaseProfile[] $diPurchaseProfiles
 * @property DiStudentSelection[] $diStudentSelections
 * @property DiUser[] $diUsers
 */
class BaseDi extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Di the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, di_type_ref_id, currency_ref_id, added_by, added_on', 'required'),
			array('uni_ref_id, di_type_ref_id, currency_ref_id, credit_limit, is_active', 'numerical', 'integerOnly'=>true),
			array('uniname_invoice', 'length', 'max'=>150),
			array('eoi_expires_in', 'length', 'max'=>5),
			array('is_autobuy_active, is_test', 'length', 'max'=>1),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_id, uni_ref_id, di_type_ref_id, currency_ref_id, credit_limit, uniname_invoice, eoi_expires_in, is_autobuy_active, is_active, added_by, added_on, modified_by, modified_on, is_test', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'diTypeRef' => array(self::BELONGS_TO, 'LookupDiType', 'di_type_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'diBannerCampaigns' => array(self::HAS_MANY, 'DiBannerCampaign', 'di_ref_id'),
			'diBuyFollowupEmails' => array(self::HAS_MANY, 'DiBuyFollowupEmail', 'di_ref_id'),
			'diCashCredits' => array(self::HAS_MANY, 'DiCashCredit', 'di_ref_id'),
			'diCashDebits' => array(self::HAS_MANY, 'DiCashDebit', 'di_ref_id'),
			'diEmailCampaigns' => array(self::HAS_MANY, 'DiEmailCampaign', 'di_ref_id'),
			'diEmailCampaignSettings' => array(self::HAS_MANY, 'DiEmailCampaignSettings', 'di_ref_id'),
			'diInvoices' => array(self::HAS_MANY, 'DiInvoice', 'di_ref_id'),
			'diInvoiceTransactions' => array(self::HAS_MANY, 'DiInvoiceTransaction', 'di_ref_id'),
			'diProducts' => array(self::HAS_MANY, 'DiProduct', 'di_ref_id'),
			'diProductCredits' => array(self::HAS_MANY, 'DiProductCredit', 'di_ref_id'),
			'diProductDebits' => array(self::HAS_MANY, 'DiProductDebit', 'di_ref_id'),
			'diPurchaseProfiles' => array(self::HAS_MANY, 'DiPurchaseProfile', 'di_ref_id'),
			'diStudentSelections' => array(self::HAS_MANY, 'DiStudentSelection', 'di_ref_id'),
			'diUsers' => array(self::HAS_MANY, 'DiUser', 'di_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_id' => 'Di',
			'uni_ref_id' => 'Uni Ref',
			'di_type_ref_id' => 'Di Type Ref',
			'currency_ref_id' => 'Currency Ref',
			'credit_limit' => 'Credit Limit',
			'uniname_invoice' => 'Uniname Invoice',
			'eoi_expires_in' => 'Eoi Expires In',
			'is_autobuy_active' => 'Is Autobuy Active',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
			'is_test' => 'Is Test',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_id',$this->di_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('di_type_ref_id',$this->di_type_ref_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('credit_limit',$this->credit_limit);
		$criteria->compare('uniname_invoice',$this->uniname_invoice,true);
		$criteria->compare('eoi_expires_in',$this->eoi_expires_in,true);
		$criteria->compare('is_autobuy_active',$this->is_autobuy_active,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('is_test',$this->is_test,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}