<?php 

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.modules.diadmin.models.base.BaseDiCashCredit');

class DiCashCredit extends BaseDiCashCredit
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('di_ref_id, amount, added_by', 'required'),
            array('di_ref_id,amount', 'numerical', 'integerOnly'=>true),
            array('amount, added_by, modified_by', 'length', 'max'=>10),
            array('modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('di_cash_credit_id, di_ref_id, currency_ref_id, amount, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
        );
    }
	
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'diUserRefund' => array(self::HAS_ONE, 'DiUserRefund', 'di_cash_credit_ref_id'),
		);
	}
	
    /*
     *  function retrieve the data with relation table
     */

    public function getDi_ref_idData($data,$row){
        return $data->diRef->diUsers[0]->first_name.' '.$data->diRef->diUsers[0]->last_name;
        //return $data->diRef->uniRef->uni_name;
    }

    /*
     *  function returning currency value
     *
     */
    public function getCurrency_ref_idData($data,$row){
        return $data->currencyRef->currency_code;
    }

    public function searchCustom()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.
        $di_id  =   Yii::app()->getRequest()->getQuery('di_id');
        $criteria=new CDbCriteria;

        $criteria->compare('di_cash_credit_id',$this->di_cash_credit_id,true);
        $criteria->compare('di_ref_id',$di_id);
        $criteria->compare('currency_ref_id',$this->currency_ref_id);
        $criteria->compare('amount',$this->amount,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'di_cash_credit_id' => 'Di Cash Credit',
            'di_ref_id' => 'DI',
            'currency_ref_id' => 'Currency',
            'amount' => 'Amount',
            'added_on' => 'Added On',
            'added_by' => 'Added By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
        );
    }

}