<?php 

class DiController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/admin';
    public $aEoiExpires = array('15' => '15 Days', '30' => '30 Days', '45' => '45 Days', '60' => '60 Days');
	//public $defaultAction	=	'admin';
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','managepricing','sendloginemail','autocompleteuni','changepassword'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model			=	new Di;
		$DiUser 		= 	new DiUser;
		$login			=	new LoginMaster('register');
		$DiUserDepart	= 	new DiUserDepartment;

		$model->is_active = 1; // set default active

        //Set default user type Admin
        $DiUser->user_type = "Admin";
		
		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation(array($model,$login,$DiUser,$DiUserDepart));
		
		if(isset($_POST['Di']))
		{

			$uni_name					=	$_POST['uni_ref_id'];
			$data						=	TblUniversityMaster::model()->exists("uni_name= :x",array(':x'=>$uni_name)); 
			
				$model->uni_ref_id			=	$_POST['uni_ref_id'];
				$model->attributes			=	$_POST['Di'];
				$model->added_on			=	new CDbExpression('NOW()');
				$DiUser->attributes			=	$_POST['DiUser'];
				$login->attributes			=	$_POST['LoginMaster'];
				$DiUserDepart->attributes	=	$_POST['DiUserDepartment'];
				$departmentArray			=	$_POST['DiUserDepartment']['main_department_ref_id'];						
			if($data){
				$modelValid 				=	$model->validate();
				$DiUserValid 				=	$DiUser->validate();
				$DiUserDepartValida 		=	$DiUserDepart->validate();
				
				$pass_word					=	DiHelper::genPassword($length = 10);
				$login->pass_word			=	$pass_word;
				$login->user_type_ref_id	=	3; #DI type lookup_user_type
				$login->scenario 			=	'register';
				$LoginValid 				=	$login->validate();
						
					if($modelValid && $LoginValid && $DiUserValid && $DiUserDepartValida) {
					
						if($model->save()) {		# Saving data in `di` Table
						
							$login->is_active			=	$model->is_active;
							if($login->save()) {	# Saving data in `login_master` Table
								$DiUser->is_active		=	$model->is_active;	
								$DiUser->added_on		=	$model->added_on;
								$DiUser->added_by		=	$model->added_by;
								$DiUser->modified_on	=	$model->modified_on;
								$DiUser->modified_by	=	$model->modified_by;
								$DiUser->di_ref_id		=	$model->di_id;
								$DiUser->login_ref_id	=	$login->login_id;
								DiHelper::RbacInsert($login->login_id,'DI');
								if($DiUser->save()){	# Saving data in `di_user` Table
								
									Yii::import('application.modules.counselorsuggest.components.*');
									$PmsToDiUserProcess = new PmsToDiUserProcess;
									$PmsToDiUserProcess->diUserId = $DiUser->di_user_id;
									$PmsToDiUserProcess->init();
									$PmsToDiUserProcess->assignPmsToDiUser();
								
									// Save fresh copy for departments
									$this->saveDepartments($departmentArray,$DiUser);
									$data           =    array(
										'username'          =>   $login->username,
										'password'          =>   $pass_word,
										'UniversityName'    =>   $_POST['uni_ref_id'],
										'FirstName'         =>   $DiUser->first_name,
										'LastName'          =>   $DiUser->last_name,
										'di_id'             =>   $model->di_id,
									);

                                    // Add credits code starts
                                    $DiID = $model->di_id;
                                    $currencyID = $model->currency_ref_id ? $model->currency_ref_id : 2;
                                    $pricingBuyModel = LookupProduct::model()->findByAttributes(array('product_shortcode' => 'Buy'));
                                    $DiProduct = new DiProduct;
                                    $DiProduct->setAttributes(array(
                                        'di_ref_id' => $DiID,
                                        'product_ref_id' => $pricingBuyModel->product_id,
                                        'currency_ref_id'   => $currencyID,
                                        'price' => '25',
                                        'start_date' => date('Y-m-d H:i:s'),
                                        'end_date' => date('Y-m-d H:i:s', strtotime('+1 years')),
                                        'is_active' => '1',
                                        'added_by'   => $model->added_by,
                                        'added_on'   => date('Y-m-d H:i:s'),
                                    ), false);
                                    $DiProduct->save(false);

                                    $pricingEOIModel = LookupProduct::model()->findByAttributes(array('product_shortcode' => 'EOI'));
                                    $DiProduct = new DiProduct;
                                    $DiProduct->setAttributes(array(
                                        'di_ref_id' => $DiID,
                                        'product_ref_id' => $pricingEOIModel->product_id,
                                        'currency_ref_id'   => $currencyID,
                                        'price' => '0.1',
                                        'start_date' => date('Y-m-d H:i:s'),
                                        'end_date' => date('Y-m-d H:i:s', strtotime('+1 years')),
                                        'is_active' => '1',
                                        'added_by'   => $model->added_by,
                                        'added_on'   => date('Y-m-d H:i:s'),
                                    ), false);
                                    $DiProduct->save(false);

                                    $DiProductCredit = new DiProductCredit;
                                    $DiProductCredit->setAttributes(array(
                                        'di_ref_id' => $DiID,
                                        'product_ref_id' => $pricingEOIModel->product_id,
                                        'credit_count' => '400',
                                        'added_by'   => $model->added_by,
                                        'added_on'   => date('Y-m-d H:i:s'),
                                    ), false);
                                    $DiProductCredit->save(false);
                                    // Add credits code ends

                                    Yii::app()->user->setFlash('updated',"Congratulations! DI account has been created successfully.");
									//self::actionSendmail($data); # to send mail
									$this->redirect(array('admin'));
								}	
							}
						}
					}
			}else{
				Yii::app()->user->setFlash('error','Invalid Univarsity');
			}// if all model valid	
			
		}

		$this->render('create',array(
			'model'=>$model,
			'DiUser'=>$DiUser,
			'login'=>$login,
			'DiUserDepart'=>$DiUserDepart,
		));
	}

    public function actionSendLoginEmail(){

        $diUserID = Yii::app()->request->getParam('id', 0);

        $Sql = "SELECT du.*, lm.username, tum.uni_name FROM di_user du
            INNER JOIN `login_master` lm ON lm.login_id = du.login_ref_id
            INNER JOIN di ON di.di_id = du.di_ref_id
            INNER JOIN `tbl_university_master` tum ON tum.uni_id = di.uni_ref_id
            WHERE du.di_user_id = '".$diUserID."'";

        $command = Yii::app()->db->createCommand($Sql);
        $command->setFetchMode(PDO::FETCH_OBJ);
        $cmdRes  = $command->queryRow();
        if(!$cmdRes) return;

        $emailInfo = (object) array(
            'contact_name' => $cmdRes->first_name.' '.$cmdRes->last_name,
            'contact_email'=> $cmdRes->username,
            'uni_name'=> $cmdRes->uni_name,
        );

        // generates a random password
        $password = DiHelper::genPassword($length = 10);
        $model = LoginMaster::model()->findByPk($cmdRes->login_ref_id);
        $model->pass_word = MD5($password);
        $model->save();

        $model = new DiGuestSignup;
        $model->sendLoginInfoEmail($diUserID, $emailInfo, $password);

        $diUsermodel = DiUser::model()->findByPk($diUserID);
        $diUsermodel->is_login_email_sent = '1';
        $diUsermodel->save();

        Yii::app()->user->setFlash('updated',"Congratulations! Login details are sent successfully.");
        $this->redirect(array('admin'));
    }

    /*
     function actionSendmail($data   =   array()){
        $msg        =   $this->renderPartial('/mailformat/di-reg', array('data'=>$data),true,false);
        $params = array();
        $params['EmailMessage']['subject']      =   'Welcome to Univariety: Your Univariety.com account details';
        $params['EmailMessage']['body']         =   $msg;
        $params['EmailMessage']['type']         =   'DIRegistration';
        $params['EmailMessage']['siteUrl']      =   '';
        $params['EmailMessage']['cc']           =   '';
        $params['EmailMessage']['toName']       =   $data['FirstName'].' '.$data['LastName'];
        $params['EmailMessage']['toEmail']      =   $data['username'];
        $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
        $status = Yii::app()->runController("sms/email/addMessage");
        //;
    }
    */
	
	 function actionSendmailUpdatePassword($data   =   array()){
        $msg        =   $this->renderPartial('/mailformat/di-updatePassword', array('data'=>$data),true,false);
        $params = array();
        $params['EmailMessage']['subject']      =   'Univariety: Your account password has been updated';
        $params['EmailMessage']['body']         =   $msg;
        $params['EmailMessage']['type']         =   'DIRegistration';
        $params['EmailMessage']['siteUrl']      =   '';
        $params['EmailMessage']['cc']           =   '';
        $params['EmailMessage']['toName']       =   $data['FirstName'].' '.$data['LastName'];
        $params['EmailMessage']['toEmail']      =   $data['username'];
        $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
        $status = Yii::app()->runController("sms/email/addMessage");
        //;
    }
	
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{

		$model=$this->loadModel($id);
		
		$DiUser		= new DiUser;
		// Di and Di user are one to one so only one record, select only first
		$DiUser		= $model->diUsers[0];
		
		$LoginMaster		= new LoginMaster('register');
		$LoginMaster		= $model->diUsers[0]->loginRef;
		
		$DiUserDepart				= 	new DiUserDepartment;
		$selectedDepartArr 			=	DiHelper::getDepartmentList($DiUser->di_user_id);
		$DiUserDepart->main_department_ref_id =  array_keys($selectedDepartArr);
		$model->TempUniversityRef	=	$model->uniRef->uni_name;
		
		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation(array($model,$DiUser,$DiUserDepart));
		
		if(isset($_POST['Di']))
		{
            /*CVarDumper::dump($_POST,10,true);
            exit;*/

            $uni_name					=	$_POST['uni_ref_id'];
            $data						=	TblUniversityMaster::model()->exists("uni_name= :x",array(':x'=>$uni_name));


            $model->attributes  = $_POST['Di'];
            $model->modified_on    = new CDbExpression('NOW()');
            if($data){
                if($model->save())	{

                    #Save Di user data
                    $DiUser->attributes	=	$_POST['DiUser'];
                    $DiUser->is_active	= 	$model->is_active; //Set di.is_active also to di_user.is_active
                    $DiUser->save();

                    #Save LoginMaster data
                    $LoginMaster->is_active = $model->is_active; //Set di.is_active also to login_master.is_active
                    $LoginMaster->save();

                    #Save updated fresh Departments
                    $departmentArray	=	$_POST['DiUserDepartment']['main_department_ref_id'];
                    $this->saveDepartments($departmentArray,$DiUser);

                    // update currency as well
                    DiProduct::model()->updateAll(
                        array('currency_ref_id' => $model->currency_ref_id),
                        "di_ref_id = {$model->di_id}"
                    );
                    DiCashCredit::model()->updateAll(
                        array('currency_ref_id' => $model->currency_ref_id),
                        "di_ref_id = {$model->di_id}"
                    );

                    $this->redirect(array('view','id'=>$model->di_id));
                }
            }else{
                Yii::app()->user->setFlash('error','Invalid Univarsity');
            }
		}

		$this->render('update',array(
			'model'=>$model,
			'DiUser'=>$DiUser,
			//'login'=>$login,
			'DiUserDepart'=>$DiUserDepart
		));
		
		
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Di');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
        $this->redirect(array('admin'));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
        Yii::import('application.modules.accountsummary.components.*');
        Yii::import('application.modules.accountsummary.models.*');
        $model=new Di('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Di']))
			$model->attributes=$_GET['Di'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
	
	public function actionUpdateprofile($id)
	{
		try{				
			$di_user_det=Yii::app()->db->createCommand()
				->select('du.di_user_id, du.first_name, du.last_name, du.user_type, lm.username')
				->from('di_user du')
				->join('login_master lm','lm.login_id=du.login_ref_id')
				->where('du.di_ref_id=:id',array(':id'=>$id))
				->queryAll();
			$user_det=array();
			foreach($di_user_det as $det)
			{				
				$user_det[$det['di_user_id']]= $det['first_name'].' '.$det['last_name'].' ('.$det['user_type'].' -  '.$det['username'].')';
			}			
			$this->render('profile',array(				
				'user_det'=>$user_det,
			));
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
	public function actionUserdet()
	{
		try{					
			if(isset($_POST['id']))
			{
				$di_user_model=DiUser::model()->findByPk($_POST['id']);
				$di_user_model->scenario="profileupdate";
				
				//if($di_user_model->email_frequency==null)
					//$di_user_model->email_frequency='null';
//if($di_user_model->sms_subscribe==null)
					//$di_user_model->sms_subscribe="Y";
				$this->performAjaxValidation($di_user_model);
				$this->renderPartial('_profile',array(
					'di_user_model'=>$di_user_model
				));
			}
			else if(isset($_POST['DiUser'])){	
				
				$di_user_model=DiUser::model()->findByPk($_POST['DiUser']['di_user_id']);
				$di_user_model->attributes=$_POST['DiUser'];
				$di_user_model->scenario="profileupdate";
				//$di_user_model->di_user_id=$_POST['DiUser']['di_user_id'];
				$di_user_model->timezone_ref_id=$_POST['DiUser']['timezone_ref_id'];
				$di_user_model->sms_subscribe=$_POST['DiUser']['sms_subscribe'];
				
				$di_user_model->email_frequency_daily=$_POST['DiUser']['email_frequency_daily'];
				$di_user_model->email_frequency_weekly=$_POST['DiUser']['email_frequency_weekly'];
				
				$di_user_model->user_type=$_POST['DiUser']['user_type'];
				$di_user_model->title=$_POST['DiUser']['title'];
				$di_user_model->designation=$_POST['DiUser']['designation'];
				
				if($_FILES['DiUser']['name']['profile_picture']){
                $tempSave=CUploadedFile::getInstance($di_user_model, 'profile_picture');
				$path='/uploads/di_images/'.date('Ymdhis').$_FILES['DiUser']['name']['profile_picture'];
				$imgPath = Yii::app()->params['docRootPath'] .$path;
				if($tempSave->saveAs($imgPath))
					$di_user_model->profile_picture=$path;
				}
				if($_FILES['DiUser']['name']['signature']){
				$tempSave1=CUploadedFile::getInstance($di_user_model, 'signature');
				$path='/uploads/di_images/'.date('Ymdhis').$_FILES['DiUser']['name']['signature'];
				$imgPath1 = Yii::app()->params['docRootPath'] .$path;
				
				if($tempSave1->saveAs($imgPath1))
					$di_user_model->signature=$path;
				}
				
				//if($di_user_model->save()){
				$di_user_model->save();
					Yii::app()->user->setFlash('updated',"Details are updated successfully.");
					$this->redirect(array('di/updateprofile/id/'.$di_user_model->di_ref_id));
				
				/*}else{						
					echo "<pre>"; print_r($di_user_model->attributes);
					echo "<pre>"; print_r($di_user_model->getErrors()); exit;
				}*/
			}
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
	
	
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Di::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}


	public function actionAutocompleteuni(){
		echo DiHelper::UniRefIdData(CHttpRequest::getParam('term'));
	}
	
	
	public function actionManagepricing($id){
        $DiDetails  =   DiHelper::GetDiDetails($id);
        $DiName     =   $DiDetails->diUsers[0]->first_name." ".$DiDetails->diUsers[0]->last_name;
        $Url        =   DiHelper::GetProductCreditData($di_ref_id = $id ,$url = '1');
		$this->render('managepriceing',array(
			'id'=>$id,
			'Url'=>$Url,
			'DiName'=>$DiName,
		));
	}
	
	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='di-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	
	
	/** 
	 * This Function will be shared in Create and update 
	 * First Delete all Departments and add fresh assigned
	*/
	protected function saveDepartments($departmentArray,$DiUser) {

        Yii::import('application.modules.di.models.*');

		$Userdepartment	= 	new DiUserDepartment;
		$Userdepartment->deleteAll(array('condition'=>'di_user_ref_id=:x', 'params'=>array(':x'=>$DiUser->di_user_id)));

        $criterias = DiUserCriteria::model()->findAll("di_user_ref_id = '".$DiUser->di_user_id."'");
        if($criterias) {
            foreach($criterias as $criteria){
                $deptPrefs = DiUserCriteriaDepartment::model()->findAll("di_user_criteria_ref_id='".$criteria->di_user_criteria_id."'");
                if($deptPrefs){
                    $removeCriteria = true;
                    foreach($deptPrefs as $deptPref){

                        if(!in_array($deptPref->department_ref_id, $departmentArray)){
                            $deptPref->delete();
                        }else{
                            $removeCriteria = false;
                        }
                    }
                    if($removeCriteria)
                        $criteria->delete();
                }
            }
        }

        $prefCountryID = $DiUser->diRef->uniRef->country_ref_id;
        $prefCountryOrder = 1;

		foreach($departmentArray as $deptID) {

			$Userdepartment								= 	new DiUserDepartment;
 			$Userdepartment->main_department_ref_id		=	$deptID;
			$Userdepartment->di_user_ref_id				=	$DiUser->di_user_id;
			$Userdepartment->is_active					=	$DiUser->is_active;	
			$Userdepartment->added_on					=	$DiUser->added_on;
			$Userdepartment->added_by					=	$DiUser->added_by;
			$Userdepartment->modified_on				=	$DiUser->modified_on;
			$Userdepartment->modified_by				=	$DiUser->modified_by;	
			$Userdepartment->save();

            $cdbCriteria = new CDbCriteria;
            $cdbCriteria->join = " INNER JOIN di_user_criteria duc ON duc.di_user_criteria_id = t.di_user_criteria_ref_id";
            $cdbCriteria->addCondition("duc.di_user_ref_id = '".$DiUser->di_user_id."'", "AND");
            $cdbCriteria->addCondition("t.department_ref_id = '".$deptID."'", "AND");

            if( DiUserCriteriaDepartment::model()->count($cdbCriteria) )
                continue;

            // get the department name
            $modelDept = LookupDepartment::model()->findByPk($deptID);
            // create criteria for each department
            $DiCriteria = new DiUserCriteria;
            $DiCriteria->setAttributes(array(
                'di_user_ref_id' => $DiUser->di_user_id,
                'criteria_name' => $modelDept->department_name,
                'course_level_ref_id' => '5',
                'added_by'   => $DiUser->added_by,
                'added_on'   => $DiUser->added_on,
            ), false);
            $DiCriteria->save(false);
            $DiUserCriteriaID = $DiCriteria->di_user_criteria_id;
            // dept
            $DiUserCriteriaDept = new DiUserCriteriaDepartment;
            $DiUserCriteriaDept->setAttributes(array(
                'di_user_criteria_ref_id' => $DiUserCriteriaID,
                'department_ref_id' => $deptID,
            ), false);
            $DiUserCriteriaDept->save(false);

            // starting session
            $filter_model = new Searchfilter;
            foreach($filter_model->getStartingYearOptions() as $startingYear){
                $startingSession = new DiUserCriteriaStartingSession;
                $startingSession->setAttributes(array(
                    'di_user_criteria_ref_id' => $DiUserCriteriaID,
                    'starting_year' => $startingYear,
                ), false);
                $startingSession->save(false);
            }

            // country
            $DiUserCriteriaCountry = new DiUserCriteriaCountry;
            $DiUserCriteriaCountry->setAttributes(array(
                'di_user_criteria_ref_id' => $DiUserCriteriaID,
                'country_ref_id' => $prefCountryID,
                'preference_order' => $prefCountryOrder,
            ), false);
            $DiUserCriteriaCountry->save(false);

            // generate criteria matches
            Criteria::generateCriteriaResults($DiUserCriteriaID);
        }
    }
	
	/* Change password */
	public function actionChangepassword($id)
	{
		$model=$this->loadModel($id);
		
		$DiUser		= new DiUser;
		// Di and Di user are one to one so only one record, select only first
		$DiUser		= $model->diUsers[0];
		
		$LoginMaster		= new LoginMaster('DiModuleChangePassword');
		$LoginMaster		= $model->diUsers[0]->loginRef;
		$LoginMaster->scenario = 'DiModuleChangePassword';
		if(isset($_POST['LoginMaster'])){
		
			$LoginMaster->pass_word = $_POST['LoginMaster']['pass_word'];
			
			if($LoginMaster->validate()){
				$LoginMaster->pass_word = md5($LoginMaster->pass_word);
				if($LoginMaster->save()){
				
				
					$data           =    array(
										'username'          =>   $LoginMaster->username,
										'password'          =>   $_POST['LoginMaster']['pass_word'],
										'FirstName'         =>   $DiUser->first_name,
										'LastName'          =>   $DiUser->last_name,
										'di_id'             =>   $model->di_id,
									);
									
									
					Yii::app()->user->setFlash('updated',"Congratulations! DI password has been changed  successfully. Note: Credentials to Log In have been emailed to Di email");
					self::actionSendmailUpdatePassword($data); # to send mail
					
					$this->redirect(array('admin'));
				}
			}//if validation ok
			
		}
		
		$LoginMaster->pass_word  = "";
		$this->render('changepassword',array('LoginMaster'=>$LoginMaster));

	}

    public function actionGuestUniversity() {

        $model  = new GuestUniversity();

        $this->performAjaxValidation(array($model));

        if (isset($_POST['GuestUniversity'])) {
            $model->attributes = $_POST['GuestUniversity'];
            if($model->validate()){

                if(($uniModel = TblUniversityMaster::model()->findByAttributes(array('uni_name' => $model->uniname))) === null){

                    $tblUniversityMasterModel = new TblUniversityMaster('Create');
                    $tblUniversityMasterModel->uni_name = $model->uniname;
                    $tblUniversityMasterModel->country_ref_id = $model->country;
                    $tblUniversityMasterModel->city_ref_id = $model->city;
                    $tblUniversityMasterModel->is_active = 'N';
                    $tblUniversityMasterModel->added_on = date('Y-m-d H:i:s');
                    $tblUniversityMasterModel->added_by = Yii::app()->user->id;
                    $tblUniversityMasterModel->save();

                    $UniId = $tblUniversityMasterModel->uni_id;
                    $id = TblUniversityMaster::model()->getUniqueUrlPrimarykey($UniId, $tblUniversityMasterModel->uni_name);
                    $tblUniversityMasterModel->url_primary_key = $id;
                    $tblUniversityMasterModel->save();

                }else{
                    $UniId = $uniModel->uni_id;
                }

                Yii::import('application.modules.pms.models.PmsUniversityContact');
                // saving contact info.
                foreach($_POST['GuestUniversity'] as $key => $val){
                    if(!is_int($key)) continue;

                    $model = new PmsUniversityContact();
                    $model->setAttributes(array(
                        'uni_ref_id'    => $UniId,
                        'contact_email' => $val['contact_email'],
                        'contact_name'  => $val['contact_name'],
                        'contact_number' => $val['contact_number'],
                        'designation'   => $val['contact_designation'],
                        'added_on'      => date('Y-m-d H:i:s'),
                        'added_by'      => Yii::app()->user->id,
                    ),false);
                    $model->save(false);
                    $contactID = $model->pms_university_contact_id;

                    // send invite emails
                    $EmailMessage = array();
                    $targetUrl = Yii::app()->createAbsoluteUrl('disignup/c/'.MD5($contactID.'/'.$UniId));
                    $sesInfo = unserialize(Yii::app()->session->get('sAdminUnivarietyContent'));

                    $EmailMessage['EmailMessage']['subject'] = 'UG Admission criteria form - Tell us what you are looking for';
                    $EmailMessage['EmailMessage']['body']    = str_replace(
                        array('__CONTACT_NAME__', '__TARGET_LINK__', '__CONTACT_LINK__', '__SENDER_NAME__') ,
                        array(ucfirst($val['contact_name']), $targetUrl, 'pupils@univariety.com', ucfirst($sesInfo['adminName'])),
                        $this->renderPartial('invite_email_tmpl', array(), true, false)
                    );
                    $EmailMessage['EmailMessage']['type']    = 'InviteUniversityDI';
                    //$EmailMessage['EmailMessage']['siteUrl'] = Yii::app()->baseUrl(true);
                    $EmailMessage['EmailMessage']['cc']      = '';
                    $EmailMessage['EmailMessage']['toName']  = ucfirst($val['contact_name']);
                    $EmailMessage['EmailMessage']['toEmail'] = $val['contact_email'];
                    $EmailMessage['EmailMessage']['apiKey']  = Yii::app()->params['emailCron']['curlKey'];

                    $_POST = $EmailMessage;
                    $status = Yii::app()->runController("sms/email/addMessage");
                }

                $this->redirect(array('admin'));
            }
        }

        $this->render('guest_university',array(
            'model'=>$model, 'uniNames' => $model->getUniNamesWithNoDI()
        ));
    }

    public function actionGetCityList(){

        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '" . $countryId . "'", "order" => "city_name", 'distinct'=>true, 'select' => 't.city_name, t.city_id'));
        $cityResults = array();
        if($result) {
            foreach ($result as $city) {
                $cityResults[$city->city_name] = $city->city_id;
            }
        }
        echo json_encode($cityResults);
    }

    public function actionReviewUnfreeze($id){

        if(isset($_POST['summery'])){
            $summery = Yii::app()->request->getParam('summery', false);
            $model = new DiReviewUnfreeze;
            $model->setAttributes(array(
                'di_ref_id' => $id,
                'notes' => $summery ?: new CDbExpression('NULL'),
                'unfreezed_on'=> date('Y-m-d H:i:s'),
                'unfreezed_by'=> Yii::app()->user->id
            ), false);
            $model->save(false);

            $diModel = Di::model()->findByPk($id);
            $diModel->setAttributes(array(
                'review_unfreeze_scheduled_time' => new CDbExpression('NULL'),
                'review_unfreeze_scheduled_by' => new CDbExpression('NULL'),
            ), false);
            $diModel->save(false);

            Yii::app()->end();
        }

        $details = DiReviewUnfreeze::model()->findAll("di_ref_id='".$id."' ORDER BY unfreezed_on ASC");
        $this->renderPartial('review_unfreeze', array('diID'=>$id, 'details'=>$details));
    }
	
}
