<?php
	Yii::import('application.modules.hotlead.models.*');
	Yii::import('application.modules.alertmatch.models.*');
	Yii::import('application.modules.shortlist.models.DiUserCriteriaShortlist');
	Yii::import('application.modules.counselorsuggest.models.DiUserCounsellorShortlist');

/*
	-------------------------------------------
	# Hotlead - These codes will handle preference changes and flags, it will refund for hotlead in any case
	$EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
	$EligibilityEngineObj->type = "hotlead";
	$EligibilityEngineObj->handleHotleads();
	------------------------------------------
	-------------------------------------------
	# Alertmatch - These codes will handle preference changes and flags, it will refund for alertmatch in any case
	$EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
	$EligibilityEngineObj->type 		= "alertmatch";
	$EligibilityEngineObj->studentId 	= $sID;
	$EligibilityEngineObj->handleAlertmatch();
	------------------------------------------
	------------------------------------------
	# Eligibility check for Hotlead | Alertmatcg	
	$EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
	$EligibilityEngineObj->type = "hotlead"; // (hotlead or alertmatch)
	$EligibilityEngineObj->studentId 	= $sID; // student id
	$EligibilityEngineObj->universityId = $uniID; // university id
	if($EligibilityEngineObj->isValidationFlagsEligible() && $EligibilityEngineObj->isPereferenceEligible()){
	}
	
*/

class StudentEligibilityUpdatesHandlerEngine extends CComponent{

	public $type = ""; // it will be (hotlead|alertmatch)
	public $studentId = "";
	public $universityId = "";
	public $diUserId = "";
	
	public $eligibilityFails = array();
	
	
	public function isPereferenceEligible()
	{
		if($this->studentId==""){ die('I need studentId to handle Pereference updates of particular student'); }
		if($this->universityId==""){ die('I need universityId to handle Pereference updates of particular student'); }
		
		if($this->type=="hotlead"){
			return $this->isPereferenceEligibleForHotlead();
		} elseif($this->type=="alertmatch"){
			return $this->isPereferenceEligibleForAlertmatch();
		} elseif($this->type=="counselor"){
			return $this->isPereferenceEligibleForCounselor();
		}
	}
	
	/*
	 * This function will update hotlead and Alertmatch Related data according to current student
	 */
	 
	public function handleUpdates(){
		if($this->type=="hotlead"){
			return $this->handleUpdatesHotlead();
		} elseif($this->type=="alertmatch"){
			return $this->handleUpdatesAlertmatch();
		}
	}

	// Hotlead Pereference Eligible 
	public function isPereferenceEligibleForHotlead()
	{
		if( 
		$this->isCountryPreferenceEligible() && 
		$this->isCourcePreferenceEligible() && 
		$this->isDesiredStudyLevelPreferenceEligible() 
		){
			return true;
		} else{
			return false;
		}
		
	}	
	
	// Alertmatch Pereference Eligible 
	public function isPereferenceEligibleForAlertmatch()
	{
		if( 
		$this->isCountryPreferenceEligible() && 
		$this->isCourcePreferenceEligible() 
		){
			return true;
		} else{
			return false;
		}
	}	
	// Counselor Pereference Eligible 
	public function isPereferenceEligibleForCounselor()
	{
		if( 
		$this->isCountryPreferenceEligible() && 
		$this->isCourcePreferenceEligible() 
		){
			return true;
		} else{
			return false;
		}
	}	
	

	/*===============================================	
	* STUDENT ELIGIBILITY CHECK FUNCTIONS
	****************************************************/
	
	// Check validation flags from login_master
	public function isValidationFlagsEligible()
	{

		$studentId = $this->studentId;
		$model	 =	new LoginMaster;
		$loginId =  UserMaster::model()->findByPk($studentId);
		
		$result = $model->find(
			$condition =  'login_id=:x AND (is_email_confirmed=:y AND is_class_status_confirmed=:y AND is_preference_confirmed=:y)',
			$params	   =  array(
			':x'=>$loginId->login_ref_id,
			':y'=>1,
			)
		);
		
		if(is_null($result)){
		$this->eligibilityFails[] = "Student not passed Login master Flags Eligibility";
		return false; 
		} else{ return true; }
	}
	
	
	// Country Preference
	function isCountryPreferenceEligible(){
	
		$studentId 		= $this->studentId;
		$universityId 	= $this->universityId;
		
		
		// Get student preference data
		$stdPrefCountries = array();
        $countryPrefs = StudentPreferredCountry::model()->getStudentPreferredCountryDetails($studentId);
		
		if(!$countryPrefs) return false;

		foreach($countryPrefs as $pref){
			if(!in_array($pref->country_ref_id, $stdPrefCountries))
				$stdPrefCountries[] = $pref->country_ref_id;
		}
		// Get University preference data
		$uniCountryId = $this->getUniversityCountry();
		
		// Match Student Preference with University Pereference and return response ( true|false )
		if(in_array($uniCountryId, $stdPrefCountries)){
			return true;
		} else{
			$this->eligibilityFails[] = "Preference country Eligibility fail";
			return false;
		}		
		
	}

	// Cource or Department Eligibility	
	function isCourcePreferenceEligible(){
	
		$studentId 		= $this->studentId;
		$universityId 	= $this->universityId;
		
		// Get student preference data
		$stdPrefDepts = array();
        $deptPrefs    = StudentPreferredDepartment::model()->getStudentPreferredDepartmentDetails($studentId);
		
		if(!$deptPrefs) return false;

		foreach($deptPrefs as $pref){
			if(!in_array($pref->main_dept_ref_id, $stdPrefDepts))
				$stdPrefDepts[] = $pref->main_dept_ref_id;
		}
		
		
		// Get DI USER OR University preference data
		// This di user department built because in hotlead it was allowing student to pass even di_user not have
		// that department
		if($this->diUserId!=""){
			$uniDepartments = $this->getDiUserDepartments();
		} else{
			$uniDepartments = $this->getUniversityDepartments();
		}
		
		// Match Student Preference with University Pereference and return response ( true|false )
		if(count(array_intersect($stdPrefDepts, $uniDepartments))>0){
			return true;
		} else{
			$this->eligibilityFails[] = "Preference Cource or department Eligibility fail";
			return false;
		}		
	}
	
  	// Study Level Eligibility
	// After Discuss with Anshul it will be applied only for Hotleads
	// 
	function isDesiredStudyLevelPreferenceEligible(){
	
		$studentId 		= $this->studentId;
		$cdbCriteria = new CDbCriteria();
		$cdbCriteria->join = "INNER JOIN lookup_course_level lcl ON lcl.level_id = t.course_level_ref_id";
		$cdbCriteria->addCondition("t.user_ref_id = '{$studentId}' AND (lcl.level_id = '5' OR lcl.parent_ref_id = '5')");
		$result = StudentPreferredStudyLevel::model()->count($cdbCriteria);
		 if(!$result){
			$this->eligibilityFails[] = "Preference Desired Study Level Eligibility fail";
			return false;
		 } else{
			return true;
		}			 

	}	
	
	
	
	
	/*===============================================	
	* (HOTLEAD | ALERTMATCH) UPDATES HANDLER FUNCTIONS
	****************************************************/	
	
	public function handleHotleads(){
		
		// SELECT All student who applied on particular university status should not be Reject
		// again to availble for hotlead
		// DISTINCT student ids, because students preference is changed for all the universities
		$sql = "SELECT DISTINCT user_ref_id,uni_ref_id,shortlist_status FROM student_shortlist_university
		WHERE shortlist_status IS NOT NULL";
		$connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL
        if($rowCount>0){
            $data = $command->queryAll();
			foreach($data as $data){
			
				$this->studentId 	= $data['user_ref_id'];
				$this->universityId = $data['uni_ref_id'];
				$shortlist_status	= $data['shortlist_status'];
				
				if($this->isValidationFlagsEligible() && $this->isPereferenceEligible()){

					$StudentHotlead = StudentHotlead::model()->findByAttributes(array(
					'user_ref_id'	=> $this->studentId,
					'uni_ref_id'	=> $this->universityId
					));
					
					if(!empty($StudentHotlead))
					{
						$student_hotlead_id = $StudentHotlead->student_hotlead_id;
						if($shortlist_status =='Reject') {// IF validation ok but student Reject that university
							$this->rejectHotlead($student_hotlead_id);
						} else{
                            // As per discussion with Shiva, we don't need this code
                            /*
                                    $this->acceptHotlead($student_hotlead_id,$shortlist_status);
                            */
                                }

                         } // if(!empty($StudentHotlead))

				} else{ // If not eligible
					/*
					# NO NEED TO update student_shortlist to reject, after Discussion with Anshul and Gaurav
					// 1. update StudentShortlistUniversity with Reject status
					$StudentShortlistUniversity = new StudentShortlistUniversity();
					$StudentShortlistUniversity->updateAll(array('shortlist_status'=>'Reject'),'user_ref_id=:x AND uni_ref_id=:y',array(
					':x'=> $this->studentId,
					':y'=> $this->universityId
					));
					*/
					
					$StudentHotlead = StudentHotlead::model()->findByAttributes(array(
					'user_ref_id'	=> $this->studentId,
					'uni_ref_id'	=> $this->universityId
					));
					
					if(!empty($StudentHotlead)) // Then update Reject status in related tables
					{
						$student_hotlead_id = $StudentHotlead->student_hotlead_id;
						$this->rejectHotlead($student_hotlead_id);
					} // if(!empty($StudentHotlead))
					
				}
			}//EOF foreach
			
		}
		
		
	}
	
	public function handleAlertmatch(){
		if($this->studentId==""){ die('I need studentId to handle Pereference updates of particular student'); }
		$sID = $this->studentId;
		/*
			1. FIND sID related students from student_criteria_match Table and Join criteria match table based on criteria_match_id
			2. loop through found record
			3. now we have di_ref_id from criteria_match table
			4. findByPk($di_ref_id ) uni_var_id		
			5. Get students pref. department and countries
			6. get university country and departments
			7. compare both
			8. if not found then delete di_user_criteria_match
		*/	
		
		#1. SELECT DUC.di_user_criteria_id, DUCM.user_ref_id FROM di_user_criteria AS DUC,di_user_criteria_match AS DUCM WHERE (DUCM.user_ref_id=1382 AND DUCM.di_user_criteria_ref_id = DUC.di_user_criteria_id);
		
			$DiUserModel	=	new DiUser;
		
			$sql ="SELECT DUC.di_user_ref_id, DUCM.user_ref_id , DUC.di_user_criteria_id, 
			DUCM.di_user_criteria_match_id, DUCM.status 
			FROM di_user_criteria AS DUC,di_user_criteria_match AS DUCM 
			WHERE (DUCM.user_ref_id='".$sID."' AND DUCM.di_user_criteria_ref_id = DUC.di_user_criteria_id)";
			$connection=Yii::app()->db;
			$command=$connection->createCommand($sql);
			$criteriaData=$command->queryAll(); // execute the non-query SQL  

			if(count($criteriaData)>0)
			{

				foreach($criteriaData as $criteriaData)
				{
					$di_user_id 			= $criteriaData['di_user_ref_id'];
					$this->universityId 	= $this->getUniversityId($di_user_id);
					$di_user_criteria_id	= $criteriaData['di_user_criteria_id'];
					
					// Save only if Eligible
					if( $this->isValidationFlagsEligible() && 
						$this->isPereferenceEligible() &&
						$this->isDesiredStudelyLevelChanged($di_user_criteria_id)
					)
					{
						//die("do nothing");
					}else
					{
						if(is_null($criteriaData['status']))
						{
							$deleteUnmatchedRecord = "DELETE from di_user_criteria_match where user_ref_id = '".$sID."'";
							$connection=Yii::app()->db;
							$command=$connection->createCommand($deleteUnmatchedRecord);
							$command->execute();
							//echo "Deleted from di_user_criteria_match <br />";
							
						}else if($criteriaData['status']=='EOI')
						{
							$shortlistData = DiUserCriteriaShortlist::model()->findAllByAttributes(array('user_ref_id'=>$sID));
							foreach($shortlistData as $shortlistData){
							
								//echo $shortlistData->status;
								//echo "<br />";
							
								if($shortlistData->status=='Buy'){
									$shortlistData->status='Refund';
									$shortlistData->save(); // updated this record to refund	
								} else if(($shortlistData->status!='Refund') || (is_null($shortlistData->status))){
									$eoi_id = $shortlistData->di_user_eoi_ref_id;
									$main_department_id = $shortlistData->main_department_ref_id;
									
									$this->deleteEoiLog($sID,$main_department_id,$eoi_id);
									$this->deleteFromCriteriaShortlist($sID,$main_department_id,$eoi_id);
									$this->deleteFromScholarshipLog($sID,$main_department_id,$eoi_id);
									$this->deleteFromScholarship($sID,$main_department_id,$eoi_id);
									$this->deleteFromUserEoi($sID,$main_department_id,$eoi_id);
								}
								
							}
							
						} // else if of "IF the stuas is EOI", ends here
					} // else part of comparision if
				} // foreach for $criteriaData ends here
			} // if count($criteriaData)>0) ends here
	}
	
	
	/*===============================================	
	* EXTRA HELPER FUNCTIONS
	****************************************************/

	public function rejectHotlead($student_hotlead_id){
		
		if($this->diUserId!=""){ // if di user is set then only apply action on di_user_hotlead
			// 2. UPDATE di_user_hotlead table to buy if hotlead is bought
			$setToRefund =  DiUserHotlead::model()->updateAll(array('status'=>'Refund'),'student_hotlead_ref_id=:x AND status=:y AND di_user_ref_id=:z',array(
			':x'=>$student_hotlead_id,
			':y'=>'Buy',
			':z'=>$this->diUserId
			));
			
			// 3. If di_user_hotlead is not bought then Igonre it ( it will not display )
			if(!$setToRefund){
				$setToIgnore =  DiUserHotlead::model()->updateAll(array('status'=>'Ignore'),
				'student_hotlead_ref_id=:x AND (status IS NULL OR status="View") AND  di_user_ref_id=:y',
				array(
				':x'=>$student_hotlead_id,
				':y'=>$this->diUserId
				));
			}
		} else{
		
			// 1. student_hotlead set status to Reject
			/*
			StudentHotlead::model()->updateAll(array('is_refund_eligible'=>'1'),'student_hotlead_id=:x',array(
			':x'=>$student_hotlead_id,
			));
			*/
			/*
			StudentHotlead::model()->updateAll(array('status'=>'Reject'),'student_hotlead_id=:x',array(
			':x'=>$student_hotlead_id,
			));
			*/
			
			// 2. UPDATE di_user_hotlead table to buy if hotlead is bought
			$setToRefund =  DiUserHotlead::model()->updateAll(array('status'=>'Refund'),'student_hotlead_ref_id=:x and status=:y',array(
			':x'=>$student_hotlead_id,
			':y'=>'Buy'
			));
			
			// 3. If di_user_hotlead is not bought then Igonre it ( it will not display )
			if(!$setToRefund){
				$setToIgnore =  DiUserHotlead::model()->updateAll(array('status'=>'Ignore'),
				'student_hotlead_ref_id=:x AND (status IS NULL OR status="View")',
				array(
				':x'=>$student_hotlead_id
				));
			}
		}			
	}
	
	public function rejectDiUserHotlead($student_hotlead_id){
	

	}	
	
	public function acceptHotlead($student_hotlead_id,$shortlist_status){
	
		// 1. student_hotlead set is_refund_eligible=0
		StudentHotlead::model()->updateAll(array('status'=>$shortlist_status),'student_hotlead_id=:x',array(
		':x'=>$student_hotlead_id,
		));
		
		// 2. UPDATE di_user_hotlead table to NULL if previous status was Ignore
		$setToRefund =  DiUserHotlead::model()->updateAll(array('status'=>NULL),'student_hotlead_ref_id=:x and status=:y',array(
		':x'=>$student_hotlead_id,
		':y'=>'Ignore'
		));
		
		// 3. UPDATE di_user_hotlead table to NULL if previous status was Refund
		// commented these code because if it is alredy there for refund we cant set it NULL, 
		// University should must get Refund
		/*
		$setToRefund =  DiUserHotlead::model()->updateAll(array('status'=>NULL),'student_hotlead_ref_id=:x and status=:y',array(
		':x'=>$student_hotlead_id,
		':y'=>'Refund'
		));
		*/		
	}	
	
	public function getUniversityDepartments(){
		$universityId 	= $this->universityId;
		$level 			= 'ug';
        $departments = array();
        $uniDepts = TblUniCourses::getDepartmentListByUniId($universityId, $level);
        if($uniDepts){
            foreach($uniDepts as $Depts)
                $departments[] = $Depts['id'];
        }
        return $departments;
    }
	
	public function getDiUserDepartments(){
		$diUserId 	= $this->diUserId;
        $departments = array();
		
        $diUserDepts = DiHelper::getDiUserDepartment($diUserId);
		
        if($diUserDepts){
            foreach($diUserDepts as $dep_id=>$dep_name)
                $departments[] = $dep_id;
        }
        return $departments;
    }	
	
	public function getUniversityCountry(){
		$universityId = $this->universityId;
		$model = TblUniversityMaster::model()->findByPk($universityId);
		$uni_country_id = $model->country_ref_id;
		return $uni_country_id;
	}

	public function getUniversityId($di_user_id){
		$model 	= DiUser::model()->findByPk($di_user_id);
		$uni_id = $model->diRef->uni_ref_id;
		return $uni_id;
	}

	public function isDesiredStudelyLevelChanged($di_user_criteria_id){
		$model 	= DiUserCriteria::model()->findByPk($di_user_criteria_id);
		$criteria_study_level_id = $model->courseLevelRef->level_id;
		
		$studentId 		= $this->studentId;
		$cdbCriteria = new CDbCriteria();
		$cdbCriteria->join = "INNER JOIN lookup_course_level lcl ON lcl.level_id = t.course_level_ref_id";
		$cdbCriteria->addCondition("t.user_ref_id = '{$studentId}'");
		$cdbCriteria->addCondition("t.course_level_ref_id = '{$criteria_study_level_id}'");
		$result = StudentPreferredStudyLevel::model()->count($cdbCriteria);
		if($result>0){
			return true;
		} else{
			return false;
		}
	}
	
	public function checkParams(){
		$errorMessage = array();
		if($this->type==""){
			$errorMessage[] = "type is not define it will be (Alertmatch|Hotlead)";
		}
		if($this->studentId==""){
			$errorMessage[] = "I need student id to check eligibility";
		}
		if($this->universityId==""){
			$errorMessage[] = "I need University id to check eligibility";
		}
		
		if(count($errorMessage)>0){
			foreach($errorMessage as $errorMessage){
				echo $errorMessage."</br >";
			}
		}
	} // EOF checkParams Function
	
	
	/***************************************
	* CRITERIA MATCH PREFERENCE UPDATES SUPPORTING FUNCTIONS
	****************************************/

	#DELETE  FROM di_user_eoi_log 
	public function deleteEoiLog($sID,$main_department_id,$eoi_id){	
	
		$deleteEoiLog = "DELETE from di_user_eoi_log where user_ref_id = '".$sID."' AND main_department_ref_id='".$main_department_id."'";
		$connection=Yii::app()->db;
		$command=$connection->createCommand($deleteEoiLog);
		//echo "Deleted from di_user_eoi_log <br />";
		return $command->execute();
	}
	
	#DELETE  FROM di_user_criteria_shortlist 
	public function deleteFromCriteriaShortlist($sID,$main_department_id,$eoi_id){	
		$deleteFromCriteriaShortlist = "DELETE from di_user_criteria_shortlist where di_user_eoi_ref_id = '".$eoi_id."'";
		$connection=Yii::app()->db;
		$command=$connection->createCommand($deleteFromCriteriaShortlist);
		//echo "Deleted from di_user_criteria_shortlist <br />";
		return $command->execute();
	}
	
	#DELETE  FROM di_user_eoi_scholarship_log 
	public function deleteFromScholarshipLog($sID,$main_department_id,$eoi_id){	
		$deleteFromScholarshipLog = "DELETE from di_user_eoi_scholarship_log where di_user_eoi_log_ref_id = '".$eoi_id."'";
		$connection=Yii::app()->db;
		$command=$connection->createCommand($deleteFromScholarshipLog);
		//echo "Deleted from di_user_eoi_scholarship_log <br />";
		return $command->execute();
	}
	
	#DELETE  FROM di_user_eoi_scholarship 
	public function deleteFromScholarship($sID,$main_department_id,$eoi_id){	
		$deleteFromScholarship = "DELETE from di_user_eoi_scholarship where di_user_eoi_ref_id = '".$eoi_id."'";
		$connection=Yii::app()->db;
		$command=$connection->createCommand($deleteFromScholarship);
		//echo "Deleted from di_user_eoi_scholarship <br />";
		return $command->execute();
	}
	
	#DELETE  FROM di_user_eoi 
	public function deleteFromUserEoi($sID,$main_department_id,$eoi_id){	
		$deleteFromUserEoi = "DELETE from di_user_eoi where di_user_eoi_id = '".$eoi_id."'";
		$connection=Yii::app()->db;
		$command=$connection->createCommand($deleteFromUserEoi);
		//echo "Deleted from di_user_eoi <br />";
		return $command->execute();
	}
	
	
	public function getDepartmentsByUniID($uniID = 0, $level = 'ug'){

        $departments = array();
        $uniDepts = TblUniCourses::getDepartmentListByUniId($uniID, $level);
        if($uniDepts){
            foreach($uniDepts as $Depts)
                $departments[] = $Depts['id'];
        }
        return $departments;
    }
	
	public function debug(){
		echo "<pre>";
		print_r("Student Id : ".$this->studentId);
		if(count($this->eligibilityFails)>0){
			print_r($this->eligibilityFails);
		} else{
			print_r("Eligibility and Preference test passed");
		}
		echo "</pre>";
	}
	
	function handleDiUserCounselorShortlist($id)
	{
		$DiUserCounsellorShortlist 	= DiUserCounsellorShortlist::model()->findByPk($id);
		$this->diUserId 			= $DiUserCounsellorShortlist->di_user_ref_id;
		$this->universityId 		= $this->getUniversityId($this->diUserId);
		$this->studentId 			= $DiUserCounsellorShortlist->user_ref_id;
	
		if( $this->isValidationFlagsEligible() && $this->isPereferenceEligible())
		{
			
			if($DiUserCounsellorShortlist->status=='IgnoreRefund')
			{
			/* cehck if this records has EOI id THEN update suiggeste dtbl with status EOI ELSE update status to interested*/
			
			if(!is_null($DiUserCounsellorShortlist->di_user_eoi_ref_id)){
				$updateStatusToInterestedAgain = "UPDATE di_user_counsellor_suggested set status='Interested' WHERE (di_user_ref_id = '".$DiUserCounsellorShortlist->di_user_ref_id."' AND user_ref_id = '".$DiUserCounsellorShortlist->user_ref_id."' AND department_ref_id = '".$DiUserCounsellorShortlist->department_ref_id."')";
				$connection=Yii::app()->db;
				$command=$connection->createCommand($updateStatusToInterestedAgain);
				$command->execute();
				echo "Updated records to di_user_counsellor_suggested.status='Interested'<br />";
			}
			/*set shortlist status to NULL*/
			$DiUserCounsellorShortlist->status=NULL;
			$DiUserCounsellorShortlist->save();		
			echo "Updated records  to di_user_counsellor_shortlist.status='Interested'<br />";
			}
			
			
		}else
		{
			if(is_null($DiUserCounsellorShortlist->status) || $DiUserCounsellorShortlist->status=='View')
			{
				$updateThisRecordToRefundIgnore = "UPDATE di_user_counsellor_shortlist set status='IgnoreRefund' WHERE di_user_counsellor_shortlist_id = '".$DiUserCounsellorShortlist->di_user_counsellor_shortlist_id."'";
				$connection=Yii::app()->db;
				$command=$connection->createCommand($updateThisRecordToRefundIgnore);
				$command->execute();
				echo "Updated records  to di_user_counsellor_shortlist.status='IgnoreRefund'<br />";					
			}else if($DiUserCounsellorShortlist->status=='Buy')
			{
				$updateThisRecordToRefundIgnore = "UPDATE di_user_counsellor_shortlist set status='Refund' WHERE di_user_counsellor_shortlist_id = '".$DiUserCounsellorShortlist->di_user_counsellor_shortlist_id."'";
				$connection=Yii::app()->db;
				$command=$connection->createCommand($updateThisRecordToRefundIgnore);
				$command->execute();
				echo "Updated records to di_user_counsellor_shortlist.status='Refund'<br />";
			}
		}
		
	}

}
